/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicLWSessionContext;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiis.OiisLWVariableOwner;
import oracle.sysman.oii.oiis.OiisVariable;

public class OiicGlobalContext {
    private List m_oOracleHomes = null;
    private List m_oToplevelCompNames = null;
    private List m_oKeys = null;
    private Map m_oContextMap = null;
    private static OiicGlobalContext s_oGlobalContext = null;
    private HashMap secureCompVarMap = new HashMap();

    private OiicGlobalContext() {
        this.m_oOracleHomes = new ArrayList();
        this.m_oToplevelCompNames = new ArrayList();
        this.m_oKeys = new ArrayList();
        this.m_oContextMap = new HashMap();
    }

    public static final OiicGlobalContext getGlobalContext() {
        if (s_oGlobalContext == null) {
            s_oGlobalContext = new OiicGlobalContext();
        }
        OiiolTextLogger.appendText("Retrieving the global context: OiicGlobalContext.getGlobalContext()", OiiolTextLogger.LOG_TRACE);
        return s_oGlobalContext;
    }

    public String getKey(String sOHName, String sToplevelCompName) {
        return sOHName + ":" + sToplevelCompName;
    }

    public void addLWVariableOwner(String sOHName, String sToplevelCompName, OiisLWVariableOwner oLWVariableOwner) {
        if (oLWVariableOwner != null && sOHName != null && sToplevelCompName != null) {
            String sMsg = "Session Context for Oracle Home = '" + sOHName + "' was added to the global context.";
            OiiolTextLogger.appendText(sMsg, OiiolTextLogger.LOG_DETAILED);
            OiisLWVariableOwner obj = this.m_oContextMap.put(this.getKey(sOHName, sToplevelCompName), oLWVariableOwner);
            if (obj == null) {
                this.m_oOracleHomes.add(sOHName);
                this.m_oToplevelCompNames.add(sToplevelCompName);
                this.m_oKeys.add(this.getKey(sOHName, sToplevelCompName));
            }
        }
    }

    public OiisLWVariableOwner getLWVariableOwner(String sOHName, String sToplevelCompName) {
        OiisLWVariableOwner oVarOwner = null;
        if (sOHName != null && sToplevelCompName != null) {
            oVarOwner = (OiisLWVariableOwner)this.m_oContextMap.get(this.getKey(sOHName, sToplevelCompName));
        }
        return oVarOwner;
    }

    public OiisLWVariableOwner getLWVariableOwner(String sKey) {
        OiisLWVariableOwner oVarOwner = null;
        if (sKey != null) {
            oVarOwner = (OiisLWVariableOwner)this.m_oContextMap.get(sKey);
        }
        return oVarOwner;
    }

    public Iterator getAllVarValues(String sVarName) {
        int iSize = this.m_oKeys.size();
        ArrayList<String> oVarValues = iSize > 0 ? new ArrayList<String>() : null;
        for (int i = 0; i < iSize; ++i) {
            String sKey = (String)this.m_oKeys.get(i);
            String sVarValue = this.getVariableValue(sKey, sVarName);
            if (sVarValue == null) continue;
            oVarValues.add(sVarValue);
        }
        return oVarValues != null ? oVarValues.iterator() : null;
    }

    public String getOracleHome(int iIndex) {
        return iIndex < this.m_oOracleHomes.size() ? (String)this.m_oOracleHomes.get(iIndex) : null;
    }

    public String getToplevelCompName(int iIndex) {
        return iIndex < this.m_oToplevelCompNames.size() ? (String)this.m_oToplevelCompNames.get(iIndex) : null;
    }

    public String getKey(int iIndex) {
        if (iIndex < this.m_oKeys.size()) {
            return (String)this.m_oKeys.get(iIndex);
        }
        return null;
    }

    public int getKeyIndex(String sKey) {
        int iPos = -1;
        if (this.getLWVariableOwner(sKey) != null) {
            Iterator iterKeys = this.getKeys();
            int i = 0;
            while (iterKeys.hasNext()) {
                String iterKey = (String)iterKeys.next();
                if (iterKey.equals(sKey)) {
                    iPos = i;
                    break;
                }
                ++i;
            }
        }
        return iPos;
    }

    public Iterator getOracleHomes() {
        return this.m_oOracleHomes.iterator();
    }

    public Iterator getToplevelCompNames() {
        return this.m_oToplevelCompNames.iterator();
    }

    public Iterator getKeys() {
        return this.m_oKeys.iterator();
    }

    public int getVariableType(String sOHName, String sToplevelCompName, String sVarName) {
        OiisVariable oVar;
        OiicLWSessionContext oLWSC;
        int iVarType = -1;
        if (this.m_oContextMap != null && sOHName != null && sToplevelCompName != null && sVarName != null && (oLWSC = (OiicLWSessionContext)this.m_oContextMap.get(this.getKey(sOHName, sToplevelCompName))) != null && (oVar = oLWSC.getVariable(sVarName)) != null) {
            iVarType = oVar.getValueType();
        }
        return iVarType;
    }

    public String getVariableValue(String sOHName, String sToplevelCompName, String sVarName) {
        OiisVariable oVar;
        OiicLWSessionContext oLWSC;
        String sVarValue = null;
        if (this.m_oContextMap != null && sOHName != null && sToplevelCompName != null && sVarName != null && (oLWSC = (OiicLWSessionContext)this.m_oContextMap.get(this.getKey(sOHName, sToplevelCompName))) != null && (oVar = oLWSC.getVariable(sVarName)) != null) {
            sVarValue = oVar.getValueAsString();
        }
        return sVarValue;
    }

    public String getVariableValue(String sKey, String sVarName) {
        OiisVariable oVar;
        OiicLWSessionContext oLWSC;
        String sVarValue = null;
        if (this.m_oContextMap != null && sKey != null && sVarName != null && (oLWSC = (OiicLWSessionContext)this.m_oContextMap.get(sKey)) != null && (oVar = oLWSC.getVariable(sVarName)) != null) {
            sVarValue = oVar.getValueAsString();
        }
        return sVarValue;
    }

    public Object getVarValue(String sKey, String sVarName) {
        OiisVariable oVar;
        OiicLWSessionContext oLWSC;
        Object oVarValue = null;
        if (this.m_oContextMap != null && sKey != null && sVarName != null && (oLWSC = (OiicLWSessionContext)this.m_oContextMap.get(sKey)) != null && (oVar = oLWSC.getVariable(sVarName)) != null) {
            oVarValue = oVar.getValue();
        }
        return oVarValue;
    }

    public Object getVarValue(String sOHName, String sToplevelCompName, String sVarName) {
        OiisVariable oVar;
        OiicLWSessionContext oLWSC;
        Object oVarValue = null;
        if (this.m_oContextMap != null && sOHName != null && sToplevelCompName != null && sVarName != null && (oLWSC = (OiicLWSessionContext)this.m_oContextMap.get(this.getKey(sOHName, sToplevelCompName))) != null && (oVar = oLWSC.getVariable(sVarName)) != null) {
            oVarValue = oVar.getValue();
        }
        return oVarValue;
    }

    public int getSize() {
        return this.m_oOracleHomes.size();
    }

    public void addAggregateToGlobalSecureVarMap(String sAggregateName) {
        if (null != this.secureCompVarMap && null != sAggregateName) {
            if (this.secureCompVarMap.containsKey(sAggregateName)) {
                OiiolTextLogger.appendText("HashMap already added with the key " + sAggregateName);
            } else {
                this.secureCompVarMap.put(sAggregateName, new Vector());
                OiiolTextLogger.appendText("HashMap added with the key " + sAggregateName + " and an empty variable Vector");
            }
        }
    }

    public void addParameterValueToGlobalSecureVarMap(String sAggregateName, OiisVariable oVar) {
        if (null != sAggregateName && null != oVar) {
            Vector<OiisVariable> v;
            if (!this.secureCompVarMap.containsKey(sAggregateName)) {
                this.addAggregateToGlobalSecureVarMap(sAggregateName);
            }
            if (null == (v = (Vector<OiisVariable>)this.secureCompVarMap.get(sAggregateName))) {
                v = new Vector<OiisVariable>();
            }
            if (!v.contains(oVar)) {
                v.addElement(oVar);
                OiiolTextLogger.appendText("Adding the variable " + oVar.getName() + " to the aggregate " + sAggregateName);
            }
        }
    }

    public Vector getParametersFromGlobalSecureVarMap(String sAggregateName) {
        Vector v = null;
        if (null != sAggregateName) {
            v = (Vector)this.secureCompVarMap.get(sAggregateName);
        }
        return v;
    }

    public Set getGlobalSecureVarAggrNames() {
        if (null != this.secureCompVarMap) {
            return this.secureCompVarMap.keySet();
        }
        return null;
    }
}

