/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import oracle.sysman.oii.oiic.OiicInventorySession;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;

public class OiicDetachedInventorySession
extends OiicInventorySession {
    private int m_nPlatform;

    public OiicDetachedInventorySession(String sAppID, String sAppVer) {
        this(sAppID, sAppVer, OiixPlatform.getCurrentPlatform());
    }

    public OiicDetachedInventorySession(String sAppID, String sAppVer, int nPlatform) {
        super(sAppID, sAppVer);
        this.m_nPlatform = nPlatform;
        String sOUILoc = System.getProperty("oracle.installer.oui_loc");
        String sLibLoc = System.getProperty("oracle.installer.library_loc", null);
        if (sOUILoc != null && (sLibLoc == null || sLibLoc.length() == 0)) {
            String sLibraryLoc = OiixPathOps.concatPath(sOUILoc, "lib");
            sLibraryLoc = OiixPathOps.concatPath(sLibraryLoc, OiixPlatform.getPlatformDirectoryName(nPlatform));
            sLibraryLoc = OiixPathOps.getNativeForm(sLibraryLoc);
            System.setProperty("oracle.installer.library_loc", sLibraryLoc);
        }
    }

    public void initSession() {
        OiiolTextLogger.setEnabled(false);
    }

    public OiiiInstallInventory createInstallInventory() {
        return new OiiiInstallInventory(false, this.m_nPlatform);
    }

    public void endSession() {
        OiiolTextLogger.setEnabled(true);
    }
}

