/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.io.IOException;
import oracle.sysman.oii.oiic.OiicBaseInventoryApp;
import oracle.sysman.oii.oiic.OiicExitCode;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiInventoryUpdateException;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiix.OiixException;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiicDetachSuite
extends OiicBaseInventoryApp {
    private static final String appName = "detachsuite";
    private static OiicDetachSuite s_oDetachSuite = null;

    private OiicDetachSuite() {
        super(appName);
    }

    private OiicDetachSuite(String app) {
        super(app);
    }

    public static OiicDetachSuite getOiicDetachSuiteInstance() {
        if (s_oDetachSuite == null) {
            s_oDetachSuite = new OiicDetachSuite();
        }
        return s_oDetachSuite;
    }

    @Override
    protected String getLogPrefix() {
        return "DetachSuite";
    }

    @Override
    public void performValidations(OiicSessionContext oContext) {
        String sError;
        String[] oracleHomesList = (String[])oContext.getVarValue("ORACLE_HOMES");
        String suiteName = (String)oContext.getVarValue("SUITE_NAME");
        String oracleHome = (String)oContext.getVarValue("ORACLE_HOME");
        if (suiteName == null) {
            sError = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_SUITE_NAME_MISSING_DETACHSUITE_ERROR");
            OiiolTextLogger.writeMessageToConsole(sError);
            OiicExitCode.setExitCode(-1);
            System.exit(OiicExitCode.getExitCode());
        }
        if (oracleHomesList.length < 1 && oracleHome == null) {
            sError = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ORACLE_HOME_MISSING_DETACHSUITE_ERROR");
            OiiolTextLogger.writeMessageToConsole(sError);
            OiicExitCode.setExitCode(-1);
            System.exit(OiicExitCode.getExitCode());
        }
    }

    @Override
    public void doOperation(OiiiInstallAreaControl iac, OiicSessionContext oContext) throws OiifbCancelException, OiiiInventoryUpdateException, IOException, OiixException, OiisVarSettingException {
        String[] oracleHomesList = (String[])oContext.getVarValue("ORACLE_HOMES");
        String suiteName = (String)oContext.getVarValue("SUITE_NAME");
        String oracleHome = (String)oContext.getVarValue("ORACLE_HOME");
        OiiiInstallInventory instinv = iac.getInstallInventory();
        if (oracleHomesList.length > 1) {
            for (int i = 0; i < oracleHomesList.length; ++i) {
                String homeLoc = oracleHomesList[i];
                OiiiOracleHomeInfo homeInfo = instinv.getHomeWithLocation(homeLoc);
                this.updateOHProperties(homeInfo, suiteName);
            }
        } else {
            OiiiOracleHomeInfo homeInfo = instinv.getHomeWithLocation(oracleHome);
            this.updateOHProperties(homeInfo, suiteName);
        }
        iac.saveInstallInventory();
    }

    protected void updateOHProperties(OiiiOracleHomeInfo homeInfo, String suite) {
        homeInfo.removeSuite(suite);
    }

    public static void main(String[] args) {
        OiicDetachSuite oDetachSuite = OiicDetachSuite.getOiicDetachSuiteInstance();
        oDetachSuite.main_helper(args);
    }
}

