/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.io.IOException;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicDelSession;
import oracle.sysman.oii.oiic.OiicSessionPlan;
import oracle.sysman.oii.oiic.OiicStageActionsPhase;
import oracle.sysman.oii.oiic.OiicStageTimeSession;
import oracle.sysman.oii.oiic.OiicStagingPlanInfo;
import oracle.sysman.oii.oiic.OiicStagingProgressListener;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifb.OiifbProgressControl;
import oracle.sysman.oii.oiif.oiifj.OiifjRemoveDlg;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiSourceAccess;
import oracle.sysman.oii.oiii.OiiiStageAreaControl;
import oracle.sysman.oii.oiii.OiiiStageCompInvEntry;
import oracle.sysman.oii.oiii.OiiiStageInventory;
import oracle.sysman.oii.oiio.oiiod.OiiodStageDepGraph;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiicDestageSession
extends OiicDelSession
implements OiicStageTimeSession {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 4;
    OiicStageActionsPhase m_actionsPhase = null;
    OiiiStageAreaControl m_stageAreaControl = (OiiiStageAreaControl)OiiiInstallAreaControl.getInventoryAreaControl();
    private OiicStagingProgressListener m_stgProgListener;
    private OiifbProgressControl m_progCtrl;

    public OiicDestageSession(OiifjRemoveDlg remDlg) {
        super(remDlg);
    }

    public void setStagingProgressListener(OiicStagingProgressListener lstnr) {
        this.m_stgProgListener = lstnr;
    }

    public void setProgressControl(OiifbProgressControl progCtrl) {
        this.m_progCtrl = progCtrl;
    }

    public boolean isSilentMode() {
        return false;
    }

    public void setStageAreaControl(OiiiStageAreaControl stageAreaControl) {
        this.m_stageAreaControl = stageAreaControl;
        OiiiInstallAreaControl.setInventoryAreaControl(this.m_stageAreaControl);
    }

    public OiicSessionPlan computeDestagingPlan(Vector compIDs, Vector plats) throws IOException {
        OiiiStageInventory stgInv = this.getStageAreaControl().getStageInventory();
        Vector<OiiiStageCompInvEntry> matchEntries = new Vector<OiiiStageCompInvEntry>();
        int numCIDs = compIDs.size();
        for (int i = 0; i < numCIDs; ++i) {
            OiiiCompInstallID cid = (OiiiCompInstallID)compIDs.elementAt(i);
            Vector invEntries = stgInv.getCompInvEntries(cid, false);
            int numEnts = invEntries.size();
            for (int j = 0; j < numEnts; ++j) {
                OiiiStageCompInvEntry scie = (OiiiStageCompInvEntry)invEntries.elementAt(j);
                int compType = scie.getCompInstallID().getCompType();
                if (compType != 4 && OiixVectorOps.intersect(scie.getPlatforms(), plats).isEmpty()) continue;
                matchEntries.addElement(scie);
            }
        }
        return this.computeDestagingPlan(matchEntries);
    }

    public OiicSessionPlan computeDestagingPlan(Vector invEntries) throws IOException {
        OiicSessionPlan sessionPlan = new OiicSessionPlan();
        this.setSessionPlan(sessionPlan);
        sessionPlan.clearPlan();
        OiiodStageDepGraph dGraph = new OiiodStageDepGraph();
        dGraph.init(this.getStageAreaControl());
        Vector remEntries = dGraph.getDestageEntries(invEntries);
        int numRems = remEntries.size();
        for (int i = 0; i < numRems; ++i) {
            OiiiStageCompInvEntry remEntry = (OiiiStageCompInvEntry)remEntries.elementAt(i);
            OiicStagingPlanInfo stgPlanInfo = new OiicStagingPlanInfo(remEntry);
            stgPlanInfo.setPlatforms((Vector)remEntry.getPlatforms().clone());
            OiiiCompInstallID cid = remEntry.getCompInstallID();
            System.out.println("Adding removal : " + stgPlanInfo);
            sessionPlan.addRemoval(cid, (Object)stgPlanInfo);
        }
        return sessionPlan;
    }

    public void executeDestagingPlan() throws OiifbEndIterateException {
        OiicStageActionsPhase actionsPhase = new OiicStageActionsPhase(this, null);
        actionsPhase.setStagingProgressListener(this.m_stgProgListener);
        actionsPhase.setProgressControl(this.m_progCtrl);
        actionsPhase.doOperation(false);
    }

    @Override
    public void startInstall() {
        this.m_actionsPhase = new OiicStageActionsPhase(this, this.m_remDlg);
        this.m_actionsPhase.doOperationInner();
    }

    @Override
    public OiiiStageAreaControl getStageAreaControl() {
        return this.m_stageAreaControl;
    }

    @Override
    public OiiiSourceAccess getSourceAccess() {
        return null;
    }
}

