/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicAPIInstaller;
import oracle.sysman.oii.oiic.OiicBaseApp;
import oracle.sysman.oii.oiic.OiicDelSession;
import oracle.sysman.oii.oiic.OiicExitCode;
import oracle.sysman.oii.oiic.OiicInstallTimeSession;
import oracle.sysman.oii.oiic.OiicInstaller;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiic.OiicSessionPlan;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifb.OiifbSyncObject;
import oracle.sysman.oii.oiif.oiifb.OiifbWizOperation;
import oracle.sysman.oii.oiif.oiifj.OiifjInventoryDialog;
import oracle.sysman.oii.oiif.oiifj.OiifjRemoveDlg;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiif.oiifm.OiifmGraphicInterfaceManager;
import oracle.sysman.oii.oiif.oiifm.OiifmMainFrame;
import oracle.sysman.oii.oiif.oiifm.OiifmProgressCancelHandler;
import oracle.sysman.oii.oiif.oiifp.OiifpWizIntroPanel;
import oracle.sysman.oii.oiif.oiifr.OiifrProgressActionListener;
import oracle.sysman.oii.oiif.oiifw.OiifwActionsPhaseWCDE;
import oracle.sysman.oii.oiif.oiifw.OiifwWizDialog;
import oracle.sysman.oii.oiii.OiiiAreaInventory;
import oracle.sysman.oii.oiii.OiiiCompIdOhPair;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiCompInvEntry;
import oracle.sysman.oii.oiii.OiiiDeinstallObjects;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiInventoryEnvUpdater;
import oracle.sysman.oii.oiii.OiiiLibInvEntry;
import oracle.sysman.oii.oiii.OiiiLibraryID;
import oracle.sysman.oii.oiii.OiiiOneoffIdOhPair;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiii.OiiiPatchSetInstallID;
import oracle.sysman.oii.oiii.OiiiTargetAreaControl;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiio.oiiod.OiiodDepEngineHelper;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgDetectCluster;
import oracle.sysman.oii.oiip.oiipg.OiipgOracleHomes;
import oracle.sysman.oii.oiis.OiisActionLibLoader;
import oracle.sysman.oii.oiis.OiisCompInstallation;
import oracle.sysman.oii.oiis.OiisDialogLibLoader;
import oracle.sysman.oii.oiis.OiisLibraryLoader;
import oracle.sysman.oii.oiis.OiisPatchSetInstallation;
import oracle.sysman.oii.oiis.OiisQueryLibLoader;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiix.OiixDebug;
import oracle.sysman.oii.oiix.OiixInstallUtil;
import oracle.sysman.oii.oiix.OiixInstantiateOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixUtil;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiicDeinstallSession
extends OiicDelSession
implements OiicInstallTimeSession,
OiifbWizOperation,
OiiiInventoryEnvUpdater,
OiifrProgressActionListener {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 4;
    OiifwActionsPhaseWCDE m_actionsPhase = null;
    private boolean m_bSilentDeinstall = false;
    private String m_sInvLoc;
    private OiifbSyncObject m_invSetupSync = new OiifbSyncObject();
    private OiiiTargetAreaControl m_targetAreaControl;
    private Hashtable m_hDeinstallTable;
    private Vector m_vDeinstallList;
    int m_nDeinstallOHIndex = 0;
    int m_nDeinstallATIndex = -1;
    private List m_lstHomesToRemove;
    private OiifbSyncObject m_syncObj = null;
    private boolean m_removeOraHome = false;
    private List m_homesToDelete;
    private Hashtable[] m_IDsToLibLoaders = new Hashtable[3];
    private String m_customDeinstallCommand = null;
    private boolean m_bCustomDeinstall = false;
    private int m_customDeinstallHomes = 0;

    public OiicDeinstallSession(OiifjRemoveDlg remDlg) {
        super(remDlg);
        for (int i = 0; i < 3; ++i) {
            this.m_IDsToLibLoaders[i] = new Hashtable();
        }
        this.m_sessionContext = new OiicSessionContext(this);
        this.initializeCluster();
    }

    public OiicDeinstallSession(OiicInstaller oi, boolean bSilentDeinstall) {
        this(bSilentDeinstall);
    }

    public OiicDeinstallSession(boolean bSilentDeinstall) {
        this(null);
        this.m_bSilentDeinstall = bSilentDeinstall;
        this.m_sessionContext = new OiicSessionContext(this);
        this.initializeCluster();
    }

    private void initializeCluster() {
        if (OiixInstallUtil.isOptionSetInOraparam("IGNORECLUSTER")) {
            return;
        }
        OiipgDetectCluster detectCluster = OiipgDetectCluster.getDetectCluster();
        if (detectCluster.isClusterMode()) {
            OiiolTextLogger.appendText("***OiicDeinstallSession:: Detect Cluster called and isClusterMode returned true.");
        }
    }

    @Override
    public OiifmMainFrame getMainFrame() {
        OiifmGraphicInterfaceManager guim = OiicDeinstallSession.getGUIManager();
        if (guim != null) {
            return guim.getMainFrame();
        }
        return null;
    }

    @Override
    public OiifwWizDialog getWizardDialog() {
        OiifmGraphicInterfaceManager guim = OiicDeinstallSession.getGUIManager();
        if (guim != null) {
            return guim.getWizardDialog();
        }
        return null;
    }

    private static OiifmGraphicInterfaceManager getGUIManager() {
        OiicSessionInterfaceManager interfaceManager = OiicSessionInterfaceManager.getInterfaceManager();
        if (interfaceManager instanceof OiifmGraphicInterfaceManager) {
            return (OiifmGraphicInterfaceManager)interfaceManager;
        }
        return null;
    }

    @Override
    public void startInstall() throws OiifbEndIterateException {
        OiicActionsThread oActionsThread = new OiicActionsThread(this);
        oActionsThread.start();
    }

    @Override
    public OiisActionLibLoader getActionLibLoader(OiiiLibraryID lid, int homeIndex) throws IOException {
        return (OiisActionLibLoader)this.getLibLoader(lid, 0, homeIndex);
    }

    public OiisLibraryLoader getLibLoader(OiiiLibraryID lid, int libType, int homeIndex) throws IOException {
        OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
        OiiiInstallInventory installInv = iac.getInstallInventory();
        lid.optimizePlatList();
        if (this.isDebug()) {
            OiixDebug.debug("OiicDeinstallSession", "Getting " + lid);
        }
        if (!this.m_IDsToLibLoaders[libType].containsKey(lid)) {
            String localFileLoc;
            OiiiLibInvEntry localLib;
            if (this.isDebug()) {
                OiixDebug.debug("OiicDeinstallSession", "" + lid + "not in hashtable");
            }
            if ((localLib = installInv.getCompatLibInvEntry(lid, libType, homeIndex)) == null) {
                if (this.isDebug()) {
                    OiixDebug.debug("OiicDeinstallSession", "No corresponding local library for " + lid);
                }
                return null;
            }
            String localLoc = localLib.getLocation();
            OiiiLibraryID newLID = localLib.getLibraryID();
            if (this.m_IDsToLibLoaders[libType].containsKey(newLID)) {
                return (OiisLibraryLoader)this.m_IDsToLibLoaders[libType].get(newLID);
            }
            if (new File(localLoc).isAbsolute()) {
                localFileLoc = localLoc;
            } else {
                String sInvDir = iac.getInventoryLocForHome(homeIndex);
                localFileLoc = OiixPathOps.concatPath(sInvDir, localLoc);
            }
            OiisLibraryLoader lLoader = null;
            switch (libType) {
                case 0: {
                    lLoader = new OiisActionLibLoader(localFileLoc);
                    break;
                }
                case 1: {
                    lLoader = new OiisQueryLibLoader(localFileLoc);
                    break;
                }
                case 2: {
                    lLoader = new OiisDialogLibLoader(localFileLoc);
                }
            }
            this.m_IDsToLibLoaders[libType].put(newLID, lLoader);
            this.m_IDsToLibLoaders[libType].put(lid, lLoader);
            lid = newLID;
        }
        return (OiisLibraryLoader)this.m_IDsToLibLoaders[libType].get(lid);
    }

    private boolean isDebug() {
        return false;
    }

    public void clearAllLibLoaders() {
        for (int i = 0; i < this.m_IDsToLibLoaders.length; ++i) {
            int size = this.m_IDsToLibLoaders[i].size();
            Enumeration em = this.m_IDsToLibLoaders[i].keys();
            for (int j = 0; j < size; ++j) {
                OiisLibraryLoader l = (OiisLibraryLoader)this.m_IDsToLibLoaders[i].remove(em.nextElement());
                l.unload();
                l = null;
            }
        }
    }

    @Override
    public OiisCompInstallation getCompInstall(OiiiCompInstallID cid) {
        return null;
    }

    @Override
    public OiisPatchSetInstallation getPSetInstall(OiiiPatchSetInstallID psid) {
        return null;
    }

    @Override
    public int getOHIndex() {
        return this.m_nDeinstallOHIndex;
    }

    public void setOHIndex(int iOHIndex) {
        this.m_nDeinstallOHIndex = iOHIndex;
    }

    @Override
    public int getAppltopIndex() {
        return 0;
    }

    @Override
    public boolean isInstallMode() {
        return false;
    }

    @Override
    public boolean isDeinstallMode() {
        return true;
    }

    @Override
    public boolean isCloneMode() {
        return false;
    }

    @Override
    public boolean isAddNodeMode() {
        return false;
    }

    @Override
    public void initialize() throws OiifbEndIterateException {
        this.m_sessionContext.setVariables();
        this.setAreaControls(null);
    }

    public void initialize(boolean noBack) throws OiifbEndIterateException {
        this.initialize();
    }

    @Override
    public int doOperation(boolean isBack) throws OiifbEndIterateException {
        OiicExitCode.setExitCode(0);
        this.m_nDeinstallOHIndex = 0;
        this.m_nDeinstallATIndex = -1;
        this.computeDeinstallList();
        if (!this.m_bSilentDeinstall && !OiixInstallUtil.isAPIMode()) {
            this.processGUIOption();
        } else {
            this.deinstallComponents();
        }
        if (OiixInstallUtil.isAPIMode()) {
            this.releaseReaderLock();
            OiiolTextLogger.appendText("disposing the install area control");
            OiiiInstallAreaControl.dispose();
        }
        return 0;
    }

    private void processGUIOption() {
        OiisVariable ovConf = this.m_sessionContext.getVariable("SHOW_DEINSTALL_CONFIRMATION");
        boolean bShowConf = (Boolean)ovConf.getValue();
        OiisVariable ovProg = this.m_sessionContext.getVariable("SHOW_DEINSTALL_PROGRESS");
        boolean bShowProg = (Boolean)ovProg.getValue();
        OiifjInventoryDialog invDlg = new OiifjInventoryDialog((Frame)((Object)this.getMainFrame()), false, true, bShowConf, bShowProg);
        invDlg.setDelSession(this);
        OiifpWizIntroPanel owip = new OiifpWizIntroPanel();
        OiifwWizDialog wd = this.getWizardDialog();
        if (null != wd) {
            boolean isWelcomeSet = OiixInstallUtil.isOptionSet("oracle.installer.welcome");
            if (isWelcomeSet) {
                wd.addWizardPanel(owip);
                wd.setEnabled(false);
                wd.setEnabledButton(2, false);
                wd.setEnabledButton(4, false);
                wd.setEnabledButton(0, false);
                wd.setEnabledButton(8, false);
                wd.setEnabledButton(1, false);
                wd.hideSplashScr();
            }
            invDlg.doModal(true);
            invDlg.dispose();
        }
    }

    @Override
    public void dispose() {
        this.m_actionsPhase = null;
        this.m_hDeinstallTable = null;
        this.m_vDeinstallList = null;
        this.m_remDlg = null;
    }

    public void setAreaControls(String sInvLoc) throws OiifbEndIterateException {
        this.m_sInvLoc = OiixInstallUtil.getInventoryLocation(sInvLoc);
        if (this.m_sInvLoc == null) {
            if (this.m_bSilentDeinstall) {
                String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_INV_LOC_NULL_ERR");
                System.out.println(sMsg);
                throw new OiifbEndIterateException(sMsg);
            }
            return;
        }
        if (this.getTargetAreaControl() == null) {
            try {
                OiiiInstallAreaControl.initAreaControl(this.m_sInvLoc);
                OiiiInstallAreaControl targetAreaControl = OiiiInstallAreaControl.getInstallAreaControl();
                if (targetAreaControl.getInstallInventory() != null) {
                    this.setTargetAreaControl(targetAreaControl);
                    targetAreaControl.setInvEnvUpdater(this);
                    this.signalLoadInv();
                    this.setLogLocation(targetAreaControl);
                }
            }
            catch (IOException e) {
                OiixInstallUtil.unsetOption("oracle.installer.cleanUpOnExit");
                throw new OiifbEndIterateException(e);
            }
        }
    }

    private void setLogLocation(OiiiInstallAreaControl targetAreaControl) throws OiifbEndIterateException {
        String logLoc = targetAreaControl.genFileSysLoc("logs");
        boolean isAPIMode = OiixInstallUtil.isAPIMode();
        boolean bUseCustomLog = false;
        String sCustomLogLoc = System.getProperty("oracle.installer.log_loc");
        if (null != sCustomLogLoc && !targetAreaControl.getAreaRoot().equalsIgnoreCase(sCustomLogLoc)) {
            logLoc = sCustomLogLoc;
            bUseCustomLog = true;
        }
        if (isAPIMode && null != OiicAPIInstaller.getHandleToAPIInstaller().getCustomLogDir()) {
            OiicAPIInstaller inst = OiicAPIInstaller.getHandleToAPIInstaller();
            try {
                logLoc = inst.getCustomLogDir();
                OiiolTextLogger.setLogLoc(inst.getCustomLogDir(), inst.getCustomLogFileName(), inst.getCustomLogFileExtn());
                bUseCustomLog = true;
            }
            catch (IOException e) {
                OiiolTextLogger.setLogLoc(logLoc);
            }
        } else {
            OiiolTextLogger.setLogLoc(logLoc);
        }
        if (!OiixInstallUtil.isSilent() && !isAPIMode) {
            OiixInstallUtil.unsetOption("oracle.installer.console");
            this.setupDuplicateStreams();
        } else if (isAPIMode) {
            if (bUseCustomLog) {
                OiicPullSession.createDuplicateStreamsForLog(logLoc);
            } else {
                this.setupDuplicateStreams();
            }
        }
        OiiolTextLogger.setSilentInstallErrLog(logLoc);
        OiiolTextLogger.appendText(OiixResourceBundle.getString("S_TL_INSTVER") + OiicBaseApp.getInstallerVersion().toString() + System.getProperty("line.separator"));
    }

    protected void setTargetAreaControl(OiiiTargetAreaControl targetAreaControl) {
        this.m_targetAreaControl = targetAreaControl;
        OiiiInstallAreaControl.setInventoryAreaControl(this.m_targetAreaControl);
    }

    public OiiiTargetAreaControl getTargetAreaControl() {
        return this.m_targetAreaControl;
    }

    public void waitOnLoadInv() {
        this.m_invSetupSync.sync();
    }

    public void signalLoadInv() {
        this.m_invSetupSync.signal();
    }

    @Override
    public void updateEnv(OiiiInstallInventory instInv) {
        Vector oHomes = instInv.getHomes();
        if (oHomes == null) {
            return;
        }
        OiisVariable homeKeyVar = this.getSessionVariable("ORACLE_HOME_KEY");
        if (homeKeyVar != null) {
            OiipgOracleHomes.setHomeCounters((String)homeKeyVar.getValue());
        }
    }

    public OiisVariable getSessionVariable(String varName) {
        if (this.m_sessionContext != null) {
            return this.m_sessionContext.getVariable(varName);
        }
        return null;
    }

    private void deinstallComponents() throws OiifbEndIterateException {
        if (this.isDebug()) {
            OiixDebug.debug("OiicDeinstallSession", "Doing Silent Deinstall");
        }
        OiiiInstallAreaControl invAreaControl = (OiiiInstallAreaControl)OiiiInstallAreaControl.getInventoryAreaControl();
        OiiiAreaInventory inventory = invAreaControl.getAreaInventory();
        Vector delComps = this.getFullDeinstallList();
        OiiiDeinstallObjects odo = this.getAllCompsForDeinstall(inventory, delComps);
        this.silentDeinstall(odo.getCompsVect(), odo.getOneoffsVect(), inventory, invAreaControl);
    }

    private List getHomesToRemove() {
        if (this.m_lstHomesToRemove == null) {
            Object[] homesToRemove;
            OiisVariable oRemoveHomesVar;
            OiiiInstallInventory instInv = OiiiInstallAreaControl.getInstallAreaControl().getInstallInventory();
            this.m_lstHomesToRemove = new ArrayList();
            if (OiixInstallUtil.isOptionSet("oracle.installer.allDepHomes")) {
                OiiiOracleHomeInfo baseHome = instInv.getHomeInfo(this.m_nDeinstallOHIndex);
                Vector refList = baseHome.getRefHomeList();
                for (int i = 0; i < refList.size(); ++i) {
                    String refOHLoc = (String)refList.elementAt(i);
                    OiiiOracleHomeInfo refHomes = instInv.getHomeWithLocation(refOHLoc);
                    this.m_lstHomesToRemove.add(refHomes);
                }
                this.m_lstHomesToRemove.add(baseHome);
            }
            boolean clusterRmHomes = false;
            if (this.m_removeOraHome) {
                OiiiOracleHomeInfo oHomeInfo = instInv.getHomeInfo(this.m_nDeinstallOHIndex);
                Vector nodeList = oHomeInfo.getNodeList();
                if (!OiixUtil.isEmpty(nodeList)) {
                    clusterRmHomes = true;
                }
                OiiolTextLogger.appendText("Adding to remove homes list: " + oHomeInfo.getLocation(), OiiolTextLogger.LOG_DETAILED);
                this.m_lstHomesToRemove.add(oHomeInfo);
            }
            if ((oRemoveHomesVar = this.m_sessionContext.getVariable("REMOVE_HOMES")) != null && !OiixUtil.isEmpty(homesToRemove = (String[])oRemoveHomesVar.getValue())) {
                for (int i = 0; i < homesToRemove.length; ++i) {
                    OiiiOracleHomeInfo homeInfo = instInv.getHomeWithLocation((String)homesToRemove[i]);
                    if (homeInfo == null) {
                        String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_HOME_LOC_NOT_FOUND", new Object[]{homesToRemove[i]});
                        OiiolTextLogger.writeToLogAndConsole(sMsg);
                        continue;
                    }
                    if (clusterRmHomes && homesToRemove.length > 1) {
                        OiicDeinstallSession.displayClusterError();
                    }
                    if (!OiixUtil.isEmpty(homeInfo.getNodeList())) {
                        clusterRmHomes = true;
                        if (this.m_lstHomesToRemove.size() > 1) {
                            OiicDeinstallSession.displayClusterError();
                        }
                    }
                    this.m_lstHomesToRemove.add(homeInfo);
                }
            }
        }
        return this.m_lstHomesToRemove;
    }

    private static void displayClusterError() {
        String msg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-22004");
        OiicDeinstallSession.displayErrorExit(msg);
    }

    private static void displayErrorExit(String msg) {
        OiifmAlert.displayError(msg);
        OiicExitCode.setExitCode(-1);
        if (!OiixInstallUtil.isAPIMode()) {
            System.exit(-1);
        }
    }

    public void silentDeinstall(Vector delComps, Vector delOneoffs, OiiiAreaInventory inventory, OiiiInstallAreaControl invAreaControl) throws OiifbEndIterateException {
        boolean silentMode = OiixInstallUtil.isSilent();
        String sDispMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_STARTING_DEINSTALL");
        if (silentMode) {
            System.out.println(sDispMsg);
        }
        OiicDeinstallSession.logMessage(sDispMsg);
        if (OiixUtil.isEmpty(delComps) && OiixUtil.isEmpty(this.getHomesToRemove())) {
            this.logNoCompErrorMessage();
            return;
        }
        boolean bLockGrabbed = this.grabWriterLock(invAreaControl);
        if (!bLockGrabbed) {
            return;
        }
        StringBuffer sMsg = new StringBuffer("");
        if (!this.prepareForDeinstall(inventory, delComps, delOneoffs, this.m_lstHomesToRemove, new OiicSessionPlan(), null, sMsg)) {
            OiicDeinstallSession.logMessage(sMsg.toString());
            if (bLockGrabbed) {
                invAreaControl.releaseWriterLock();
            }
            return;
        }
        this.m_syncObj = new OiifbSyncObject();
        this.startInstall();
        if (!this.m_syncObj.signalHappenedBeforeSync()) {
            this.m_syncObj.sync();
        }
        if (bLockGrabbed) {
            invAreaControl.releaseWriterLock();
        }
        this.logCompleteMessage(silentMode);
    }

    private void logCompleteMessage(boolean silentMode) {
        this.logMessage("End Silent Deinstall", "S_DEINSTALL_END");
    }

    private void logNoCompErrorMessage() {
        this.logMessage("No comps to deinstall", "S_DEINSTALL_LIST_EMPTY");
    }

    private void logMessage(String debugMsg, String msgKey) {
        if (this.isDebug()) {
            OiixDebug.debug("OiicDeinstallSession", debugMsg);
        }
        String sDispMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", msgKey);
        if (OiixInstallUtil.isSilent()) {
            String sDet = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_SILENT_INSTALL_DETAILS");
            System.out.println(sDispMsg);
            Object[] objs = new Object[]{OiiolTextLogger.getErrorLogFileName()};
            sDet = MessageFormat.format(sDet, objs);
            System.out.println(sDet);
            OiicDeinstallSession.logMessage(sDet);
        }
        OiicDeinstallSession.logMessage(sDispMsg);
    }

    public boolean prepareForDeinstall(OiiiAreaInventory inventory, Vector delComps, OiicSessionPlan sessionPlan, Vector vErrorComps, StringBuffer errMsg) {
        Vector delOneoffs = new Vector();
        return this.prepareForDeinstall(inventory, delComps, delOneoffs, sessionPlan, vErrorComps, errMsg);
    }

    public boolean prepareForDeinstall(OiiiAreaInventory inventory, Vector delComps, Vector delOneoffs, OiicSessionPlan sessionPlan, Vector vErrorComps, StringBuffer errMsg) {
        ArrayList delHomes = new ArrayList();
        return this.prepareForDeinstall(inventory, delComps, delOneoffs, delHomes, sessionPlan, vErrorComps, errMsg);
    }

    public boolean prepareForDeinstall(OiiiAreaInventory inventory, List delComps, List delOneoffs, List delHomes, OiicSessionPlan sessionPlan, Vector vErrorComps, StringBuffer errMsg) {
        boolean bRet = true;
        sessionPlan.clearPlan();
        this.setSessionPlan(sessionPlan);
        if (vErrorComps == null) {
            vErrorComps = new Vector<String>(5, 5);
        }
        OiiiVersion higherVersion = null;
        for (OiiiCompIdOhPair delID : delComps) {
            OiiiVersion installedVer;
            OiiiInstallCompInvEntry oEntry = (OiiiInstallCompInvEntry)inventory.getCompInvEntry(delID.getCompID(), delID.getOHIndex());
            if (oEntry != null && (installedVer = oEntry.getDeinstallVersion()).laterThan(OiicInstaller.getInstallerVersion())) {
                if (higherVersion == null || installedVer.laterThan(higherVersion)) {
                    higherVersion = installedVer;
                }
                vErrorComps.addElement(oEntry.getFullDisplayName());
            }
            sessionPlan.addRemoval(delID);
        }
        for (OiiiOneoffIdOhPair ooPair : delOneoffs) {
            sessionPlan.addRemoval(ooPair.getOneoffID(), (Object)ooPair);
        }
        for (OiiiOracleHomeInfo homeInfo : delHomes) {
            sessionPlan.addRemoval(homeInfo);
        }
        if (!OiixUtil.isEmpty(vErrorComps)) {
            String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_INST_INSTVER_ERR");
            Object[] objs = new Object[]{higherVersion.toString()};
            sMsg = MessageFormat.format(sMsg, objs);
            errMsg.append(sMsg);
            bRet = false;
        }
        return bRet;
    }

    public boolean grabWriterLock(OiiiInstallAreaControl invAreaControl) {
        boolean bLockGrabbed = true;
        try {
            invAreaControl.grabWriterLock(false);
        }
        catch (Exception e) {
            String errString = e.getMessage();
            if (OiixUtil.isNullOrBlank(errString, false)) {
                errString = OiixResourceBundle.getString("S_INV_SETUP_ERR");
            }
            String sTitle = OiixResourceBundle.getString("S_INVENTORY_LOC");
            if (this.isDebug()) {
                OiixDebug.debug("OiicDeinstallSession", "Exception : " + errString);
            }
            Object[] objs = new Object[]{errString};
            String sMessage = MessageFormat.format(OiixResourceBundle.getString("S_DEINSTALL_FAILED"), objs);
            OiifmAlert.displayAlert(sTitle, sMessage, 30, 1, 1, 20);
            OiicDeinstallSession.logMessage(sMessage);
            bLockGrabbed = false;
        }
        return bLockGrabbed;
    }

    void releaseReaderLock() {
        try {
            OiiiTargetAreaControl otac = this.getTargetAreaControl();
            if (otac != null) {
                otac.releaseReaderLock();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Vector getDeinstallList() {
        return this.m_vDeinstallList;
    }

    public void clearDeinstallList() {
        if (this.m_vDeinstallList != null) {
            this.m_vDeinstallList.removeAllElements();
        }
    }

    public Vector getDeinstallList(int ohIndex) {
        Integer iIndex = new Integer(ohIndex);
        Vector vComps = (Vector)this.m_hDeinstallTable.get(iIndex);
        return vComps;
    }

    private Vector getFullDeinstallList() {
        Enumeration enumHomes = this.m_hDeinstallTable.keys();
        Vector vDeinstall = new Vector();
        while (enumHomes.hasMoreElements()) {
            Integer oHomeIndex = (Integer)enumHomes.nextElement();
            Vector vComps = (Vector)this.m_hDeinstallTable.get(oHomeIndex);
            if (vComps == null) continue;
            OiixVectorOps.unionInPlace(vDeinstall, vComps);
        }
        return vDeinstall;
    }

    public boolean isCompInDeinstallList(OiiiCompIdOhPair currIdOhPair) {
        boolean bRet = false;
        if (currIdOhPair == null) {
            return bRet;
        }
        int ohIndex = currIdOhPair.getOHIndex();
        OiiiCompInstallID oci = currIdOhPair.getCompID();
        if (ohIndex != this.m_nDeinstallOHIndex && ohIndex != this.m_nDeinstallATIndex && ohIndex != 0) {
            return bRet;
        }
        if (oci.getCompType() != 1) {
            return bRet;
        }
        Vector comps = this.getDeinstallList();
        if (OiixUtil.isEmpty(comps)) {
            return bRet;
        }
        String compName = oci.getName();
        String compVer = oci.getVersion().getVerString();
        for (int i = 0; i < comps.size(); ++i) {
            String[] deinsComp = (String[])comps.elementAt(i);
            if (!OiixUtil.equals(compName, deinsComp[0]) || !OiixUtil.equals(compVer, deinsComp[1])) continue;
            bRet = true;
            break;
        }
        return bRet;
    }

    private void createDeinstallTable(OiiiAreaInventory inventory) {
        List homesToRemove;
        if (this.isDebug()) {
            OiixDebug.debug("OiicDeinstallSession", "In Create Deinstall components Table");
        }
        if (inventory == null) {
            if (this.isDebug()) {
                OiixDebug.debug("OiicDeinstallSession", "Deinstall list is empty");
            }
            return;
        }
        OiiiInstallInventory oii = (OiiiInstallInventory)inventory;
        if (this.m_vDeinstallList != null) {
            if (this.isDebug()) {
                OiixDebug.debug("OiicDeinstallSession", "Deinstall list is empty");
            }
            if (this.m_nDeinstallOHIndex != 0) {
                this.processDeinstallOH(inventory, oii);
            }
            Vector comps = this.getDeinstallList();
            comps = (Vector)comps.clone();
            if (!this.m_removeOraHome) {
                this.addToTable(inventory, this.m_nDeinstallOHIndex, comps);
            }
            if (this.m_nDeinstallATIndex == -1) {
                if (this.isDebug()) {
                    OiixDebug.debug("OiicDeinstallSession", "Deinstall list is empty for Appl tops, as no Appl Top is specified");
                }
            } else {
                this.addToTable(inventory, this.m_nDeinstallATIndex, comps);
            }
            if (this.m_nDeinstallOHIndex != 0) {
                this.addToTable(inventory, 0, comps);
            }
        }
        if (!OiixUtil.isEmpty(homesToRemove = this.getHomesToRemove())) {
            for (OiiiOracleHomeInfo homeInfo : homesToRemove) {
                this.addtoDeinstallTable(homeInfo, inventory);
                oii.setOHProperties(homeInfo);
            }
        }
        this.checkForMultipleClusterHomes(this.m_hDeinstallTable);
        this.customDeinstallProcess(homesToRemove);
    }

    private void addToTable(OiiiAreaInventory inventory, int homeIndex, Vector comps) {
        Vector invComps = inventory.getAllCompsVect(homeIndex);
        Vector ohComps = this.createCompOHList(inventory, comps, invComps, homeIndex);
        this.m_hDeinstallTable.put(homeIndex, ohComps);
    }

    private void processDeinstallOH(OiiiAreaInventory inventory, OiiiInstallInventory oii) {
        boolean bCanSetOHProp = OiixInstallUtil.isDefaultsOverriddenPropSet("oracle.installer.compsdeinstall");
        OiiiOracleHomeInfo oHomeInfo = oii.getHomeInfo(this.m_nDeinstallOHIndex);
        oii.setOHProperties(oHomeInfo);
        boolean compsDeinstall = oii.allowCompsDeinstall(oHomeInfo, bCanSetOHProp);
        if (!compsDeinstall) {
            this.m_removeOraHome = true;
            this.addtoDeinstallTable(oHomeInfo, inventory);
        }
    }

    private void customDeinstallProcess(List homesToRemove) {
        this.customDeinstallCheck(homesToRemove);
        if (this.m_bCustomDeinstall) {
            if (this.m_customDeinstallHomes > 1) {
                String msg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-22026");
                OiicDeinstallSession.displayErrorExit(msg);
            } else if (this.m_customDeinstallHomes == 1) {
                Object[] args = new String[]{this.m_customDeinstallCommand};
                String msg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-22025", args);
                OiicDeinstallSession.displayErrorExit(msg);
            }
        }
    }

    private void addtoDeinstallTable(OiiiOracleHomeInfo homeInfo, OiiiAreaInventory inventory) {
        int homeIndex = homeInfo.getIndex();
        Vector tlComps = inventory.getTopLevelComps(homeIndex);
        if (!OiixUtil.isEmpty(tlComps)) {
            Vector<OiiiCompIdOhPair> lstIdOh = new Vector<OiiiCompIdOhPair>(tlComps.size());
            for (OiiiCompInstallID cid : tlComps) {
                if (cid instanceof OiiiPatchSetInstallID) continue;
                OiiiCompIdOhPair idOhPair = new OiiiCompIdOhPair(cid, homeIndex);
                lstIdOh.add(idOhPair);
            }
            this.m_hDeinstallTable.put(new Integer(homeIndex), lstIdOh);
        }
    }

    private void checkForMultipleClusterHomes(Hashtable ht) {
        boolean clusterRmHomes = false;
        int clusterRmHomeIndex = -10;
        ArrayList<Integer> ohList = new ArrayList<Integer>();
        OiiiInstallAreaControl oiac = OiiiInstallAreaControl.getInstallAreaControl();
        OiiiInstallInventory inv = oiac.getInstallInventory();
        Enumeration en = ht.keys();
        while (en.hasMoreElements()) {
            Integer indexInt;
            OiiiOracleHomeInfo ohInfo;
            Object nextElement = en.nextElement();
            int index = (Integer)nextElement;
            List nextObject = (List)ht.get(nextElement);
            if (nextObject.size() == 0 || (ohInfo = inv.getHomeInfo(index)) == null) continue;
            if (clusterRmHomes) {
                if (clusterRmHomeIndex != index) {
                    OiicDeinstallSession.displayClusterError();
                }
            } else {
                Vector nodeList = ohInfo.getNodeList();
                if (nodeList != null && nodeList.size() > 0) {
                    if (ohList.size() > 0) {
                        OiicDeinstallSession.displayClusterError();
                    } else {
                        clusterRmHomes = true;
                        clusterRmHomeIndex = index;
                    }
                }
            }
            if (ohList.contains(indexInt = new Integer(index))) continue;
            ohList.add(indexInt);
        }
    }

    private Vector createCompOHList(OiiiAreaInventory inventory, Vector comps, Vector invComps, int ohIndex) {
        Vector retCompsList = new Vector();
        if (invComps == null) {
            if (this.isDebug()) {
                OiixDebug.debug("OiicDeinstallSession", "No components in inventory");
            }
            OiicDeinstallSession.logMessage(OiixResourceBundle.getString("S_NO_INST_PRODS_PROMPT"));
            return retCompsList;
        }
        if (OiixUtil.isEmpty(comps)) {
            return retCompsList;
        }
        Vector<OiiiCompInstallID> compIdsVect = new Vector<OiiiCompInstallID>();
        block0: for (int i = 0; i < invComps.size(); ++i) {
            OiiiCompInvEntry cie = (OiiiCompInvEntry)invComps.elementAt(i);
            String invCompName = cie.getCompInstallID().getName();
            String invCompVer = cie.getVersion().getVerString();
            for (int k = 0; k < comps.size(); ++k) {
                String[] compEntry = (String[])comps.elementAt(k);
                if (!OiixUtil.equals(invCompName, compEntry[0]) || !OiixUtil.equals(invCompVer, compEntry[1])) continue;
                if (this.isDebug()) {
                    OiixDebug.debug("OiicDeinstallSession", "Adding to deinstall list :" + cie.getFullDisplayName());
                }
                compIdsVect.addElement(cie.getCompInstallID());
                comps.removeElementAt(k);
                continue block0;
            }
        }
        Vector compOhVect = OiiiCompIdOhPair.createCompIdOhVector(compIdsVect, ohIndex);
        return compOhVect;
    }

    private OiiiDeinstallObjects getAllCompsForDeinstall(OiiiAreaInventory inventory, Vector comps) {
        Vector compsList = new Vector();
        Vector oneoffsList = new Vector();
        if (!OiixUtil.isEmpty(comps)) {
            boolean debug = OiixInstallUtil.isDebug();
            for (int j = 0; j < comps.size(); ++j) {
                OiiiCompIdOhPair currIdOhPair = (OiiiCompIdOhPair)comps.elementAt(j);
                if (debug) {
                    OiiolTextLogger.appendText(" Calling getRefsToDeinstall for " + currIdOhPair);
                }
                Vector refComps = OiiodDepEngineHelper.getRefsToDeinstall(inventory, currIdOhPair, comps, oneoffsList);
                for (int n = 0; n < refComps.size(); ++n) {
                    if (comps.contains(refComps.elementAt(n))) continue;
                    if (debug) {
                        OiiolTextLogger.appendText("Adding to  Deinstall referencers List " + refComps.elementAt(n));
                    }
                    comps.addElement(refComps.elementAt(n));
                }
            }
            if (debug) {
                OiiolTextLogger.appendText(" Calling getDependeesToDeinstall");
            }
            compsList = OiiodDepEngineHelper.getDependeesToDeinstall(inventory, comps, oneoffsList, new Hashtable());
        }
        return new OiiiDeinstallObjects(compsList, oneoffsList);
    }

    protected void computeDeinstallList() throws OiifbEndIterateException {
        this.m_hDeinstallTable = new Hashtable();
        this.m_vDeinstallList = new Vector(1, 1);
        OiiiInstallAreaControl oiac = OiiiInstallAreaControl.getInstallAreaControl();
        if (oiac == null) {
            return;
        }
        OiiiInstallInventory oii = oiac.getInstallInventory();
        Vector vHomes = oii.getHomes();
        if (OiixUtil.isEmpty(vHomes)) {
            if (this.isDebug()) {
                OiixDebug.debug("OiicDeinstallSession", "No homes in inventory");
            }
            if (vHomes == null) {
                throw new OiifbEndIterateException(OiixResourceBundle.getString("S_LOG_INV_READ_HOMELIST_ERROR"));
            }
            return;
        }
        this.setOHIndex(vHomes);
        this.setApplTopIndex(vHomes);
        OiisVariable retVar = null;
        try {
            if (this.m_sessionContext != null && (retVar = this.m_sessionContext.getVariable("DEINSTALL_LIST")) != null && retVar.getType() == OiisVariable.STRINGLIST) {
                this.addToDeinstallList(retVar);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        OiiiAreaInventory oai = oiac.getAreaInventory();
        this.createDeinstallTable(oai);
    }

    private void addToDeinstallList(OiisVariable retVar) {
        Object oVal = retVar.getValue();
        if (oVal != null && oVal instanceof String[]) {
            String[] compList = (String[])oVal;
            int listLen = compList.length;
            int adv = 2;
            if (listLen < adv) {
                if (this.isDebug()) {
                    OiixDebug.debug("OiicDeinstallSession", "De install list should have more than one entries");
                }
            } else if (listLen % 2 != 0) {
                if (this.isDebug()) {
                    OiixDebug.debug("OiicDeinstallSession", "Deinstall list contains odd entries");
                }
            } else {
                for (int i = 0; i < listLen; i += adv) {
                    String name = compList[i];
                    String version = compList[i + 1];
                    this.m_vDeinstallList.addElement(new String[]{name, version});
                }
            }
        }
    }

    private void setApplTopIndex(Vector vHomes) {
        OiisVariable ovATName = this.m_sessionContext.getVariable("APPLTOP_NAME");
        OiisVariable ovAT = this.m_sessionContext.getVariable("APPLTOP");
        String sATName = (String)ovATName.getValue();
        String sATLoc = (String)ovAT.getValue();
        if (sATName != null || sATLoc != null) {
            this.m_nDeinstallATIndex = this.getHomeIndex(vHomes, sATName, sATLoc, 1);
        }
    }

    private void setOHIndex(Vector vHomes) {
        OiisVariable ovOHName = this.m_sessionContext.getVariable("ORACLE_HOME_NAME");
        String sOHName = (String)ovOHName.getValue();
        OiisVariable ovOH = this.m_sessionContext.getVariable("ORACLE_HOME");
        String sOHLoc = (String)ovOH.getValue();
        if (sOHName != null || sOHLoc != null) {
            this.m_nDeinstallOHIndex = this.getHomeIndex(vHomes, sOHName, sOHLoc, 0);
            if (this.m_nDeinstallOHIndex == -1) {
                this.m_nDeinstallOHIndex = 0;
            }
        }
    }

    private int getHomeIndex(Vector vHomes, String sHomeName, String sHomeLoc, int nHomeType) {
        int retVal = -1;
        if (vHomes == null) {
            return retVal;
        }
        int iSize = vHomes.size();
        for (int j = 0; j < iSize; ++j) {
            OiiiOracleHomeInfo oh = (OiiiOracleHomeInfo)vHomes.elementAt(j);
            if (oh.getHomeType() != nHomeType || !OiixUtil.equals(sHomeName, oh.getName(), true) && !OiixUtil.equals(sHomeLoc, oh.getLocation(), true)) continue;
            retVal = oh.getIndex();
            break;
        }
        return retVal;
    }

    public void setupDuplicateStreams() throws OiifbEndIterateException {
        OiicPullSession.createDuplicateStreams(this.m_sInvLoc);
    }

    @Override
    public void setTotalBytes(long bytes) {
    }

    @Override
    public void setStatus(String status) {
    }

    @Override
    public void addBytes(int bytes) {
    }

    @Override
    public void removeBytes(int bytes) {
    }

    @Override
    public void onDoneProgress() {
    }

    @Override
    public void onCurrentComponent(String Comp) {
    }

    @Override
    public void onStartDeinstall() {
    }

    public void onStartInstall() {
    }

    public void onStartLink() {
    }

    public void onStartInstallPhase2() {
    }

    public void onStartClusterOps() {
    }

    @Override
    public void onDoneDeinstall() {
    }

    public void onDoneInstall() {
    }

    public void onDoneLink() {
    }

    public void onDoneInstallPhase2() {
    }

    public void onDoneClusterOps() {
    }

    @Override
    public void onSuspend() {
    }

    @Override
    public void onResume() {
    }

    @Override
    public void addPercentage(int percent) {
    }

    @Override
    public boolean isNewProgressUsed() {
        return true;
    }

    private static void logMessage(String msg) {
        if (OiixInstallUtil.isSilent()) {
            OiiolTextLogger.appendErrorText(msg);
        } else {
            OiiolTextLogger.appendText(msg);
        }
    }

    @Override
    public void setTitle(String title) {
    }

    public String setLocalNode(OiiiOracleHomeInfo homeInfo) throws OiisVarSettingException, OiifbCancelException {
        OiicSessionContext oContext = this.getSessionContext();
        return oContext.setLocalNodeName(homeInfo);
    }

    public String[] setRemoteNodes() throws OiisVarSettingException, OiifbCancelException {
        OiicSessionContext oContext = this.getSessionContext();
        return oContext.setRemoteNodeList();
    }

    public List getHomesToDelete() {
        return this.m_homesToDelete;
    }

    public void setHomesToDelete(List homelocs) {
        this.m_homesToDelete = homelocs;
    }

    @Override
    public void onStartPhase(int phase) {
    }

    @Override
    public void onDonePhase(int phase) {
    }

    private void customDeinstallCheck(List lstHomesToRemove) {
        this.m_bCustomDeinstall = false;
        this.m_customDeinstallHomes = 0;
        if (OiixInstallUtil.isOptionSet("oracle.installer.forceDeinstall")) {
            return;
        }
        if (!lstHomesToRemove.isEmpty()) {
            for (OiiiOracleHomeInfo homeInfo : lstHomesToRemove) {
                Properties homeProps = homeInfo.getHomeProperties();
                if (homeProps == null) continue;
                ++this.m_customDeinstallHomes;
                String customDeinstall = homeProps.getProperty("oracle.install.customizedeinstall");
                if (customDeinstall == null || !customDeinstall.equalsIgnoreCase("true")) continue;
                this.m_bCustomDeinstall = true;
                this.m_customDeinstallCommand = homeProps.getProperty("oracle.install.customdeinstallcommand");
                HashMap<String, String> oSearchReplaceMap = new HashMap<String, String>();
                String delimiter = "%";
                String key = delimiter + "ORACLE_HOME" + delimiter;
                String value = homeInfo.getLocation();
                oSearchReplaceMap.put(key, value);
                this.m_customDeinstallCommand = OiixInstantiateOps.processString(this.m_customDeinstallCommand, oSearchReplaceMap, delimiter);
                if (this.m_customDeinstallHomes <= 1) continue;
                break;
            }
        }
    }

    private class OiicActionsThread
    extends Thread {
        OiicInstallTimeSession m_session;
        OiicSessionInterfaceManager interfaceManager;

        public OiicActionsThread(OiicDeinstallSession session) {
            super("deinstallThread");
            this.interfaceManager = null;
            this.m_session = session;
        }

        @Override
        public void run() {
            block5: {
                try {
                    OiicDeinstallSession.this.m_actionsPhase = new OiifwActionsPhaseWCDE(this.m_session);
                    if (OiicDeinstallSession.this.m_remDlg != null) {
                        OiicDeinstallSession.this.m_remDlg.addProgressUIListener(new OiifmProgressCancelHandler(OiicDeinstallSession.this.m_actionsPhase));
                    }
                    OiicInstallTimeSession oSession = null;
                    if (null == this.interfaceManager) {
                        this.interfaceManager = OiicSessionInterfaceManager.getInterfaceManager();
                        oSession = this.interfaceManager.getSession();
                        this.interfaceManager.setSession(this.m_session);
                    }
                    OiicDeinstallSession.this.m_actionsPhase.initialize();
                    OiicDeinstallSession.this.m_actionsPhase.doOperation(false);
                    this.interfaceManager.setSession(oSession);
                    OiicDeinstallSession.logMessage(OiixResourceBundle.getString("S_DEINSTALL_SUCCESS"));
                    if (OiicDeinstallSession.this.m_syncObj != null) {
                        OiicDeinstallSession.this.m_syncObj.signal();
                    }
                }
                catch (OiifbEndIterateException ex) {
                    ex.printStackTrace();
                    if (OiicDeinstallSession.this.m_syncObj == null) break block5;
                    OiicDeinstallSession.this.m_syncObj.signal();
                }
            }
        }
    }
}

