/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.io.File;
import java.util.HashMap;
import java.util.Vector;
import oracle.sysman.emCfg.client.CfwSession;
import oracle.sysman.oii.oiic.OiicGlobalContext;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiic.OiicSessionPlan;
import oracle.sysman.oii.oiii.OiiiCompIdOhPair;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiPatchInstallID;
import oracle.sysman.oii.oiii.OiiiPatchSetInstallID;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterOps;
import oracle.sysman.oii.oiip.oiipg.OiipgRemoteFileOperationException;
import oracle.sysman.oii.oiip.oiipg.OiipgRemoteOpsException;
import oracle.sysman.oii.oiis.OiisCompInstallation;
import oracle.sysman.oii.oiis.OiisCompProperties;
import oracle.sysman.oii.oiis.OiisConfigToolDetails;
import oracle.sysman.oii.oiis.OiisPatchSetInstallation;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiicConfigContext {
    private HashMap m_cfwSessionTable = new HashMap();
    private HashMap m_compsWithOptPlugInsToBeInActive = null;
    private Vector m_plugInList = null;
    private Vector m_exitOnlyPlugInList = null;
    private CfwSession m_CFSession = null;
    private static boolean m_bInstallDoneFileGenerated = false;
    private boolean m_bPatchSetInstall = false;
    private static final String sConfigXMLRltPath = OiiiInstallAreaControl.getConfigXMLDirRltPath();
    private static final String addLanguage = OiiiInstallAreaControl.getAddLanguageAggregateName();

    public OiicConfigContext() {
        OiiolTextLogger.appendText("config-context initialized");
    }

    public boolean isInstallDoneFineGenerated() {
        return m_bInstallDoneFileGenerated;
    }

    public void setInstallDoneFileGenFlag(boolean b) {
        m_bInstallDoneFileGenerated = b;
    }

    public String[] getPlugInsToBeInActive(String compName) {
        return (String[])this.m_compsWithOptPlugInsToBeInActive.get(compName);
    }

    public void savePlugInToBeInActive(String compName, String plugInID) {
        String[] current_plugIns;
        if (this.m_compsWithOptPlugInsToBeInActive == null) {
            this.m_compsWithOptPlugInsToBeInActive = new HashMap();
        }
        if ((current_plugIns = (String[])this.m_compsWithOptPlugInsToBeInActive.get(compName)) == null) {
            String[] plugIns = new String[]{plugInID};
            this.m_compsWithOptPlugInsToBeInActive.put(compName, plugIns);
        } else {
            String[] plugIns = new String[current_plugIns.length + 1];
            for (int ii = 0; ii < current_plugIns.length; ++ii) {
                plugIns[ii] = current_plugIns[ii];
            }
            plugIns[current_plugIns.length] = plugInID;
            this.m_compsWithOptPlugInsToBeInActive.put(compName, plugIns);
        }
    }

    public String[] getCompsWithPlugInsToBeInActive() {
        String[] cmpList = null;
        Object[] objs = this.m_compsWithOptPlugInsToBeInActive.keySet().toArray();
        if (objs != null) {
            cmpList = new String[objs.length];
            for (int i = 0; i < objs.length; ++i) {
                cmpList[i] = (String)objs[i];
            }
        }
        return cmpList;
    }

    public boolean plugInsToBeSetInactive() {
        return this.m_compsWithOptPlugInsToBeInActive != null && this.m_compsWithOptPlugInsToBeInActive.size() > 0;
    }

    public void saveCfwSession(CfwSession cfSession) {
        this.m_CFSession = cfSession;
    }

    public CfwSession getCfwSession(String oraHomeName, String TLCompName) {
        String key = oraHomeName + TLCompName;
        return (CfwSession)this.m_cfwSessionTable.get(key);
    }

    public CfwSession getCfwSession() {
        return this.m_CFSession;
    }

    public void saveCfwSession(CfwSession cfwSession, String oraHomeName, String TLCompName) {
        String key = oraHomeName + TLCompName;
        this.m_cfwSessionTable.put(key, cfwSession);
    }

    public Vector getPlugInList() {
        return this.m_plugInList;
    }

    public void savePlugInList(Vector pluginList) {
        this.m_plugInList = new Vector();
        this.m_plugInList.addAll(pluginList);
    }

    public Vector getExitOnlyPlugInList() {
        return this.m_exitOnlyPlugInList;
    }

    public void saveExitOnlyPlugInList(Vector pluginList) {
        OiiolTextLogger.appendText("saving exit only tools ...");
        this.m_exitOnlyPlugInList = new Vector();
        this.m_exitOnlyPlugInList.addAll(pluginList);
    }

    public String getEncapsulatingAggregateName() {
        String aggrFileName = null;
        String aggrName = null;
        aggrFileName = this.getValFromGlobalContext(0, "ENCAPSULATING_AGGREGATE_NAME");
        if (aggrFileName != null && aggrFileName.endsWith(".xml")) {
            int indx = aggrFileName.lastIndexOf(46);
            aggrName = aggrFileName.substring(0, indx);
        } else if (aggrFileName != null) {
            aggrName = aggrFileName;
        } else {
            OiiolTextLogger.appendText("encapsulating aggregate name not found from global context");
        }
        if (aggrName != null && aggrName.length() == 0) {
            OiiolTextLogger.appendText("encapsulating aggregate name is empty string: no configuration");
            return null;
        }
        return aggrName;
    }

    public boolean isPatchSetInstall() {
        return this.m_bPatchSetInstall;
    }

    public void setPatchSetInstall(boolean val) {
        this.m_bPatchSetInstall = val;
    }

    private String getValFromGlobalContext(int sessionIndex, String varName) {
        String key = null;
        String val = null;
        if (OiicGlobalContext.getGlobalContext().getKeys().hasNext()) {
            key = OiicGlobalContext.getGlobalContext().getKey(sessionIndex);
        }
        if (key != null) {
            val = OiicGlobalContext.getGlobalContext().getVariableValue(key, varName);
        }
        if (val == null) {
            OiiolTextLogger.appendText("not found: value from global context for: " + varName);
        }
        return val;
    }

    public static boolean isNextSessionExist(OiicPullSession ps) {
        boolean nextS = false;
        OiicSessionContext oSessionContext = ps.getSessionContext();
        OiisVariable oNSVar = oSessionContext.getVariable("NEXT_SESSION");
        OiisVariable oNSRVar = oSessionContext.getVariable("NEXT_SESSION_RESPONSE");
        if (oNSVar != null && oNSRVar != null) {
            Boolean ns = (Boolean)oNSVar.getValue();
            String nextSessionResFileName = (String)oNSRVar.getValue();
            if (ns != null && ns.booleanValue() && nextSessionResFileName != null && nextSessionResFileName.length() != 0) {
                nextS = true;
            }
            return nextS;
        }
        return nextS;
    }

    public static boolean isChainInstall(OiicPullSession ps) {
        boolean chainInst = false;
        if (OiicConfigContext.isResumedChainInstallSession()) {
            return true;
        }
        if (OiicConfigContext.isNextSessionExist(ps)) {
            return true;
        }
        String firstHomeKey = OiicGlobalContext.getGlobalContext().getKey(0);
        OiisVariable ns = (OiisVariable)OiicGlobalContext.getGlobalContext().getVarValue(firstHomeKey, "NEXT_SESSION");
        OiisVariable nsr = (OiisVariable)OiicGlobalContext.getGlobalContext().getVarValue(firstHomeKey, "NEXT_SESSION_RESPONSE");
        chainInst = ns != null && nsr != null && ns.getValue() != null && nsr.getValue() != null && (Boolean)ns.getValue() != false && ((String)nsr.getValue()).length() != 0;
        return chainInst;
    }

    public boolean isFirstInstallSession() {
        return OiicGlobalContext.getGlobalContext().getSize() == 0;
    }

    public static boolean isResumedChainInstallSession() {
        return OiicGlobalContext.getGlobalContext().getSize() > 0;
    }

    boolean canProceedForConfiguration(OiicPullSession ps) {
        OiicSessionPlan sessionPlan = ps.getSessionPlan();
        Vector installElems = new Vector();
        if (ps.isAddNodeMode()) {
            if (!Boolean.getBoolean("oracle.installer.config")) {
                return false;
            }
            installElems = sessionPlan.getSuccessfulAdditionsForAddNode();
        } else {
            installElems = sessionPlan.getSuccessfulAdditions(60, true);
            if (this.isPatchSetInstall()) {
                Vector vPatchSetInstallElems = sessionPlan.getPatchSets();
                installElems = OiixVectorOps.union(vPatchSetInstallElems, installElems);
            }
        }
        Vector installIEs = installElems;
        int numInstalls = installIEs.size();
        OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
        OiiiInstallInventory instInv = iac.getInstallInventory();
        if (ps.isCloneMode()) {
            if (ps.isCloneMode() && !ps.isHomeVersionCompatibleForClone()) {
                return false;
            }
            OiisVariable oraHomeLoc = ps.getContext().getVariable("ORACLE_HOME");
            String sOHLoc = (String)oraHomeLoc.getValue();
            String configXMLDirName = sOHLoc.concat("/").concat(sConfigXMLRltPath);
            File f = new File(configXMLDirName = OiixPathOps.getNativeForm(configXMLDirName));
            if (f.exists()) {
                return true;
            }
        }
        OiiiInstallCompInvEntry icie = null;
        for (int i = numInstalls - 1; i >= 0; --i) {
            icie = (OiiiInstallCompInvEntry)installIEs.elementAt(i);
            OiiiCompInstallID cid = icie.getCompInstallID();
            if (!this.allDepsPastPhase(icie, 60, ps, sessionPlan) || !this.compIsConfigurable(cid, ps)) continue;
            return true;
        }
        return false;
    }

    public boolean compIsConfigurable(OiiiCompInstallID cid, OiicPullSession ps) {
        OiisCompProperties compProps = this.getCompProperties(cid, ps);
        if (null != compProps) {
            return compProps.getConfigToolCount() > 0;
        }
        return false;
    }

    public boolean isPatchSet(OiiiCompInstallID cid) {
        return cid.getCompType() == 4;
    }

    public boolean allDepsPastPhase(OiiiCompInvEntry cie, int phase, OiicPullSession ps, OiicSessionPlan sessionPlan) {
        OiiiCompInstallID baseId;
        OiiiCompInstallID id;
        boolean bAllDepsPast = true;
        Vector dependees = cie.getDependees();
        int numDeps = dependees.size();
        OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
        OiiiInstallInventory instInv = iac.getInstallInventory();
        for (int i = 0; i < numDeps; ++i) {
            OiiiCompIdOhPair depIdOh = (OiiiCompIdOhPair)dependees.elementAt(i);
            OiiiCompInstallID depID = depIdOh.getCompID();
            if (sessionPlan.getAdditionPhase(depID) >= phase || instInv.getCompatCompEntry(depID, depIdOh.getOHIndex()) != null || depIdOh.getDepType() == 0) continue;
            bAllDepsPast = false;
            break;
        }
        if ((id = cie.getCompInstallID()).getCompType() == 2 && sessionPlan.getAdditionPhase(baseId = ((OiiiPatchInstallID)id).getCompInstallID()) < phase && instInv.getCompatCompEntry(baseId, ps.getHomeIndex(baseId)) == null) {
            bAllDepsPast = false;
        }
        return bAllDepsPast;
    }

    public OiisCompProperties getCompProperties(OiiiCompInstallID cid, OiicPullSession ps) {
        OiisCompInstallation ci = null;
        OiisCompProperties compProps = null;
        if (cid.getCompType() == 4) {
            OiisPatchSetInstallation pi = ps.getPSetInstall((OiiiPatchSetInstallID)cid);
            compProps = pi.getProperties();
        } else {
            ci = ps.getCompInstall(cid);
            compProps = ci.getProperties();
        }
        return compProps;
    }

    public boolean compHavingCfgTool(OiiiCompInstallID cid, OiicPullSession ps) {
        OiisCompProperties compProps = this.getCompProperties(cid, ps);
        if (null != compProps) {
            Vector tools = compProps.getConfigToolDetails();
            for (int i = 0; i < tools.size(); ++i) {
                OiisConfigToolDetails cd = (OiisConfigToolDetails)tools.elementAt(i);
                String toolClassName = cd.getToolClassName();
                if (toolClassName.matches("")) continue;
                return true;
            }
        }
        return false;
    }

    public OiiiCompInstallID getCurrentTLCompID(OiicPullSession ps) {
        OiiiCompInstallID TLCompID = ps.getSelTopLevelCompID();
        return TLCompID;
    }

    public String getTopLevelAggregateName(OiicPullSession pullSession) {
        if (!pullSession.isLangAddonMode()) {
            if (OiicConfigContext.isChainInstall(pullSession)) {
                String name = this.getEncapsulatingAggregateName();
                return name;
            }
            return this.getCurrentTLCompID(pullSession).getName();
        }
        return addLanguage;
    }

    public String getCurrentTopLevelAggregateName(OiicPullSession pullSession) {
        if (!pullSession.isLangAddonMode()) {
            return this.getCurrentTLCompID(pullSession).getName();
        }
        return addLanguage;
    }

    public static void propagateFilesToRemoteNodes(String[] fileAbsNames, String[] nodes) {
        for (int i = 0; i < fileAbsNames.length; ++i) {
            File f = new File(fileAbsNames[i]);
            if (f.exists()) {
                String baseDir = f.getParent();
                try {
                    OiipgClusterOps.transferFileToNodes(nodes, fileAbsNames[i], baseDir);
                    OiiolTextLogger.appendText(fileAbsNames[i] + " saved to remote node");
                }
                catch (OiipgRemoteOpsException roe) {
                    OiiolTextLogger.appendException(roe);
                }
                catch (OiipgRemoteFileOperationException rfoe) {
                    OiiolTextLogger.appendException(rfoe);
                }
                continue;
            }
            OiiolTextLogger.appendText("non-existing file can't be propagated: " + fileAbsNames[i]);
        }
    }
}

