/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.sysman.oii.oiic.OiicBaseApp;
import oracle.sysman.oii.oiic.OiicClusterInstallInfo;
import oracle.sysman.oii.oiic.OiicDetachHome;
import oracle.sysman.oii.oiic.OiicExitCode;
import oracle.sysman.oii.oiic.OiicInstVersion;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiic.OiicStandardInventorySession;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiii.OiiiClusterInstallInventory;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiInventoryDoesNotExistException;
import oracle.sysman.oii.oiii.OiiiInventoryUpdateException;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiii.OiiiRemoteHome;
import oracle.sysman.oii.oiil.OiilNativeException;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgBootstrap;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterChecks;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterException;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterInvSetup;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterOps;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterRunCmd;
import oracle.sysman.oii.oiip.oiipg.OiipgDetectCluster;
import oracle.sysman.oii.oiip.oiipg.OiipgPropertyLoader;
import oracle.sysman.oii.oiip.oiipg.OiipgRemoteFileOperationException;
import oracle.sysman.oii.oiip.oiipg.OiipgRemoteOpsException;
import oracle.sysman.oii.oiip.osd.win32.OiipwClusterWindowsOps;
import oracle.sysman.oii.oiip.osd.win32.OiipwWin32NativeCalls;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiit.OiitTargetLockNotAvailableException;
import oracle.sysman.oii.oiix.OiixEnvironmentOps;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixInstallUtil;
import oracle.sysman.oii.oiix.OiixInteractiveOps;
import oracle.sysman.oii.oiix.OiixNetOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixRegistryOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixServiceOps;
import oracle.sysman.oii.oiix.OiixTeePrintStream;
import oracle.sysman.oii.oiix.OiixUtil;
import oracle.sysman.oii.oiix.OiixUtilityOps;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiicCleanup
extends OiicBaseApp {
    private static final String INST_LOC = "inst_loc";
    private static final String SOFTWARE_ORACLE = "Software\\Oracle";
    public static final String HKLM = "HKEY_LOCAL_MACHINE";
    public static final String SW_ORACLE_HOME_KEY_PREFIX = "SOFTWARE\\ORACLE\\KEY_";
    public static final String SW_ORACLE_HOME_PREFIX = "SOFTWARE\\ORACLE";
    public static final String OH_FOLDER_REG_KEY = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders";
    public static final String ENV_REG_SUBKEY = "SYSTEM\\CurrentControlSet\\Control\\Session Manager\\Environment";
    public static final String ENV_REG_KEY = "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Control\\Session Manager\\Environment";
    public static final String OBASE_CLEANUP_PTR = "oracle.installer.OBaseCleanupPtrLoc";
    public static final String SKIP_LOCAL_HOME_DELETION = "oracle.installer.skipLocalHomeDeletion";
    public static final String SKIP_REMOTE_HOME_DELETION = "oracle.installer.skipRemoteHomeDeletion";
    public static final String REGISTRY_CLEANUP_PTR = "WindowsRegistryCleanupList";
    public static final String NODES_LAST_HOME = "NodesWithLastHome";
    private static final int SERVICE_RUNNING = 4;
    private static OiicCleanup s_oiicCleanup = null;
    private OiicSessionContext m_oContext = null;
    private OiicStandardInventorySession invSession = null;
    private String[] m_sRemoteNodes = null;
    private String[] m_sRemoteNodesOracleBase = null;
    private String[] m_sRemoteNodesHomeAttached = null;
    private boolean m_bCleanupRemoteCI = false;
    private boolean m_bCleanupRemoteOracleBase = true;
    private boolean m_bCleanupLocalCI = false;
    private boolean m_bCleanupLocalOracleBase = true;
    private String m_sOracleHome = null;
    private String m_sOracleBase = null;
    private String m_sOracleHomeName = null;
    private boolean s_bIsWindows = false;
    private HashMap m_oInvLocations = null;
    private String m_sInvLocation = null;
    private static final String s_baseAppPrefix = "oui";
    private String m_logLocation = "";
    private boolean s_bApiMode = false;
    private boolean s_bDetachHomeLocal = false;
    private boolean s_bDetachHomeRemote = false;
    private boolean bSharedHome = false;
    private String m_sLocalNode = null;
    private boolean s_bForce = false;
    private boolean s_bForceOBase = false;
    private String m_sDefInvPtrLoc = null;
    public static final String m_sDefInvPtrFileName = "oraInst.loc";
    private String m_sInvPtrLoc = null;
    private String m_sInvPtrLocDir = null;
    private Vector nodesWithSameDefaultOraInst = null;
    private Vector nodesToRemoveOraInst = null;
    private Vector nodesLastHome = null;
    private boolean localNodeSameDefaultOraInst = false;
    private boolean localNodeRemoveOraInst = false;
    private boolean localNodeLastHome = false;
    private List cleanSummary = new ArrayList();
    private String m_sLogDir = null;
    boolean doLocalInvOps = true;
    OiiiClusterInstallInventory m_clusterInstInv = null;
    private String[] m_sOHServices = null;
    private Vector homeDeinstallExcludeListVector = null;
    private Vector oracleBaseDirListVector = null;
    private Vector miscRegistryListVector = null;

    public static OiicCleanup getOiicCleanupInstance() {
        if (s_oiicCleanup == null) {
            s_oiicCleanup = new OiicCleanup();
        }
        return s_oiicCleanup;
    }

    public OiicCleanup() {
        super(s_baseAppPrefix);
    }

    public static void main(String[] args) {
        OiicCleanup oCleanup = OiicCleanup.getOiicCleanupInstance();
        oCleanup.main_helper(args);
    }

    @Override
    public void processCommandLine(String[] args) {
        this.processCmdLine(args);
        this.setAdditionalProperties();
    }

    @Override
    protected String getSystemPropertyPrefix() {
        return "oracle.installer.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean main_helper(String[] args) {
        this.initCleanup();
        boolean retVal = true;
        try {
            this.processCommandLine(args);
            if (this.isHelpOptionSpecified()) {
                this.displayHelp();
            } else {
                boolean validateFlag = true;
                if (!this.validateInputVariables()) {
                    OiicExitCode.setExitCode(-1);
                    validateFlag = false;
                }
                if (validateFlag) {
                    this.doCleanup();
                }
            }
        }
        catch (Throwable e) {
            this.handleDoException(e);
        }
        finally {
            retVal = this.finalizeCleanup();
        }
        return retVal;
    }

    private void initCleanup() {
        OiixUtilityOps.displayStackTraceInformation(new Throwable());
        System.setProperty("oracle.installer.noGUI", "yes");
        OiixInstallUtil.setOption("DO_NOT_UPDATE_ORACLE_HOME_PROPERTIES");
        this.s_bIsWindows = OiixInstallUtil.isWindows();
        this.nodesToRemoveOraInst = new Vector();
        this.nodesLastHome = new Vector();
        this.nodesWithSameDefaultOraInst = new Vector();
        OiicExitCode.setExitCode(0);
    }

    private void doCleanup() throws OiifbEndIterateException {
        if (this.m_oContext == null) {
            this.m_oContext = new OiicSessionContext(this);
            this.m_oContext.setVariables();
        }
        OiixInstallUtil.setOption("oracle.installer.detachHome");
        String message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_START");
        OiiolTextLogger.writeMessageToConsole(message);
        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_BASIC) {
            OiiolTextLogger.appendText("Done creating session context and setting session variables as per command line", OiiolTextLogger.LOG_BASIC);
        }
        if (!this.s_bApiMode) {
            this.setForceFlag(OiixInstallUtil.isOptionSet("oracle.installer.force"));
        }
        try {
            this.doOperation();
        }
        catch (OiitTargetLockNotAvailableException e) {
            OiiolTextLogger.appendException(e);
            OiicExitCode.setExitCode(-1);
        }
        catch (IOException e) {
            OiiolTextLogger.appendException(e);
            OiicExitCode.setExitCode(-1);
        }
        catch (OiiiInventoryDoesNotExistException e) {
            OiiolTextLogger.appendException(e);
            OiicExitCode.setExitCode(-1);
        }
        catch (OiiiInventoryUpdateException e) {
            OiiolTextLogger.appendException(e);
            OiicExitCode.setExitCode(-1);
        }
        catch (OiifbCancelException e) {
            OiiolTextLogger.appendException(e);
            OiicExitCode.setExitCode(-1);
        }
        catch (OiipgRemoteOpsException e) {
            OiiolTextLogger.appendException(e);
            OiicExitCode.setExitCode(-1);
        }
        catch (OiisVarSettingException e) {
            OiiolTextLogger.appendException(e);
            OiicExitCode.setExitCode(-1);
        }
    }

    private void handleDoException(Throwable e) {
        System.err.println("Exception " + e + " occurred..");
        e.printStackTrace();
        OiicExitCode.setExitCode(-1);
        String sMsg = "";
        String sUnknown = OiixResourceBundle.getString("S_LOG_UNKNOWN");
        String sLogLoc = OiiolTextLogger.getCurLogFileName();
        sLogLoc = OiixUtil.isNullOrBlank(sLogLoc, true) ? sUnknown : sLogLoc;
        String sErrLoc = OiixTeePrintStream.getErrFileLoc();
        sErrLoc = OiixUtil.isNullOrBlank(sErrLoc, true) ? sUnknown : sErrLoc;
        String sOutLoc = OiixTeePrintStream.getOutFileLoc();
        sOutLoc = OiixUtil.isNullOrBlank(sOutLoc, true) ? sUnknown : sOutLoc;
        sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CALL_SUPPORT", new Object[]{sLogLoc, sErrLoc, sOutLoc});
        sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ABNORMAL_TERMINATION_MSG") + " " + sMsg;
        OiifmAlert.displayError(sMsg, OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ABNORMAL_TERMINATION_TITLE"));
    }

    private boolean finalizeCleanup() {
        boolean retVal = this.logFinalMessage();
        if (!this.s_bIsWindows) {
            this.cleanupRemoteInvPtrLoc();
        }
        String message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_END");
        OiiolTextLogger.writeMessageToConsole(message);
        if (this.s_bIsWindows && !this.s_bApiMode) {
            OiixInteractiveOps.fetchUserInput(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_EXIT_CONTINUE"));
        }
        if (this.invSession != null) {
            OiiolTextLogger.appendText("Ending the Inventory Session which was created");
            this.invSession.endSession();
        }
        this.unsetProperties();
        return retVal;
    }

    private boolean logFinalMessage() {
        String sMsg = null;
        int iExitCode = OiicExitCode.getExitCode();
        boolean retVal = true;
        switch (iExitCode) {
            case 0: {
                sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_OUI_CLEANUP_SUCCESS");
                retVal = true;
                break;
            }
            case -1: {
                sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_OUI_CLEANUP_FAILURE");
                retVal = false;
            }
        }
        if (sMsg != null) {
            OiiolTextLogger.writeToLogAndConsole(sMsg);
            this.logSummaryMessage(sMsg);
        }
        if (this.s_bApiMode && !OiixUtil.isNullOrBlank(this.m_sLogDir, true)) {
            OiiolTextLogger.copyLogs(OiiolTextLogger.getLogDir(), this.m_sLogDir);
            try {
                OiiolTextLogger.setLogLoc(this.m_sLogDir, OiicCleanup.getLogPrefix());
            }
            catch (IOException e) {
                OiiolTextLogger.appendException(e);
            }
        }
        if (OiiolTextLogger.getCurLogFileName() != null) {
            String logLocMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_SESSION_LOG_LOC_PROMPT", new String[]{OiiolTextLogger.getCurLogFileName()});
            OiiolTextLogger.appendText(logLocMsg);
        }
        return retVal;
    }

    private void cleanupRemoteInvPtrLoc() {
        if (this.m_sLocalNode == null) {
            if (this.localNodeRemoveOraInst) {
                Object[] args1 = new String[]{"rm -r " + this.m_sDefInvPtrLoc};
                String lastMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETE_ORAINST_ON_LOCALNODE", args1);
                if (this.s_bApiMode) {
                    this.logSummaryMessage(lastMsg);
                } else {
                    OiiolTextLogger.writeToLogAndConsole(lastMsg);
                }
            }
            if (this.localNodeLastHome) {
                System.setProperty(NODES_LAST_HOME, OiixNetOps.getFullHostName());
            }
        } else {
            String nodesStr;
            String[] nodesArr;
            if (!OiixUtil.isEmpty(this.nodesToRemoveOraInst)) {
                nodesArr = OiixVectorOps.vect2StrArr(this.nodesToRemoveOraInst);
                nodesStr = OiixFunctionOps.implodeList(nodesArr, ",");
                Object[] args1 = new String[]{"rm -r " + this.m_sDefInvPtrLoc, nodesStr};
                String lastMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETE_ORAINST_ON_NODES", args1);
                if (this.s_bApiMode) {
                    this.logSummaryMessage(lastMsg);
                } else {
                    OiiolTextLogger.writeToLogAndConsole(lastMsg);
                }
            }
            if (!OiixUtil.isEmpty(this.nodesLastHome)) {
                nodesArr = OiixVectorOps.vect2StrArr(this.nodesLastHome);
                nodesStr = OiixFunctionOps.implodeList(nodesArr, ",");
                System.setProperty(NODES_LAST_HOME, nodesStr);
            }
        }
    }

    private void unsetProperties() {
        this.invSession = null;
        this.m_sRemoteNodes = null;
        this.m_sRemoteNodesHomeAttached = null;
        this.m_bCleanupRemoteCI = false;
        this.m_bCleanupRemoteOracleBase = true;
        this.m_bCleanupLocalCI = false;
        this.m_bCleanupLocalOracleBase = true;
        this.m_sOracleHome = null;
        this.m_sOracleBase = null;
        this.m_sOracleHomeName = null;
        this.s_bIsWindows = false;
        this.m_oInvLocations = null;
        this.m_sInvLocation = null;
        this.m_logLocation = "";
        this.s_bApiMode = false;
        this.s_bDetachHomeLocal = false;
        this.s_bDetachHomeRemote = false;
        this.m_sLocalNode = null;
        this.s_bForce = false;
        this.s_bForceOBase = false;
        this.m_sDefInvPtrLoc = null;
        this.m_sInvPtrLoc = null;
        this.nodesWithSameDefaultOraInst = null;
        this.nodesToRemoveOraInst = null;
        this.nodesLastHome = null;
        this.localNodeSameDefaultOraInst = false;
        this.localNodeRemoveOraInst = false;
        this.localNodeLastHome = false;
        this.m_sLogDir = null;
        this.m_sOHServices = null;
    }

    public void doOperation() throws OiitTargetLockNotAvailableException, IOException, OiiiInventoryDoesNotExistException, OiiiInventoryUpdateException, OiifbCancelException, OiipgRemoteOpsException, OiisVarSettingException, OiifbEndIterateException {
        OiipgClusterRunCmd.getClusterCmdObj();
        ClusterCmd.setDeconfigNonClusterMode((boolean)true);
        if (!this.s_bApiMode) {
            this.promptUserForSessionVariables();
        }
        this.setClassVariables();
        if (this.s_bApiMode) {
            System.setProperty("oracle.installer.scratchPath", OiixPathOps.getNativeForm(OiipgBootstrap.initScratchLoc("OraInstall")));
        }
        if (!this.validateHomeVariables()) {
            return;
        }
        if (!this.s_bIsWindows) {
            this.setInvPtrLoc();
            if (!this.validateInvPtrLoc()) {
                return;
            }
        }
        if (!OiixUtil.isEmpty(this.m_sRemoteNodes) && this.s_bApiMode) {
            OiiolTextLogger.appendText("Copying OUI and JRE to ScratchPath");
            this.copyOuiJreToScratch();
            if (!this.s_bIsWindows && !OiixUtil.isNullOrBlank(this.m_sInvPtrLoc, true)) {
                this.setRemoteInvPtrLoc();
            }
        }
        this.cleanupLocalHome();
        if (!OiixInstallUtil.isOptionSet("oracle.installer.local")) {
            this.cleanupRemoteNodes();
        }
    }

    private void cleanupLocalHome() throws OiitTargetLockNotAvailableException, IOException, OiiiInventoryDoesNotExistException, OiiiInventoryUpdateException, OiifbCancelException, OiisVarSettingException, OiifbEndIterateException {
        if (!this.s_bIsWindows && this.m_sInvPtrLoc == null && this.s_bApiMode) {
            this.doLocalInvOps = false;
        }
        if (this.s_bIsWindows) {
            this.getAllOHServices();
            this.cleanupOHServicesLocal();
        }
        this.initCleanupProperties();
        this.cleanupOHLocal();
        if (this.s_bIsWindows) {
            this.cleanupPathLocal();
        }
        if (!this.s_bIsWindows && this.checkForSameInventoryLocation(this.m_sInvPtrLoc, this.m_sDefInvPtrLoc)) {
            if (this.m_sLocalNode == null) {
                this.localNodeSameDefaultOraInst = true;
            } else {
                this.nodesWithSameDefaultOraInst.add(this.m_sLocalNode);
            }
        }
        if (this.doLocalInvOps) {
            this.determineCleanupCILocal();
        }
        if (this.m_bCleanupLocalCI) {
            this.cleanupCILocal();
        }
        this.determineCleanupOracleBaseLocal();
        if (this.m_bCleanupLocalOracleBase) {
            this.cleanupOracleBaseLocal();
        }
    }

    private void initCleanupProperties() {
        String registryList;
        String oracleBaseDirList;
        String homeDeleteExcludeList = this.getRemoveExcludeList();
        if (!OiixUtil.isNullOrBlank(homeDeleteExcludeList, true)) {
            this.homeDeinstallExcludeListVector = this.readFileIntoVector(homeDeleteExcludeList);
        }
        if (!OiixUtil.isNullOrBlank(oracleBaseDirList = this.getOracleBaseDirList(), true)) {
            this.oracleBaseDirListVector = this.readFileIntoVector(oracleBaseDirList);
        }
        if (this.s_bIsWindows && !OiixUtil.isNullOrBlank(registryList = this.getMiscRegistryList(), true)) {
            this.miscRegistryListVector = this.readFileIntoVector(registryList);
        }
    }

    private void setInvPtrLoc() {
        this.m_sInvPtrLoc = System.getProperty("oracle.installer.invPtrLoc");
        if (this.m_sInvPtrLoc != null) {
            System.clearProperty("oracle.installer.invPtrLoc");
            OiipgPropertyLoader.setUnixPtrFileLocFromSysProps();
            this.m_sDefInvPtrLoc = OiipgPropertyLoader.getUnixPtrFileLoc();
            System.setProperty("oracle.installer.invPtrLoc", this.m_sInvPtrLoc);
        } else {
            this.m_sDefInvPtrLoc = OiipgPropertyLoader.getUnixPtrFileLoc();
        }
    }

    private void cleanupRemoteNodes() {
        this.updateRemoteNodes();
        if (this.s_bIsWindows) {
            this.cleanupOHServicesRemote();
        }
        this.cleanupOHRemote();
        if (this.s_bIsWindows) {
            this.cleanupPathRemote();
        }
        if (this.doLocalInvOps) {
            this.determineCleanupCIRemote();
        }
        if (this.m_bCleanupRemoteCI) {
            this.cleanupCIRemote();
        }
        if (this.m_bCleanupRemoteOracleBase) {
            this.determineCleanupOracleBaseRemote();
        }
        if (this.m_bCleanupRemoteOracleBase) {
            this.cleanupOracleBaseRemote();
        }
    }

    private void updateRemoteNodes() {
        OiicClusterInstallInfo cInfo = OiicClusterInstallInfo.getClusterInstallInfo();
        cInfo.setClusterNodes(this.m_sRemoteNodes);
        try {
            this.m_sRemoteNodes = OiipgClusterChecks.checkUserEquivalence(this.m_sRemoteNodes, cInfo);
            this.m_oContext.setVarValue("REMOTE_NODES", this.m_sRemoteNodes);
        }
        catch (OiipgClusterException e) {
            OiiolTextLogger.appendException(e);
        }
        catch (OiisVarSettingException e) {
            OiiolTextLogger.appendException(e);
        }
        catch (OiifbCancelException e) {
            OiiolTextLogger.appendException(e);
        }
    }

    private static String getLogPrefix() {
        return "Cleanup";
    }

    private void determineCleanupCIRemote() {
        this.m_clusterInstInv = new OiiiClusterInstallInventory(this.m_sRemoteNodes);
        this.m_oInvLocations = this.m_clusterInstInv.getInventoryLocsRemote();
        if (!OiixUtil.isEmpty(this.m_oInvLocations)) {
            String bDelete;
            if (this.getForceFlag()) {
                this.m_bCleanupRemoteCI = true;
            } else if (!OiixInstallUtil.isSilent() && !this.s_bApiMode && (bDelete = OiixInteractiveOps.fetchUserInput(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIC-22012"))) != null && OiixUtil.equals(bDelete.trim(), "yes", true)) {
                this.m_bCleanupRemoteCI = true;
            }
        }
    }

    private void determineCleanupCILocal() throws OiitTargetLockNotAvailableException, IOException, OiiiInventoryDoesNotExistException, OiifbEndIterateException, OiisVarSettingException, OiifbCancelException {
        this.initInvSession();
        OiiiInstallAreaControl iAreaControl = OiiiInstallAreaControl.getInstallAreaControl();
        this.m_oContext.setVarValue("INVENTORY_LOCATION", iAreaControl.getAreaRoot());
        OiiiInstallInventory instinv = iAreaControl.getInstallInventory();
        OiiolTextLogger.appendText("The access level of the inventory is " + iAreaControl.getAccessLevel());
        this.m_sInvLocation = iAreaControl.getAreaRoot();
        Vector homesAttached = instinv.getHomes();
        if (OiixUtil.isEmpty(homesAttached)) {
            if (this.getForceFlag()) {
                this.m_bCleanupLocalCI = true;
            } else {
                String bDelete;
                this.m_bCleanupLocalCI = false;
                if (!OiixInstallUtil.isSilent() && !this.s_bApiMode && (bDelete = OiixInteractiveOps.fetchUserInput(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIC-22013"))) != null && OiixUtil.equals(bDelete.trim(), "yes", true)) {
                    this.m_bCleanupLocalCI = true;
                }
            }
        }
        if (this.m_bCleanupLocalCI) {
            this.m_logLocation = !OiixInstallUtil.isSilent() && !this.s_bApiMode ? OiixInteractiveOps.fetchUserInput(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-22019")) : new File(System.getProperty("oracle.installer.scratchPath")).getParent();
        }
        if (OiixUtil.isNullOrBlank(this.m_logLocation, true)) {
            this.m_logLocation = OiiolTextLogger.getLogDir();
        }
    }

    private void promptUserForSessionVariables() {
        if (!OiixInstallUtil.isSilent()) {
            String[] sessionVars = new String[]{"ORACLE_HOME", "ORACLE_HOME_NAME", "REMOTE_NODES"};
            for (int i = 0; i < Array.getLength(sessionVars); ++i) {
                OiisVariable var = this.m_oContext.getVariable(sessionVars[i]);
                if (var.isValueSetByUser()) continue;
                this.m_oContext.setSessionVarValFromUser(var);
            }
        }
    }

    private void setClassVariables() {
        this.m_sOracleHome = (String)this.m_oContext.getVarValue("ORACLE_HOME");
        this.m_sOracleBase = (String)this.m_oContext.getVarValue("ORACLE_BASE");
        this.m_sOracleHomeName = (String)this.m_oContext.getVarValue("ORACLE_HOME_NAME");
        this.m_sRemoteNodes = (String[])this.m_oContext.getVarValue("REMOTE_NODES");
        this.m_sLocalNode = (String)this.m_oContext.getVarValue("LOCAL_NODE");
    }

    private void cleanupRegKeysLocal(String oracleHomeName) {
        String subKey = SW_ORACLE_HOME_KEY_PREFIX + oracleHomeName;
        Object[] args = new String[]{HKLM, subKey};
        String message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETE_REGKEY_LOCAL", args);
        try {
            if (OiipwWin32NativeCalls.RegKeyExists(HKLM, subKey)) {
                OiipwWin32NativeCalls.RegDeleteKey(HKLM, subKey);
            }
            this.logServiceSuccess((String[])args, message, "S_CLEANUP_DELETE_REGKEY_LOCAL_SUMMARY_SUCCESS");
        }
        catch (OiilNativeException e) {
            this.serviceException((String[])args, message, "S_CLEANUP_DELETE_REGKEY_LOCAL_SUMMARY_FAILED");
            OiiolTextLogger.appendText("OUI-22016", args);
            OiiolTextLogger.appendException(e);
        }
    }

    private void deleteOHRemote() {
        if (this.doLocalInvOps) {
            this.determineRemoteNodesForDetachHome();
            String[] args = null;
            if (!OiixUtil.isEmpty(this.m_sRemoteNodesHomeAttached)) {
                args = new String[]{OiixFunctionOps.implodeList(this.m_sRemoteNodesHomeAttached, ","), this.m_sOracleHome};
            }
            this.detachOHRemote();
            if (args != null) {
                String message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DETACH_HOME_ON_REMOTE_NODES", args);
                this.logServiceSuccess(args, message, "S_CLEANUP_DETACH_HOME_ON_REMOTE_NODES_SUMMARY_SUCCESS");
            }
        }
        if (!this.checkSkipHomeDeletionStatus(true)) {
            if (this.bSharedHome) {
                this.recdelete(new File(this.m_sOracleHome), this.homeDeinstallExcludeListVector);
            } else {
                System.setProperty("oracle.installer.racFilesLoc", this.m_logLocation);
                OiipgClusterLogger clusterLogger = OiipgClusterLogger.getClusterLogger();
                OiipgClusterLogger.logRmdirCommands(this.m_sOracleHome);
                clusterLogger.updateListFiles(this.m_sOracleHome);
                Object[] args1 = new String[]{OiixFunctionOps.implodeList(this.m_sRemoteNodes, ","), this.m_sOracleHome};
                String message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETING_DIRECTORY_ON_REMOTE_NODES", args1);
                try {
                    OiipgClusterOps.removeListedDirsFromNodes(this.m_sRemoteNodes, clusterLogger.getRmdirListFile());
                    this.logServiceSuccess((String[])args1, message, "S_CLEANUP_DELETING_DIRECTORY_ON_REMOTE_NODES_SUMMARY_SUCCESS");
                }
                catch (OiipgRemoteFileOperationException e) {
                    this.serviceException((String[])args1, message, "S_CLEANUP_DELETING_DIRECTORY_ON_REMOTE_NODES_SUMMARY_FAILED");
                    OiiolTextLogger.appendException(e);
                    OiiolTextLogger.writeMessageToConsole(e.getBriefMessage());
                }
                catch (OiipgRemoteOpsException e) {
                    this.serviceException((String[])args1, message, "S_CLEANUP_DELETING_DIRECTORY_ON_REMOTE_NODES_SUMMARY_FAILED");
                    OiiolTextLogger.appendException(e);
                    OiiolTextLogger.writeMessageToConsole(e.getBasicMessage());
                }
            }
        }
    }

    private void cleanupOHLocal() throws OiitTargetLockNotAvailableException, IOException, OiiiInventoryDoesNotExistException, OiiiInventoryUpdateException, OiifbCancelException, OiisVarSettingException {
        if (OiixUtil.isNullOrBlank(this.m_sOracleHome, true)) {
            Object[] args1 = new String[]{" oracle home location"};
            OiiolTextLogger.writeMessageToConsole("OIIC-22014", args1);
            return;
        }
        Object[] args = new String[]{this.m_sOracleHome};
        if (this.doLocalInvOps) {
            try {
                OiiolTextLogger.appendText("Creating a new Inventory Session");
                this.invSession = new OiicStandardInventorySession(OiicCleanup.getLogPrefix(), OiicInstVersion.getVersionString());
                OiiolTextLogger.appendText("Initializing the inventory session with access 1");
                this.invSession.initSession(1);
            }
            catch (OiiiInventoryDoesNotExistException e) {
                OiiolTextLogger.appendException(e);
            }
            OiiiInstallAreaControl iAreaControl = OiiiInstallAreaControl.getInstallAreaControl();
            OiiolTextLogger.appendText("The access level of the inventory is " + iAreaControl.getAccessLevel());
            OiiiInstallInventory instinv = iAreaControl.getInstallInventory();
            OiiiOracleHomeInfo ohi = instinv.getHomeWithLocation(this.m_sOracleHome);
            if (ohi != null) {
                OiipgDetectCluster detectCluster;
                if (OiixUtil.isNullOrBlank(this.m_sOracleHomeName, true)) {
                    this.m_sOracleHomeName = ohi.getName();
                }
                if (OiixUtil.isNullOrBlank(this.m_sLocalNode, true)) {
                    this.m_sLocalNode = ohi.getLocalNode();
                }
                if (OiixUtil.isNullOrBlank(this.m_sLocalNode, true) && (detectCluster = OiipgDetectCluster.getDetectCluster()) != null && detectCluster.isCluster()) {
                    this.m_sLocalNode = detectCluster.getLocalNodeName();
                    if (this.m_sLocalNode != null) {
                        OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFW1024", new String[]{this.m_sLocalNode}));
                    }
                }
                String message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DETACH_HOME_ON_LOCAL_NODE", args);
                try {
                    OiiolTextLogger.appendText("Trying to remove the home forcefully");
                    instinv.removeHomeForce(ohi, true, false);
                    OiiolTextLogger.appendText("Remove home has been done. Now saving the inventory");
                    iAreaControl.saveInstallInventory();
                    this.s_bDetachHomeLocal = true;
                    this.logServiceSuccess((String[])args, message, "S_CLEANUP_DETACH_HOME_ON_LOCAL_NODE_SUMMARY_SUCCESS");
                }
                catch (Exception e) {
                    this.serviceException((String[])args, message, "S_CLEANUP_DETACH_HOME_ON_LOCAL_NODE_SUMMARY_FAILED");
                    OiiolTextLogger.appendException(e);
                    OiiolTextLogger.writeMessageToConsole(e.getMessage());
                }
            }
        }
        if (!this.bSharedHome && !this.checkSkipHomeDeletionStatus(false)) {
            this.removeOHLocal((String[])args);
        }
        if (this.s_bIsWindows && !OiixUtil.isNullOrBlank(this.m_sOracleHomeName, true)) {
            if (!this.s_bDetachHomeLocal) {
                this.cleanupRegKeysLocal(this.m_sOracleHomeName);
            }
            if (!this.checkSkipHomeDeletionStatus(false)) {
                this.cleanupFoldersLocal(this.m_sOracleHomeName);
            }
        }
    }

    private void removeOHLocal(String[] args) {
        String message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETING_DIRECTORY_ON_LOCAL_NODE", args);
        try {
            File ohLocalFile = new File(this.m_sOracleHome);
            boolean retVal = true;
            if (ohLocalFile.exists()) {
                retVal = this.recdelete(ohLocalFile, this.homeDeinstallExcludeListVector);
            }
            if (retVal) {
                this.logServiceSuccess(args, message, "S_CLEANUP_DELETING_DIRECTORY_ON_LOCAL_NODE_SUMMARY_SUCCESS");
            } else {
                this.serviceException(args, message, "S_CLEANUP_DELETING_DIRECTORY_ON_LOCAL_NODE_SUMMARY_FAILED", false);
            }
        }
        catch (Exception e) {
            this.serviceException(args, message, "S_CLEANUP_DELETING_DIRECTORY_ON_LOCAL_NODE_SUMMARY_FAILED");
            OiiolTextLogger.appendException(e);
            OiiolTextLogger.writeMessageToConsole(e.getMessage());
        }
    }

    private void cleanupOHRemote() {
        if (OiixUtil.isEmpty(this.m_sRemoteNodes)) {
            return;
        }
        this.deleteOHRemote();
        if (this.s_bIsWindows && !OiixUtil.isNullOrBlank(this.m_sOracleHomeName, true)) {
            if (!this.s_bDetachHomeRemote) {
                this.cleanupRegKeysRemote(this.m_sOracleHomeName);
            }
            if (!this.checkSkipHomeDeletionStatus(true)) {
                this.cleanupFoldersRemote(this.m_sOracleHomeName);
            }
        }
    }

    private void cleanupFoldersRemote(String oracleHomeName) {
        String folderPath = "Oracle - " + oracleHomeName;
        for (int i = 0; i < this.m_sRemoteNodes.length; ++i) {
            Object[] args = null;
            String message = "";
            try {
                String path = OiipwClusterWindowsOps.getRegStringDataOnNode("HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders", "Common Programs", this.m_sRemoteNodes[i]) + "\\" + folderPath;
                args = new String[]{this.m_sRemoteNodes[i], path};
                message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETING_DIRECTORY_ON_REMOTE_NODES", args);
                if (OiipgClusterOps.fileExistsOnNode(this.m_sRemoteNodes[i], path)) {
                    OiipgClusterOps.removeDirectoryFromNode(this.m_sRemoteNodes[i], path, System.getProperty("oracle.installer.scratchPath"));
                }
                this.logServiceSuccess((String[])args, message, "S_CLEANUP_DELETING_DIRECTORY_ON_REMOTE_NODES_SUMMARY_SUCCESS");
                continue;
            }
            catch (OiipgRemoteOpsException e) {
                this.serviceException((String[])args, message, "S_CLEANUP_DELETING_DIRECTORY_ON_REMOTE_NODES_SUMMARY_FAILED");
                OiiolTextLogger.writeMessageToConsole(e.getBasicMessage());
                OiiolTextLogger.appendException(e);
                continue;
            }
            catch (OiipgRemoteFileOperationException e) {
                this.serviceException((String[])args, message, "S_CLEANUP_DELETING_DIRECTORY_ON_REMOTE_NODES_SUMMARY_FAILED");
                OiiolTextLogger.writeMessageToConsole(e.getBasicMessage());
                OiiolTextLogger.appendException(e);
            }
        }
    }

    private void cleanupFoldersLocal(String oracleHomeName) {
        String folderPath = "Oracle - " + oracleHomeName;
        try {
            folderPath = OiipwWin32NativeCalls.RegGetValue(HKLM, OH_FOLDER_REG_KEY, "Common Programs") + "\\" + folderPath;
        }
        catch (OiilNativeException e) {
            OiiolTextLogger.appendException(e);
            Object[] args = new String[]{"HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders\\Common Programs"};
            OiiolTextLogger.writeToLogAndConsole("OUI-22017", args);
            return;
        }
        Object[] args2 = new String[]{folderPath};
        File folderPathFile = new File(folderPath);
        if (folderPathFile.isDirectory()) {
            String message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETING_DIRECTORY_ON_LOCAL_NODE", args2);
            try {
                if (folderPathFile.exists()) {
                    OiixFileOps.cleanupdelete(folderPathFile);
                }
                if (!folderPathFile.exists()) {
                    this.logServiceSuccess((String[])args2, message, "S_CLEANUP_DELETING_DIRECTORY_ON_LOCAL_NODE_SUMMARY_SUCCESS");
                } else {
                    this.serviceException((String[])args2, message, "S_CLEANUP_DELETING_DIRECTORY_ON_LOCAL_NODE_SUMMARY_FAILED");
                }
            }
            catch (Exception e) {
                this.serviceException((String[])args2, message, "S_CLEANUP_DELETING_DIRECTORY_ON_LOCAL_NODE_SUMMARY_FAILED");
                OiiolTextLogger.appendException(e);
                OiiolTextLogger.writeMessageToConsole(e.getMessage());
            }
        }
    }

    public void cleanupRegKeysRemote(String oracleHomeName) {
        String subKey = SW_ORACLE_HOME_KEY_PREFIX + oracleHomeName;
        try {
            OiipwClusterWindowsOps.registryDeleteKey(HKLM, subKey, this.m_sRemoteNodes);
        }
        catch (OiipgRemoteOpsException e) {
            OiiolTextLogger.appendText(e.getBasicMessage());
        }
    }

    private void cleanupCIRemote() {
        if (OiixUtil.isEmpty(this.m_oInvLocations)) {
            return;
        }
        Set invLocs = this.m_oInvLocations.keySet();
        Iterator iter = invLocs.iterator();
        String[] sampleStringList = new String[invLocs.size()];
        String[] remoteNodesForInvDel = invLocs.toArray(sampleStringList);
        while (iter.hasNext()) {
            String nodeName = (String)iter.next();
            this.nodesLastHome.add(nodeName);
            String invLocOnNode = (String)this.m_oInvLocations.get(nodeName);
            this.removeRemoteOHDir(nodeName, invLocOnNode);
            if (!this.s_bIsWindows) continue;
            this.cleanRemoteOHParentDir(nodeName, invLocOnNode);
        }
        if (this.s_bIsWindows) {
            this.removeOHRegKeyRemote(remoteNodesForInvDel, SOFTWARE_ORACLE, INST_LOC);
            this.cleanupMiscRegistriesRemote(remoteNodesForInvDel);
            this.removeTopLevelOHRegKeysRemote(remoteNodesForInvDel, SOFTWARE_ORACLE, INST_LOC);
        }
    }

    private void removeTopLevelOHRegKeysRemote(String[] remoteNodes, String subKey, String value) {
        ArrayList<String> remoteNodesForTopLevelRegKeyDel = new ArrayList<String>();
        for (int i = 0; i < remoteNodes.length; ++i) {
            try {
                Object[] subKeys = OiipwClusterWindowsOps.getRegSubKey("HKEY_LOCAL_MACHINE\\" + subKey, remoteNodes[i]);
                if (!OiixUtil.isEmpty(subKeys)) continue;
                remoteNodesForTopLevelRegKeyDel.add(remoteNodes[i]);
                continue;
            }
            catch (OiipgRemoteOpsException e) {
                OiiolTextLogger.appendException(e);
                OiiolTextLogger.writeMessageToConsole(e.getBasicMessage());
            }
        }
        Object[] nodes = OiixVectorOps.list2StrArr(remoteNodesForTopLevelRegKeyDel);
        Object[] args = new String[]{HKLM, subKey + "\\" + value, OiixFunctionOps.implodeList((String[])nodes, ",")};
        String message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETE_REGKEY_REMOTE", args);
        try {
            if (!OiixUtil.isEmpty(nodes)) {
                OiipwClusterWindowsOps.registryDeleteKey(HKLM, subKey, (String[])nodes);
                this.logServiceSuccess((String[])args, message, "S_CLEANUP_DELETE_REGKEY_REMOTE_SUMMARY_SUCCESS");
            }
        }
        catch (OiipgRemoteOpsException e) {
            this.serviceException((String[])args, message, "S_CLEANUP_DELETE_REGKEY_REMOTE_SUMMARY_FAILED", false);
            OiiolTextLogger.appendException(e);
            OiiolTextLogger.writeMessageToConsole(e.getBasicMessage());
        }
    }

    private void removeOHRegKeyRemote(String[] nodes, String subKey, String value) {
        Object[] args = new String[]{HKLM, subKey + "\\" + value, OiixFunctionOps.implodeList(nodes, ",")};
        String message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETE_REGKEY_REMOTE", args);
        try {
            OiipwClusterWindowsOps.registryDeleteValue(HKLM, subKey, value, nodes);
            this.logServiceSuccess((String[])args, message, "S_CLEANUP_DELETE_REGKEY_REMOTE_SUMMARY_SUCCESS");
        }
        catch (OiipgRemoteOpsException e) {
            this.serviceException((String[])args, message, "S_CLEANUP_DELETE_REGKEY_REMOTE_SUMMARY_FAILED", false);
            OiiolTextLogger.appendException(e);
            OiiolTextLogger.writeMessageToConsole(e.getBasicMessage());
        }
    }

    private void cleanRemoteOHParentDir(String nodeName, String invLocOnNode) {
        String parentDirOnNode = new File(invLocOnNode).getParent();
        Object[] args1 = new String[]{nodeName, parentDirOnNode};
        String message1 = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETING_DIRECTORY_ON_REMOTE_NODES", args1);
        try {
            Object[] listofFiles = OiipgClusterOps.listDirectory(nodeName, parentDirOnNode);
            if (OiixUtil.isEmpty(listofFiles)) {
                if (OiipgClusterOps.fileExistsOnNode(nodeName, parentDirOnNode)) {
                    OiipgClusterOps.removeDirFromNode(nodeName, parentDirOnNode);
                }
                this.logServiceSuccess((String[])args1, message1, "S_CLEANUP_DELETING_DIRECTORY_ON_REMOTE_NODES_SUMMARY_SUCCESS");
            }
        }
        catch (OiipgRemoteOpsException e) {
            this.deleteRMNodeDirFailed((String[])args1, message1, e);
        }
    }

    private void removeRemoteOHDir(String nodeName, String invLocOnNode) {
        Object[] args = new String[]{nodeName, invLocOnNode};
        String message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETING_DIRECTORY_ON_REMOTE_NODES", args);
        try {
            if (OiipgClusterOps.fileExistsOnNode(nodeName, invLocOnNode)) {
                OiipgClusterOps.removeDirectoryFromNode(nodeName, invLocOnNode, System.getProperty("oracle.installer.scratchPath"));
            }
            this.logServiceSuccess((String[])args, message, "S_CLEANUP_DELETING_DIRECTORY_ON_REMOTE_NODES_SUMMARY_SUCCESS");
            if (this.nodesWithSameDefaultOraInst.contains(nodeName)) {
                this.nodesToRemoveOraInst.add(nodeName);
            }
        }
        catch (OiipgRemoteOpsException e) {
            this.deleteRMNodeDirFailed((String[])args, message, e);
        }
        catch (OiipgRemoteFileOperationException e) {
            this.deleteRMNodeDirFailed((String[])args, message, e);
        }
    }

    private void deleteRMNodeDirFailed(String[] args, String message, Exception e) {
        this.serviceException(args, message, "S_CLEANUP_DELETING_DIRECTORY_ON_REMOTE_NODES_SUMMARY_FAILED");
        OiiolTextLogger.appendException(e);
        OiiolTextLogger.writeMessageToConsole("OUI-20024", args);
    }

    private void cleanupCILocal() {
        OiiolTextLogger.copyLogs(OiiolTextLogger.getLogDir(), this.m_logLocation);
        try {
            OiiolTextLogger.setLogLoc(this.m_logLocation, OiicCleanup.getLogPrefix());
        }
        catch (IOException e) {
            OiiolTextLogger.appendException(e);
        }
        File invLocFile = new File(this.m_sInvLocation);
        this.removeCentralInvLocal(invLocFile);
        if (this.s_bIsWindows) {
            this.removeOralceFolderFromPF(invLocFile);
            this.removeInstLocKeys();
            this.cleanupMiscRegistriesLocal();
            this.removeOracleKeys();
        }
    }

    private void removeOracleKeys() {
        Object[] args = new String[]{HKLM, SOFTWARE_ORACLE};
        String message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETE_REGKEY_LOCAL", args);
        try {
            Object[] subKeys = OiipwWin32NativeCalls.RegGetAllSubkeys(HKLM, SOFTWARE_ORACLE);
            if (OiixUtil.isEmpty(subKeys)) {
                if (OiipwWin32NativeCalls.RegKeyExists(HKLM, SOFTWARE_ORACLE)) {
                    OiipwWin32NativeCalls.RegDeleteKey(HKLM, SOFTWARE_ORACLE);
                }
                this.logServiceSuccess((String[])args, message, "S_CLEANUP_DELETE_REGKEY_LOCAL_SUMMARY_SUCCESS");
            }
        }
        catch (OiilNativeException e) {
            this.serviceException((String[])args, message, "S_CLEANUP_DELETE_REGKEY_LOCAL_SUMMARY_FAILED");
            OiiolTextLogger.appendException(e);
        }
    }

    private void removeInstLocKeys() {
        Object[] args = new String[]{HKLM, "Software\\Oracle\\inst_loc"};
        String message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETE_REGKEY_LOCAL", args);
        try {
            if (OiipwWin32NativeCalls.RegKeyExists(HKLM, SOFTWARE_ORACLE)) {
                OiipwWin32NativeCalls.RegDeleteValue(HKLM, SOFTWARE_ORACLE, INST_LOC);
            }
            this.logServiceSuccess((String[])args, message, "S_CLEANUP_DELETE_REGKEY_LOCAL_SUMMARY_SUCCESS");
        }
        catch (OiilNativeException e) {
            this.serviceException((String[])args, message, "S_CLEANUP_DELETE_REGKEY_LOCAL_SUMMARY_FAILED");
            OiiolTextLogger.appendException(e);
        }
    }

    private void removeOralceFolderFromPF(File invLocFile) {
        File parentdir = invLocFile.getParentFile();
        Object[] listofFiles = parentdir.list();
        Object[] args = new String[]{parentdir.toString()};
        String message1 = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETING_DIRECTORY_ON_LOCAL_NODE", args);
        if (OiixUtil.isEmpty(listofFiles)) {
            boolean bDelete = true;
            if (parentdir.exists()) {
                bDelete = parentdir.delete();
            }
            if (bDelete) {
                this.logServiceSuccess((String[])args, message1, "S_CLEANUP_DELETING_DIRECTORY_ON_LOCAL_NODE_SUMMARY_SUCCESS");
            } else {
                this.serviceException((String[])args, message1, "S_CLEANUP_DELETING_DIRECTORY_ON_LOCAL_NODE_SUMMARY_FAILED");
            }
        }
    }

    private void removeCentralInvLocal(File invLocFile) {
        Object[] args = new String[]{this.m_sInvLocation};
        String message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETING_DIRECTORY_ON_LOCAL_NODE", args);
        try {
            if (invLocFile.exists()) {
                OiixFileOps.cleanupdelete(invLocFile);
            }
            if (!invLocFile.exists()) {
                this.logServiceSuccess((String[])args, message, "S_CLEANUP_DELETING_DIRECTORY_ON_LOCAL_NODE_SUMMARY_SUCCESS");
            } else {
                this.serviceException((String[])args, message, "S_CLEANUP_DELETING_DIRECTORY_ON_LOCAL_NODE_SUMMARY_FAILED");
            }
            if (this.m_sLocalNode == null) {
                this.localNodeLastHome = true;
                if (this.localNodeSameDefaultOraInst) {
                    this.localNodeRemoveOraInst = true;
                }
            } else {
                this.nodesLastHome.add(this.m_sLocalNode);
                if (this.nodesWithSameDefaultOraInst.indexOf(this.m_sLocalNode) != -1) {
                    this.nodesToRemoveOraInst.add(this.m_sLocalNode);
                }
            }
        }
        catch (Exception e) {
            this.serviceException((String[])args, message, "S_CLEANUP_DELETING_DIRECTORY_ON_LOCAL_NODE_SUMMARY_FAILED");
        }
    }

    private void copyOuiJreToScratch() throws IOException {
        String ouiLoc = System.getProperty("oracle.installer.oui_loc");
        String jreLoc = System.getProperty("oracle.installer.jre_loc");
        String scratchLoc = System.getProperty("oracle.installer.scratchPath");
        File ouiFile = new File(OiixPathOps.getAbsolutePath(ouiLoc));
        String ouiLocNew = OiixPathOps.getStandardForm(scratchLoc + "/" + s_baseAppPrefix);
        File scratchOuiFile = new File(ouiLocNew);
        OiixFileOps.copyDir(ouiFile, scratchOuiFile);
        System.setProperty("oracle.installer.oui_loc", ouiLocNew);
        File jreFile = new File(OiixPathOps.getAbsolutePath(jreLoc));
        String jreLocNew = OiixPathOps.getStandardForm(scratchLoc + "/" + "jre");
        File scratchJreFile = new File(jreLocNew);
        OiixFileOps.copyDir(jreFile, scratchJreFile);
        System.setProperty("oracle.installer.jre_loc", jreLocNew);
        String parentLoc = ouiFile.getParent();
        String srvmLoc = OiixPathOps.getStandardForm(parentLoc + "/" + "srvm");
        String srvmLocNew = OiixPathOps.getStandardForm(scratchLoc + "/" + "srvm");
        File srvmFile = new File(srvmLoc);
        File scratchSrvmFile = new File(srvmLocNew);
        if (srvmFile.exists()) {
            OiixFileOps.copyDir(srvmFile, scratchSrvmFile);
        }
    }

    public void setApiModeFlag() {
        this.s_bApiMode = true;
    }

    private void detachOHRemote() {
        OiixInstallUtil.setOption("oracle.installer.bootstrap");
        String invLoc = (String)this.m_oContext.getVarValue("INVENTORY_LOCATION");
        if (!OiixUtil.isEmpty(this.m_sRemoteNodesHomeAttached)) {
            String sCustomInvPtrLoc = this.getCustomUnixInvPtrLoc();
            if (!OiixUtil.isNullOrBlank(sCustomInvPtrLoc, true)) {
                this.setupRemoteInvPtrLoc(this.m_sRemoteNodesHomeAttached, sCustomInvPtrLoc);
            }
            OiicDetachHome detachHome = OiicDetachHome.getOiicDetachHomeInstance();
            detachHome.clsCmdDetachHome(this.m_sRemoteNodesHomeAttached, this.m_sOracleHome, this.m_sOracleHomeName, this.m_sLocalNode, invLoc, sCustomInvPtrLoc, this.bSharedHome);
            this.s_bDetachHomeRemote = true;
        }
    }

    private String[] setupRemoteInvPtrLoc(String[] asClusterNodes, String sLoc) {
        Object[] asNodes = OiipgClusterInvSetup.getCleanMachines(asClusterNodes);
        if (OiixUtil.isEmpty(asNodes)) {
            return asNodes;
        }
        ArrayList oCleanNodes = new ArrayList();
        try {
            OiipgClusterOps.transferFileToNodes((String[])asNodes, sLoc, new File(sLoc).getParent());
        }
        catch (OiipgRemoteOpsException e) {
            OiiolTextLogger.appendErrorText(e.getErrorMessage(), OiiolTextLogger.LOG_WITHOUT_LEVEL);
            return asNodes;
        }
        catch (OiipgRemoteFileOperationException e) {
            OiiolTextLogger.appendErrorText(e.getErrorMessage(), OiiolTextLogger.LOG_WITHOUT_LEVEL);
            return asNodes;
        }
        return OiixVectorOps.list2StrArr(oCleanNodes);
    }

    private String getCustomUnixInvPtrLoc() {
        String sCustomInvPtrLoc = null;
        if (OiixInstallUtil.isUnix()) {
            sCustomInvPtrLoc = System.getProperty("oracle.installer.invPtrLoc", "");
        }
        return sCustomInvPtrLoc;
    }

    private boolean validateHomeVariables() {
        if (OiixUtil.isNullOrBlank(this.m_sOracleHome, true)) {
            Object[] args1 = new String[]{" ORACLE_HOME"};
            OiiolTextLogger.writeToLogAndConsole("OIIC-22014", args1);
            OiicExitCode.setExitCode(-1);
            return false;
        }
        if (this.s_bIsWindows && OiixUtil.isNullOrBlank(this.m_sOracleHomeName, true)) {
            this.m_sOracleHomeName = this.getOracleHomeName(this.m_sOracleHome);
        }
        return true;
    }

    private boolean validateInputVariables() {
        if (this.s_bApiMode) {
            String ouiLoc = System.getProperty("oracle.installer.oui_loc");
            String jreLoc = System.getProperty("oracle.installer.jre_loc");
            String scratchPath = System.getProperty("oracle.installer.scratchPath");
            if (OiixUtil.isNullOrBlank(ouiLoc, true)) {
                Object[] args1 = new String[]{" 'oracle.installer.oui_loc'"};
                OiiolTextLogger.writeToLogAndConsole("OIIC-22014", args1);
                OiicExitCode.setExitCode(-1);
                return false;
            }
            if (OiixUtil.isNullOrBlank(jreLoc, true)) {
                Object[] args1 = new String[]{" 'oracle.installer.jre_loc'"};
                OiiolTextLogger.writeToLogAndConsole("OIIC-22014", args1);
                OiicExitCode.setExitCode(-1);
                return false;
            }
            if (!OiixUtil.isEmpty(this.m_sRemoteNodes) && OiixUtil.isNullOrBlank(scratchPath, true)) {
                Object[] args1 = new String[]{" BOOTSTRAP_LOCATION"};
                OiiolTextLogger.writeToLogAndConsole("OIIC-22014", args1);
                OiicExitCode.setExitCode(-1);
                return false;
            }
        }
        return true;
    }

    private boolean validateInvPtrLoc() {
        if (!this.s_bIsWindows && !OiixUtil.isNullOrBlank(this.m_sInvPtrLoc, true)) {
            File invPtrFile = new File(this.m_sInvPtrLoc);
            if (!invPtrFile.exists()) {
                Object[] args1 = new String[]{this.m_sInvPtrLoc};
                String message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_INVPTRLOC_ERROR", args1);
                OiiolTextLogger.writeToLogAndConsole(message);
                this.logSummaryMessage(message);
                OiicExitCode.setExitCode(-1);
                return false;
            }
            this.m_sInvPtrLocDir = invPtrFile.getParent();
        }
        return true;
    }

    private void determineRemoteNodesForDetachHome() {
        this.m_clusterInstInv = new OiiiClusterInstallInventory(this.m_sRemoteNodes);
        HashMap remoteNodesHomesAttached = this.m_clusterInstInv.getRemoteHomesAttached();
        Vector<String> remoteNodes = new Vector<String>();
        if (!OiixUtil.isEmpty(remoteNodesHomesAttached)) {
            Set nodes = remoteNodesHomesAttached.keySet();
            for (String nodeName : nodes) {
                List homesAttachedOnNode = this.m_clusterInstInv.getHomes(nodeName);
                if (OiixUtil.isEmpty(homesAttachedOnNode)) continue;
                for (String homeName : homesAttachedOnNode) {
                    if (!OiixUtil.equals(homeName, this.m_sOracleHome, OiixInstallUtil.isWindows())) continue;
                    remoteNodes.add(nodeName);
                }
            }
        }
        if (!OiixUtil.isEmpty(remoteNodes)) {
            String[] sampleStringList = new String[remoteNodes.size()];
            this.m_sRemoteNodesHomeAttached = remoteNodes.toArray(sampleStringList);
        }
    }

    public void setForceFlag(boolean forceFlag) {
        this.s_bForce = forceFlag;
    }

    public void setForceFlagOBase(boolean forceFlagOBase) {
        OiiolTextLogger.writeToLogAndConsole("Setting the force flag to cleanup the Oracle Base");
        this.s_bForceOBase = forceFlagOBase;
    }

    public boolean getForceFlag() {
        return this.s_bForce;
    }

    public boolean getForceFlagOBase() {
        return this.s_bForceOBase;
    }

    public void setDefInvPtrLoc(String defInvPtrLoc) {
        this.m_sDefInvPtrLoc = defInvPtrLoc;
    }

    private void setRemoteInvPtrLoc() throws OiipgRemoteOpsException, OiifbCancelException, IOException {
        if (this.m_sInvPtrLoc.equals(this.m_sDefInvPtrLoc)) {
            return;
        }
        for (int i = 0; i < this.m_sRemoteNodes.length; ++i) {
            boolean found = false;
            String remoteNode = this.m_sRemoteNodes[i];
            String scratchPath = System.getProperty("oracle.installer.scratchPath");
            String localPath = OiixPathOps.concatPath(scratchPath, "oraInst.loc_" + remoteNode);
            String defLocalPath = OiixPathOps.concatPath(scratchPath, "oraInst.loc_default_" + remoteNode);
            String filePath = OiixPathOps.concatPath(this.m_sOracleHome, m_sDefInvPtrFileName);
            if (OiipgClusterOps.fileExistsOnNode(remoteNode, filePath)) {
                OiipgClusterOps.transferFileFromNode(remoteNode, filePath, localPath);
                found = true;
            }
            if (!found && OiipgClusterOps.fileExistsOnNode(remoteNode, this.m_sDefInvPtrLoc)) {
                OiipgClusterOps.transferFileFromNode(remoteNode, this.m_sDefInvPtrLoc, localPath);
                found = true;
            }
            if (!found) {
                OiixFileOps.copyFile(this.m_sInvPtrLoc, localPath, true, false);
                found = true;
            }
            if (!found) continue;
            if (!OiipgClusterOps.fileExistsOnNode(remoteNode, this.m_sInvPtrLocDir)) {
                OiipgClusterOps.createDirInNode(remoteNode, this.m_sInvPtrLocDir);
            }
            OiipgClusterOps.transferFileToNode(localPath, remoteNode, this.m_sInvPtrLoc);
            if (!OiipgClusterOps.fileExistsOnNode(remoteNode, this.m_sDefInvPtrLoc)) continue;
            OiipgClusterOps.transferFileFromNode(remoteNode, this.m_sDefInvPtrLoc, defLocalPath);
            if (!this.checkForSameInventoryLocation(localPath, defLocalPath)) continue;
            this.nodesWithSameDefaultOraInst.add(remoteNode);
        }
    }

    private String getOracleHomeName(String oracleHome) {
        try {
            String[] keys = OiixRegistryOps.RegGetAllSubkeys(HKLM, SW_ORACLE_HOME_PREFIX);
            for (int i = 0; i < keys.length; ++i) {
                String oh;
                if (!keys[i].startsWith("KEY_") || !(oh = OiixRegistryOps.RegGetValue(HKLM, "SOFTWARE\\ORACLE\\" + keys[i], "ORACLE_HOME")).equals(oracleHome)) continue;
                String ohname = OiixRegistryOps.RegGetValue(HKLM, "SOFTWARE\\ORACLE\\" + keys[i], "ORACLE_HOME_NAME");
                return ohname;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private boolean checkForSameInventoryLocation(String path1, String path2) {
        try {
            if (path1 == null && path2 != null) {
                return true;
            }
            String invLoc1 = this.getPath(path1);
            String invLoc2 = this.getPath(path2);
            return OiixUtil.equals(invLoc1, invLoc2, true);
        }
        catch (IOException ioe) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String getPath(String path1) throws FileNotFoundException, IOException {
        FileInputStream fin1 = new FileInputStream(path1);
        Properties prop1 = new Properties();
        prop1.load(fin1);
        fin1.close();
        return prop1.getProperty("inventory_loc");
    }

    public List getCleanSummary() {
        return this.cleanSummary;
    }

    private void logSummaryMessage(String message) {
        if (this.s_bApiMode) {
            this.cleanSummary.add(message);
        }
    }

    public void setLogDir(String logDir) {
        this.m_sLogDir = logDir;
    }

    private boolean recdelete(File delDir, Vector excludeList) {
        boolean retVal = true;
        boolean childRetVal = true;
        if (!delDir.exists()) {
            return retVal;
        }
        String[] conts = delDir.list();
        int contslen = 0;
        if (conts != null) {
            contslen = conts.length;
        }
        for (int i = 0; i < contslen; ++i) {
            File subFile = new File(delDir, conts[i]);
            if (excludeList != null && excludeList.indexOf(conts[i]) > -1) {
                String excludeFile = subFile.getAbsolutePath();
                Object[] argsNew = new String[]{excludeFile};
                String msgNew = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ORACLE_HOME_DELETE_EXCLUDE", argsNew);
                OiiolTextLogger.writeToLogAndConsole(msgNew);
                continue;
            }
            if (subFile.isDirectory()) {
                boolean dirDeleteRetVal = this.recdelete(subFile, excludeList);
                if (dirDeleteRetVal) continue;
                childRetVal = false;
                continue;
            }
            if (subFile.delete() || !subFile.exists()) continue;
            Object[] args1 = new String[]{subFile.getAbsolutePath()};
            String message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_FAILED_DELETE_FILE", args1);
            OiiolTextLogger.writeToLogAndConsole(message);
            childRetVal = false;
            retVal = false;
        }
        conts = delDir.list();
        contslen = 0;
        if (conts != null) {
            contslen = conts.length;
        }
        boolean checkTopLevel = true;
        if (contslen > 0) {
            checkTopLevel = false;
            for (int i = 0; i < contslen; ++i) {
                boolean found = false;
                if (excludeList != null && excludeList.indexOf(conts[i]) > -1) {
                    found = true;
                }
                if (found) continue;
                checkTopLevel = true;
                break;
            }
        }
        if (checkTopLevel && !delDir.delete() && delDir.exists()) {
            Object[] args1 = new String[]{delDir.getAbsolutePath()};
            String message = null;
            message = childRetVal ? OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_FAILED_DELETE_DIRECTORY_IN_USE", args1) : OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_FAILED_DELETE_DIRECTORY_NOT_EMPTY", args1);
            OiiolTextLogger.writeToLogAndConsole(message);
            retVal = false;
        }
        return retVal;
    }

    private void cleanupMiscRegistriesRemote(String[] nodes) {
        if (!OiixUtil.isEmpty(this.miscRegistryListVector)) {
            String[] regArr = OiixVectorOps.vect2StrArr(this.miscRegistryListVector);
            for (int i = 0; i < regArr.length; ++i) {
                String entry = regArr[i];
                String key = OiicCleanup.getRegKey(entry);
                String subKey = OiicCleanup.getRegSubKey(entry);
                Object[] args = new String[]{key, subKey, OiixFunctionOps.implodeList(nodes, ",")};
                String message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETE_REGKEY_REMOTE", args);
                try {
                    if (OiixUtil.isEmpty(nodes)) continue;
                    OiipwClusterWindowsOps.registryDeleteKeyRecursivelyOnNodes(entry, nodes);
                    this.logServiceSuccess((String[])args, message, "S_CLEANUP_DELETE_REGKEY_REMOTE_SUMMARY_SUCCESS");
                    continue;
                }
                catch (OiipgRemoteOpsException e) {
                    this.serviceException((String[])args, message, "S_CLEANUP_DELETE_REGKEY_REMOTE_SUMMARY_FAILED", false);
                    OiiolTextLogger.appendException(e);
                    OiiolTextLogger.writeMessageToConsole(e.getBasicMessage());
                }
            }
        }
    }

    private void cleanupMiscRegistriesLocal() {
        if (!OiixUtil.isEmpty(this.miscRegistryListVector)) {
            String[] regArr = OiixVectorOps.vect2StrArr(this.miscRegistryListVector);
            for (int i = 0; i < regArr.length; ++i) {
                String entry = regArr[i];
                String key = OiicCleanup.getRegKey(entry);
                String subKey = OiicCleanup.getRegSubKey(entry);
                Object[] args = new String[]{key, subKey};
                String message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETE_REGKEY_LOCAL", args);
                try {
                    if (OiipwWin32NativeCalls.RegKeyExists(key, subKey)) {
                        OiipwWin32NativeCalls.RegDeleteKey(key, subKey);
                    }
                    this.logServiceSuccess((String[])args, message, "S_CLEANUP_DELETE_REGKEY_LOCAL_SUMMARY_SUCCESS");
                    continue;
                }
                catch (OiilNativeException e) {
                    this.serviceException((String[])args, message, "S_CLEANUP_DELETE_REGKEY_LOCAL_SUMMARY_FAILED");
                    OiiolTextLogger.appendText("OUI-22016", args);
                    OiiolTextLogger.appendException(e);
                }
            }
        }
    }

    private static String getRegKey(String entry) {
        int index = entry.indexOf("\\");
        return entry.substring(0, index);
    }

    private static String getRegSubKey(String entry) {
        int index = entry.indexOf("\\");
        int startIndex = index + 2;
        return entry.substring(startIndex);
    }

    private void cleanupOracleBaseLocal() {
        Object[] args = new String[]{this.m_sOracleBase};
        String message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETING_DIRECTORY_ON_LOCAL_NODE", args);
        File oracleBaseFile = new File(this.m_sOracleBase);
        boolean retVal = true;
        boolean emptyBase = false;
        if (oracleBaseFile.exists()) {
            this.recdeleteEmptyFoldersLocal(oracleBaseFile, false);
            String[] conts = oracleBaseFile.list();
            int contslen = 0;
            if (conts != null) {
                contslen = conts.length;
            }
            if (contslen == 0) {
                emptyBase = true;
            } else {
                emptyBase = true;
                if (!this.getForceFlagOBase()) {
                    for (int i = 0; i < contslen; ++i) {
                        File subFile = new File(oracleBaseFile, conts[i]);
                        if (this.oracleBaseDirListVector == null) continue;
                        if (this.oracleBaseDirListVector.indexOf(conts[i]) > -1) {
                            retVal = this.recdelete(subFile, this.homeDeinstallExcludeListVector);
                            continue;
                        }
                        String path = "";
                        String ohCanPath = "";
                        try {
                            path = OiixPathOps.getStandardForm(subFile.getCanonicalPath());
                            ohCanPath = OiixPathOps.getStandardCanonicalPath(this.m_sOracleHome);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (ohCanPath.indexOf(path) < 0) {
                            emptyBase = false;
                            continue;
                        }
                        if (!this.getForceFlagOBase()) continue;
                        retVal = this.recdelete(subFile, this.homeDeinstallExcludeListVector);
                    }
                }
            }
            if (emptyBase) {
                retVal = this.recdelete(oracleBaseFile, this.homeDeinstallExcludeListVector);
            } else {
                Object[] argsNew = new String[]{this.m_sOracleBase};
                String msgNew = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ORACLE_BASE_NOT_EMPTY_LOCAL_NODE", argsNew);
                OiiolTextLogger.writeToLogAndConsole(msgNew);
                return;
            }
        }
        if (retVal) {
            this.logServiceSuccess((String[])args, message, "S_CLEANUP_DELETING_DIRECTORY_ON_LOCAL_NODE_SUMMARY_SUCCESS");
        } else {
            this.serviceException((String[])args, message, "S_CLEANUP_DELETING_DIRECTORY_ON_LOCAL_NODE_SUMMARY_FAILED");
        }
    }

    private void recdeleteEmptyFoldersLocal(File folder, boolean removeCurrentFolder) {
        try {
            File[] fileList = folder.listFiles();
            for (int x = 0; fileList != null && x < fileList.length; ++x) {
                File subFile = fileList[x];
                if (!subFile.isDirectory()) continue;
                this.recdeleteEmptyFoldersLocal(subFile, true);
            }
            fileList = folder.listFiles();
            if (fileList != null && fileList.length == 0 && removeCurrentFolder) {
                this.recdelete(folder, this.homeDeinstallExcludeListVector);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void recdeleteEmptyFoldersRemote(String path, String node, boolean removeCurrentFolder) {
        try {
            String[] fileList = OiipgClusterOps.listDirectory(node, path);
            for (int x = 0; fileList != null && x < fileList.length; ++x) {
                String subFile = fileList[x];
                String subFilePath = OiixPathOps.getStandardForm(path + "/" + subFile);
                String[] subFileDirList = OiipgClusterOps.listDirectory(node, subFilePath);
                if (subFileDirList == null) continue;
                this.recdeleteEmptyFoldersRemote(subFilePath, node, true);
            }
            fileList = OiipgClusterOps.listDirectory(node, path);
            if (fileList != null && fileList.length == 0 && removeCurrentFolder) {
                OiipgClusterOps.removeDirectoryFromNode(node, path, System.getProperty("oracle.installer.scratchPath"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void cleanupOracleBaseRemote() {
        if (!this.bSharedHome && !OiixUtil.isEmpty(this.m_sRemoteNodesOracleBase)) {
            for (int i = 0; i < this.m_sRemoteNodesOracleBase.length; ++i) {
                String nodeName = this.m_sRemoteNodesOracleBase[i];
                Object[] args = new String[]{nodeName, this.m_sOracleBase};
                String message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETING_DIRECTORY_ON_REMOTE_NODES", args);
                try {
                    boolean emptyBase = false;
                    if (OiipgClusterOps.fileExistsOnNode(nodeName, this.m_sOracleBase)) {
                        this.recdeleteEmptyFoldersRemote(this.m_sOracleBase, nodeName, false);
                        String[] conts = OiipgClusterOps.listDirectory(nodeName, this.m_sOracleBase);
                        int contslen = 0;
                        if (conts != null) {
                            contslen = conts.length;
                        }
                        if (contslen == 0) {
                            emptyBase = true;
                        } else {
                            emptyBase = true;
                            if (!this.getForceFlagOBase()) {
                                for (int j = 0; j < contslen; ++j) {
                                    String path = OiixPathOps.getStandardForm(this.m_sOracleBase + "/" + conts[j]);
                                    if (this.oracleBaseDirListVector == null) continue;
                                    if (this.oracleBaseDirListVector.indexOf(conts[j]) > -1) {
                                        OiipgClusterOps.removeDirectoryFromNode(nodeName, path, System.getProperty("oracle.installer.scratchPath"));
                                        continue;
                                    }
                                    if (this.m_sOracleHome.indexOf(path) < 0) {
                                        emptyBase = false;
                                        continue;
                                    }
                                    if (!this.getForceFlagOBase()) continue;
                                    OiipgClusterOps.removeDirectoryFromNode(nodeName, path, System.getProperty("oracle.installer.scratchPath"));
                                }
                            }
                        }
                        if (emptyBase) {
                            OiipgClusterOps.removeDirectoryFromNode(nodeName, this.m_sOracleBase, System.getProperty("oracle.installer.scratchPath"));
                        } else {
                            Object[] argsNew = new String[]{this.m_sOracleBase, nodeName};
                            String msgNew = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ORACLE_BASE_NOT_EMPTY_REMOTE_NODE", argsNew);
                            OiiolTextLogger.writeToLogAndConsole(msgNew);
                            continue;
                        }
                    }
                    this.logServiceSuccess((String[])args, message, "S_CLEANUP_DELETING_DIRECTORY_ON_REMOTE_NODES_SUMMARY_SUCCESS");
                    continue;
                }
                catch (OiipgRemoteOpsException e) {
                    this.deleteRMNodeDirFailed((String[])args, message, e);
                    continue;
                }
                catch (OiipgRemoteFileOperationException e) {
                    this.deleteRMNodeDirFailed((String[])args, message, e);
                }
            }
        }
    }

    private void determineCleanupOracleBaseLocal() throws OiitTargetLockNotAvailableException, IOException, OiiiInventoryDoesNotExistException, OiifbEndIterateException, OiisVarSettingException, OiifbCancelException {
        if (this.bSharedHome || OiixUtil.isNullOrBlank(this.m_sOracleBase, true)) {
            this.m_bCleanupLocalOracleBase = false;
            this.m_bCleanupRemoteOracleBase = false;
            return;
        }
        this.initInvSession();
        OiiiInstallAreaControl iAreaControl = OiiiInstallAreaControl.getInstallAreaControl();
        this.m_oContext.setVarValue("INVENTORY_LOCATION", iAreaControl.getAreaRoot());
        OiiiInstallInventory instinv = iAreaControl.getInstallInventory();
        OiiolTextLogger.appendText("The access level of the inventory is " + iAreaControl.getAccessLevel());
        this.m_sInvLocation = iAreaControl.getAreaRoot();
        Vector homesAttached = this.s_bIsWindows ? new Vector(instinv.getAllWinHomes()) : instinv.getHomes();
        if (homesAttached != null) {
            for (int i = 0; i < homesAttached.size(); ++i) {
                OiiiOracleHomeInfo ohInfo = (OiiiOracleHomeInfo)homesAttached.elementAt(i);
                if (ohInfo == null) continue;
                String obase = ohInfo.getAdditionalOracleHomeProperty("ORACLE_BASE");
                String ohLoc = ohInfo.getLocation();
                if (!OiixUtil.isNullOrBlank(obase, true) && obase.equalsIgnoreCase(this.m_sOracleBase)) {
                    this.logBaseMissingError(ohLoc);
                    break;
                }
                if (OiixUtil.isNullOrBlank(ohLoc, true) || !ohLoc.toLowerCase().startsWith(this.m_sOracleBase.toLowerCase())) continue;
                this.logBaseMissingError(ohLoc);
                break;
            }
        }
        if (OiixUtil.isFileExists(this.m_sInvLocation) && this.m_sInvLocation.toLowerCase().startsWith(this.m_sOracleBase.toLowerCase())) {
            this.m_bCleanupLocalOracleBase = false;
            Object[] args = new String[]{this.m_sOracleBase};
            String msg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ORACLE_BASE_IN_USE_CI_LOCAL_NODE", args);
            OiiolTextLogger.writeToLogAndConsole(msg);
        }
    }

    private void logBaseMissingError(String ohLoc) {
        this.m_bCleanupLocalOracleBase = false;
        Object[] args = new String[]{this.m_sOracleBase, ohLoc};
        String msg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ORACLE_BASE_IN_USE_LOCAL_NODE", args);
        OiiolTextLogger.writeToLogAndConsole(msg);
    }

    private void initInvSession() throws OiitTargetLockNotAvailableException, IOException {
        if (this.invSession == null) {
            try {
                OiiolTextLogger.appendText("Creating a new Inventory Session");
                this.invSession = new OiicStandardInventorySession(OiicCleanup.getLogPrefix(), OiicInstVersion.getVersionString());
                OiiolTextLogger.appendText("Initializing the inventory session with access 1");
                this.invSession.initSession(1);
            }
            catch (OiiiInventoryDoesNotExistException e) {
                OiiolTextLogger.appendException(e);
            }
        }
    }

    private void determineCleanupOracleBaseRemote() {
        Vector<String> oBaseNodes = new Vector<String>();
        if (!OiixUtil.isEmpty(this.m_sRemoteNodes)) {
            for (int i = 0; i < this.m_sRemoteNodes.length; ++i) {
                oBaseNodes.add(this.m_sRemoteNodes[i]);
            }
        }
        this.m_clusterInstInv = new OiiiClusterInstallInventory(this.m_sRemoteNodes, true);
        HashMap remoteNodesHomesAttached = this.m_clusterInstInv.getRemoteHomesAttached();
        if (!OiixUtil.isEmpty(remoteNodesHomesAttached)) {
            Set nodes = remoteNodesHomesAttached.keySet();
            Iterator iter = nodes.iterator();
            while (iter.hasNext()) {
                boolean oBaseUsed = false;
                String nodeName = (String)iter.next();
                List homesAttachedOnNode = this.m_clusterInstInv.getHomes(nodeName);
                if (!OiixUtil.isEmpty(homesAttachedOnNode)) {
                    for (int i = 0; i < homesAttachedOnNode.size(); ++i) {
                        String remoteHomeLoc = (String)homesAttachedOnNode.get(i);
                        OiiiRemoteHome remoteHome = this.m_clusterInstInv.getRemoteHome(nodeName, remoteHomeLoc);
                        if (remoteHome == null) continue;
                        String obase = remoteHome.getAdditionalOracleHomeProperty("ORACLE_BASE");
                        if (!OiixUtil.isNullOrBlank(obase, true) && obase.equalsIgnoreCase(this.m_sOracleBase)) {
                            oBaseUsed = this.oracleHomeInUseError(nodeName, remoteHomeLoc);
                            break;
                        }
                        if (OiixUtil.isNullOrBlank(remoteHomeLoc, true) || !remoteHomeLoc.toLowerCase().startsWith(this.m_sOracleBase.toLowerCase())) continue;
                        oBaseUsed = this.oracleHomeInUseError(nodeName, remoteHomeLoc);
                        break;
                    }
                }
                boolean remoteInvExist = false;
                try {
                    remoteInvExist = OiipgClusterOps.fileExistsOnNode(nodeName, this.m_sInvLocation);
                }
                catch (Exception remoteHomeLoc) {
                    // empty catch block
                }
                if (remoteInvExist && this.m_sInvLocation.toLowerCase().startsWith(this.m_sOracleBase.toLowerCase())) {
                    oBaseUsed = true;
                    Object[] args = new String[]{this.m_sOracleBase, nodeName};
                    String msg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ORACLE_BASE_IN_USE_CI_REMOTE_NODE", args);
                    OiiolTextLogger.writeToLogAndConsole(msg);
                }
                if (!oBaseUsed) continue;
                oBaseNodes.remove(nodeName);
            }
        }
        this.m_sRemoteNodesOracleBase = OiixVectorOps.list2StrArr(oBaseNodes);
    }

    private boolean oracleHomeInUseError(String nodeName, String remoteHomeLoc) {
        boolean oBaseUsed = true;
        Object[] args = new String[]{this.m_sOracleBase, nodeName, remoteHomeLoc};
        String msg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ORACLE_BASE_IN_USE_REMOTE_NODE", args);
        OiiolTextLogger.writeToLogAndConsole(msg);
        return oBaseUsed;
    }

    private void getAllOHServices() {
        String[] services = null;
        Vector<String> ohServices = new Vector<String>();
        try {
            services = (String[])OiixServiceOps.getAllOracleServices();
            if (services != null) {
                for (int i = 0; i < services.length; ++i) {
                    try {
                        String service = services[i];
                        String exeName = OiixServiceOps.getServiceExeName(service);
                        String homeLoc = this.m_sOracleHome + "\\";
                        if (exeName.toLowerCase().indexOf(homeLoc.toLowerCase()) <= -1) continue;
                        ohServices.add(service);
                        continue;
                    }
                    catch (Exception e) {
                        OiiolTextLogger.appendText(e.getMessage());
                    }
                }
                if (!OiixUtil.isEmpty(ohServices)) {
                    this.m_sOHServices = OiixVectorOps.vect2StrArr(ohServices);
                }
            }
        }
        catch (Exception e) {
            OiiolTextLogger.appendText(e.getMessage());
        }
    }

    private void cleanupOHServicesLocal() {
        if (!OiixUtil.isEmpty(this.m_sOHServices)) {
            for (int i = 0; i < this.m_sOHServices.length; ++i) {
                String service = this.m_sOHServices[i];
                int status = 0;
                try {
                    status = OiixServiceOps.queryService(service);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (status == 4) {
                    this.stopService(service);
                }
                this.removeService(service);
            }
        }
    }

    private void removeService(String service) {
        Object[] args = new String[]{service};
        String message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_REMOVING_SERVICE_ON_LOCAL_NODE", args);
        try {
            OiixServiceOps.ntDeleteService(service);
            this.logServiceSuccess((String[])args, message, "S_REMOVE_SERVICE_ON_LOCAL_NODE_SUMMARY_SUCCESS");
        }
        catch (Exception e) {
            this.serviceException((String[])args, message, "S_REMOVE_SERVICE_ON_LOCAL_NODE_SUMMARY_FAILED");
        }
    }

    private void stopService(String service) {
        Object[] args = new String[]{service};
        String message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_STOPPING_SERVICE_ON_LOCAL_NODE", args);
        try {
            OiixServiceOps.ntStopService(service);
            this.logServiceSuccess((String[])args, message, "S_STOP_SERVICE_ON_LOCAL_NODE_SUMMARY_SUCCESS");
        }
        catch (Exception e) {
            this.serviceException((String[])args, message, "S_STOP_SERVICE_ON_LOCAL_NODE_SUMMARY_FAILED");
        }
    }

    private void cleanupOHServicesRemote() {
        if (!OiixUtil.isEmpty(this.m_sRemoteNodes) && !OiixUtil.isEmpty(this.m_sOHServices)) {
            for (int i = 0; i < this.m_sRemoteNodes.length; ++i) {
                String nodeName = this.m_sRemoteNodes[i];
                for (int j = 0; j < this.m_sOHServices.length; ++j) {
                    String service = this.m_sOHServices[j];
                    boolean status = false;
                    try {
                        status = OiipwClusterWindowsOps.checkServiceRunningOnNode(service, nodeName);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (status) {
                        this.stopRemoteNodeService(nodeName, service);
                    }
                    this.removeRemoteNodeService(nodeName, service);
                }
            }
        }
    }

    private void removeRemoteNodeService(String nodeName, String service) {
        Object[] args = new String[]{service, nodeName};
        String message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_REMOVING_SERVICE_ON_REMOTE_NODE", args);
        try {
            OiipwClusterWindowsOps.deleteServiceOnNode(service, nodeName);
            this.logServiceSuccess((String[])args, message, "S_REMOVE_SERVICE_ON_REMOTE_NODE_SUMMARY_SUCCESS");
        }
        catch (Exception e) {
            this.serviceException((String[])args, message, "S_REMOVE_SERVICE_ON_REMOTE_NODE_SUMMARY_FAILED");
        }
    }

    private void stopRemoteNodeService(String nodeName, String service) {
        Object[] args = new String[]{service, nodeName};
        String message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_STOPPING_SERVICE_ON_REMOTE_NODE", args);
        try {
            OiipwClusterWindowsOps.stopServiceOnNode(service, nodeName);
            this.logServiceSuccess((String[])args, message, "S_STOP_SERVICE_ON_REMOTE_NODE_SUMMARY_SUCCESS");
        }
        catch (Exception e) {
            this.serviceException((String[])args, message, "S_STOP_SERVICE_ON_REMOTE_NODE_SUMMARY_FAILED");
        }
    }

    private void cleanupPathLocal() {
        String varName = "Path";
        Object[] args = new String[]{this.m_sOracleHome};
        String message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_REMOVING_ORACLE_HOME_FROM_PATH_ON_LOCAL_NODE", args);
        try {
            String value = OiixRegistryOps.RegGetValue(HKLM, ENV_REG_SUBKEY, varName);
            String newValue = this.removeHomeFromPath(value);
            if (value.equals(newValue)) {
                OiiolTextLogger.appendText("Path variable has no reference to Oracle Home '" + this.m_sOracleHome + "' on local node, no changes required.");
                return;
            }
            OiixRegistryOps.RegSetWideCharsetValue(HKLM, ENV_REG_SUBKEY, varName, newValue, true, false);
            OiixEnvironmentOps.SendIniChangeMessage();
            this.logServiceSuccess((String[])args, message, "S_REMOVE_ORACLE_HOME_FROM_PATH_ON_LOCAL_NODE_SUMMARY_SUCCESS");
        }
        catch (Exception e) {
            this.serviceException((String[])args, message, "S_REMOVE_ORACLE_HOME_FROM_PATH_ON_LOCAL_NODE_SUMMARY_FAILED");
        }
    }

    private void cleanupPathRemote() {
        if (!OiixUtil.isEmpty(this.m_sRemoteNodes)) {
            for (int i = 0; i < this.m_sRemoteNodes.length; ++i) {
                String node = this.m_sRemoteNodes[i];
                Object[] args = new String[]{this.m_sOracleHome, node};
                String message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_REMOVING_ORACLE_HOME_FROM_PATH_ON_REMOTE_NODE", args);
                try {
                    String varName = "Path";
                    String value = OiipwClusterWindowsOps.getRegStringDataOnNode(ENV_REG_KEY, varName, node);
                    if (value == null) continue;
                    String newValue = this.removeHomeFromPath(value);
                    if (value.equals(newValue)) {
                        OiiolTextLogger.appendText("Path variable has no reference to Oracle Home '" + this.m_sOracleHome + "' on node '" + node + ", no changes required.");
                        continue;
                    }
                    String[] nodes = new String[]{node};
                    String srcLoc = System.getProperty("DC_HOME");
                    OiipwClusterWindowsOps.registrySetValue(HKLM, ENV_REG_SUBKEY, varName, newValue, true, nodes);
                    OiipwClusterWindowsOps.updateEnv(nodes, srcLoc);
                    this.logServiceSuccess((String[])args, message, "S_REMOVE_ORACLE_HOME_FROM_PATH_ON_REMOTE_NODE_SUMMARY_SUCCESS");
                    continue;
                }
                catch (Exception e) {
                    this.serviceException((String[])args, message, "S_REMOVE_ORACLE_HOME_FROM_PATH_ON_REMOTE_NODE_SUMMARY_FAILED");
                }
            }
        }
    }

    private String removeHomeFromPath(String path) {
        if (OiixUtil.isNullOrBlank(path, true)) {
            return path;
        }
        String delimiter = ";";
        Vector<String> newPath = new Vector<String>();
        String[] tokens = OiixFunctionOps.explodeString(path, delimiter);
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (token.toLowerCase().startsWith(this.m_sOracleHome.toLowerCase())) continue;
            newPath.add(token);
        }
        String[] newPathString = OiixVectorOps.vect2StrArr(newPath);
        return OiixFunctionOps.implodeList(newPathString, delimiter);
    }

    private String getRemoveExcludeList() {
        String dcRemExclList;
        String homeRemExclList = OiixPathOps.getStandardForm(this.m_sOracleHome + "/crs/install/installRemove.excl");
        String exclList = null;
        String retExclList = null;
        String toolDir = System.getProperty("DC_HOME");
        if (new File(homeRemExclList).exists()) {
            exclList = homeRemExclList;
        } else if (!OiixUtil.isNullOrBlank(toolDir, true) && new File(dcRemExclList = OiixPathOps.getStandardForm(toolDir + "/crs/install/installRemove.excl")).exists()) {
            exclList = dcRemExclList;
        }
        if (exclList != null) {
            String scratchPath = System.getProperty("oracle.installer.scratchPath");
            retExclList = OiixPathOps.getStandardForm(scratchPath + "/removeHomeExcludeList");
            try {
                OiixFileOps.copyFile(exclList, retExclList, true, false);
            }
            catch (Exception e) {
                retExclList = null;
            }
        }
        OiiolTextLogger.appendText("RemoveHomeExcludeList is: " + retExclList);
        return retExclList;
    }

    private String getOracleBaseDirList() {
        String retObaseList = null;
        String sysPropVal = System.getProperty(OBASE_CLEANUP_PTR);
        if (OiixUtil.isFileExists(sysPropVal)) {
            retObaseList = sysPropVal;
        }
        OiiolTextLogger.appendText("OracleBaseDirList is: " + retObaseList);
        return retObaseList;
    }

    private String getMiscRegistryList() {
        String retRegistryList = null;
        String sysPropVal = System.getProperty(REGISTRY_CLEANUP_PTR);
        if (OiixUtil.isFileExists(sysPropVal)) {
            retRegistryList = sysPropVal;
        }
        OiiolTextLogger.appendText("WindowsRegistryCleanupList is: " + retRegistryList);
        return retRegistryList;
    }

    private Vector readFileIntoVector(String fileName) {
        Vector<String> ret = null;
        try {
            BufferedReader reader = new BufferedReader(new FileReader(fileName));
            String str = reader.readLine();
            while (str != null) {
                if (ret == null) {
                    ret = new Vector<String>();
                }
                ret.add(str);
                str = reader.readLine();
            }
            reader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public boolean isbSharedHome() {
        return this.bSharedHome;
    }

    public void setbSharedHome(boolean bSharedHome) {
        this.bSharedHome = bSharedHome;
    }

    private void logServiceSuccess(String[] args, String message, String type) {
        String result = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_DONE");
        Object[] args1 = new String[]{message, result};
        String doneMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_MESSAGE_RESULT", args1);
        OiiolTextLogger.writeToLogAndConsole(doneMessage);
        String summaryMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", type, args);
        this.logSummaryMessage(summaryMessage);
    }

    private void serviceException(String[] args, String message, String type) {
        this.serviceException(args, message, type, true);
    }

    private void serviceException(String[] args, String message, String type, boolean setExitCode) {
        String result = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_FAILED");
        Object[] args1 = new String[]{message, result};
        String failedMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_MESSAGE_RESULT", args1);
        OiiolTextLogger.writeToLogAndConsole(failedMessage);
        String summaryMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", type, args);
        this.logSummaryMessage(summaryMessage);
        if (setExitCode) {
            OiicExitCode.setExitCode(-1);
        }
    }

    private boolean checkSkipHomeDeletionStatus(boolean remote) {
        String value = "";
        if (!remote) {
            value = System.getProperty(SKIP_LOCAL_HOME_DELETION);
            if (value != null) {
                OiiolTextLogger.appendText("skipLocalHomeDeletion value = " + value);
                System.out.println("skipLocalHomeDeletion value = " + value);
            }
        } else {
            value = System.getProperty(SKIP_REMOTE_HOME_DELETION);
            if (value != null) {
                OiiolTextLogger.appendText("skipRemoteHomeDeletion value = " + value);
                System.out.println("skipRemoteHomeDeletion value = " + value);
            }
        }
        return null != value && value.trim().equalsIgnoreCase("true");
    }
}

