/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import oracle.sysman.oii.oiic.OiicAPIInstaller;
import oracle.sysman.oii.oiic.OiicBaseInventoryApp;
import oracle.sysman.oii.oiic.OiicCmdLineProperty;
import oracle.sysman.oii.oiic.OiicConfigContext;
import oracle.sysman.oii.oiic.OiicExitCode;
import oracle.sysman.oii.oiic.OiicInstVersion;
import oracle.sysman.oii.oiic.OiicInstaller;
import oracle.sysman.oii.oiic.OiicInvalidCmdLineException;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterOps;
import oracle.sysman.oii.oiip.oiipg.OiipgRemoteOpsException;
import oracle.sysman.oii.oiip.oiipg.OiipgSRVMTracing;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixInstallUtil;
import oracle.sysman.oii.oiix.OiixLanguage;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixTeePrintStream;
import oracle.sysman.oii.oiix.OiixUtil;

public abstract class OiicBaseApp {
    private static OiicBaseApp m_oBaseApp = null;
    private static final String DELIM = ",";
    private static final String NEW_LINE = "\n";
    private String m_sAppName;
    private Map m_oCommandLineArgs;
    private List m_oInvalidArgs;
    protected List m_oCmdLineOptions;
    private static Properties m_oDefaultsOverriden;
    private Properties m_oCmdProps;
    private static OiicConfigContext s_oiicConfigContext;
    protected static boolean altInstallProps;
    private Properties m_oBackupProps;

    public OiicBaseApp(String sName) {
        this.m_sAppName = sName;
        this.m_oCmdProps = null;
        m_oBaseApp = this;
    }

    public static OiicBaseApp getOiicBaseApp() {
        return m_oBaseApp;
    }

    public Properties getDefaultsOverriden() {
        if (m_oDefaultsOverriden == null) {
            m_oDefaultsOverriden = new Properties();
        }
        return m_oDefaultsOverriden;
    }

    public Properties getCmdProps() {
        return this.m_oCmdProps;
    }

    public String getAppName() {
        return this.m_sAppName;
    }

    protected String getSystemPropertyPrefix() {
        return "oracle." + this.getAppName() + ".";
    }

    public void resetCommandLineArgsTable() {
        this.m_oCommandLineArgs = null;
    }

    public Hashtable getCommandLineArgsTable() {
        Hashtable ht = new Hashtable(this.getCommandLineArgs());
        return ht;
    }

    public Map getCommandLineArgs() {
        if (this.m_oCommandLineArgs == null) {
            this.m_oCommandLineArgs = new HashMap(20, 10.0f);
        }
        return this.m_oCommandLineArgs;
    }

    public static boolean isAPI() {
        return OiixInstallUtil.isAPIMode();
    }

    public static OiicBaseApp getBaseApp() {
        OiicBaseApp o_baseApp = null;
        o_baseApp = OiicBaseApp.isAPI() ? OiicAPIInstaller.getHandleToAPIInstaller() : OiicInstaller.getHandleToOiicInstaller();
        if (o_baseApp == null && (o_baseApp = OiicBaseInventoryApp.getOiicBaseInventoryApp()) == null) {
            o_baseApp = OiicBaseApp.getOiicBaseApp();
        }
        return o_baseApp;
    }

    public List getInvalidArgsList() {
        return this.m_oInvalidArgs;
    }

    private void addToInvalidArgs(String sInvalidArg) {
        if (this.m_oInvalidArgs == null) {
            this.m_oInvalidArgs = new ArrayList(5);
        }
        this.m_oInvalidArgs.add(sInvalidArg);
    }

    protected boolean anyInvalidArgsFound() {
        return !OiixUtil.isEmpty(this.getInvalidArgsList());
    }

    public void setSystemProperties(Properties props) {
        Properties sysProps = System.getProperties();
        Enumeration<?> propNames = props.propertyNames();
        while (propNames.hasMoreElements()) {
            String propName = (String)propNames.nextElement();
            sysProps.put(propName, props.get(propName));
        }
    }

    public void processCommandLine(String[] args) throws OiicInvalidCmdLineException {
        Properties cmdProps = this.parseCmdLineEx(args);
        this.setSystemProperties(cmdProps);
        if (this.anyInvalidArgsFound()) {
            throw new OiicInvalidCmdLineException(this.formatInvalidArgsMsg());
        }
    }

    public void processCmdLine(String[] args) {
        this.setDefaults();
        Properties props = new Properties();
        this.parseCmdLine(args, props);
        this.setSystemProperties(props);
        this.m_oCmdProps = props;
    }

    public void processCmdLineWithProps(Properties oProps) {
        this.setDefaults();
        Properties props = new Properties();
        this.parseCmdLineWithProps(oProps, props);
        this.setSystemProperties(oProps);
        this.setSystemProperties(props);
        this.m_oCmdProps = props;
    }

    protected void parseCmdLineWithProps(Properties oProps, Properties props) {
        if (null != oProps) {
            Enumeration<Object> oKeys = oProps.keys();
            while (oKeys.hasMoreElements()) {
                int iIndex;
                boolean found = false;
                String sCurArg = (String)oKeys.nextElement();
                if ("-bigCluster".equalsIgnoreCase(sCurArg)) {
                    sCurArg = "-setCustomNodelist";
                }
                for (int i = 0; i < this.m_oCmdLineOptions.size(); ++i) {
                    OiicCmdLineProperty oCmdOption = (OiicCmdLineProperty)this.m_oCmdLineOptions.get(i);
                    String sName = oCmdOption.getNameFromType();
                    String sNameOrig = oCmdOption.getName();
                    String sPrefix = oCmdOption.getSysPropertyPrefix();
                    int nArgType = oCmdOption.getType();
                    if (!sCurArg.equalsIgnoreCase("-" + sName)) continue;
                    int nNumValuesExpected = oCmdOption.getNumValuesExpected();
                    if (nNumValuesExpected > 0) {
                        String sVal = oProps.getProperty(sCurArg);
                        props.put(sPrefix + sNameOrig, sVal);
                    } else {
                        props.put(sPrefix + sNameOrig, OiicBaseApp.getValForType(nArgType));
                    }
                    found = true;
                    break;
                }
                if (!found && (iIndex = sCurArg.indexOf("=")) != -1) {
                    String varName = sCurArg.substring(0, iIndex);
                    String varValue = sCurArg.substring(iIndex + 1, sCurArg.length());
                    found = true;
                    this.addToCommandLineTable(varName, varValue);
                }
                if (found || sCurArg.trim().length() == 0) continue;
                this.addToInvalidArgs(sCurArg);
            }
        }
    }

    public void setAdditionalProperties() {
        Properties sysProps = System.getProperties();
        Properties props = this.getCmdProps();
        if (OiixInstallUtil.isDebug() && !OiixInstallUtil.isOptionSetInOraparam("IGNORECLUSTER")) {
            OiipgSRVMTracing.setTraceEnabled(true);
            OiipgSRVMTracing.setTraceLevel(5);
        }
        boolean bSilent = OiixInstallUtil.isSilent();
        if (OiixInstallUtil.isOptionSet("oracle.installer.local")) {
            OiixInstallUtil.unsetOption("oracle.installer.clusterEnabled");
        } else if (!OiixInstallUtil.isOptionSet("oracle.installer.clusterEnabled")) {
            OiixInstallUtil.setOption("oracle.installer.local");
        }
        if (!bSilent && (OiixInstallUtil.isOptionSet("oracle.installer.help") || OiixInstallUtil.isOptionSet("oracle.installer.h"))) {
            OiixInstallUtil.setOption("oracle.installer.silent");
            if (props != null) {
                props.put("oracle.installer.silent", "true");
            }
            bSilent = true;
        }
        if (!bSilent && OiixInstallUtil.isOptionSet("oracle.installer.attachHome")) {
            OiixInstallUtil.setOption("oracle.installer.silent");
            if (props != null) {
                props.put("oracle.installer.silent", "true");
            }
            bSilent = true;
        }
        String sNls = sysProps.getProperty("oracle.installer.nlsEnabled", "");
        sNls = sNls.replace('\"', ' ');
        if ((sNls = sNls.trim()).equalsIgnoreCase("FALSE")) {
            Locale.setDefault(OiixLanguage.ENGLISH);
        } else {
            Locale.setDefault(OiixLanguage.getDefaultLocale());
        }
        String sOUILoc = sysProps.getProperty("oracle.installer.oui_loc");
        if (sOUILoc == null) {
            this.computeDefaultOUILoc();
        }
        if (sOUILoc != null) {
            String sLibraryLoc = OiixPathOps.concatPath(sOUILoc, "lib");
            sLibraryLoc = OiixPathOps.concatPath(sLibraryLoc, OiixPlatform.getCurrentPlatformDirectoryName());
            sLibraryLoc = OiixPathOps.getNativeForm(sLibraryLoc);
            sysProps.put("oracle.installer.library_loc", sLibraryLoc);
            if (props != null) {
                props.put("oracle.installer.library_loc", sLibraryLoc);
            }
        }
    }

    protected String getInvalidCommandLineArgsList() {
        StringBuffer sbRet = new StringBuffer();
        List s_vInvalidCommandLineArgs = this.getInvalidArgsList();
        int iSize = s_vInvalidCommandLineArgs.size();
        String comma = ", ";
        String quote = "'";
        for (int i = 0; i < iSize; ++i) {
            sbRet.append(quote + (String)s_vInvalidCommandLineArgs.get(i) + quote);
            if (i + 1 >= iSize) continue;
            sbRet.append(comma);
        }
        return sbRet.toString();
    }

    protected String formatInvalidArgsMsg() {
        String sbMsg = this.getInvalidCommandLineArgsList();
        Object[] msgparams = new String[]{sbMsg, this.getAppName()};
        return OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-25001", msgparams);
    }

    protected void setDefaults() {
        Properties props = new Properties();
        try {
            this.m_oCmdLineOptions = this.setupAppProperties();
        }
        catch (OiicInvalidCmdLineException error) {
            System.out.println("exception in set dafaults -- setup app properties ");
        }
        this.initBooleanDefaults(props);
        if (System.getProperty("oracle.installer.font") == null) {
            props.put("oracle.installer.font", "SansSerif");
        }
        this.setSystemProperties(props);
    }

    protected void initBooleanDefaults(Properties props) {
        Properties defProps = this.getDefaultsOverriden();
        for (int i = 0; i < this.m_oCmdLineOptions.size(); ++i) {
            OiicCmdLineProperty oCmdOption = (OiicCmdLineProperty)this.m_oCmdLineOptions.get(i);
            if (!oCmdOption.isBooleanType()) continue;
            String sName = oCmdOption.getName();
            String sPrefix = oCmdOption.getSysPropertyPrefix();
            String propName = sPrefix + sName;
            if (System.getProperty(propName) != null) continue;
            String propVal = OiicBaseApp.getDefValForType(oCmdOption.getType());
            props.put(propName, propVal);
            defProps.put(propName, propVal);
        }
    }

    protected void parseCmdLine(String[] args, Properties props) {
        int nArgsIndex = 0;
        if (null == args) {
            return;
        }
        while (nArgsIndex < args.length) {
            int iIndex;
            int advanceBy = 1;
            boolean found = false;
            String sCurArg = args[nArgsIndex].trim();
            if ("-bigCluster".equalsIgnoreCase(sCurArg)) {
                sCurArg = "-setCustomNodelist";
            }
            for (int i = 0; i < this.m_oCmdLineOptions.size(); ++i) {
                OiicCmdLineProperty oCmdOption = (OiicCmdLineProperty)this.m_oCmdLineOptions.get(i);
                String sName = oCmdOption.getNameFromType();
                String sNameOrig = oCmdOption.getName();
                String sPrefix = oCmdOption.getSysPropertyPrefix();
                int nArgType = oCmdOption.getType();
                if (!sCurArg.equalsIgnoreCase("-" + sName)) continue;
                int nNumValuesExpected = oCmdOption.getNumValuesExpected();
                if (nNumValuesExpected > 0) {
                    if (nArgsIndex + 1 < args.length) {
                        String sVal = args[nArgsIndex + 1];
                        props.put(sPrefix + sNameOrig, sVal);
                    }
                } else {
                    props.put(sPrefix + sNameOrig, OiicBaseApp.getValForType(nArgType));
                }
                advanceBy += nNumValuesExpected;
                found = true;
                break;
            }
            if (!found && (iIndex = sCurArg.indexOf("=")) != -1) {
                String varName = sCurArg.substring(0, iIndex);
                String varValue = sCurArg.substring(iIndex + 1, sCurArg.length());
                found = true;
                this.addToCommandLineTable(varName, varValue);
            }
            if (!found) {
                if (sCurArg.trim().length() == 0) {
                    ++nArgsIndex;
                    continue;
                }
                this.addToInvalidArgs(sCurArg);
            }
            nArgsIndex += advanceBy;
        }
    }

    public static boolean getAltInstallProps() {
        return altInstallProps;
    }

    public boolean loadInstallPropertiesFile(String location) {
        boolean retVal = false;
        Properties props = new Properties();
        try {
            FileInputStream fs = new FileInputStream(location);
            props.load(fs);
            retVal = true;
            Properties backup = this.getBackupProps();
            Properties sysProps = System.getProperties();
            Properties dProps = this.getDefaultsOverriden();
            Enumeration<?> propNames = props.propertyNames();
            while (propNames.hasMoreElements()) {
                String propName = (String)propNames.nextElement();
                String sysPropVal = sysProps.getProperty(propName);
                if (sysPropVal != null && (dProps == null || dProps.getProperty(propName) == null)) {
                    props.remove(propName);
                    continue;
                }
                String propVal = System.getProperty(propName);
                if (propVal == null) {
                    propVal = "";
                }
                backup.put(propName, propVal);
            }
            this.setSystemProperties(props);
            this.logProperties(props);
            fs.close();
        }
        catch (IOException error) {
            OiiolTextLogger.appendText(error.toString(), OiiolTextLogger.LOG_DETAILED);
        }
        return retVal;
    }

    public static OiicConfigContext getConfigContext() {
        if (s_oiicConfigContext == null) {
            s_oiicConfigContext = new OiicConfigContext();
        }
        return s_oiicConfigContext;
    }

    public static Locale getSystemLocale() {
        return Locale.getDefault();
    }

    public static OiiiVersion getInstallerVersion() {
        return OiicInstVersion.getInstallerVersion();
    }

    public Properties getBackupProps() {
        if (this.m_oBackupProps == null) {
            this.m_oBackupProps = new Properties();
        }
        return this.m_oBackupProps;
    }

    public void resetInstallProps() {
        Properties backup = this.getBackupProps();
        Properties sysProps = System.getProperties();
        Properties dProps = this.getDefaultsOverriden();
        Enumeration<?> propNames = backup.propertyNames();
        while (propNames.hasMoreElements()) {
            String propName = (String)propNames.nextElement();
            String propVal = backup.getProperty(propName);
            if (propVal == "" && (dProps == null || dProps.getProperty(propName) == null)) {
                sysProps.remove(propName);
                continue;
            }
            sysProps.put(propName, propVal);
        }
        backup.clear();
    }

    void addToCommandLineTable(String sVar, String sValue) {
        Map commandLineArgsTable = this.getCommandLineArgs();
        commandLineArgsTable.put(sVar.toLowerCase(), sValue);
    }

    public String getFromCommandLineTable(String sVar) {
        Map commandLineArgsTable = this.getCommandLineArgs();
        return (String)commandLineArgsTable.get(sVar.toLowerCase());
    }

    public boolean isVarInCommandLineTable(String sVar) {
        Map commandLineArgsTable = this.getCommandLineArgs();
        return commandLineArgsTable.containsKey(sVar.toLowerCase());
    }

    protected Properties parseCmdLineEx(String[] args) throws OiicInvalidCmdLineException {
        Properties props = new Properties();
        this.m_oCmdLineOptions = this.setupAppProperties();
        if (null != this.m_oCmdLineOptions) {
            this.initBooleanDefaults(props);
        }
        if (null != args) {
            this.parseCmdLine(args, props);
        }
        return props;
    }

    protected boolean isHelpOptionSpecified() {
        return OiixInstallUtil.isOptionSet(this.getSystemPropertyPrefix() + "help") || OiixInstallUtil.isOptionSet(this.getSystemPropertyPrefix() + "h");
    }

    public void setJREScratchDirectories() {
        if (OiixPlatform.isPlatInGroup(-1, OiixPlatform.getCurrentPlatform())) {
            Properties props = System.getProperties();
            String _SYSTEMPREFS = ".systemPrefs";
            String _JAVA = ".java";
            String _USERPREFS = ".userPrefs";
            String _SYSTEMROOT = "java.util.prefs.systemRoot";
            String _USERROOT = "java.util.prefs.userRoot";
            String _SCRATCHPATH = this.getSystemPropertyPrefix() + "scratchPath";
            String sTempLoc = System.getProperty(_SCRATCHPATH);
            String sSystemPrefs = OiixPathOps.concatPath(sTempLoc, ".systemPrefs");
            String sUserDir = OiixPathOps.concatPath(sTempLoc, ".java");
            sUserDir = OiixPathOps.concatPath(sUserDir, ".userPrefs");
            OiixFileOps.mkdirs(new File(sSystemPrefs));
            OiixFileOps.mkdirs(new File(sUserDir));
            props.setProperty("java.util.prefs.systemRoot", sTempLoc);
            props.setProperty("java.util.prefs.userRoot", sTempLoc);
            this.setSystemProperties(props);
        }
    }

    protected String getAppExecutableName() {
        String sExecutable = null;
        sExecutable = OiixPlatform.isPlatInGroup(-1, OiixPlatform.getCurrentPlatform()) ? OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_HELP_UNIX_EXECUTABLE") : OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_HELP_WINDOWS_EXECUTABLE");
        return sExecutable;
    }

    public void displayBanner() {
        String sProductName = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_OUI_NAME");
        Object[] sArgs = new String[]{OiicInstVersion.getCopyrightCurrentYear()};
        OiiolTextLogger.writeMessageToConsole(sProductName + ", " + OiicInstVersion.getVersionString());
        OiiolTextLogger.writeMessageToConsole("S_BANNER_COPYRIGHT", sArgs);
        OiiolTextLogger.writeMessageToConsole("");
    }

    protected String displayHelp() {
        String sList;
        StringBuffer sb = new StringBuffer("");
        sb.append(OiixResourceBundle.getString("S_HELP_TITLE") + NEW_LINE);
        OiiolTextLogger.writeMessageToConsole("S_HELP_TITLE", null);
        sb.append(this.getAppExecutableName() + " " + OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_HELP_COMPLETE_OPTIONS") + NEW_LINE);
        OiiolTextLogger.writeMessageToConsole(this.getAppExecutableName() + " " + OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_HELP_COMPLETE_OPTIONS"));
        sb.append(OiixResourceBundle.getString("S_HELP_OPTIONS_TITLE") + NEW_LINE);
        OiiolTextLogger.writeMessageToConsole("");
        OiiolTextLogger.writeMessageToConsole("S_HELP_OPTIONS_TITLE", null);
        if (null != this.m_oCmdLineOptions) {
            for (int i = 0; i < this.m_oCmdLineOptions.size(); ++i) {
                OiicCmdLineProperty oCmdOption = (OiicCmdLineProperty)this.m_oCmdLineOptions.get(i);
                String sHelpId = oCmdOption.getHelpId();
                boolean bPublish = oCmdOption.isPublished();
                boolean bDebug = OiixInstallUtil.isOptionSet(this.getSystemPropertyPrefix() + "debug");
                if (!bPublish && (bPublish || !bDebug) || sHelpId == null) continue;
                String sHelpMessage = OiixResourceBundle.getStringFromFullyQualifiedID(sHelpId);
                sb.append(sHelpMessage + NEW_LINE);
                OiiolTextLogger.writeMessageToConsole(sHelpMessage + NEW_LINE);
            }
        }
        if ((sList = System.getProperty("example_ids")) != null) {
            StringTokenizer tokenizer = new StringTokenizer(sList, DELIM);
            while (tokenizer.hasMoreTokens()) {
                String sToken = tokenizer.nextToken();
                sb.append(sToken + NEW_LINE);
                OiiolTextLogger.writeMessageToConsole(sToken, null);
            }
        }
        return sb.toString();
    }

    protected Properties getResourceProperties() throws OiicInvalidCmdLineException {
        Properties props = new Properties();
        ResourceBundle res = null;
        try {
            res = ResourceBundle.getBundle(this.getPropFileName());
        }
        catch (MissingResourceException e) {
            res = null;
        }
        if (res == null) {
            OiicExitCode.setExitCode(-1);
            Object[] args = new String[]{this.getPropFileName()};
            String sErrMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-25009", args);
            args[0] = sErrMsg;
            sErrMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-25008", args);
            throw new OiicInvalidCmdLineException(sErrMsg);
        }
        try {
            Enumeration<String> en = res.getKeys();
            while (en.hasMoreElements()) {
                String propName = en.nextElement();
                props.setProperty(propName, res.getString(propName));
            }
        }
        catch (MissingResourceException me) {
            me.printStackTrace();
        }
        return props;
    }

    protected List setupAppProperties() throws OiicInvalidCmdLineException {
        Properties props = this.getResourceProperties();
        if (null == props || null != props && props.size() <= 0) {
            return null;
        }
        ArrayList oList = new ArrayList(20);
        this.parseProps(props, "StringProps", 0, this.getSystemPropertyPrefix(), oList);
        this.parseProps(props, "BoolProps", 1, this.getSystemPropertyPrefix(), oList);
        this.parseProps(props, "NegBoolProps", 2, this.getSystemPropertyPrefix(), oList);
        this.parseProps(props, "SRVMBoolProps", 3, "oracle.srvm.", oList);
        this.parseProps(props, "SRVMStringProps", 4, "oracle.srvm.", oList);
        Properties defProps = this.getDefaultsOverriden();
        Properties sysProps = System.getProperties();
        Enumeration<?> propNames = props.propertyNames();
        while (propNames.hasMoreElements()) {
            String propName = (String)propNames.nextElement();
            if (sysProps.getProperty(propName) != null) continue;
            String propVal = (String)props.get(propName);
            sysProps.put(propName, propVal);
            defProps.put(propName, propVal);
        }
        return oList;
    }

    private String[] parseProps(Properties props, String sListName, int type, String prefix, List oList) {
        String sList = props.getProperty(sListName);
        if (sList != null) {
            StringTokenizer tokenizer = new StringTokenizer(sList, DELIM);
            int count = tokenizer.countTokens();
            String[] propNames = new String[count];
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                String sOption;
                propNames[i] = sOption = tokenizer.nextToken();
                try {
                    OiicCmdLineProperty cmdProp = new OiicCmdLineProperty(sOption, type);
                    if (props.getProperty(sOption + "_publish") != null) {
                        boolean bPublish = Boolean.valueOf(props.getProperty(sOption + "_publish"));
                        cmdProp.setPublished(bPublish);
                    }
                    cmdProp.setSysPropertyPrefix(prefix);
                    cmdProp.setHelpId(props.getProperty(sOption + "_helpid"));
                    oList.add(cmdProp);
                    props.remove(sListName);
                    props.remove(sOption + "_publish");
                    props.remove(sOption + "_helpid");
                }
                catch (MissingResourceException me) {
                    me.printStackTrace();
                }
            }
            return propNames;
        }
        return null;
    }

    protected String getPropFileName() {
        return this.getAppName() + "_app";
    }

    static String getValForType(int type) {
        String sVal = "";
        switch (type) {
            case 1: 
            case 3: {
                sVal = "true";
                break;
            }
            case 2: {
                sVal = "false";
            }
        }
        return sVal;
    }

    static String getDefValForType(int type) {
        String sVal = null;
        switch (type) {
            case 1: 
            case 3: {
                sVal = "false";
                break;
            }
            case 2: {
                sVal = "true";
                break;
            }
            case 0: 
            case 4: {
                sVal = "";
            }
        }
        return sVal;
    }

    public void logProperties(Properties props) {
        Enumeration<?> propNames = props.propertyNames();
        while (propNames.hasMoreElements()) {
            String propName = (String)propNames.nextElement();
            OiiolTextLogger.appendText("Set " + propName + " to " + props.get(propName));
        }
    }

    protected boolean isResponseFileSpecified() {
        String respFile = System.getProperty("oracle.installer.responseFile");
        return !OiixUtil.isNullOrBlank(respFile, true);
    }

    protected boolean isResponseFileRequired() {
        return OiixInstallUtil.isSilent() && OiixUtil.isEmpty(this.getCommandLineArgs());
    }

    protected void copyLogsToCallingNode(String calledNodeName) {
        if (OiixInstallUtil.isOptionSet("oracle.installer.remoteInvocation") && calledNodeName != null) {
            OiicBaseApp.copyFileToCallingNode(calledNodeName, OiixTeePrintStream.getErrFileLoc());
            OiicBaseApp.copyFileToCallingNode(calledNodeName, OiixTeePrintStream.getOutFileLoc());
            OiicBaseApp.copyFileToCallingNode(calledNodeName, OiiolTextLogger.getCurLogFileName());
        }
    }

    private static void copyFileToCallingNode(String node, String file) {
        try {
            OiipgClusterOps.copyLogsToCallingNode(node, file);
        }
        catch (OiipgRemoteOpsException e) {
            OiiolTextLogger.appendException(e);
        }
    }

    private void computeDefaultOUILoc() {
        String sOUILoc;
        Class<?> oClass = null;
        try {
            oClass = Class.forName("oracle.sysman.oii.oiic.OiicBaseApp");
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
            OiiolTextLogger.appendText("Error occurred while trying to find class oracle/sysman/oii/oiic/OiicBaseApp");
        }
        if (oClass != null && !OiixUtil.isNullOrBlank(sOUILoc = oClass.getProtectionDomain().getCodeSource().getLocation().getPath(), true)) {
            sOUILoc = OiixPathOps.getNativeForm(OiixPathOps.getParentDir(sOUILoc));
            sOUILoc = OiixPathOps.getNativeForm(OiixPathOps.getParentDir(sOUILoc));
            System.setProperty("oracle.installer.oui_loc", sOUILoc);
        }
    }

    static {
        s_oiicConfigContext = null;
        altInstallProps = false;
    }
}

