/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import oracle.sysman.emCfg.client.CfwClient;
import oracle.sysman.emCfg.client.CfwSession;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.common.IActionState;
import oracle.sysman.emCfg.common.IActionStepState;
import oracle.sysman.emCfg.common.IAggregate;
import oracle.sysman.emCfg.common.IMicroStepState;
import oracle.sysman.emCfg.common.IMicroStepStateReference;
import oracle.sysman.emCfg.common.IParameter;
import oracle.sysman.emCfg.common.IParameterReference;
import oracle.sysman.emCfg.common.IPlugInInvocationState;
import oracle.sysman.emCfg.types.ActionType;
import oracle.sysman.emCfg.types.MicroStepStatus;
import oracle.sysman.oii.oiic.OiicInstVersion;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiic.OiicSessionPlan;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbConfigController;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifb.OiifbIConfigActionHandler;
import oracle.sysman.oii.oiif.oiifb.OiifbIRetry;
import oracle.sysman.oii.oiif.oiifb.OiifbWizOperation;
import oracle.sysman.oii.oiif.oiifr.OiifrProgressActionListener;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiis.OiisPreRequisiteVar;
import oracle.sysman.oii.oiis.OiisProdHomeVar;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiix.OiixCFOps;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixProgressListener;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiicAdditionalUtilityWCDE
implements OiifbWizOperation,
OiifbIConfigActionHandler {
    private OiicPullSession m_pullSession;
    private OiicSessionPlan m_sessionPlan;
    private static final String sConfigXMLRltPath = OiiiInstallAreaControl.getConfigXMLDirRltPath();
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 4;
    private String m_addlConfigAggrLoc;
    private String m_addlConfigAggrFilename;
    private CfwClient m_cfwClient;
    private CfwSession m_cfwSession;
    private IAggregate m_aggregate;
    private ActionType m_action;
    private String m_oracleHome;
    private OiifbConfigController m_configController;
    private int m_configExecState;
    private ArrayList m_tools2Perform;
    private ArrayList m_allToolsList;
    private IMicroStepStateReference m_currentTool;
    private String sXMLFilenameForRunConfig;
    private OiicSessionInterfaceManager m_interfaceManager;

    public OiicAdditionalUtilityWCDE(OiicPullSession pullSession) {
        this.m_pullSession = pullSession;
        this.m_sessionPlan = this.m_pullSession.getSessionPlan();
    }

    @Override
    public void initialize() throws OiifbEndIterateException {
        this.m_oracleHome = OiixPathOps.getStandardForm((String)this.m_pullSession.getContext().getVariable("ORACLE_HOME").getValue());
        OiiolTextLogger.appendText("Oracle Home value set as " + this.m_oracleHome, OiiolTextLogger.LOG_TRACE);
    }

    @Override
    public int doOperation(boolean isBack) throws OiifbEndIterateException {
        boolean bCopied;
        if (!Boolean.parseBoolean(System.getProperty("oracle.installer.mandatorySetup", "false"))) {
            OiiolTextLogger.appendText("oracle.installer.mandatorySetup property is set to false, so skipping the execution of additional tools");
            return 0;
        }
        this.saveConfigAggrInfoFromAction();
        if (this.canProceed() && (bCopied = this.copyConfigAggrToOH())) {
            this.createCfwObjects();
            if (null != this.m_aggregate) {
                this.makePlugInList();
                this.passParametersToAggr();
                boolean bRetry = false;
                do {
                    this.m_configExecState = 1;
                    this.execConfigTools(bRetry);
                    if (0 == this.m_configExecState) continue;
                    boolean isAPIMode = System.getProperty("oracle.installer.ouiApiMode", "false").equalsIgnoreCase("true");
                    OiicAdditionalUtilityWCDE oiicAdditionalUtilityWCDE = this;
                    if (oiicAdditionalUtilityWCDE.m_pullSession.isSilentMode() || isAPIMode) {
                        if (System.getProperty("oracle.installer.additionaltool_continue_onerror", "false").compareToIgnoreCase("true") == 0) {
                            bRetry = false;
                            continue;
                        }
                        OiiolTextLogger.writeToLogAndConsole("Error in execution of the additional util config tools");
                        OiiolTextLogger.writeToLogAndConsole("Exiting");
                        this.logRunConfigCmd();
                        throw new OiifbEndIterateException("script failed");
                    }
                    if (System.getProperty("oracle.installer.additionaltool_continue_onerror", "false").compareToIgnoreCase("true") == 0) {
                        bRetry = false;
                    } else {
                        int buttonOps = 0;
                        buttonOps = 0;
                        buttonOps |= 2;
                        bRetry = this.showRetryDialog(buttonOps |= 4, "Error in execution of additional utility tool");
                    }
                    if (bRetry) continue;
                    this.logRunConfigCmd();
                } while (bRetry);
            }
        }
        return 0;
    }

    @Override
    public void dispose() {
        this.disposeCfwObjects();
    }

    @Override
    public void setStatus(String toolname, String oraHomeName, String toplevelName, String compName, String actionName, String stepIdx, String microStepIdx, int status, String details, String sMsg) {
        if (status == 1) {
            this.m_currentTool = this.getTool(toolname, oraHomeName, toplevelName, compName, actionName, stepIdx, microStepIdx);
            this.showStatusTextMsg(OiixResourceBundle.getString("S_ADR_EXECUTING_TOOL", new Object[]{toolname}));
        }
        if (status == 3) {
            this.m_tools2Perform.remove(this.getTool(toolname, oraHomeName, toplevelName, compName, actionName, stepIdx, microStepIdx));
            this.m_currentTool = null;
            this.showStatusTextMsg(OiixResourceBundle.getString("S_ADR_COMPLETED_EXECUTING_TOOL_SUCCESSFULLY", new Object[]{toolname}));
        }
        if (status == 4) {
            this.showStatusTextMsg(OiixResourceBundle.getString("S_ADR_COMPLETED_EXECUTING_TOOL_UNSUCCESSFULLY", new Object[]{toolname}));
        }
    }

    private void logRunConfigCmd() {
        String sRunConfigCmd = OiixCFOps.getRunConfigCommand(this.m_oracleHome, "perform", OiixCFOps.getActionTypeAsStringForRunConfig(), this.sXMLFilenameForRunConfig, true);
        OiiolTextLogger.appendText("The additional tools can be executed again using the following command");
        OiiolTextLogger.appendText(sRunConfigCmd);
    }

    private void showStatusTextMsg(String sMsg) {
        OiixProgressListener listener = this.m_pullSession.getProgressListener();
        if (null != listener) {
            listener.setStatus(sMsg);
        }
    }

    private void saveConfigAggrInfoFromAction() {
        OiicSessionContext oSessionContext = this.m_pullSession.getSessionContext();
        OiisVariable oVar = oSessionContext.getVariable("ADDL_UTIL_CONFIG_TOOL_NAME");
        String progMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CONFIG_AGGREGATES");
        this.m_interfaceManager = OiicSessionInterfaceManager.getInterfaceManager();
        OiifrProgressActionListener progressListener = (OiifrProgressActionListener)this.m_interfaceManager.getProgressListener();
        if (progressListener != null) {
            progressListener.onStartPhase(64);
            progressListener.setStatus(progMessage);
        }
        if (oVar != null) {
            this.m_addlConfigAggrFilename = oVar.getValueAsString();
            OiiolTextLogger.appendText("Aggregate Name as given in the action for additional utility tools: " + this.m_addlConfigAggrFilename);
        } else {
            OiiolTextLogger.appendText("NO Aggregate Name given in the action for additional utility tools");
        }
        oVar = oSessionContext.getVariable("ADDL_UTIL_CONFIG_TOOL_LOC");
        if (oVar != null) {
            this.m_addlConfigAggrLoc = oVar.getValueAsString();
            OiiolTextLogger.appendText("Aggregate Location as given in the action for additional utility tools: " + oVar.getValueAsString());
        } else {
            OiiolTextLogger.appendText("NO Aggregate Location given in the action for additional utility tools");
        }
    }

    private boolean copyConfigAggrToOH() {
        boolean retVal = false;
        String sOraHomeAbsPath = this.m_oracleHome;
        sOraHomeAbsPath = sOraHomeAbsPath.concat(File.separator);
        String sConfigXMLDir = sOraHomeAbsPath.concat(sConfigXMLRltPath);
        OiiolTextLogger.appendText("Location where the Config Agg XML will be copied: " + sOraHomeAbsPath, OiiolTextLogger.LOG_TRACE);
        if (this.m_addlConfigAggrFilename.endsWith(".xml")) {
            this.m_addlConfigAggrFilename = this.m_addlConfigAggrFilename.substring(0, this.m_addlConfigAggrFilename.lastIndexOf(".xml") - 1);
        }
        String sAggrId = this.m_addlConfigAggrFilename;
        String OuiConfigVariablesVersion = OiicInstVersion.getOuiConfigVariablesVersion().getVerString();
        OuiConfigVariablesVersion = OuiConfigVariablesVersion.replace('.', '_');
        this.sXMLFilenameForRunConfig = sAggrId + "." + OuiConfigVariablesVersion + ".xml";
        String sDestFileName = sConfigXMLDir.concat(this.sXMLFilenameForRunConfig);
        OiiolTextLogger.appendText("Destination file name which will be copied to : " + sDestFileName, OiiolTextLogger.LOG_TRACE);
        String srcFileName = this.m_addlConfigAggrLoc.concat(File.separator + sAggrId + ".xml");
        OiiolTextLogger.appendText("Source file name to be copied : " + srcFileName, OiiolTextLogger.LOG_TRACE);
        File f = new File(OiixPathOps.getNativeForm(srcFileName));
        File fdest = new File(OiixPathOps.getNativeForm(sDestFileName));
        if (f.exists()) {
            if (fdest.exists()) {
                OiiolTextLogger.appendText(this.m_addlConfigAggrFilename + " already present, so backing it and its CFM instance files if any");
                try {
                    OiixFileOps.backUpFile(sDestFileName, sDestFileName + ".bak");
                    OiiolTextLogger.appendText("Backed up " + sDestFileName + " to " + sDestFileName + ".bak");
                }
                catch (IOException e) {
                    OiiolTextLogger.appendText(e.getMessage());
                }
                OiixCFOps.backupCFInstanceFiles(sConfigXMLDir, this.m_addlConfigAggrFilename);
            }
            try {
                OiiolTextLogger.appendText("Copying " + OiixPathOps.getNativeForm(srcFileName) + " to " + OiixPathOps.getNativeForm(sDestFileName) + " with the permissions " + OiixCFOps.S_PERMS_FOR_CFW_FILES_TXT);
                OiixFileOps.copyFile(OiixPathOps.getNativeForm(srcFileName), OiixPathOps.getNativeForm(sDestFileName), true, true, false, true, OiixCFOps.S_PERMS_FOR_CFW_FILES_TXT, null, null, null, false);
                retVal = true;
            }
            catch (OiifbCancelException e) {
                OiiolTextLogger.appendText(e.getMessage());
            }
            catch (IOException ioe) {
                OiiolTextLogger.appendText(ioe.getMessage());
            }
        } else {
            OiiolTextLogger.appendText(" Aggr " + srcFileName + " not found to copy to  " + sDestFileName);
        }
        return retVal;
    }

    private boolean canProceed() {
        boolean retVal = false;
        String sFilename = null;
        if (null != this.m_addlConfigAggrFilename && null != this.m_addlConfigAggrLoc) {
            String sTmp = this.m_addlConfigAggrLoc + File.separator + this.m_addlConfigAggrFilename;
            sFilename = sTmp.endsWith(".xml") ? sTmp : this.m_addlConfigAggrLoc + File.separator + this.m_addlConfigAggrFilename + ".xml";
            OiiolTextLogger.appendText("checking if the file " + sFilename + " is present?");
            retVal = new File(sFilename).exists();
        }
        OiiolTextLogger.appendText("Can proceed with additional utility processes ? : " + retVal);
        return retVal;
    }

    private void disposeCfwObjects() {
        if (null != this.m_cfwSession && null != this.m_cfwClient) {
            OiixCFOps.letCFSaveConfigInfo(this.m_cfwSession);
        }
        this.m_cfwSession = null;
        this.m_cfwClient = null;
        this.m_aggregate = null;
        this.m_configController = null;
        this.m_allToolsList = null;
        this.m_tools2Perform = null;
    }

    private void createCfwObjects() {
        List<String> aggregatesToLoad = null;
        String[] TLAggrs = new String[]{this.m_addlConfigAggrFilename};
        aggregatesToLoad = Arrays.asList(TLAggrs);
        String cfgXMLPath = sConfigXMLRltPath;
        cfgXMLPath = OiixPathOps.getNativeForm(cfgXMLPath);
        String sOHLoc = this.m_oracleHome.concat(File.separator);
        OiiolTextLogger.appendText("cf session will be created for OH: " + sOHLoc + " TLAggr: " + this.m_addlConfigAggrFilename + " instancePath: " + cfgXMLPath);
        this.m_cfwClient = OiixCFOps.getCfwClient(false, sOHLoc, cfgXMLPath, cfgXMLPath, aggregatesToLoad);
        if (this.m_cfwClient == null) {
            OiiolTextLogger.appendText("no cf client : execution of plugIns not done", OiiolTextLogger.LOG_WARNING);
        } else {
            this.m_cfwSession = OiixCFOps.getCfwSession(this.m_cfwClient);
            if (null != this.m_cfwSession) {
                this.m_aggregate = OiixCFOps.getAggregate(this.m_cfwSession, this.m_addlConfigAggrFilename);
                this.m_action = OiixCFOps.getActionType();
            } else {
                OiiolTextLogger.appendText("no cf session : execution of plugIns not done", OiiolTextLogger.LOG_WARNING);
            }
        }
    }

    private void execConfigTools(boolean bRetry) {
        if (null != this.m_aggregate) {
            if (null == this.m_configController) {
                this.m_configController = new OiifbConfigController();
                this.m_configController.initializeForAdditionalUtilityExecution(true, this.m_aggregate, this.m_cfwSession, this.m_pullSession);
                this.m_configController.registerConfigActionHandler(this);
            }
            OiiolTextLogger.appendText(OiixResourceBundle.getString("S_ADR_TOOLS_EXECUTION_BEGIN"));
            this.m_configExecState = this.m_configController.launchConfigToolsForAdditionalUtilityExecution(this.m_action, bRetry, this.m_tools2Perform.toArray(new IMicroStepStateReference[this.m_tools2Perform.size()]));
            OiiolTextLogger.appendText(OiixResourceBundle.getString("S_ADR_TOOLS_EXECUTION_END"));
        } else {
            OiiolTextLogger.appendText("no cf aggregate : execution of plugIns not done", OiiolTextLogger.LOG_WARNING);
        }
    }

    private boolean showRetryDialog(int buttonOps, String prompt) throws OiifbEndIterateException {
        int userInput = 0;
        boolean retry = false;
        try {
            OiifbIRetry actionDlg = OiicSessionInterfaceManager.getInterfaceManager().getRetryHandler(prompt, buttonOps, 1);
            userInput = actionDlg.doModal();
            actionDlg = null;
            Thread.yield();
        }
        catch (Exception e) {
            OiiolTextLogger.appendException(e);
        }
        switch (userInput) {
            case 2: {
                retry = true;
                break;
            }
            case 4: {
                retry = false;
                break;
            }
            case 32: {
                throw new OiifbEndIterateException(prompt);
            }
            case 16: {
                throw new OiifbEndIterateException(prompt);
            }
        }
        return retry;
    }

    private void makePlugInList() {
        IMicroStepStateReference[] toolsList = null;
        OiicAdditionalUtilityWCDE oiicAdditionalUtilityWCDE = this;
        boolean bSilent = oiicAdditionalUtilityWCDE.m_pullSession.isSilentMode();
        boolean bNotRetry = false;
        boolean bSkipDetached = true;
        boolean bRecommended = false;
        try {
            toolsList = this.m_aggregate.listTools(bRecommended, bSilent, bNotRetry, bSkipDetached, this.m_action);
            if (null != toolsList) {
                OiiolTextLogger.appendText("No of  Tools: " + toolsList.length);
                this.m_allToolsList = new ArrayList<IMicroStepStateReference>(Arrays.asList(toolsList));
                this.m_tools2Perform = new ArrayList();
                this.m_tools2Perform.addAll(this.m_allToolsList);
            }
        }
        catch (CfwException ce) {
            OiiolTextLogger.appendText(ce.getMessage());
        }
    }

    private void passParametersToAggr() {
        OiicSessionContext ssnContext = this.m_pullSession.getSessionContext();
        IAggregate cfwAggr = this.m_aggregate;
        if (cfwAggr != null) {
            IParameterReference[] paramRef = null;
            try {
                paramRef = cfwAggr.getParameterReferences();
            }
            catch (CfwException exc) {
                OiiolTextLogger.appendText(exc.getMessage());
            }
            if (paramRef != null) {
                HashMap<String, IParameter> ssnVarsHashMap = new HashMap<String, IParameter>(paramRef.length);
                for (int i = 0; i < paramRef.length; ++i) {
                    IParameter param = OiixCFOps.getParameter(cfwAggr, paramRef[i]);
                    ssnVarsHashMap.put(paramRef[i].getSelfID(), param);
                }
                this.handlePassParameters(ssnContext.getAllVariables(), ssnVarsHashMap);
            }
        }
    }

    private void handlePassParameters(Enumeration varEnum, HashMap ssnVarsHashMap) {
        Enumeration e = varEnum;
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            OiisVariable v = (OiisVariable)obj;
            IParameter p = null;
            p = (IParameter)ssnVarsHashMap.get(v.getName());
            if (p == null || v.getValue() == null) continue;
            if (obj instanceof OiisProdHomeVar) {
                OiixCFOps.passParameter(p, v.getValue(), 1);
                continue;
            }
            if (obj instanceof OiisPreRequisiteVar) {
                OiixCFOps.passParameter(p, v.getValue(), 3);
                continue;
            }
            if (!(obj instanceof OiisVariable)) continue;
            OiixCFOps.passParameter(p, v.getValue(), v.getType());
        }
    }

    private IMicroStepStateReference getTool(String toolname, String oraHomeName, String toplevelName, String compName, String actionName, String stepIdx, String microStepId) {
        IMicroStepStateReference selectedTool = null;
        if (null != this.m_tools2Perform) {
            Iterator itr = this.m_tools2Perform.iterator();
            while (itr.hasNext()) {
                try {
                    IMicroStepStateReference tool = (IMicroStepStateReference)itr.next();
                    IMicroStepState state = this.m_cfwSession.getMicroStepState(tool);
                    MicroStepStatus microStatus = (MicroStepStatus)state.getStatus();
                    IPlugInInvocationState pState = state.getPlugInInvocationState();
                    IActionStepState aState = state.getActionStepState();
                    IActionState actState = state.getActionState();
                    String stoolName = state.getPlugInID();
                    String soraHome = actState.getOriginator().getOracleHome();
                    String stopLevelName = this.m_aggregate.getSelfID();
                    String scompName = actState.getOriginator().getSelfID();
                    String sactionName = tool.getActionID();
                    String sstepIdx = Integer.toString(tool.getStepIndex());
                    String smstepIdx = Integer.toString(tool.getMicroStepIndex());
                    if (!toolname.equals(stoolName) || !oraHomeName.equals(soraHome) || !compName.equals(scompName) || !actionName.equals(sactionName) || !stepIdx.equals(sstepIdx) || !microStepId.equals(smstepIdx)) continue;
                    selectedTool = tool;
                    break;
                }
                catch (Exception e) {
                    OiiolTextLogger.appendText(e.getMessage());
                }
            }
        }
        return selectedTool;
    }
}

