/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicAddNodeSession;
import oracle.sysman.oii.oiic.OiicInstallTimeSession;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiic.OiicSessionPlan;
import oracle.sysman.oii.oiic.OiicSummaryInformation;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgCFSDriveCheck;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterOps;
import oracle.sysman.oii.oiip.oiipg.OiipgRemoteOpsException;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiix.OiixPathOps;

public class OiicAddNodeSummaryInformation
extends OiicSummaryInformation {
    private OiicInstallTimeSession m_instTimeSession = null;
    private OiicSessionPlan m_sessionPlan = null;
    private OiicSessionContext oContext = null;
    private String m_sSourceHomeValue = null;
    private String[] m_slClusterNewNodes = null;
    private String[] m_slClusterNodeNames = null;
    private ArrayList m_lInstalledComponents = new ArrayList();
    private boolean m_bCRSHome = false;
    private long m_lTotalBytes = 0L;
    private HashMap m_mVolumesLocal = new HashMap();
    private HashMap m_mVolumesRemote = new HashMap();
    private String[] m_slVolumesRemoteSpaceInvalid = null;

    public OiicAddNodeSummaryInformation(OiicInstallTimeSession oSession) {
        super(oSession);
        this.initializeAddNodeSession(oSession);
    }

    @Override
    public boolean displayClusterSpace() {
        return false;
    }

    @Override
    public boolean isVolumeOnCFS(String volumeName) {
        OiipgCFSDriveCheck cfsDriveCheck = OiipgCFSDriveCheck.getCFSDriveChecker();
        boolean bCFS = cfsDriveCheck.isDriveOnCFS(volumeName);
        return bCFS;
    }

    @Override
    public List getComponentsForDowngrade() {
        return null;
    }

    @Override
    public List getComponentsForInstall() {
        return null;
    }

    @Override
    public List getComponentsForReinstall() {
        return null;
    }

    @Override
    public List getComponentsForUpgrade() {
        return null;
    }

    @Override
    public String[] getRemoteNodeNames() {
        return null;
    }

    @Override
    public Map getVolumeDetailsLocal() {
        return this.m_mVolumesLocal;
    }

    public Map getVolumeDetailsRemote() {
        return this.m_mVolumesRemote;
    }

    @Override
    public Map getVolumeDetailsRemote(String sRemoteNodes) {
        return null;
    }

    public String[] getRemoteVolumeDetails(String sRemoteNodeName) {
        String[] volDetails = null;
        if (null != sRemoteNodeName) {
            volDetails = (String[])this.m_mVolumesRemote.get(sRemoteNodeName);
        }
        return volDetails;
    }

    @Override
    public boolean allVolsShared() {
        return false;
    }

    public String[] getClusterNodeNames() {
        return this.m_slClusterNodeNames;
    }

    public String[] getNewClusterNodes() {
        return this.m_slClusterNewNodes;
    }

    public String[] getClusterNodeNamesWithInsufficientSpace() {
        return this.m_slVolumesRemoteSpaceInvalid;
    }

    public List getInstalledComponents() {
        return this.m_lInstalledComponents;
    }

    public String getSourceHomeLocation() {
        return this.m_sSourceHomeValue;
    }

    public boolean isCRSHome() {
        return this.m_bCRSHome;
    }

    private void initializeAddNodeSession(OiicInstallTimeSession instTimeSession) {
        this.m_instTimeSession = instTimeSession;
        this.m_sessionPlan = this.m_instTimeSession.getSessionPlan();
        this.oContext = this.m_instTimeSession.getSessionContext();
        if (this.m_instTimeSession instanceof OiicAddNodeSession && this.m_instTimeSession.isAddNodeMode()) {
            this.computeGlobalInfo();
            if (null != this.m_sSourceHomeValue) {
                this.computeComponentsInfo();
                this.computeSpaceInfo();
            }
        }
    }

    private void computeGlobalInfo() {
        OiiiOracleHomeInfo oInfo;
        OiisVariable oClusterNodes;
        OiisVariable oNewNodes;
        OiisVariable oSource = this.oContext.getVariable("ORACLE_HOME");
        if (null != oSource) {
            this.m_sSourceHomeValue = (String)oSource.getValue();
        }
        if (null != (oNewNodes = this.oContext.getVariable("CLUSTER_NEW_NODES"))) {
            this.m_slClusterNewNodes = (String[])oNewNodes.getValue();
        }
        if (null != (oClusterNodes = this.oContext.getVariable("CLUSTER_NODES"))) {
            this.m_slClusterNodeNames = (String[])oClusterNodes.getValue();
        }
        if (null != this.m_sSourceHomeValue && (oInfo = ((OiicPullSession)this.m_instTimeSession).getInstallAreaControl().getInstallInventory().getHomeWithLocation(this.m_sSourceHomeValue)) != null && oInfo.isCRSHome()) {
            this.m_bCRSHome = true;
        }
    }

    private void computeSpaceInfo() {
        boolean bCFS = false;
        File oHome = new File(this.m_sSourceHomeValue);
        String sVolume = "";
        if (null != oHome && oHome.exists()) {
            sVolume = oHome.getAbsolutePath();
            OiiolTextLogger.appendText("### \t\t\t The specified OH is present : " + sVolume);
        } else {
            OiiolTextLogger.appendText("### \t\t\t The specified Oracle Home directory doesn't exists. Hence considering the parent directory of the oracle home");
            sVolume = oHome.getParent();
        }
        OiiolTextLogger.appendText("### \t\t\t The Directory to be checked is : " + sVolume);
        long reqSpace = this.getDiskSpaceOccupied(this.m_sSourceHomeValue);
        String sReqSpace = OiixPathOps.getDiskSpaceString(reqSpace, 1);
        String[] localVolInfo = new String[]{"", sReqSpace};
        this.m_mVolumesLocal.put(this.m_sSourceHomeValue, localVolInfo);
        String[] nodeMsgArr = this.getNewClusterNodes();
        bCFS = this.isVolumeOnCFS(sVolume);
        if (!bCFS) {
            long lAvailSpaceCluster = 0L;
            String sAvailSpaceCluster = null;
            Vector<String> vVolsWithInsufficientSpace = new Vector<String>();
            for (int i = 0; i < nodeMsgArr.length; ++i) {
                try {
                    lAvailSpaceCluster = OiipgClusterOps.getFreeSpaceOnNode(nodeMsgArr[i], sVolume);
                    lAvailSpaceCluster *= 1000L;
                }
                catch (OiipgRemoteOpsException ce) {
                    OiiolTextLogger.appendException(ce);
                }
                sAvailSpaceCluster = OiixPathOps.getDiskSpaceString(lAvailSpaceCluster, 1);
                String[] clusterobj = new String[]{sAvailSpaceCluster, sReqSpace};
                this.m_mVolumesRemote.put(nodeMsgArr[i], clusterobj);
                if (reqSpace <= lAvailSpaceCluster) continue;
                vVolsWithInsufficientSpace.addElement(nodeMsgArr[i]);
            }
            if (vVolsWithInsufficientSpace.size() > 0) {
                this.m_slVolumesRemoteSpaceInvalid = vVolsWithInsufficientSpace.toArray(new String[vVolsWithInsufficientSpace.size()]);
            }
        }
    }

    private void computeComponentsInfo() {
        OiiiOracleHomeInfo oInfo;
        OiiiInstallAreaControl oAreaControl = OiiiInstallAreaControl.getInstallAreaControl();
        OiiiInstallInventory oInventory = oAreaControl.getInstallInventory();
        int homeIndex = 0;
        if (oInventory != null && null != (oInfo = oInventory.getHomeWithLocation(this.m_sSourceHomeValue))) {
            homeIndex = oInfo.getIndex();
            Enumeration enumComps = oInventory.getAllComps(homeIndex);
            while (enumComps.hasMoreElements()) {
                OiiiInstallCompInvEntry icie = (OiiiInstallCompInvEntry)enumComps.nextElement();
                this.m_lInstalledComponents.add(icie);
            }
        }
    }

    private long getDiskSpaceOccupied(String path) {
        String[] dirContents;
        File fPath = new File(path);
        if (fPath.isDirectory() && (dirContents = fPath.list()) != null) {
            for (int i = 0; i < dirContents.length; ++i) {
                dirContents[i] = path + File.separatorChar + dirContents[i];
                File content = new File(dirContents[i]);
                if (content.isDirectory()) {
                    this.getDiskSpaceOccupied(dirContents[i]);
                    continue;
                }
                this.m_lTotalBytes += content.length();
            }
        }
        return this.m_lTotalBytes;
    }
}

