/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicAPIInstaller;
import oracle.sysman.oii.oiic.OiicAPISessionInterfaceManager;
import oracle.sysman.oii.oiic.OiicAddNodeSession;
import oracle.sysman.oii.oiic.OiicAddNodeSummaryInformation;
import oracle.sysman.oii.oiic.OiicIOUIAPISession;
import oracle.sysman.oii.oiic.OiicISession;
import oracle.sysman.oii.oiic.OiicIllegalStateException;
import oracle.sysman.oii.oiic.OiicInstAccessSetupWCCE;
import oracle.sysman.oii.oiic.OiicInstallAPIException;
import oracle.sysman.oii.oiic.OiicInstallCancelHandler;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiic.OiicSummaryInformation;
import oracle.sysman.oii.oiif.oiifb.OiifbCondIterator;
import oracle.sysman.oii.oiif.oiifb.OiifbCondWizOperation;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifb.OiifbIRetry;
import oracle.sysman.oii.oiif.oiifb.OiifbLinearIterator;
import oracle.sysman.oii.oiif.oiifb.OiifbSyncObject;
import oracle.sysman.oii.oiif.oiifb.OiifbWizOperation;
import oracle.sysman.oii.oiif.oiifm.OiifmAlertHandler;
import oracle.sysman.oii.oiif.oiifm.OiifmDiskChangeHandler;
import oracle.sysman.oii.oiif.oiifm.OiifmIRootShInfo;
import oracle.sysman.oii.oiif.oiifr.OiifrProgressActionListener;
import oracle.sysman.oii.oiif.oiifw.OiifwActionsPhaseWCDE;
import oracle.sysman.oii.oiif.oiifw.OiifwAddNodePhaseWCDE;
import oracle.sysman.oii.oiif.oiifw.OiifwAddNodeSummaryWCDE;
import oracle.sysman.oii.oiif.oiifw.OiifwAddNodeWCDE;
import oracle.sysman.oii.oiif.oiifw.OiifwCloneDepCalcWCCE;
import oracle.sysman.oii.oiif.oiifw.OiifwClusterChecksWCCE;
import oracle.sysman.oii.oiif.oiifw.OiifwClusterHostNameCheckWCCE;
import oracle.sysman.oii.oiif.oiifw.OiifwInstEndSessionWCDE;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixProgressListener;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiicAddNodeAPISession
extends OiicAddNodeSession
implements OiicIOUIAPISession {
    private static OiicAPISessionInterfaceManager im = (OiicAPISessionInterfaceManager)OiicSessionInterfaceManager.getInterfaceManager();
    public static final int CLUSTER_CHECK_IND = 1;
    public static final int HOSTNAME_CHECK_IND = 2;
    public static final int ACCESS_SETUP = 3;
    public static final int CLONE_DEP_IND = 4;
    public static final int INST_SUMMARY_IND = 5;
    public static final int ADDNODE_PROGRESS_IND = 6;
    private OiifmIRootShInfo[] m_oRootShList;
    private OiifrProgressActionListener m_oInstallProgressListener;
    private OiixProgressListener m_oIntwProgressListener;
    private OiicAddNodeSummaryInformation m_oSummaryInfo;
    private OiifbSyncObject m_syncObj = null;
    private OiicActionsThread m_oActionsThread = null;

    public OiicAddNodeAPISession(OiicAPIInstaller install, boolean silentMode) throws OiifbEndIterateException {
        super(null, silentMode);
    }

    public OiicAddNodeAPISession(OiicAPIInstaller install) throws OiifbEndIterateException {
        this(install, false);
    }

    @Override
    public Vector getIterElements() {
        Vector<OiifbWizOperation> iterEls = new Vector<OiifbWizOperation>();
        OiifwAddNodeWCDE addNode = new OiifwAddNodeWCDE(this.m_sessionContext, 1);
        iterEls.addElement(addNode);
        OiifwClusterChecksWCCE clsCheck = new OiifwClusterChecksWCCE(this.m_sessionContext, 2);
        iterEls.addElement(clsCheck);
        OiifwClusterHostNameCheckWCCE hostCheck = new OiifwClusterHostNameCheckWCCE(this.m_sessionContext, 3);
        iterEls.addElement(hostCheck);
        OiicInstAccessSetupWCCE setupAccess = new OiicInstAccessSetupWCCE(this.m_sessionContext, 4);
        iterEls.addElement(setupAccess);
        OiifwCloneDepCalcWCCE depCalc = new OiifwCloneDepCalcWCCE(this.m_sessionContext, 5);
        iterEls.addElement(depCalc);
        OiifwAddNodeSummaryWCDE summary = new OiifwAddNodeSummaryWCDE(this.m_sessionContext, -1);
        iterEls.addElement(summary);
        boolean isGenSilentLogs = System.getProperty("oracle.installer.silentLogs", "false").equalsIgnoreCase("true");
        if (isGenSilentLogs) {
            iterEls.addElement(new OiifwInstEndSessionWCDE(this.m_sessionContext, null, null, null, false));
        }
        return iterEls;
    }

    @Override
    public void setInterviewProgressListener(OiixProgressListener listener) {
        this.m_oIntwProgressListener = listener;
        im.setProgressListener(listener);
    }

    @Override
    public void setInstallProgresListener(OiifrProgressActionListener listener) {
        this.m_oInstallProgressListener = listener;
        im.setProgressListener(listener);
    }

    @Override
    public OiicSummaryInformation getSessionSummary() {
        return this.m_oSummaryInfo;
    }

    @Override
    public OiifrProgressActionListener getInstallProgressListener() {
        return this.m_oInstallProgressListener;
    }

    @Override
    public OiixProgressListener getInterviewProgressListener() {
        return this.m_oIntwProgressListener;
    }

    @Override
    public String getFromLocation() {
        return null;
    }

    @Override
    public void addInstallCancelHandler(OiicInstallCancelHandler oCancelHandler) {
        im.setInstallCancelHandler(oCancelHandler);
    }

    @Override
    public void addDiskChangeHandler(OiifmDiskChangeHandler oDiskHandler) {
        im.setDiskChangeHandler(oDiskHandler);
    }

    @Override
    public void addAlertHandler(OiifmAlertHandler oAlertHandler) {
        im.setAlertHandler(oAlertHandler);
    }

    @Override
    public void addRetryHandler(OiifbIRetry oRetryHandler) {
        im.setRetryHandler(oRetryHandler);
    }

    public void prepareForInstallOperations() throws OiicInstallAPIException, OiicIllegalStateException {
        try {
            OiiolTextLogger.appendText("Do the iterator execution till Summary");
            this.doOperationsTillSummary();
            this.m_oSummaryInfo = new OiicAddNodeSummaryInformation(this);
        }
        catch (OiifbEndIterateException e) {
            throw new OiicInstallAPIException(e.getLocalizedMessage());
        }
    }

    public int doAddNodeOperation(boolean back) throws OiifbEndIterateException {
        OiiolTextLogger.appendText("Does the pre installation setup");
        this.m_syncObj = new OiifbSyncObject();
        this.m_oActionsThread = new OiicActionsThread();
        this.m_oActionsThread.start();
        if (!this.m_syncObj.signalHappenedBeforeSync()) {
            this.m_syncObj.sync();
        }
        if (null != this.m_oActionsThread && null != this.m_oActionsThread.getException()) {
            throw new OiifbEndIterateException(this.m_oActionsThread.getException());
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelOperation() {
        OiifwActionsPhaseWCDE m_installStatus = this.getActionsPhaseWCDE();
        if (null != m_installStatus) {
            Object object = m_installStatus.getSynchObject();
            synchronized (object) {
                OiicSessionInterfaceManager.getInterfaceManager().getProgressListener();
                m_installStatus.setInstallInterrupted(true);
                String msg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_USER_CANCEL_INS");
                m_installStatus.setInterruptedException(new OiifbEndIterateException(msg));
                m_installStatus.setSessionCancelled(true);
                this.setSuccessfullInstallation(false);
                m_installStatus.getProgressControl().confirmCancel(new Boolean(true));
            }
        }
    }

    public void suspend() {
        if (null != this.getActionsPhaseWCDE()) {
            this.getActionsPhaseWCDE().getProgressControl().suspend();
            OiixProgressListener listener = im.getProgressListener();
            if (listener instanceof OiifrProgressActionListener) {
                ((OiifrProgressActionListener)listener).onSuspend();
            }
        }
    }

    public void resume() {
        if (null != this.getActionsPhaseWCDE()) {
            this.getActionsPhaseWCDE().getProgressControl().resume();
            OiixProgressListener listener = im.getProgressListener();
            if (listener instanceof OiifrProgressActionListener) {
                ((OiifrProgressActionListener)listener).onResume();
            }
        }
    }

    @Override
    public OiicISession getISession() {
        return this;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.m_oInstallProgressListener = null;
        this.m_oIntwProgressListener = null;
        this.m_syncObj = null;
        this.m_oSummaryInfo = null;
        this.m_oActionsThread = null;
        OiicAPIInstaller.getHandleToAPIInstaller().disposeSession();
    }

    private void doOperationsTillSummary() throws OiifbEndIterateException {
        this.doOperation(false);
    }

    private Vector getIterElementsForAddNodeExecution() {
        Vector<OiifbWizOperation> iterEls = new Vector<OiifbWizOperation>();
        OiifwAddNodePhaseWCDE addnodeWCDE = new OiifwAddNodePhaseWCDE(this.m_sessionContext);
        iterEls.addElement(addnodeWCDE);
        OiicAPISelCompsInstall m_selCompsInstall = new OiicAPISelCompsInstall(this, -1, false);
        OiiolTextLogger.appendText("Adding the iterator " + m_selCompsInstall.getClass().getName());
        iterEls.addElement(m_selCompsInstall);
        return iterEls;
    }

    private void doAddNodeAction(boolean bBack) throws OiifbEndIterateException {
        if (!bBack) {
            try {
                this.m_iter = new OiifbCondIterator(this.getIterElementsForAddNodeExecution(), bBack);
                this.m_iter.iterate(bBack);
            }
            catch (OiifbEndIterateException e) {
                OiiolTextLogger.appendText(e.getMessage());
            }
        }
    }

    public void setRootSHInfo(List rootShList) {
        if (null != rootShList && rootShList.size() > 0) {
            int iSize = rootShList.size();
            this.m_oRootShList = new OiifmIRootShInfo[iSize];
            int i = 0;
            Iterator itr = rootShList.iterator();
            while (itr.hasNext()) {
                this.m_oRootShList[i] = (OiifmIRootShInfo)itr.next();
                ++i;
            }
        }
    }

    @Override
    public OiifmIRootShInfo[] getRootShInfo() {
        return this.m_oRootShList;
    }

    class OiicAPISelCompsInstall
    implements OiifbCondWizOperation {
        private OiicAddNodeSession m_instSession = null;
        private OiifbLinearIterator m_postInstallIter = null;
        private int m_nextInd = -1;

        public OiicAPISelCompsInstall(OiicAddNodeSession instSession, int nextInd, boolean bTillSummary) {
            this.m_instSession = instSession;
            this.m_nextInd = nextInd;
        }

        public OiicAddNodeSession getInstSession() {
            return this.m_instSession;
        }

        @Override
        public void initialize() throws OiifbEndIterateException {
            this.m_postInstallIter = new OiifbLinearIterator(true);
        }

        @Override
        public int doOperation(boolean back) throws OiifbEndIterateException {
            this.addPostInstallEls(this.m_postInstallIter);
            return this.m_postInstallIter.iterate(back);
        }

        private void addPostInstallEls(OiifbLinearIterator iter) {
            boolean isGenSilentLogs = System.getProperty("oracle.installer.silentLogs", "false").equalsIgnoreCase("true");
            if (isGenSilentLogs) {
                iter.addElement(new OiifwInstEndSessionWCDE(this.getInstSession().getContext(), null, null, null, false));
            }
        }

        @Override
        public void dispose() {
            if (this.m_postInstallIter != null) {
                this.m_postInstallIter.dispose();
                this.m_postInstallIter = null;
            }
            this.m_instSession = null;
        }

        public void finalize() {
            this.dispose();
        }

        @Override
        public String getName() {
            return this.getClass().getName();
        }

        @Override
        public int getNext() {
            return this.m_nextInd;
        }
    }

    private class OiicActionsThread
    extends Thread {
        Exception installException;

        public OiicActionsThread() {
            super("AddNode API Thread");
            this.installException = null;
        }

        public Exception getException() {
            return this.installException;
        }

        @Override
        public void run() {
            try {
                OiicAddNodeAPISession.this.doAddNodeAction(false);
            }
            catch (OiifbEndIterateException e) {
                this.installException = e;
            }
            if (OiicAddNodeAPISession.this.m_syncObj != null) {
                OiicAddNodeAPISession.this.m_syncObj.signal();
            }
        }
    }
}

