/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import oracle.sysman.oii.oiic.OiicIOUIAPISession;
import oracle.sysman.oii.oiic.OiicInstallCancelHandler;
import oracle.sysman.oii.oiic.OiicSilentInstallPhaseProgressListener;
import oracle.sysman.oii.oiic.OiicSilentInterfaceManager;
import oracle.sysman.oii.oiif.oiifb.OiifbIRetry;
import oracle.sysman.oii.oiif.oiifm.OiifmAlertHandler;
import oracle.sysman.oii.oiif.oiifm.OiifmDiskChangeHandler;
import oracle.sysman.oii.oiif.oiifw.OiifwActionsPhaseWCDE;
import oracle.sysman.oii.oiif.oiifw.OiifwAddNodePhaseWCDE;
import oracle.sysman.oii.oiii.OiiiDiskNotFoundException;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixProgressListener;

public class OiicAPISessionInterfaceManager
extends OiicSilentInterfaceManager {
    private OiixProgressListener m_oProgressListener;
    private OiicInstallCancelHandler m_oInstallCnclHandler;
    private OiifmDiskChangeHandler m_oDiskChangeHandler;
    private OiifmAlertHandler m_oAlertHandler;
    private OiifbIRetry m_oRetryHandler;

    @Override
    public OiixProgressListener getProgressListener() {
        return this.m_oProgressListener;
    }

    @Override
    public void setupInstallProgress(OiifwActionsPhaseWCDE installStatus, int phases, int lastPhase) {
        OiicIOUIAPISession session = (OiicIOUIAPISession)((Object)this.getSession());
        if (null != session && null != session.getInstallProgressListener()) {
            this.setProgressListener(session.getInstallProgressListener());
        } else {
            this.setProgressListener(new OiicSilentInstallPhaseProgressListener(true, phases, lastPhase));
        }
    }

    @Override
    public void setProgressListener(OiixProgressListener listener) {
        this.m_oProgressListener = listener;
    }

    @Override
    public OiicInstallCancelHandler getInstallCancelHandler(int flags, String msg, int type) {
        CustomCancelHandler oCnclHdlr = new CustomCancelHandler(msg, this.m_oInstallCnclHandler);
        return oCnclHdlr;
    }

    @Override
    public void setupAddNodeProgress(OiifwAddNodePhaseWCDE addNodeStatus, int phases, int lastPhase) {
        this.setProgressListener(this.getProgressListener());
    }

    public void setInstallCancelHandler(OiicInstallCancelHandler oHandler) {
        this.m_oInstallCnclHandler = oHandler;
    }

    public void setAlertHandler(OiifmAlertHandler oHandler) {
        this.m_oAlertHandler = oHandler;
    }

    public void setDiskChangeHandler(OiifmDiskChangeHandler oHandler) {
        this.m_oDiskChangeHandler = oHandler;
    }

    public void setRetryHandler(OiifbIRetry oHandler) {
        this.m_oRetryHandler = oHandler;
    }

    @Override
    public String getDiskLocation(String sDefaultLoc, String label, int nDiskNumber) throws OiiiDiskNotFoundException {
        String sResult = null;
        if (null != this.m_oDiskChangeHandler) {
            sResult = this.m_oDiskChangeHandler.getDiskLocation(sDefaultLoc, label, nDiskNumber);
        } else {
            OiiolTextLogger.appendText("No Disk change handler registered. Calling super class method to have the default handling mechanism");
            sResult = super.getDiskLocation(sDefaultLoc, label, nDiskNumber);
        }
        return sResult;
    }

    @Override
    public int displayAlert(String title, String msg, int alertType, int userChoices, int defaultChoice, int severity, boolean bSelectable) {
        int iResult = -1;
        if (null != this.m_oAlertHandler) {
            iResult = this.m_oAlertHandler.displayAlert(title, msg, alertType, userChoices, defaultChoice, severity, bSelectable);
        } else {
            OiiolTextLogger.appendText("Alert Handler not registered, using Super class functionality");
            iResult = super.displayAlert(title, msg, alertType, userChoices, defaultChoice, severity, bSelectable);
        }
        return iResult;
    }

    @Override
    public int displayAlert(String title, String msg, int alertType, int userChoices, int defaultChoice, int severity) {
        int iResult = -1;
        if (null != this.m_oAlertHandler) {
            iResult = this.m_oAlertHandler.displayAlert(title, msg, alertType, userChoices, defaultChoice, severity);
        } else {
            OiiolTextLogger.appendText("Alert Handler not registered, using Super class functionality");
            iResult = super.displayAlert(title, msg, alertType, userChoices, defaultChoice, severity);
        }
        return iResult;
    }

    @Override
    public OiifbIRetry getRetryHandler(String msg, int flags, int type) {
        if (null != this.m_oRetryHandler) {
            CustomRetryHandler customHandler = new CustomRetryHandler(msg, flags, type, this.m_oRetryHandler);
            return customHandler;
        }
        OiiolTextLogger.appendText("Retry Handler not registered, using Super class functionality");
        return super.getRetryHandler(msg, flags, type);
    }

    @Override
    public OiifbIRetry getRetryHandler(String title, String msg, int flags, int type, boolean bCancel) {
        if (null != this.m_oRetryHandler) {
            CustomRetryHandler customHandler = new CustomRetryHandler(msg, flags, type, this.m_oRetryHandler);
            return customHandler;
        }
        OiiolTextLogger.appendText("Retry Handler not registered, using Super class functionality");
        return super.getRetryHandler(title, msg, flags, type, bCancel);
    }

    @Override
    public void logMessage(String sMessage) {
        OiiolTextLogger.appendText(sMessage);
    }

    class CustomCancelHandler
    implements OiicInstallCancelHandler {
        private String m_msg;
        private OiicInstallCancelHandler m_oInstallCancelHandler;

        public CustomCancelHandler(String msg, OiicInstallCancelHandler oCancelHandler) {
            this.m_msg = null == msg ? "" : msg;
            this.m_oInstallCancelHandler = oCancelHandler;
        }

        @Override
        public int doCancelOperation() {
            if (null != this.m_oInstallCancelHandler) {
                if (null != this.m_msg) {
                    return this.doCancelOperation(this.m_msg);
                }
                return this.m_oInstallCancelHandler.doCancelOperation();
            }
            return 2;
        }

        @Override
        public int doCancelOperation(String sMsg) {
            if (null != this.m_oInstallCancelHandler) {
                return this.m_oInstallCancelHandler.doCancelOperation(sMsg);
            }
            return 2;
        }

        @Override
        public int doCancelOperation(boolean isExit) {
            return this.doCancelOperation();
        }

        @Override
        public void dispose() {
            if (null != this.m_oInstallCancelHandler) {
                this.m_oInstallCancelHandler.dispose();
            }
        }
    }

    class CustomRetryHandler
    implements OiifbIRetry {
        private String m_sMsg;
        private int m_type = -1;
        private int m_flags = -1;
        private OiifbIRetry m_oUserRetryHandler;

        public CustomRetryHandler(String sMsg, int flags, int type, OiifbIRetry oUserRetryHdlr) {
            this.m_sMsg = sMsg;
            this.m_type = type;
            this.m_flags = flags;
            this.m_oUserRetryHandler = oUserRetryHdlr;
        }

        @Override
        public void setEnableCancel(boolean bFlag) {
            if (null != this.m_oUserRetryHandler) {
                this.m_oUserRetryHandler.setEnableCancel(bFlag);
            }
        }

        @Override
        public int doModal() {
            if (null != this.m_oUserRetryHandler) {
                if (null != this.m_sMsg && this.m_flags == -1 && this.m_type == -1) {
                    return this.doModal(this.m_sMsg);
                }
                if (null != this.m_sMsg && this.m_flags != -1 && this.m_type != -1) {
                    return this.doModal(this.m_sMsg, this.m_flags, this.m_type);
                }
                return this.m_oUserRetryHandler.doModal();
            }
            return 16;
        }

        @Override
        public int doModal(String sMsg, int flags, int type) {
            if (null != this.m_oUserRetryHandler) {
                return this.m_oUserRetryHandler.doModal(sMsg, flags, type);
            }
            return 16;
        }

        @Override
        public int doModal(String sMsg) {
            if (null != this.m_oUserRetryHandler) {
                return this.m_oUserRetryHandler.doModal(sMsg);
            }
            return 16;
        }
    }
}

