/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Formatter;
import java.util.logging.Level;
import oracle.sysman.oii.oiic.OiicAPISessionDetails;
import oracle.sysman.oii.oiic.OiicAPISessionInterfaceManager;
import oracle.sysman.oii.oiic.OiicAddNodeAPISession;
import oracle.sysman.oii.oiic.OiicBaseApp;
import oracle.sysman.oii.oiic.OiicCloneAPISession;
import oracle.sysman.oii.oiic.OiicDeinstallAPISession;
import oracle.sysman.oii.oiic.OiicExitCode;
import oracle.sysman.oii.oiic.OiicExitOps;
import oracle.sysman.oii.oiic.OiicIOUIAPISession;
import oracle.sysman.oii.oiic.OiicIllegalStateException;
import oracle.sysman.oii.oiic.OiicInstallAPIException;
import oracle.sysman.oii.oiic.OiicInstallAPISession;
import oracle.sysman.oii.oiic.OiicInstallTimeSession;
import oracle.sysman.oii.oiic.OiicInvalidCmdLineException;
import oracle.sysman.oii.oiic.OiicLangAddonSession;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifb.OiifbWizOperation;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInventoryDoesNotExistException;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixUtilityOps;

public class OiicAPIInstaller
extends OiicBaseApp {
    public static final int INSTALL = 1;
    public static final int DEINSTALL = 2;
    public static final int CLONE = 3;
    public static final int ADDNODE = 4;
    public static final int LANG_ADDON = 5;
    public static final int UPGRADE = 6;
    public static final String STAGE_SESSION = "Stage";
    public static final String INSTALL_SESSION = "Install";
    public static final String DEINSTALL_SESSION = "DeInstall";
    public static final String CLONE_SESSION = "Clone";
    public static final String ADDNODE_SESSION = "AddNode";
    public static final String LANGADDON_SESSION = "LangAddon";
    public static final String UPGRADE_SESSION = "Upgrade";
    public static final int INIT_ENV_INVENTORY_INIT_FAILURE = 1001;
    public static final int INIT_ENV_SUCCESS = 9999;
    public static final int STATE_CLEAN = 1;
    public static final int STATE_INIT_ENV = 2;
    public static final int STATE_INIT_SESSION = 4;
    public static final int STATE_READY = 8;
    public static final int STATE_DONE = 16;
    public static final int INSTALL_COPY = 1;
    public static final int INSTALL_LINK = 2;
    public static final int INSTALL_SETUP = 4;
    private static Locale s_systemLocale = Locale.getDefault();
    private static OiicAPIInstaller m_oAPIInstaller = null;
    private static final String s_appName = "oui";
    private static int m_nState = 1;
    private OiicSessionInterfaceManager m_oSessionInterfaceManager = null;
    private int m_nMode = 1;
    private boolean m_bChainInstall = false;
    private List m_oSessionList;
    private List m_oInstalledSessionList;
    private OiicAPISessionDetails m_oCurSessionDetails;
    private int m_iIndexOfCurrentSessionDetails;
    private OiiiInstallAreaControl m_oInstallAreaControl;
    private OiiolTextLogger m_oLogger;
    private boolean m_bSuspend = false;
    private String[] m_sMandatoryProps = new String[]{"oracle.installer.oui_loc", "oracle.installer.scratchPath", "oracle.installer.startup_location"};
    private OiicIOUIAPISession m_oSession;
    private boolean isDeinstallMode = false;
    private String[] m_sCustomLogInfo = new String[3];
    private Level m_oCustomLevel = null;
    private Formatter m_oCustomFormatter = null;
    private String sResPropFile = null;
    private ResourceBundle sPropResBundle = null;
    private HashMap m_oUnassignedInstallVars = new HashMap();
    private String initialInventoryLocation;

    private OiicAPIInstaller() {
        super(s_appName);
        System.setProperty("oracle.installer.ouiApiMode", "true");
    }

    public static OiicAPIInstaller getAPIInstallerInstance() {
        if (m_oAPIInstaller == null) {
            m_oAPIInstaller = new OiicAPIInstaller();
        }
        return m_oAPIInstaller;
    }

    public static OiicAPIInstaller getHandleToAPIInstaller() {
        return m_oAPIInstaller;
    }

    public void setMode(int nMode) throws OiicInstallAPIException {
        this.m_nMode = nMode;
        if (this.m_nMode != 1 && this.m_nMode != 2 && this.m_nMode != 3 && this.m_nMode != 5 && this.m_nMode != 4) {
            String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-40001");
            throw new OiicInstallAPIException(sMsg);
        }
        switch (this.m_nMode) {
            case 2: {
                System.setProperty("oracle.installer.deinstall", "true");
                break;
            }
            case 3: {
                System.setProperty("oracle.installer.clone", "true");
                break;
            }
            case 4: {
                System.setProperty("oracle.installer.addNode", "true");
                break;
            }
            case 5: {
                System.setProperty("oracle.installer.addLangs", "true");
            }
        }
    }

    public int getMode() {
        return this.m_nMode;
    }

    public int initInstallEnvironment(Properties ouiProps, boolean bChainInstall, int nMode, String inventoryLocation) throws OiicIllegalStateException, OiicInstallAPIException {
        assert (null != inventoryLocation);
        this.initialInventoryLocation = inventoryLocation.trim();
        return this.initInstallEnvironment(ouiProps, bChainInstall, nMode);
    }

    public int initInstallEnvironment(Properties ouiProps, boolean bChainInstall, int nMode) throws OiicIllegalStateException, OiicInstallAPIException {
        System.setProperty("oracle.installer.timestamp", OiixUtilityOps.getSessionTimeStamp());
        int iRetVal = 9999;
        this.setMode(nMode);
        this.validateRequiredProperties(ouiProps);
        this.validateSessionState(2);
        this.processOUIProperties(ouiProps);
        try {
            if (null != this.initialInventoryLocation && !this.initialInventoryLocation.equals("")) {
                OiicPullSession.createDuplicateStreams(this.initialInventoryLocation);
            } else {
                OiicPullSession.createDuplicateStreams(null);
            }
            OiiolTextLogger.appendText("Initializing the OiiiInstallAreaControl");
            OiiiInstallAreaControl.initAreaControl(1);
            this.m_oInstallAreaControl = OiiiInstallAreaControl.getInstallAreaControl();
            OiiolTextLogger.appendText("Logs dir " + this.m_oInstallAreaControl.getLogsLoc());
        }
        catch (OiiiInventoryDoesNotExistException e) {
            OiiolTextLogger.appendText(e.getLocalizedMessage(), OiiolTextLogger.LOG_TRACE);
            iRetVal = 1001;
        }
        catch (IOException e) {
            OiiolTextLogger.appendText(e.getLocalizedMessage(), OiiolTextLogger.LOG_TRACE);
            iRetVal = 1001;
        }
        catch (OiifbEndIterateException ee) {
            throw new OiicInstallAPIException(ee.getLocalizedMessage());
        }
        this.setJREScratchDirectories();
        this.m_bChainInstall = bChainInstall;
        if (iRetVal == 9999) {
            OiiolTextLogger.appendText("Update the state machine to STATE_INIT_ENV");
            m_nState = 2;
        }
        return iRetVal;
    }

    public String getDefaultLogLoc() {
        String sLogLoc = null;
        if (null != this.m_oInstallAreaControl) {
            sLogLoc = this.m_oInstallAreaControl.getLogsLoc();
        }
        return sLogLoc;
    }

    public void processCommandLine(String sPropFile, String[] args) throws OiicInvalidCmdLineException {
        this.sResPropFile = sPropFile;
        this.sPropResBundle = null;
        Properties cmdProps = this.parseCmdLineEx(args);
        this.setSystemProperties(cmdProps);
        if (this.anyInvalidArgsFound()) {
            throw new OiicInvalidCmdLineException(this.formatInvalidArgsMsg());
        }
    }

    public void processCommandLine(ResourceBundle sPropRes, String[] args) throws OiicInvalidCmdLineException {
        this.sPropResBundle = sPropRes;
        this.sResPropFile = null;
        Properties cmdProps = this.parseCmdLineEx(args);
        this.setSystemProperties(cmdProps);
        if (this.anyInvalidArgsFound()) {
            throw new OiicInvalidCmdLineException(this.formatInvalidArgsMsg());
        }
    }

    public Object getUnassignedVarValue(String sVarName) {
        return this.m_oUnassignedInstallVars.get(sVarName);
    }

    @Override
    protected Properties getResourceProperties() throws OiicInvalidCmdLineException {
        Properties props = new Properties();
        if (null != this.sResPropFile) {
            Properties aProperties = new Properties();
            try {
                FileInputStream is = new FileInputStream(new File(this.sResPropFile));
                if (is == null) {
                    System.out.println("Unable to resolve the resource to an input stream");
                    aProperties = null;
                } else {
                    aProperties.load(is);
                    System.out.println("  This is a value from the properties file name = <" + aProperties.getProperty("a.value") + ">");
                }
            }
            catch (MissingResourceException e) {
                e.printStackTrace();
                aProperties = null;
            }
            catch (IOException e) {
                e.printStackTrace();
                aProperties = null;
            }
            if (aProperties == null) {
                OiicExitCode.setExitCode(-1);
                Object[] args = new String[]{this.sResPropFile};
                String sErrMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-25009", args);
                args[0] = sErrMsg;
                sErrMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-25008", args);
                throw new OiicInvalidCmdLineException(sErrMsg);
            }
            Enumeration<Object> en = aProperties.keys();
            while (en.hasMoreElements()) {
                String propName = (String)en.nextElement();
                props.setProperty(propName, aProperties.getProperty(propName));
            }
        } else if (null != this.sPropResBundle) {
            try {
                Enumeration<String> en = this.sPropResBundle.getKeys();
                while (en.hasMoreElements()) {
                    String propName = en.nextElement();
                    props.setProperty(propName, this.sPropResBundle.getString(propName));
                }
            }
            catch (MissingResourceException me) {
                me.printStackTrace();
            }
        } else {
            return super.getResourceProperties();
        }
        return props;
    }

    public void initLogLoc(String sLogDir, String sLogFile, String sExtension, boolean bDefault) throws IOException {
        if (!bDefault) {
            OiiolTextLogger.appendText("Setting the Log location to " + sLogDir + " to the file " + sLogFile + " with extension " + sExtension);
            this.m_sCustomLogInfo[0] = sLogDir;
            this.m_sCustomLogInfo[1] = sLogFile;
            this.m_sCustomLogInfo[2] = sExtension;
        }
    }

    public void initLogLoc(String sLogDir, String sLogFile, String sExtension, Level level, Formatter formatter) throws IOException {
        OiiolTextLogger.appendText("Setting the Log location to " + sLogDir + " to the file " + sLogFile + " with extension " + sExtension);
        this.m_sCustomLogInfo[0] = sLogDir;
        this.m_sCustomLogInfo[1] = sLogFile;
        this.m_sCustomLogInfo[2] = sExtension;
        this.m_oCustomLevel = level;
        this.m_oCustomFormatter = formatter;
    }

    public void registerInstallAPISession(List oSessionDetails) {
        this.m_oSessionList = oSessionDetails;
    }

    public OiicIOUIAPISession initOUIAPISession() throws OiicInstallAPIException, OiicIllegalStateException {
        this.validateSessionState(4);
        if (null != this.m_oSession) {
            this.disposeSession();
        }
        String sTempLoc = System.getProperty("oracle.installer.scratchPath");
        boolean cleanUpOnExit = System.getProperty("oracle.installer.cleanUpOnExit", "true").equalsIgnoreCase("true");
        if (null != sTempLoc && cleanUpOnExit) {
            String sCleanLoc = OiixPathOps.getNativeForm(sTempLoc);
            OiiolTextLogger.appendText("Registering the dir " + sCleanLoc + " with the ExitOps to be cleanedup, when ExitOps's doExitOperations or exit is called");
            OiicExitOps.getExitOps().addDelDir(sCleanLoc);
        }
        switch (this.m_nMode) {
            case 1: 
            case 5: {
                OiiolTextLogger.appendText("Initializing the Session for INSTALL");
                this.initInstallSession();
                break;
            }
            case 2: {
                OiiolTextLogger.appendText("Initializing the Session for DEINSTALL");
                this.initDeinstallSession();
                break;
            }
            case 3: {
                OiiolTextLogger.appendText("Initializing the Session for CLONE");
                this.initCloneSession();
                break;
            }
            case 4: {
                OiiolTextLogger.appendText("Initializing the Session for ADDNODE");
                this.initAddNodeSession();
            }
        }
        if (null != this.m_oSession) {
            OiiolTextLogger.appendText("Creating & Initializing the Session Interface Manager");
            this.m_oSessionInterfaceManager = OiicAPISessionInterfaceManager.getInterfaceManager();
            this.m_oSessionInterfaceManager.setSession((OiicInstallTimeSession)((Object)this.m_oSession));
            this.m_oSessionInterfaceManager.initialize();
        }
        return this.m_oSession;
    }

    public void prepareForInstallOperations() throws OiicInstallAPIException, OiicIllegalStateException {
        this.validateSessionState(8);
        switch (this.m_nMode) {
            case 1: 
            case 5: {
                OiiolTextLogger.appendText("Calling OiicInstallAPISession's prepareForInstallOperations");
                ((OiicInstallAPISession)this.m_oSession).prepareForInstallOperations();
                break;
            }
            case 4: {
                OiiolTextLogger.appendText("Calling OiicInstallAPISession's prepareForInstallOperations");
                ((OiicAddNodeAPISession)this.m_oSession).prepareForInstallOperations();
            }
        }
        OiiolTextLogger.appendText("Update the state machine to STATE_READY");
        m_nState = 8;
    }

    public void cancelOperation() {
        m_nState = 8;
        switch (this.m_nMode) {
            case 1: 
            case 5: {
                OiiolTextLogger.appendText("Calling OiicInstallAPISession's cancel Operation");
                ((OiicInstallAPISession)this.m_oSession).cancelOperation();
                break;
            }
            case 2: {
                OiiolTextLogger.appendText("Calling OiicDeinstallAPISession's cancel Operation");
                ((OiicDeinstallAPISession)this.m_oSession).cancelOperation();
                break;
            }
            case 3: {
                OiiolTextLogger.appendText("Calling OiicCloneAPISession's cancel Operation");
                ((OiicCloneAPISession)this.m_oSession).cancelOperation();
            }
        }
    }

    public void suspendOperation() {
        if (!this.m_bSuspend && m_nState == 16) {
            this.m_bSuspend = true;
            switch (this.m_nMode) {
                case 1: 
                case 5: {
                    OiiolTextLogger.appendText("Calling OiicInstallAPISession's suspend Operation");
                    ((OiicInstallAPISession)this.m_oSession).suspend();
                    break;
                }
                case 2: {
                    OiiolTextLogger.appendText("Calling OiicDeinstallAPISession's suspend Operation");
                    ((OiicDeinstallAPISession)this.m_oSession).suspend();
                    break;
                }
                case 3: {
                    OiiolTextLogger.appendText("Calling OiicCloneAPISession's suspend Operation");
                    ((OiicCloneAPISession)this.m_oSession).suspend();
                }
            }
        } else {
            OiiolTextLogger.appendText("Operation already suspended");
        }
    }

    public void resumeOperation() {
        if (this.m_bSuspend) {
            this.m_bSuspend = false;
            switch (this.m_nMode) {
                case 1: 
                case 5: {
                    OiiolTextLogger.appendText("Calling OiicInstallAPISession's resume Operation");
                    ((OiicInstallAPISession)this.m_oSession).resume();
                    break;
                }
                case 2: {
                    OiiolTextLogger.appendText("Calling OiicDeinstallAPISession's resume Operation");
                    ((OiicDeinstallAPISession)this.m_oSession).resume();
                    break;
                }
                case 3: {
                    OiiolTextLogger.appendText("Calling OiicCloneAPISession's resume Operation");
                    ((OiicCloneAPISession)this.m_oSession).resume();
                }
            }
        } else {
            OiiolTextLogger.appendText("Operation not suspended to resume");
        }
    }

    public void doOperation() throws OiicIllegalStateException, OiicInstallAPIException {
        this.doOperation(7);
    }

    public void doOperation(int iOperation) throws OiicIllegalStateException, OiicInstallAPIException {
        this.validateSessionState(16);
        try {
            if (this.m_bChainInstall) {
                OiiolTextLogger.appendText("Setting the chain install property to true");
                System.setProperty("oracle.installer.ouiApiChainInstall", "true");
            }
            OiiolTextLogger.appendText("Update the state machine to STATE_DONE");
            m_nState = 16;
            switch (this.m_nMode) {
                case 1: 
                case 5: {
                    OiiolTextLogger.appendText("Calling OiicInstallAPISession's doOperation");
                    ((OiicInstallAPISession)this.m_oSession).doOperation(iOperation, false);
                    break;
                }
                case 2: {
                    OiiolTextLogger.appendText("Calling OiicDeinstallAPISession's doOperation");
                    ((OiicDeinstallAPISession)this.m_oSession).doOperation(false);
                    break;
                }
                case 3: {
                    OiiolTextLogger.appendText("Calling OiicCloneAPISession's doOperation");
                    ((OiicCloneAPISession)this.m_oSession).doOperation(false);
                    break;
                }
                case 4: {
                    OiiolTextLogger.appendText("Calling OiicAddNodeAPISession's doOperation");
                    ((OiicAddNodeAPISession)this.m_oSession).doAddNodeOperation(false);
                }
            }
            if (this.m_nMode != 2 && ((OiicPullSession)((Object)this.m_oSession)).isSuccessfullInstallation()) {
                ((OiicPullSession)((Object)this.m_oSession)).setSuccessfullInstallation(true);
            }
            if (null == this.m_oInstalledSessionList) {
                this.m_oInstalledSessionList = new ArrayList(1);
            }
            OiiolTextLogger.appendText("Since operation was successful, move the current OiicAPISessionDetails to installed list");
            this.m_oInstalledSessionList.add(this.m_oCurSessionDetails);
            this.m_oSessionList.remove(this.m_iIndexOfCurrentSessionDetails);
            this.m_oCurSessionDetails = null;
        }
        catch (OiifbEndIterateException e) {
            OiiolTextLogger.appendException(e);
            OiiolTextLogger.appendText("Update the state machine to STATE_READY");
            m_nState = 8;
            throw new OiicInstallAPIException(e.getLocalizedMessage());
        }
    }

    public void disposeInstance() {
        if (null != this.m_oSession) {
            OiiolTextLogger.appendText("Dispose the current Session instance");
            ((OiifbWizOperation)((Object)this.m_oSession)).dispose();
        }
        OiiolTextLogger.appendText("Dispose the install area control object");
        if (null != this.m_oInstallAreaControl) {
            OiicAPIInstaller oiicAPIInstaller = this;
            oiicAPIInstaller.m_oInstallAreaControl.dispose();
        }
        this.m_oInstallAreaControl = null;
        OiiolTextLogger.appendText("Update the state machine to STATE_CLEAN");
        m_nState = 1;
        this.m_oSession = null;
        m_oAPIInstaller = null;
    }

    public OiicIOUIAPISession getOUIAPISession() {
        return this.m_oSession;
    }

    String getCustomLogDir() {
        return this.m_sCustomLogInfo[0];
    }

    String getCustomLogFileName() {
        return this.m_sCustomLogInfo[1];
    }

    String getCustomLogFileExtn() {
        return this.m_sCustomLogInfo[2];
    }

    Level getCustomLevel() {
        return this.m_oCustomLevel;
    }

    Formatter getCustomFormatter() {
        return this.m_oCustomFormatter;
    }

    void disposeSession() {
        if (null != this.m_oSessionInterfaceManager) {
            this.m_oSessionInterfaceManager.dispose();
        }
        this.m_oSession = null;
        this.m_oSessionInterfaceManager = null;
        m_nState = 2;
    }

    private OiicSessionContext getSessionContext() {
        switch (this.m_nMode) {
            case 1: 
            case 5: {
                return ((OiicInstallAPISession)this.m_oSession).getSessionContext();
            }
            case 2: {
                return ((OiicDeinstallAPISession)this.m_oSession).getSessionContext();
            }
            case 3: {
                return ((OiicCloneAPISession)this.m_oSession).getSessionContext();
            }
            case 4: {
                return ((OiicAddNodeAPISession)this.m_oSession).getSessionContext();
            }
        }
        return null;
    }

    private void updateSessionVars(OiicAPISessionDetails oSessionDetails) {
        OiiolTextLogger.appendText("Resetting the Command line arguments table before adding the contents of the OiicAPISessionDetails to it");
        this.resetCommandLineArgsTable();
        OiiolTextLogger.appendText("Updating the user provided variables to session vars and component vars");
        if (null != oSessionDetails) {
            String sGlobalVarXML;
            OiisVariable oVar;
            String sOracleHome = oSessionDetails.getOHLoc();
            String sOracleHomeName = oSessionDetails.getOHName();
            if (null != sOracleHome) {
                oVar = null;
                oVar = this.getSessionContext().getVariable("ORACLE_HOME");
                if (null != oVar) {
                    try {
                        OiiolTextLogger.appendText("Setting the value " + sOracleHome + " for ORACLE_HOME variable");
                        oVar.setValueForAPIMode(sOracleHome);
                        this.addToCommandLineTable("ORACLE_HOME", sOracleHome);
                    }
                    catch (OiifbCancelException e) {
                        OiiolTextLogger.appendException(e);
                    }
                    catch (OiisVarSettingException e) {
                        OiiolTextLogger.appendException(e);
                    }
                }
            }
            if (null != sOracleHomeName) {
                oVar = null;
                oVar = this.getSessionContext().getVariable("ORACLE_HOME_NAME");
                if (null != oVar) {
                    try {
                        OiiolTextLogger.appendText("Setting the value " + sOracleHomeName + " for ORACLE_HOME_NAME variable");
                        oVar.setValueForAPIMode(sOracleHomeName);
                        this.addToCommandLineTable("ORACLE_HOME_NAME", sOracleHomeName);
                    }
                    catch (OiifbCancelException e) {
                        OiiolTextLogger.appendException(e);
                    }
                    catch (OiisVarSettingException e) {
                        OiiolTextLogger.appendException(e);
                    }
                }
            }
            if (null != (sGlobalVarXML = oSessionDetails.getGlobalVarLoc())) {
                OiiolTextLogger.appendText("Setting the global Var property to the value : " + sGlobalVarXML);
                System.setProperty("oracle.installer.globalvarxml", sGlobalVarXML);
            } else {
                OiiolTextLogger.appendText("Setting the global Var property to empty string");
                System.setProperty("oracle.installer.globalvarxml", "");
            }
            OiiolTextLogger.appendText("Setting the entries of Variable HashMap provided in OiicAPISessionDetails");
            HashMap hVarMap = oSessionDetails.getVariableMap();
            if (null != hVarMap && !hVarMap.isEmpty()) {
                for (String sVarName : hVarMap.keySet()) {
                    String obj = null;
                    String sVarValue = null;
                    boolean bValueSet = false;
                    obj = hVarMap.get(sVarName) instanceof String ? (sVarValue = (String)hVarMap.get(sVarName)) : (String)hVarMap.get(sVarName);
                    OiisVariable oVar2 = null;
                    oVar2 = this.getSessionContext().getVariable(sVarName);
                    if (null != oVar2 && null != obj) {
                        try {
                            OiiolTextLogger.appendText("Setting the value  for " + sVarName + " variable");
                            if (null != obj) {
                                oVar2.setValueForAPIMode(obj);
                                bValueSet = true;
                            }
                        }
                        catch (OiifbCancelException e) {
                            OiiolTextLogger.appendException(e);
                        }
                        catch (OiisVarSettingException e) {
                            OiiolTextLogger.appendException(e);
                        }
                    } else {
                        this.m_oUnassignedInstallVars.put(sVarName, obj);
                    }
                    if (sVarValue == null || bValueSet) continue;
                    OiiolTextLogger.appendText("adding the variable " + sVarName + " to command line args table");
                    this.addToCommandLineTable(sVarName, sVarValue);
                }
            }
        }
    }

    private void validateRequiredProperties(Properties ouiProps) throws OiicInstallAPIException {
        if (null != ouiProps && ouiProps.size() > 0) {
            for (int i = 0; i < this.m_sMandatoryProps.length; ++i) {
                if (ouiProps.containsKey(this.m_sMandatoryProps[i])) continue;
                System.out.println("The user provided properties object doesnt have the entry for " + this.m_sMandatoryProps[i] + ". Checking if the value has been set in the System environment");
                String sPropVal = System.getProperty(this.m_sMandatoryProps[i]);
                if (null != sPropVal && (null == sPropVal || sPropVal.length() > 0)) continue;
                Object[] msgParams = new Object[]{this.m_sMandatoryProps[i]};
                String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-40003", msgParams);
                throw new OiicInstallAPIException(sMsg);
            }
        }
    }

    private boolean validateSessionState(int nState) throws OiicIllegalStateException {
        boolean bRet = false;
        Object[] msgparams = null;
        String sMsg = null;
        if (nState == m_nState >> 1) {
            return true;
        }
        if (m_nState == 1 || m_nState == 16) {
            if (nState == 2 || nState == 4) {
                return true;
            }
            msgparams = new String[]{"STATE_CLEAN/STATE_DONE", "STATE_INIT_ENV/STATE_INIT_SESSION"};
            sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-40002", msgparams);
            throw new OiicIllegalStateException(sMsg);
        }
        if (m_nState == 2) {
            if (nState != 4) {
                msgparams = new String[]{"STATE_INIT_ENV", "STATE_INIT_SESSION"};
                sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-40002", msgparams);
                throw new OiicIllegalStateException(sMsg);
            }
            return true;
        }
        if (m_nState == 4) {
            if (nState != 8) {
                msgparams = new String[]{"STATE_INIT_SESSION", "STATE_READY"};
                sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-40002", msgparams);
                throw new OiicIllegalStateException(sMsg);
            }
            return true;
        }
        if (m_nState == 8) {
            if (nState != 16) {
                msgparams = new String[]{"STATE_READY", "STATE_DONE"};
                sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-40002", msgparams);
                throw new OiicIllegalStateException(sMsg);
            }
            return true;
        }
        return bRet;
    }

    private void putCmdArgsIntoSystemProperty() {
        Properties props = this.getCmdProps();
        Properties defProps = this.getDefaultsOverriden();
        Properties sysProps = System.getProperties();
        Enumeration<?> propNames = props.propertyNames();
        while (propNames.hasMoreElements()) {
            String propName = (String)propNames.nextElement();
            sysProps.put(propName, props.get(propName));
            defProps.remove(propName);
        }
    }

    @Override
    protected String getSystemPropertyPrefix() {
        return "oracle.installer.";
    }

    @Override
    public String displayHelp() {
        return super.displayHelp();
    }

    private void processOUIProperties(Properties ouiProps) {
        String location;
        if (null != ouiProps) {
            this.processCmdLineWithProps(ouiProps);
            this.putCmdArgsIntoSystemProperty();
        }
        if ((location = System.getProperty("oracle.installer.installprops")) != null && (location = location.trim()).length() != 0 && this.loadInstallPropertiesFile(location)) {
            altInstallProps = true;
        }
        this.setAdditionalProperties();
        String sessionType = System.getProperty("oracle.installer.sessionType");
        boolean bDeinstall = Boolean.getBoolean("oracle.installer.deinstall");
        boolean bClone = Boolean.getBoolean("oracle.installer.clone");
        boolean bAddNode = Boolean.getBoolean("oracle.installer.addNode");
        boolean bLangAddon = Boolean.getBoolean("oracle.installer.addLangs");
        sessionType = bDeinstall ? DEINSTALL_SESSION : (bClone ? CLONE_SESSION : (bAddNode ? ADDNODE_SESSION : (bLangAddon ? LANGADDON_SESSION : INSTALL_SESSION)));
        System.setProperty("oracle.installer.sessionType", sessionType);
    }

    private void initDeinstallSession() throws OiicInstallAPIException, OiicIllegalStateException {
        try {
            this.isDeinstallMode = true;
            OiiolTextLogger.appendText("Create the OiicDeinstallAPISession");
            this.m_oSession = new OiicDeinstallAPISession(null);
            OiiolTextLogger.appendText("Initialize the OiicDeinstallAPISession");
            ((OiicDeinstallAPISession)this.m_oSession).initialize(false);
            OiiolTextLogger.appendText("Update the necessary details for OiicDeinstallAPISession");
            this.updateSessionDetails();
            OiiolTextLogger.appendText("Update the State machine to STATE_INIT_SESSION");
            m_nState = 4;
        }
        catch (Exception e) {
            throw new OiicInstallAPIException(e.getMessage());
        }
    }

    private void updateSessionDetails() {
        OiiolTextLogger.appendText("Select the OiicAPISessionDetail object from the given list");
        int iSessionDetailsSize = this.m_oSessionList.size();
        for (int i = 0; i < iSessionDetailsSize; ++i) {
            OiicAPISessionDetails oSessionDetails = (OiicAPISessionDetails)this.m_oSessionList.get(i);
            if (null != this.m_oCurSessionDetails && this.m_oCurSessionDetails.equals(oSessionDetails)) {
                OiiolTextLogger.appendText("A OiicAPISession Details object has been initialized but not installed.");
                continue;
            }
            if (null == this.m_oCurSessionDetails) {
                OiiolTextLogger.appendText("There is currently no OiicAPISessionDetails object that has been initialized. So Initializing the object " + (i + 1) + " from the list");
                this.m_oCurSessionDetails = oSessionDetails;
                this.m_iIndexOfCurrentSessionDetails = i;
                break;
            }
            if (null == this.m_oCurSessionDetails || this.m_oCurSessionDetails.equals(oSessionDetails)) continue;
            OiiolTextLogger.appendText("Initializing the " + (i + 1) + "st object from the list");
            this.m_oCurSessionDetails = oSessionDetails;
            this.m_iIndexOfCurrentSessionDetails = i;
            break;
        }
        OiiolTextLogger.appendText("OiicAPISessionDetails object selected for initialization \n" + this.m_oCurSessionDetails);
        this.updateSessionVars(this.m_oCurSessionDetails);
    }

    private void initCloneSession() throws OiicInstallAPIException, OiicIllegalStateException {
        try {
            OiiolTextLogger.appendText("Creating a new OiicCloneAPISession");
            this.m_oSession = new OiicCloneAPISession(this);
            OiiolTextLogger.appendText("Initializing the OiicCloneAPISession");
            OiiolTextLogger.appendText("Checking if there are any OiicAPISessionDetails object registered");
            if (null == this.m_oSessionList || null != this.m_oSessionList && this.m_oSessionList.size() <= 0) {
                OiiolTextLogger.appendText("No registered OiicAPISessionDetails Object, hence cannot continue");
                throw new OiicInstallAPIException(OiixResourceBundle.getString("S_OUIAPI_SESSION_DETAILS_NOT_REGISTERED"));
            }
            this.updateSessionDetails();
            ((OiicCloneAPISession)this.m_oSession).initialize();
            OiiolTextLogger.appendText("Update the State machine to STATE_INIT_SESSION");
            m_nState = 4;
        }
        catch (OiifbEndIterateException e) {
            throw new OiicInstallAPIException(e.getLocalizedMessage());
        }
    }

    private void initAddNodeSession() throws OiicInstallAPIException, OiicIllegalStateException {
        try {
            OiiolTextLogger.appendText("Creating a new OiicAddNodeAPISession");
            this.m_oSession = new OiicAddNodeAPISession(this);
            OiiolTextLogger.appendText("Initializing the OiicAddNodeAPISession");
            OiiolTextLogger.appendText("Checking if there are any OiicAPISessionDetails object registered");
            if (null == this.m_oSessionList || null != this.m_oSessionList && this.m_oSessionList.size() <= 0) {
                OiiolTextLogger.appendText("No registered OiicAPISessionDetails Object, hence cannot continue");
                throw new OiicInstallAPIException(OiixResourceBundle.getString("S_OUIAPI_SESSION_DETAILS_NOT_REGISTERED"));
            }
            this.updateSessionDetails();
            ((OiicAddNodeAPISession)this.m_oSession).initSessionWithDepEngine();
            OiiolTextLogger.appendText("Update the State machine to STATE_INIT_SESSION");
            m_nState = 4;
        }
        catch (OiifbEndIterateException e) {
            throw new OiicInstallAPIException(e.getLocalizedMessage());
        }
    }

    private void initInstallSession() throws OiicInstallAPIException, OiicIllegalStateException {
        try {
            OiiolTextLogger.appendText("Creating a new OiicInstallAPISession");
            this.m_oSession = this.m_nMode != 5 ? new OiicInstallAPISession(this) : new OiicLangAddonSession(this, true);
            OiiolTextLogger.appendText("Initializing the OiicInstallAPISession");
            ((OiicInstallAPISession)this.m_oSession).initialize();
            OiiolTextLogger.appendText("Checking if there are any OiicAPISessionDetails object registered");
            if (null == this.m_oSessionList || null != this.m_oSessionList && this.m_oSessionList.size() <= 0) {
                OiiolTextLogger.appendText("No registered OiicAPISessionDetails Object, hence cannot continue");
                throw new OiicInstallAPIException(OiixResourceBundle.getString("S_OUIAPI_SESSION_DETAILS_NOT_REGISTERED"));
            }
            this.updateSessionDetails();
            OiiolTextLogger.appendText("Update the State machine to STATE_INIT_SESSION");
            m_nState = 4;
        }
        catch (OiifbEndIterateException e) {
            throw new OiicInstallAPIException(e.getLocalizedMessage());
        }
    }
}

