/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiib;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.ListResourceBundle;
import java.util.StringTokenizer;

public class OiibConsMesgGenerator {
    public static final String S_OPT_HELP = "-help";
    public static final String S_OPT_HELP_DESC = "Lists the valid options";
    public static final String S_OPT_INRES = "-inRes";
    public static final String S_OPT_INRES_DESC = "Resource to load (default is oracle.sysman.oii.oiib.OiibRuntimeRes)";
    public static final String S_OPT_OUTBASE = "-outBase";
    public static final String S_OPT_OUTBASE_DESC = "Base name of output files (default is \"cons\")";
    public static final String S_OPT_OUTDIR = "-outDir";
    public static final String S_OPT_OUTDIR_DESC = "Output directory (default is the current folder)";
    public static final String S_OPT_LOCALES = "-locales";
    public static final String S_OPT_LOCALES_DESC = "Comma separated list of locales to look for";
    public static final String S_DEF_RES = "oracle.sysman.oii.oiib.OiibRuntimeRes";
    public static final String S_DEF_BASE = "cons";
    public static final String S_DEF_DIR = ".";
    public static final String S_DEF_SUFFIX = ".nls";
    public static final int I_KEY_VALUE_MAX_LENGTH = 1023;

    public static void main(String[] args) throws Exception {
        File oDirFile;
        String outDir = S_DEF_DIR;
        String res = S_DEF_RES;
        String base = S_DEF_BASE;
        String[] locales = new String[]{"", "_de", "_es", "_fr", "_it", "_ja", "_ko", "_pt_BR", "_zh_CN", "_zh_TW"};
        if (args.length > 0) {
            for (int argNum = 0; argNum < args.length; ++argNum) {
                String argVal = args[argNum];
                if (argVal.equals(S_OPT_HELP)) {
                    System.out.println("\nUsage: java oracle.sysman.oii.oiib.OiibConsMesgGenerator <options>\n");
                    System.out.println("Options:");
                    System.out.println("  -help  Lists the valid options");
                    System.out.println("  -inRes  Resource to load (default is oracle.sysman.oii.oiib.OiibRuntimeRes)");
                    System.out.println("  -outBase  Base name of output files (default is \"cons\")");
                    System.out.println("  -outDir  Output directory (default is the current folder)");
                    System.out.println("  -locales  Comma separated list of locales to look for");
                    System.exit(0);
                    continue;
                }
                if (argVal.equals(S_OPT_INRES)) {
                    res = args[++argNum];
                    continue;
                }
                if (argVal.equals(S_OPT_OUTBASE)) {
                    base = args[++argNum];
                    continue;
                }
                if (argVal.equals(S_OPT_OUTDIR)) {
                    outDir = args[++argNum];
                    continue;
                }
                if (argVal.equals(S_OPT_LOCALES)) {
                    String localesList = args[++argNum];
                    StringTokenizer t = new StringTokenizer(localesList, ",");
                    int numLocales = t.countTokens();
                    locales = new String[numLocales + 1];
                    locales[0] = "";
                    int i = 1;
                    while (t.hasMoreTokens()) {
                        locales[i] = "_" + t.nextToken();
                        ++i;
                    }
                    continue;
                }
                System.err.println("ERROR: Unexpected argument \"" + argVal + "\"");
                System.exit(1);
            }
        }
        if (!(oDirFile = new File(outDir)).exists()) {
            System.err.println("ERROR: Invalid directory \"" + outDir + "\"!");
            System.err.println("Folder does not exist");
            System.exit(1);
        } else if (!oDirFile.isDirectory()) {
            System.err.println("ERROR: Invalid directory \"" + outDir + "\"!");
            System.err.println("Not a folder");
            System.exit(1);
        }
        for (int i = 0; i < locales.length; ++i) {
            try {
                Class<?> resClass = Class.forName(res + locales[i]);
                File oFile = new File(oDirFile, base + locales[i] + S_DEF_SUFFIX);
                FileOutputStream fos = new FileOutputStream(oFile);
                System.out.println("Generating messages file \"" + oFile.toString() + "\"...");
                ListResourceBundle lrb = (ListResourceBundle)resClass.newInstance();
                Enumeration<String> keys = lrb.getKeys();
                while (keys.hasMoreElements()) {
                    String aKey = keys.nextElement();
                    byte[] keyBytes = aKey.getBytes("UTF-8");
                    fos.write(keyBytes);
                    fos.write(61);
                    String val = lrb.getString(aKey);
                    byte[] valBytes = val.getBytes("UTF-8");
                    fos.write(valBytes);
                    fos.write(0);
                    if (keyBytes.length + 1 + valBytes.length <= 1023) continue;
                    System.err.println("WARNING: The key \"" + aKey + "\" has too long a message!");
                }
                fos.flush();
                fos.close();
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }
}

