/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.gridhome.giprov122;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.cluster.common.InvalidArgsException;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.database.DatabaseException;
import oracle.cluster.database.DatabaseFactory;
import oracle.cluster.database.Service;
import oracle.cluster.database.ServiceException;
import oracle.cluster.database.ServiceStopArgs;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.deployment.ractrans.RACTransfer;
import oracle.cluster.deployment.ractrans.RemoteFileOpException;
import oracle.cluster.gridhome.giprov.GIResponseFileHandlerException;
import oracle.cluster.gridhome.giprov.RHPHelper;
import oracle.cluster.gridhome.giprov122.GIResponseFileHandler122;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.Filter;
import oracle.cluster.impl.crs.FilterFactoryImpl;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.util.Utils;
import oracle.cluster.install.ConfigurationSetup;
import oracle.cluster.install.InstallException;
import oracle.cluster.install.UserInfo;
import oracle.cluster.logger.TraceLogger;
import oracle.cluster.logger.TraceLoggerFactory;
import oracle.cluster.remote.RemoteUserInfo;
import oracle.cluster.resources.PrCgMsgID;
import oracle.cluster.server.ServerGroup;
import oracle.cluster.server.ServerGroupException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.util.NotRunningException;
import oracle.cluster.verification.ClusterVerification;
import oracle.cluster.verification.FixupException;
import oracle.cluster.verification.FixupOverallStatus;
import oracle.cluster.verification.FixupResult;
import oracle.cluster.verification.FixupResultSet;
import oracle.cluster.verification.InvalidFixupNodeException;
import oracle.cluster.verification.InvalidPathException;
import oracle.cluster.verification.NetworkInterfaceInfo;
import oracle.cluster.verification.NodeConnectivityResultSet;
import oracle.cluster.verification.NodeResultsUnavailableException;
import oracle.cluster.verification.OverallStatus;
import oracle.cluster.verification.ParamPreReqCRSInst;
import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.SharedStorageInfo;
import oracle.cluster.verification.SharedStorageResultSet;
import oracle.cluster.verification.StorageType;
import oracle.cluster.verification.SubnetAndInterfaceInfo;
import oracle.cluster.verification.SubtasksUnavailableException;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.VerificationResultSet;
import oracle.cluster.verification.VerificationTask;
import oracle.cluster.verification.fixup.RootAutomationException;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.InvalidNodeListException;
import oracle.ops.mgmt.cluster.SharedDeviceException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.network.NetworkConstants;
import oracle.ops.verification.framework.util.CVUVariableConstants;

public class RHPHelper122
extends RHPHelper {
    private static final String PRIVATEANDASM = "5";
    private static final String PUBLIC = "1";
    private static final String ROOT_USER = "root";
    private static final String SETUPSSH_OPTION = "-setupSSH";
    private static TraceLoggerFactory tf;
    private static TraceLogger s_tlogger;
    private static MessageBundle m_msgBndl;

    public RHPHelper122() {
        this.addCommandLineOption("-verify", 8, "verify", "Verify the parameters supplied in the responsefile. Usage: rhphelper <ORACLE_HOME> 12.2.0.0.0 -verify <Oracle home> <response_file> {-ignorewarn|null} {-fixup|null} {-root|<sudo_user>} {<sudopath>|null} {-setupSSH|null}");
        this.addCommandLineOption("-verifyUpgrade", 4, "verifyUpgrade", "Perform verification for pre upgrade GI home. Usage: rhphelper <ORACLE_HOME> 12.2.0.0.0 -verifyUpgrade <Oracle home> <nodelist> <dstHome>");
        this.addCommandLineOption("-discover", 4, "discover", "Discovers the parameters on the given nodelist. Usage: rhphelper <ORACLE_HOME> 12.2.0.0.0 -discover <Oracle home> <response_file> {<groups>|HelperConstants.GROUP_PLACEHOLDER}");
        this.addCommandLineOption("isSharedPath", 3, "isSharedPath", "Determine if directory (absolute path) is shared. Usage: rhphelper <ORACLE_HOME> 12.2.0.0.0 isSharedPath <nodelist> <dir>");
        this.addCommandLineOption("-checkEnoughSpace", 5, "checkEnoughSpace", "Determine if directory (absolute path) has enough space. Usage: rhphelper <ORACLE_HOME> 12.2.0.0.0 checkEnoughSpace <Oracle home> <nodelist> <dir> <size>");
        this.addCommandLineOption("-getOracleUser", 2, "getOracleHomeOwner", "Determine the owner of the oracle binary in the specified Oracle home. Usage: rhphelper <ORACLE_HOME> 12.2.0.0.0 -getOracleUser <Oracle home>");
        this.addCommandLineOption("-copydbs", 3, "copyDBFiles", "Copy files from source Oracle home's dbs directory to destination Oracle home's dbs directory. Usage: rhphelper <ORACLE_HOME> 12.2.0.0.0 -copydbs <source_home_path> <destination_home_path> [database_unique_name]");
        this.addCommandLineOption("-transfer", 5, "transfer", "Copies the directory to the specified path on the specified node list. Usage: rhphelper <ORACLE_HOME> 11.2.0.{3|4}.0 -transfer <oracle_home> <node_list> <source_path> <destination_paths> [exclude_list]");
        this.addCommandLineOption("-mergeListenerOra", 3, "mergeListenerOra", "Merge two listener.ora files. Usage: rhphelper <ORACLE_HOME> 12.2.0.0.0 -mergelistenerora <source_home_path> <destination_home_path>");
        this.addCommandLineOption("-mergeSqlNetOra", 3, "mergeSqlNetOra", "Merge two sqlnet.ora files. Usage: rhphelper <ORACLE_HOME> 12.2.0.0.0 -mergesqlnetora <source_home_path> <destination_home_path>");
        this.addCommandLineOption("-mergeTNSNames", 3, "mergeTNSNames", "Merge two tnsnames.ora files. Usage: rhphelper <ORACLE_HOME> 12.2.0.0.0 -mergetnsnames <source_home_path> <destination_home_path>");
        this.addCommandLineOption("-getClusterName", 1, "getClusterName", "Determine the cluster name. Usage: rhphelper <ORACLE_HOME> 12.2.0.0.0 -getClustername");
        this.addCommandLineOption("-getClusterNodes", 1, "getClusterNodes", "Retrieve names of nodes in the cluster. Usage: rhphelper <ORACLE_HOME> 12.2.0.0.0 -getClusterNodes");
        this.addCommandLineOption("-getServiceInfo", 1, "getServiceInfo", "Retrieve service information for creating batches for smart move. Usage: rhphelper <ORACLE_HOME> 12.2.0.0.0 -getServiceInfo");
        this.addCommandLineOption("-getHubNodes", 1, "getHubNodes", "Retrieve names of hub nodes in the cluster. Usage: rhphelper <ORACLE_HOME> 12.2.0.0.0 -getHubNodes");
        this.addCommandLineOption("-relocateServices", 2, "relocateServices", "Relocates services running on the specified nodes. Usage: rhphelper <ORACLE_HOME> 12.2.0.0.0 -relocateServices <node_list>");
        this.addCommandLineOption("-getInventory", 1, "getInventoryLoc", "Determine the Oracle Inventory location. Usage: rhphelper <ORACLE_HOME> 12.2.0.0.0 -getInventory");
        this.addCommandLineOption("-getOracleHomes", 1, "getOracleHomes", "Determine the Oracle Inventory location. Usage: rhphelper <ORACLE_HOME> 12.2.0.0.0 -getOracleHomes");
        this.addCommandLineOption("-updateOratab", 3, "updateOratab", "Updates the specified SIDB to use the specified home directory in /etc/oratab.Usage: rhphelper <ORACLE_HOME> 12.2.0.0.0 -updateOratab <sid> <home>");
        this.addCommandLineOption("-transferNoUserEq", 8, "transferNoUserEq", "Copies the directory to the specified path on the specified node list where passwordless user equivalence is not present. Usage: rhphelper <ORACLE_HOME> 12.2.0.0.0 -transferNoUserEq <oracle_home> <node_list> <source_path> <destination_paths> {-root|<sudoUser>} <sudoPath> <asUser>");
        this.addCommandLineOption("-checkPatchedBugs", 7, "checkPatchedBugs", "Checks if the specified Oracle bug numbers or patch numbers are installed in the specified Oracle HomeUsage: rhphelper <ORACLE_HOME> 12.2.0.0.0 -checkPatchedBugs <Oracle_home> <bugs> <node_list> <isRacHome> <Oracle_home_ver>");
    }

    public static void main(String[] args) {
        int retVal = 1;
        RHPHelper122 helper = new RHPHelper122();
        String methodName = helper.parseArguments(args);
        if (methodName != null) {
            retVal = helper.processCommandLine("oracle.cluster.gridhome.giprov122.RHPHelper122", methodName, args);
            if (retVal != 1) {
                helper.displayExecutionSuccess();
            } else {
                helper.displayExecutionError(MessageBundle.getMessage((MessageKey)PrCgMsgID.UNEXPECTED_INTERNAL_ERROR, (boolean)true, (Object[])new Object[]{"RHPHELP122_main-01"}));
            }
        } else {
            helper.displayExecutionError(MessageBundle.getMessage((MessageKey)PrCgMsgID.UNEXPECTED_INTERNAL_ERROR, (boolean)true, (Object[])new Object[]{"RHPHELP122_main-02"}));
        }
        System.exit(retVal);
    }

    public int verify(String[] args) {
        Trace.out((String)"Entering verify method");
        String frameworkHome = args[1];
        String responseFile = args[2];
        boolean isIgnoreWarn = args[3].equals("-ignorewarn");
        boolean isFixup = args[4].equals("-fixup");
        boolean isRoot = args[5].equals("-root");
        String sudoUser = args[5];
        String sudoPath = args[6];
        boolean isSetupSSH = args[7].trim().toLowerCase().equals(SETUPSSH_OPTION.trim().toLowerCase());
        String password = null;
        ArrayList<VerificationTask> fixUpTaskList = new ArrayList<VerificationTask>();
        String errMsg = "";
        String errMsg1 = "";
        int count = 0;
        int warnCount = 0;
        boolean setupSSHNeeded = false;
        Trace.out((String)("Response file is " + args[2]));
        Trace.out((String)("fixup is " + args[4]));
        Trace.out((String)("setupssh is " + args[7]));
        Trace.out((String)("sudo Path is" + args[6]));
        Trace.out((String)("Ignore warning is" + args[3]));
        try {
            String errorMessage;
            VerificationResultSet resultSet;
            if (isFixup) {
                BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
                password = in.readLine();
            }
            Trace.out((String)("Response File path is " + responseFile));
            GIResponseFileHandler122 gihdl = new GIResponseFileHandler122(responseFile, false);
            List<String> nodeList = gihdl.getNodeList();
            String[] nodeListArr = this.getNodeListArr(nodeList);
            ParamPreReqCRSInst cvuParam = new ParamPreReqCRSInst();
            ClusterVerification cvu = ClusterVerification.getInstance((String)frameworkHome, (ClusterVerification.PathType)ClusterVerification.PathType.FRAMEWORK_HOME);
            Trace.out((String)("Setting up SSH? " + (isFixup && isSetupSSH)));
            if (isFixup && isSetupSSH) {
                Trace.out((String)"Checking if user equivalence needs to be set up...");
                resultSet = cvu.checkUserEquiv(nodeListArr);
                errorMessage = this.getErrorMessage(resultSet);
                if (errorMessage.length() > 0) {
                    Trace.out((String)"User equivalence needs to be set up with a timeout of 600 seconds.");
                    String loggedInUser = new Util().getCurrentUser();
                    FixupResultSet sshResults = null;
                    if (isRoot) {
                        Trace.out((String)"Setting up ssh using root");
                        sshResults = cvu.setupSSHUserEquivalenceUsingRoot(nodeListArr, password, loggedInUser, 600);
                    } else {
                        Trace.out((String)"Setting up ssh using sudo");
                        sshResults = cvu.setupSSHUserEquivalenceUsingSudo(nodeListArr, sudoUser, password, sudoPath, loggedInUser, 600);
                    }
                    Trace.out((String)"CVU setup ssh call has completed");
                    if (sshResults.getFixupOverallStatus() != FixupOverallStatus.SUCCESSFUL) {
                        for (VerificationError vfe : sshResults.getErrors()) {
                            errMsg1 = errMsg1 + LSEP + vfe.getErrorMessage();
                        }
                    }
                }
            }
            cvu.setDefaultFixupRequirement(isFixup);
            cvu.setVariableValue(CVUVariableConstants.USE_SHARED_GNS.toString(), gihdl.getUseSharedGNS());
            cvu.setVariableValue("RHP_MOUNT", "true");
            resultSet = cvu.checkFrameworkSetup(nodeListArr);
            errorMessage = this.getErrorMessage(resultSet);
            if (errorMessage.length() > 0) {
                this.displayErrorResult(errorMessage, 3);
                return 0;
            }
            Trace.out((String)"getting task list by providing the responsefile.. ");
            List taskList = cvu.getPreReqTasksForCRSInst(responseFile);
            List<VerificationTask> giTaskList = this.getTaskList(taskList);
            for (VerificationTask verTask : giTaskList) {
                ArrayList<String> resultLst = new ArrayList<String>();
                this.CVUTaskCheck(verTask, resultLst);
                boolean isTaskCritical = SeverityType.CRITICAL.equals((Object)verTask.getSeverity());
                Trace.out((String)("Task: " + verTask.getElementName() + " isTaskCritical:" + isTaskCritical));
                if (resultLst.isEmpty()) continue;
                Trace.out((String)("Task: " + verTask.getElementName() + " with error"));
                if (isTaskCritical || !isIgnoreWarn) {
                    for (String rstr : resultLst) {
                        errMsg1 = errMsg1 + LSEP + rstr;
                    }
                }
                Trace.out((String)("CVU task error message is " + errMsg1));
                if (isTaskCritical) {
                    ++count;
                    continue;
                }
                ++warnCount;
            }
            if (count > 0 && !isFixup) {
                Trace.out((String)("No of critical cvu tasks that failed are " + count));
                this.displayErrorResult(errMsg1, 3);
                return 0;
            }
            if (warnCount > 0 && !isFixup) {
                Trace.out((String)("Number of warnings from cvu tasks are " + warnCount));
                if (!isIgnoreWarn) {
                    this.displayWarningResult(errMsg1, 1);
                    return 0;
                }
            }
            if (isFixup) {
                Trace.out((String)"getting fixup task list .. ");
                List taskListFixUp = cvu.getFixupTaskList();
                StringBuilder allTaskStatus = new StringBuilder();
                int fixupErrCnt = 0;
                int fixupWarnCnt = 0;
                if (!taskListFixUp.isEmpty()) {
                    Trace.out((String)"Setup user info params");
                    if (isRoot) {
                        cvu.setRootExecutionInfo(ConfigurationSetup.ConfigMethod.ROOT, new UserInfo(ROOT_USER, password));
                    } else {
                        cvu.setRootExecutionInfo(ConfigurationSetup.ConfigMethod.SUDO, new UserInfo(sudoUser, password), sudoPath);
                    }
                    cvu.setupFixups(taskListFixUp);
                    for (VerificationTask verTask : taskListFixUp) {
                        fixUpTaskList.add(verTask);
                        try {
                            if (!verTask.hasSubtasks()) continue;
                            List subTasks = verTask.getSubtasks();
                            Iterator subtaskIt = subTasks.iterator();
                            while (subtaskIt.hasNext()) {
                                fixUpTaskList.add((VerificationTask)subtaskIt.next());
                            }
                        }
                        catch (SubtasksUnavailableException ce) {
                            Trace.out((String)ce.getMessage());
                        }
                    }
                    cvu.executeFixupsAutomated();
                    for (VerificationTask verTask : fixUpTaskList) {
                        ArrayList fixupresultLst = new ArrayList();
                        this.checkFixupResults(verTask, fixupresultLst, allTaskStatus);
                        boolean isTaskCritical = SeverityType.CRITICAL.equals((Object)verTask.getSeverity());
                        boolean isRebootRequired = verTask.isRebootRequiredForFixup();
                        Trace.out((String)("Task: " + verTask.getElementName() + " isTaskCritical:" + isTaskCritical));
                        if (fixupresultLst.isEmpty()) continue;
                        Trace.out((String)("Task: " + verTask.getElementName() + " with error"));
                        if (isTaskCritical || !isIgnoreWarn) {
                            for (String rstr : fixupresultLst) {
                                errMsg1 = errMsg1 + LSEP + rstr;
                            }
                        }
                        if (isRebootRequired) {
                            errMsg1 = errMsg1 + LSEP + m_msgBndl.getMessage((MessageKey)PrCgMsgID.REBOOT_REQD_FIXUP, false);
                        }
                        Trace.out((String)("CVU task error message is " + errMsg1));
                        if (isTaskCritical) {
                            ++fixupErrCnt;
                            continue;
                        }
                        ++fixupWarnCnt;
                    }
                }
                String fixupResultStr = "";
                if (allTaskStatus.length() > 0) {
                    fixupResultStr = allTaskStatus.toString();
                    Trace.out((String)("CVU Fixup status " + fixupResultStr));
                    errMsg1 = errMsg1 + LSEP + fixupResultStr;
                }
                if (count > 0 || fixupErrCnt > 0) {
                    this.displayErrorResult(errMsg1, 3);
                    return 0;
                }
                if (warnCount > 0 || fixupWarnCnt > 0) {
                    Trace.out((String)("Number of warnings from cvu fixup tasks are :" + warnCount));
                    if (!isIgnoreWarn) {
                        this.displayWarningResult(errMsg1, 1);
                        return 0;
                    }
                }
                if (fixupResultStr.length() > 0) {
                    this.displaySuccessResult(fixupResultStr);
                }
            }
        }
        catch (ClassNotFoundException e) {
            Trace.out((String)("ClassNotFoundException : " + e));
            this.displayErrorResult(MessageBundle.getMessage((MessageKey)PrCgMsgID.UNEXPECTED_INTERNAL_ERROR, (boolean)true, (Object[])new Object[]{"RHPHELP122_verify-01"}), 2);
        }
        catch (IllegalAccessException e) {
            Trace.out((String)("IllegalAccessException : " + e));
            this.displayErrorResult(MessageBundle.getMessage((MessageKey)PrCgMsgID.UNEXPECTED_INTERNAL_ERROR, (boolean)true, (Object[])new Object[]{"RHPHELP122_verify-02"}), 2);
        }
        catch (InvocationTargetException e) {
            Trace.out((String)("InvocationTargetException : " + e.getCause()));
            this.displayErrorResult(e.getCause().getMessage(), 3);
        }
        catch (NoSuchMethodException e) {
            Trace.out((String)("NoSuchMethodException : " + e));
            this.displayErrorResult(MessageBundle.getMessage((MessageKey)PrCgMsgID.UNEXPECTED_INTERNAL_ERROR, (boolean)true, (Object[])new Object[]{"RHPHELP122_verify-03"}), 2);
        }
        catch (VerificationException ce) {
            Trace.out((String)("Got Verification Exception " + (Object)((Object)ce)));
            this.displayErrorResult(ce.getMessage(), 3);
        }
        catch (UtilException ce) {
            Trace.out((String)("Got UtilException " + (Object)((Object)ce)));
            this.displayErrorResult(ce.getMessage(), 3);
        }
        catch (GIResponseFileHandlerException e) {
            Trace.out((Exception)e);
            this.displayErrorResult(e.getMessage(), 3);
        }
        catch (RootAutomationException e) {
            Trace.out((Exception)((Object)e));
            this.displayErrorResult(e.getMessage(), 3);
        }
        catch (FixupException e) {
            Trace.out((Exception)((Object)e));
            this.displayErrorResult(e.getMessage(), 3);
        }
        catch (IOException e) {
            Trace.out((Exception)e);
            this.displayErrorResult(MessageBundle.getMessage((MessageKey)PrCgMsgID.UNEXPECTED_INTERNAL_ERROR, (boolean)true, (Object[])new Object[]{"RHPHELP122_verify-04"}), 2);
        }
        Trace.out((String)"Exit verify method");
        return 0;
    }

    public int verifyUpgrade(String[] args) {
        Trace.out((String)"Entering verify upgrade method");
        String frameworkHome = args[1];
        String nodes = args[2];
        String dstHomePath = args[3];
        Trace.out((String)"Framework home is %s, nodes is %s, dst homepath is %s", (Object[])new Object[]{frameworkHome, nodes, dstHomePath});
        String[] nodeListArr = nodes.split(",");
        String errMsg1 = "";
        int count = 0;
        int warnCount = 0;
        try {
            Trace.out((String)"CVU framework initialization");
            ParamPreReqCRSInst cvuParam = new ParamPreReqCRSInst();
            ClusterVerification cvu = ClusterVerification.getInstance((String)frameworkHome, (ClusterVerification.PathType)ClusterVerification.PathType.FRAMEWORK_HOME);
            cvu.setVariableValue("INSTALL_OPTION", "UPGRADE");
            cvu.setVariableValue("CRS_HOME", dstHomePath);
            cvu.setVariableValue("RHP_MOUNT", "true");
            Trace.out((String)"Checking existence of CVU framework");
            VerificationResultSet resultSet = cvu.checkFrameworkSetup(nodeListArr);
            Trace.out((String)"After finishing CVU framework setup check");
            String errorMessage = this.getErrorMessage(resultSet);
            Trace.out((String)("error message = " + errorMessage));
            if (errorMessage.length() > 0) {
                this.displayErrorResult(errorMessage, 3);
                return 0;
            }
            Trace.out((String)"getting task list for GI upgrade.. ");
            List taskList = cvu.getPreReqTasksForCRSInst(nodeListArr);
            List<VerificationTask> giTaskList = this.getTaskList(taskList);
            Trace.out((String)"Processing task list");
            for (VerificationTask verTask : giTaskList) {
                ArrayList<String> resultLst = new ArrayList<String>();
                this.CVUTaskCheck(verTask, resultLst);
                boolean isTaskCritical = SeverityType.CRITICAL.equals((Object)verTask.getSeverity());
                Trace.out((String)("Task: " + verTask.getElementName() + " isTaskCritical:" + isTaskCritical));
                if (resultLst.isEmpty()) continue;
                Trace.out((String)("Task : " + verTask.getElementName() + " with error"));
                for (String rstr : resultLst) {
                    errMsg1 = errMsg1 + LSEP + rstr;
                }
                Trace.out((String)("CVU task error message is " + errMsg1));
                if (isTaskCritical) {
                    ++count;
                    continue;
                }
                ++warnCount;
            }
            if (count > 0) {
                Trace.out((String)("No of critical cvu tasks that failed are " + count));
                this.displayErrorResult(errMsg1, 3);
                return 0;
            }
            if (warnCount > 0) {
                Trace.out((String)("Number of warnings from cvu tasks are " + warnCount));
                this.displayWarningResult(errMsg1, 1);
                return 0;
            }
        }
        catch (ClassNotFoundException e) {
            Trace.out((String)("ClassNotFoundException : " + e));
            this.displayErrorResult(MessageBundle.getMessage((MessageKey)PrCgMsgID.UNEXPECTED_INTERNAL_ERROR, (boolean)true, (Object[])new Object[]{"RHPHELP122_verifyUpgrade-01"}), 2);
        }
        catch (IllegalAccessException e) {
            Trace.out((String)("IllegalAccessException : " + e));
            this.displayErrorResult(MessageBundle.getMessage((MessageKey)PrCgMsgID.UNEXPECTED_INTERNAL_ERROR, (boolean)true, (Object[])new Object[]{"RHPHELP122_verifyUpgrade-02"}), 2);
        }
        catch (InvocationTargetException e) {
            Trace.out((String)("InvocationTargetException : " + e.getCause()));
            this.displayErrorResult(e.getCause().getMessage(), 3);
        }
        catch (NoSuchMethodException e) {
            Trace.out((String)("NoSuchMethodException : " + e));
            this.displayErrorResult(MessageBundle.getMessage((MessageKey)PrCgMsgID.UNEXPECTED_INTERNAL_ERROR, (boolean)true, (Object[])new Object[]{"RHPHELP122_verifyUpgrade-03"}), 2);
        }
        catch (VerificationException ce) {
            Trace.out((String)("Got Verification Exception " + (Object)((Object)ce)));
            this.displayErrorResult(ce.getMessage(), 3);
        }
        Trace.out((String)"Exit verify upgrade method");
        return 0;
    }

    private List<VerificationTask> getTaskList(List taskList) {
        ArrayList<VerificationTask> giTaskList = new ArrayList<VerificationTask>();
        for (VerificationTask verTask : taskList) {
            giTaskList.add(verTask);
            try {
                if (!verTask.hasSubtasks()) continue;
                List subTasks = verTask.getSubtasks();
                Iterator subtaskIt = subTasks.iterator();
                while (subtaskIt.hasNext()) {
                    giTaskList.add((VerificationTask)subtaskIt.next());
                }
            }
            catch (SubtasksUnavailableException ce) {
                Trace.out((String)ce.getMessage());
            }
        }
        return giTaskList;
    }

    public int discover(String[] args) {
        Trace.out((String)"Enter discover method");
        String frameworkHome = args[1];
        String responseFile = args[2];
        String imgGroupsStr = args[3];
        Trace.out((String)("Image groups: " + imgGroupsStr));
        Trace.out((String)("Response File input is" + args[2]));
        Trace.out((String)("Framework Home is " + args[1]));
        ArrayList giTaskList = new ArrayList();
        String errMsg = "";
        Trace.out((String)"Process the input file");
        try {
            Trace.out((String)("Response File path is " + responseFile));
            GIResponseFileHandler122 gihdl = new GIResponseFileHandler122(responseFile, false);
            List<String> nodeList = gihdl.getNodeList();
            String[] nodeListArr = this.getNodeListArr(nodeList);
            ClusterVerification cvu = ClusterVerification.getInstance((String)frameworkHome, (ClusterVerification.PathType)ClusterVerification.PathType.FRAMEWORK_HOME);
            VerificationResultSet resultSet = cvu.checkFrameworkSetup(nodeListArr);
            String errorMessage = this.getErrorMessage(resultSet);
            if (errorMessage.length() > 0) {
                this.displayErrorResult(errorMessage, 3);
                return 0;
            }
            Trace.out((String)"CVU framework exists");
            SharedStorageResultSet sSresultSet = cvu.checkSharedStorageAccessibility(nodeListArr);
            List storageList = sSresultSet.getSharedStorage();
            StringBuilder disksDiscoveredString = new StringBuilder();
            ArrayList<String> sharedPathDiscoveredStringArr = new ArrayList<String>();
            for (SharedStorageInfo storage : storageList) {
                String storagePath = storage.getStoragePath();
                StorageType stType = storage.getStorageType();
                if (StorageType.NFS == storage.getStorageType() || StorageType.FILESYSTEM == storage.getStorageType()) {
                    sharedPathDiscoveredStringArr.add(storagePath);
                } else if (StorageType.DISK == storage.getStorageType() || StorageType.ISCSI == storage.getStorageType()) {
                    disksDiscoveredString.append(storagePath);
                    disksDiscoveredString.append(",");
                }
                Trace.out((String)("The path recieved is:" + storage.getStoragePath()));
            }
            if (disksDiscoveredString.length() != 0) {
                disksDiscoveredString.deleteCharAt(disksDiscoveredString.length() - 1);
                gihdl.addDiscoveredDisks(disksDiscoveredString.toString());
            }
            for (String fileSystem : sharedPathDiscoveredStringArr) {
                Trace.out((String)("Disk discovery string is " + fileSystem));
                gihdl.addDiscoveredDiskDiscoveryString(fileSystem);
            }
            NodeConnectivityResultSet nCresultSet = cvu.checkNodeConnectivity(nodeListArr);
            List siInfoSubnet = nCresultSet.getAvailableSubnets();
            ArrayList<String> privateInf = new ArrayList<String>();
            ArrayList<String> publicInf = new ArrayList<String>();
            ArrayList<String> interfaceList = new ArrayList<String>();
            for (SubnetAndInterfaceInfo sIInfo : siInfoSubnet) {
                List nwInfList = sIInfo.getInterfaceInfo();
                Iterator iterator = nwInfList.iterator();
                while (iterator.hasNext()) {
                    NetworkInterfaceInfo nwinterface = (NetworkInterfaceInfo)iterator.next();
                    StringBuilder nwInterfaceDiscoveredString = new StringBuilder();
                    StringBuilder interfaceString = new StringBuilder();
                    String infName = nwinterface.getInterfaceName();
                    String infAddress = nwinterface.getInetAddress().getHostAddress();
                    int subnetType = sIInfo.getSubnetType();
                    String subnetNum = null;
                    try {
                        subnetNum = InetAddress.getByAddress(sIInfo.getSubnetNumber()).getHostAddress();
                    }
                    catch (UnknownHostException uhe) {
                        Trace.out((String)("SubnetNumber: Unknown Host Exception" + uhe));
                    }
                    Trace.out((String)("Inf Name :" + infName + " infAddress :" + infAddress + " Subnet type: " + subnetType + " SubnetNumber: " + subnetNum));
                    if (subnetType != 2 && subnetType != 1) continue;
                    nwInterfaceDiscoveredString.append(infName);
                    nwInterfaceDiscoveredString.append(':');
                    nwInterfaceDiscoveredString.append(subnetNum);
                    nwInterfaceDiscoveredString.append(':');
                    interfaceString.append(infName);
                    interfaceString.append(" ");
                    interfaceString.append(infAddress);
                    interfaceString.append(" ");
                    if (1 == subnetType) {
                        Trace.out((String)("Interface number is " + sIInfo.getSubnetType()));
                        nwInterfaceDiscoveredString.append(PRIVATEANDASM);
                        privateInf.add(nwInterfaceDiscoveredString.toString());
                        interfaceString.append(NetworkConstants.NetworkType.PRIVATE.toString());
                    } else if (2 == subnetType) {
                        nwInterfaceDiscoveredString.append(PUBLIC);
                        Trace.out((String)("Interface number is " + sIInfo.getSubnetType()));
                        publicInf.add(nwInterfaceDiscoveredString.toString());
                        interfaceString.append(NetworkConstants.NetworkType.PUBLIC.toString());
                    }
                    interfaceList.add(interfaceString.toString());
                }
            }
            ArrayList<String> outerInfListVar = publicInf;
            ArrayList<String> innerInfListVar = privateInf;
            if (publicInf.isEmpty()) {
                outerInfListVar = privateInf;
                innerInfListVar = publicInf;
            }
            for (String outInf : outerInfListVar) {
                if (!innerInfListVar.isEmpty()) {
                    for (String inInf : innerInfListVar) {
                        gihdl.addDiscoveredInterfaces(inInf + "," + outInf);
                    }
                    continue;
                }
                gihdl.addDiscoveredInterfaces(outInf);
            }
            gihdl.addDiscoveredInterfacesList(interfaceList);
            Hashtable primaryGroupMap = new Hashtable();
            Hashtable secondaryGroupMap = new Hashtable();
            ArrayList<String> disGroups = new ArrayList<String>();
            VerificationResultSet groupResultSet = cvu.getUserGroups(nodeListArr, primaryGroupMap, secondaryGroupMap);
            if (groupResultSet.getOverallStatus() == OverallStatus.SUCCESSFUL) {
                Trace.out((String)"Successfully discovered groups");
                Collection groupVals = primaryGroupMap.values();
                int index = 0;
                String primaryGroup = null;
                for (String group : groupVals) {
                    if (++index == 1) {
                        primaryGroup = group;
                        continue;
                    }
                    if (primaryGroup.equals(group)) continue;
                    break;
                }
                Trace.out((String)("Primary group is " + primaryGroup));
                if (nodeListArr.length == index) {
                    disGroups.add(primaryGroup);
                }
                Collection secGroupVals = secondaryGroupMap.values();
                List secGroupList = (List)secondaryGroupMap.get(nodeListArr[0]);
                for (String group : secGroupList) {
                    List groupList;
                    Trace.out((String)("looking for group " + group));
                    index = 0;
                    Iterator iterator = secGroupVals.iterator();
                    while (iterator.hasNext() && (groupList = (List)iterator.next()).contains(group)) {
                        ++index;
                    }
                    if (nodeListArr.length != index) continue;
                    disGroups.add(group);
                }
            }
            String dbaGrp = "";
            String asmGrp = "";
            String operGrp = "";
            if (imgGroupsStr != null) {
                String[] imgGroups = imgGroupsStr.split(",", 3);
                if (imgGroups[0] != null && !imgGroups[0].isEmpty() && disGroups.contains(imgGroups[0])) {
                    dbaGrp = imgGroups[0];
                }
                if (imgGroups[1] != null && !imgGroups[1].isEmpty() && disGroups.contains(imgGroups[1])) {
                    operGrp = imgGroups[1];
                }
                if (imgGroups[2] != null && !imgGroups[2].isEmpty() && disGroups.contains(imgGroups[2])) {
                    asmGrp = imgGroups[2];
                }
            }
            for (String g : disGroups) {
                if (!g.equals(dbaGrp)) {
                    gihdl.addDiscoveredGroupDBA(g);
                }
                if (!g.equals(asmGrp)) {
                    gihdl.addDiscoveredGroupASM(g);
                }
                if (g.equals(operGrp)) continue;
                gihdl.addDiscoveredGroupOPER(g);
            }
            if (dbaGrp != "") {
                gihdl.addDiscoveredGroupDBA(dbaGrp);
            }
            if (operGrp != "") {
                gihdl.addDiscoveredGroupOPER(operGrp);
            }
            if (asmGrp != "") {
                gihdl.addDiscoveredGroupASM(asmGrp);
            }
            gihdl.addMandatoryTag();
            gihdl.generateResponseFile(responseFile);
        }
        catch (ClassNotFoundException e) {
            Trace.out((Exception)e);
            this.displayErrorResult(MessageBundle.getMessage((MessageKey)PrCgMsgID.UNEXPECTED_INTERNAL_ERROR, (boolean)true, (Object[])new Object[]{"RHPHELP122_discover-01"}), 2);
            return 0;
        }
        catch (IllegalAccessException e) {
            Trace.out((Exception)e);
            this.displayErrorResult(MessageBundle.getMessage((MessageKey)PrCgMsgID.UNEXPECTED_INTERNAL_ERROR, (boolean)true, (Object[])new Object[]{"RHPHELP122_discover-02"}), 2);
            return 0;
        }
        catch (InvocationTargetException e) {
            Trace.out((Object)e.getCause());
            this.displayErrorResult(e.getCause().getMessage(), 3);
            return 0;
        }
        catch (NoSuchMethodException e) {
            Trace.out((Exception)e);
            this.displayErrorResult(MessageBundle.getMessage((MessageKey)PrCgMsgID.UNEXPECTED_INTERNAL_ERROR, (boolean)true, (Object[])new Object[]{"RHPHELP122_discover-03"}), 2);
            return 0;
        }
        catch (VerificationException ce) {
            Trace.out((Exception)((Object)ce));
            this.displayErrorResult(ce.getMessage(), 3);
            return 0;
        }
        catch (GIResponseFileHandlerException e) {
            Trace.out((Exception)e);
            this.displayErrorResult(e.getMessage(), 3);
            return 0;
        }
        Trace.out((String)"Exit discover method");
        if (errMsg.length() > 0) {
            this.displayErrorResult(errMsg, 3);
        }
        return 0;
    }

    private boolean checkFixupResults(VerificationTask verTask, List resultList, StringBuilder allTaskStatus) throws VerificationException {
        String failedNodesString = null;
        StringBuilder nodeSpecificErr = new StringBuilder();
        String taskName = null;
        String taskDescr = null;
        taskName = verTask.getElementName();
        taskDescr = verTask.getDescription();
        Trace.out((String)("CVU Fixup task name is " + taskName));
        Trace.out((String)("CVU Fixup task description is " + taskDescr));
        FixupResultSet set = null;
        Object[] msgArgs = new Object[]{taskName};
        if (!verTask.hasSubtasks()) {
            allTaskStatus.append(LSEP);
            set = verTask.getFixupResultSet();
            if (set == null) {
                Trace.out((String)("No result set found  for " + taskName + ", ignoring.."));
                allTaskStatus.append(MessageBundle.getMessage((MessageKey)PrCgMsgID.FIXUP_TASK_UNKNOWN, (boolean)true, (Object[])msgArgs));
                return false;
            }
            if (set.getFixupOverallStatus() != FixupOverallStatus.SUCCESSFUL) {
                for (VerificationError vfe : set.getErrors()) {
                    resultList.add(vfe.getErrorMessage());
                }
            } else {
                allTaskStatus.append(MessageBundle.getMessage((MessageKey)PrCgMsgID.FIXUP_TASK_SUCCESSFUL, (boolean)true, (Object[])msgArgs));
                return true;
            }
            List failedNodes = set.getFailedNodes();
            if (failedNodes.size() > 0) {
                Trace.out((String)("Verification failed on " + failedNodes.size() + " nodes"));
            }
            for (String nodeName : failedNodes) {
                Trace.out((String)("Failed Node ==> " + nodeName));
                if (nodeSpecificErr.length() > 0) {
                    nodeSpecificErr.append(LSEP);
                }
                failedNodesString = failedNodesString != null ? failedNodesString + "," + nodeName : nodeName;
                try {
                    FixupResult vr = set.getResult(nodeName);
                    List verErrList = vr.getErrors();
                    for (VerificationError verErr : verErrList) {
                        Trace.out((String)("Failed Node msg ==> " + verErr.getErrorMessage()));
                        resultList.add(verErr.getErrorMessage());
                        nodeSpecificErr.append(nodeName + "  " + verErr.getErrorMessage());
                    }
                }
                catch (NodeResultsUnavailableException e) {
                    Trace.out((String)("Got NodeResultsUnavailableException " + e.getMessage()));
                    resultList.add(e.getMessage());
                    nodeSpecificErr.append(nodeName + " : " + e.getMessage());
                }
                catch (InvalidFixupNodeException e) {
                    Trace.out((String)("Got NodeResultsUnavailableException " + e.getMessage()));
                    nodeSpecificErr.append(nodeName + " : " + e.getMessage());
                    resultList.add(e.getMessage());
                }
            }
            Object[] msgArgs1 = new Object[]{taskName, failedNodesString};
            allTaskStatus.append(MessageBundle.getMessage((MessageKey)PrCgMsgID.FIXUP_TASK_FAILED, (boolean)true, (Object[])msgArgs1));
            if (nodeSpecificErr.length() > 0) {
                allTaskStatus.append(LSEP);
                allTaskStatus.append((CharSequence)nodeSpecificErr);
            }
            return false;
        }
        return true;
    }

    @Override
    public int isSharedPath(String[] args) {
        Trace.out((int)2, (String)"Entry");
        try {
            boolean isShared = false;
            String nodes = null;
            if (!args[1].equals("null")) {
                nodes = args[1];
                Trace.out((String)("Node list is...." + nodes));
            }
            String dirPath = null;
            if (args[2].equals("null")) {
                this.displayErrorResult(MessageBundle.getMessage((MessageKey)PrCgMsgID.UNEXPECTED_INTERNAL_ERROR, (boolean)true, (Object[])new Object[]{"RHPHELP122_isShared-01"}), 2);
                return 1;
            }
            dirPath = args[2];
            Trace.out((String)("Dir path is...." + dirPath));
            String[] nodeList = null;
            if (nodes == null) {
                ClusterwareInfo clustInfo = new ClusterwareInfo();
                String crsHome = clustInfo.getCRSHome(new Version());
                List clustNodes = clustInfo.getActiveClusterNodes(crsHome);
                Trace.out((String)("cluster nodes = " + clustNodes.toString()));
                nodeList = clustNodes.toArray(new String[clustNodes.size()]);
            } else {
                nodeList = nodes.split(",");
            }
            if (nodeList.length == 0) {
                this.displayErrorResult(MessageBundle.getMessage((MessageKey)PrCgMsgID.UNEXPECTED_INTERNAL_ERROR, (boolean)true, (Object[])new Object[]{"RHPHELP122_isShared-02"}), 2);
                return 1;
            }
            if (nodeList.length > 1) {
                isShared = Cluster.isSharedPath((String)dirPath, (String[])nodeList);
            }
            this.displaySuccessResult(new Boolean(isShared).toString(), 0);
            return 0;
        }
        catch (InstallException e) {
            Trace.out((String)("InstallException: " + e.getMessage()));
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        catch (InvalidNodeListException e) {
            Trace.out((String)("InvalidNodeListException: " + e.getMessage()));
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        catch (SharedDeviceException e) {
            Trace.out((String)("SharedDeviceException: " + e.getMessage()));
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
    }

    @Override
    public int getServiceInfo(String[] args) {
        Trace.out((String)"retrieving service info ...");
        try {
            Filter svcsFilter = FilterFactoryImpl.getFilter4ResourceType((String)ResourceType.Service.NAME.toString());
            Filter stateFilter = FilterFactoryImpl.getFilter4RunningState();
            svcsFilter = FilterFactoryImpl.getExpressionFilter((Filter.Operator)Filter.Operator.AND, (Filter)svcsFilter, (Filter)stateFilter);
            CRSFactoryImpl cf = CRSFactoryImpl.getInstance();
            Map searchResults = cf.searchEntities(CRSEntity.Type.ResourceInstance, false, svcsFilter, new String[]{ResourceType.Service.NAME.name()});
            DatabaseFactory df = DatabaseFactory.getInstance();
            Map dbInfos = df.getDatabaseInfos();
            ArrayList svcNames = new ArrayList();
            ArrayList<Service> svcs = new ArrayList<Service>();
            for (Object key : searchResults.keySet()) {
                Map val = (Map)searchResults.get(key);
                String resName = (String)val.get(ResourceType.Service.NAME.name());
                if (svcNames.contains(resName)) continue;
                List<String> splitList = this.processServiceResName(resName);
                String dbName = splitList.get(0);
                String svcName = splitList.get(1);
                Version dbVer = (Version)((LinkedList)dbInfos.get(dbName)).getLast();
                Trace.out((String)"getting service %s of db %s", (Object[])new Object[]{dbName, svcName});
                svcs.add(df.getService(dbName, svcName, dbVer));
            }
            if (svcs.isEmpty()) {
                this.displaySuccessResult("", 0);
                return 0;
            }
            Trace.out((Object)"Starting svcs %s ...", (String)((Object)svcNames).toString());
            try {
                df.getDBServicesSelection(svcs).start();
            }
            catch (InvalidArgsException e) {
                Trace.out((Exception)((Object)e));
            }
            catch (AlreadyRunningException e) {
                Trace.out((Exception)((Object)e));
            }
            catch (CompositeOperationException e) {
                Trace.out((Exception)((Object)e));
            }
            catch (ServiceException e) {
                Trace.out((Exception)((Object)e));
            }
            StringBuilder result = new StringBuilder();
            for (Service svc : svcs) {
                result.append(svc.getName());
                result.append(";");
                ServerGroup srvGrp = svc.getServerGroup();
                List allNodes = srvGrp.servers();
                if (allNodes != null && !allNodes.isEmpty()) {
                    result.append(Utils.list2String((List)allNodes, (String)","));
                }
                result.append(";");
                CRSResource crsRes = svc.crsResource();
                List onlineNodes = crsRes.fetchRunningNodes();
                if (onlineNodes != null && !onlineNodes.isEmpty()) {
                    result.append(Utils.nodeList2String((List)onlineNodes, (String)","));
                }
                result.append(";");
                List disabledNodes = crsRes.fetchDisabledNodes();
                if (disabledNodes != null && !disabledNodes.isEmpty()) {
                    result.append(Utils.nodeList2String((List)disabledNodes, (String)","));
                }
                result.append("=###=");
            }
            String print = "";
            if (result.length() > 0) {
                print = result.substring(0, result.length() - "=###=".length());
            }
            this.displaySuccessResult(print, 0);
            return 0;
        }
        catch (CRSException e) {
            Trace.out((Exception)((Object)e));
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        catch (DatabaseException e) {
            Trace.out((Exception)((Object)e));
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        catch (InvalidArgsException e) {
            Trace.out((Exception)((Object)e));
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        catch (NodeException e) {
            Trace.out((Exception)((Object)e));
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        catch (NotExistsException e) {
            Trace.out((Exception)((Object)e));
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        catch (ServerGroupException e) {
            Trace.out((Exception)((Object)e));
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        catch (SoftwareModuleException e) {
            Trace.out((Exception)((Object)e));
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
    }

    @Override
    public int relocateServices(String[] args) {
        Trace.out((String)"relocating services ...");
        ArrayList<String> nodes = new ArrayList<String>(Arrays.asList(args[1].split(",")));
        Trace.out((Object)"source nodes are %s ", (String)((Object)nodes).toString());
        try {
            DatabaseFactory df = DatabaseFactory.getInstance();
            ServiceStopArgs stopArgs = new ServiceStopArgs();
            stopArgs.setForceFlag(true);
            df.getDBServicesSelectionByNodes(nodes).relocate(nodes, stopArgs);
            return 0;
        }
        catch (CompositeOperationException e) {
            Trace.out((Exception)((Object)e));
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        catch (NotRunningException e) {
            Trace.out((Exception)((Object)e));
            return 0;
        }
        catch (SoftwareModuleException e) {
            Trace.out((Exception)((Object)e));
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
    }

    public int transferNoUserEq(String[] args) {
        String oracleHomePath = args[1];
        String[] nodeNames = args[2].split(",");
        String srcPath = args[3];
        String[] destPath = args[4].split(",");
        String sudoUser = args[5];
        String sudoPath = args[6];
        String asUser = args[7];
        String password = null;
        boolean isRoot = args[5].equals("-root");
        RemoteUserInfo uinfo = null;
        try {
            Trace.out((String)"Reading sudo password ...");
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            password = in.readLine();
            uinfo = isRoot ? new RemoteUserInfo(password) : new RemoteUserInfo(sudoUser, password, sudoPath);
            new RACTransfer().transferDirStructureToNodes(oracleHomePath, nodeNames, srcPath, null, true, null, true, "/tmp/", destPath, uinfo, asUser);
            return 0;
        }
        catch (IOException | RemoteFileOpException | ClusterException e) {
            Trace.out((String)("Failed to transfer dir structure without user equivalence because of exception " + e.getClass().getName() + ": " + e.getMessage()));
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
    }

    public int checkPatchedBugs(String[] args) {
        Trace.out((int)2, (String)"Entry");
        Trace.out((Object)"Framework home is: %s", (String)args[1]);
        Trace.out((Object)"Oracle Home is: %s", (String)args[2]);
        Trace.out((Object)"Bug numbers are: %s", (String)args[3]);
        Trace.out((Object)"Nodes are: %s", (String)args[4]);
        Trace.out((Object)"isRacHome: %s", (String)args[5]);
        Trace.out((Object)"oracleHomeVer %s", (String)args[6]);
        String frameworkHome = args[1];
        String oracleHome = args[2];
        String[] bugNums = args[3].split(",");
        String[] nodes = args[4].split(",");
        Boolean isRacHome = Boolean.parseBoolean(args[5]);
        String oracleHomeVer = args[6];
        StringBuilder allErrMsg = new StringBuilder();
        try {
            ClusterVerification cvu = ClusterVerification.getInstance((String)frameworkHome, (ClusterVerification.PathType)ClusterVerification.PathType.FRAMEWORK_HOME);
            cvu.setVariableValue("RAC_VERSION", oracleHomeVer);
            cvu.setVariableValue("CV_RAC_HOME", frameworkHome);
            Hashtable result = cvu.checkOraclePatches(oracleHome, nodes, bugNums, isRacHome.booleanValue());
            for (String bug : result.keySet()) {
                String errMsg = this.getErrorMessage(result.get(bug));
                if (errMsg.isEmpty()) continue;
                allErrMsg.append(errMsg);
            }
            if (!allErrMsg.toString().isEmpty()) {
                Trace.out((Object)"Error Message is %s ", (String)allErrMsg.toString());
                this.displayWarningResult(allErrMsg.toString(), 1);
                return 2;
            }
            return 0;
        }
        catch (InvocationTargetException | InvalidPathException | VerificationException e) {
            Trace.out((String)"Attempt to check if Oracle home has specific patches failed with %s: %s", (Object[])new Object[]{e.getClass().getSimpleName(), e.getMessage()});
            this.displayErrorResult(e.getMessage(), 3);
            return 0;
        }
        catch (NoSuchMethodException e) {
            Trace.out((String)"Attempt to check if Oracle home has specific patches failed with %s: %s", (Object[])new Object[]{e.getClass().getSimpleName(), e.getMessage()});
            this.displayErrorResult(MessageBundle.getMessage((MessageKey)PrCgMsgID.UNEXPECTED_INTERNAL_ERROR, (boolean)true, (Object[])new Object[]{"RHPHELP122_checkPatchedBugs-01"}), 2);
            return 0;
        }
        catch (ClassNotFoundException e) {
            Trace.out((String)"Attempt to check if Oracle home has specific patches failed with %s: %s", (Object[])new Object[]{e.getClass().getSimpleName(), e.getMessage()});
            this.displayErrorResult(MessageBundle.getMessage((MessageKey)PrCgMsgID.UNEXPECTED_INTERNAL_ERROR, (boolean)true, (Object[])new Object[]{"RHPHELP122_checkPatchedBugs-02"}), 2);
            return 0;
        }
        catch (IllegalAccessException e) {
            Trace.out((String)"Attempt to check if Oracle home has specific patches failed with %s: %s", (Object[])new Object[]{e.getClass().getSimpleName(), e.getMessage()});
            this.displayErrorResult(MessageBundle.getMessage((MessageKey)PrCgMsgID.UNEXPECTED_INTERNAL_ERROR, (boolean)true, (Object[])new Object[]{"RHPHELP122_checkPatchedBugs-03"}), 2);
            return 0;
        }
    }

    static {
        s_tlogger = null;
        m_msgBndl = MessageBundle.getMessageBundle((MessageKey)PrCgMsgID.facility);
        m_msgBndl.setPackage("oracle.cluster.resources");
    }
}

