/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.gridhome.giprov122;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import oracle.cluster.common.ClusterClassification;
import oracle.cluster.common.ClusterType;
import oracle.cluster.gridhome.giprov.GIResponseFileHandler;
import oracle.cluster.gridhome.giprov.GIResponseFileHandlerException;
import oracle.cluster.gridhome.giprov122.ClusterConfiguration;

public class GIResponseFileHandler122
extends GIResponseFileHandler {
    protected static final String[] INVALID_CLUSTER_CONFIGURATION = new String[]{"PrGo", "1673"};
    private static String NODE_ROLE_DEFAULT;
    private static String CLUSTER_CONFIGURATION_DEFAULT;

    public GIResponseFileHandler122(String responseFile, boolean isTemplateResponseFile) throws GIResponseFileHandlerException {
        super(responseFile, isTemplateResponseFile);
        this.validateClusterConfig();
    }

    public GIResponseFileHandler122(String responseFile, String tmpltResponseFile) throws GIResponseFileHandlerException {
        super(responseFile, tmpltResponseFile);
        this.validateClusterConfig();
    }

    public boolean getExecuteRootScript() {
        String executeRootScript = this.get((String)s_rspParams.get("EXECUTE_ROOT_SCRIPT"));
        if (executeRootScript != null) {
            executeRootScript = executeRootScript.trim();
        }
        return Boolean.valueOf(executeRootScript);
    }

    public void overrideExecuteRootScript(boolean executeRootScript) {
        this.overrideParams((String)s_rspParams.get("EXECUTE_ROOT_SCRIPT"), Boolean.toString(executeRootScript));
    }

    @Override
    public void overrideNodeList(String nodeList) {
        if (null == nodeList) {
            return;
        }
        String[] nodes = nodeList.split(",");
        for (int iter = 0; iter < nodes.length; ++iter) {
            String[] nodeArr = nodes[iter].split(":");
            if (nodeArr.length == 3 || nodeArr.length != 2) continue;
            nodes[iter] = nodes[iter] + ":" + NODE_ROLE_DEFAULT;
        }
        this.overrideParams((String)s_rspParams.get("CLUSTER_NODES"), this.list2String(Arrays.asList(nodes), ","));
    }

    public ClusterType getClusterType() {
        String clusterConfig = this.get((String)s_rspParams.get("CLUSTER_CONFIGURATION"));
        if (clusterConfig == null) {
            return ClusterType.FLEX;
        }
        if (clusterConfig.equalsIgnoreCase(ClusterConfiguration.MEMBERAPP.toString())) {
            return ClusterType.APPLICATION;
        }
        return ClusterType.FLEX;
    }

    public String getClusterMode() {
        String clusterMode = "FLEX";
        return clusterMode;
    }

    public ClusterClassification getClusterClassification() {
        String clusterConfig = this.get((String)s_rspParams.get("CLUSTER_CONFIGURATION"));
        if (clusterConfig == null) {
            return ClusterClassification.STANDALONE_CLUSTER;
        }
        if (clusterConfig.equalsIgnoreCase(ClusterConfiguration.DOMAIN.toString())) {
            return ClusterClassification.DOMAIN_CLUSTER;
        }
        if (clusterConfig.equalsIgnoreCase(ClusterConfiguration.STANDALONE.toString())) {
            return ClusterClassification.STANDALONE_CLUSTER;
        }
        return ClusterClassification.MEMBER_CLUSTER;
    }

    public String getClusterManifestFile() {
        return this.get((String)s_rspParams.get("CLUSTER_MANIFEST_FILE"));
    }

    private void validateClusterConfig() throws GIResponseFileHandlerException {
        String clusterConfig = this.get((String)s_rspParams.get("CLUSTER_CONFIGURATION"));
        if (!(clusterConfig == null || clusterConfig.equalsIgnoreCase(ClusterConfiguration.DOMAIN.toString()) || clusterConfig.equalsIgnoreCase(ClusterConfiguration.STANDALONE.toString()) || clusterConfig.equalsIgnoreCase(ClusterConfiguration.MEMBERDB.toString()) || clusterConfig.equalsIgnoreCase(ClusterConfiguration.MEMBERAPP.toString()))) {
            throw new GIResponseFileHandlerException(this.genTagExceptionMsg(INVALID_CLUSTER_CONFIGURATION, new String[]{clusterConfig}));
        }
    }

    @Override
    public void overrideGNSClientData(String gnsClientData) {
        if (null == gnsClientData) {
            return;
        }
        this.overrideParams((String)s_rspParams.get("CONFIG_GNS"), "true");
        this.overrideParams((String)s_rspParams.get("CREATE_GNS"), "USE_SHARED_GNS");
        this.overrideParams((String)s_rspParams.get("GNS_CLIENT_FILE_122"), gnsClientData);
        m_manifestFileFromCLI = true;
    }

    @Override
    public void overrideASMClientData(String asmClientData) {
        if (null == asmClientData) {
            return;
        }
        this.overrideParams((String)s_rspParams.get("STORAGE_OPTION"), "CLIENT_ASM_STORAGE");
        this.overrideParams((String)s_rspParams.get("ASM_CLIENT_FILE_122"), asmClientData);
        m_manifestFileFromCLI = true;
    }

    public void overrideClusterManifestFile(String manifestFile) {
        if (manifestFile == null) {
            this.Trace("memberClusterManifestFile parameter will not be over-written");
            return;
        }
        this.overrideParams((String)s_rspParams.get("CLUSTER_MANIFEST_FILE"), manifestFile);
        m_manifestFileFromCLI = true;
    }

    @Override
    public void isValidResponseFile() throws GIResponseFileHandlerException {
        ArrayList<String> paramArrList = new ArrayList<String>();
        if (null == this.get((String)s_rspParams.get("CLUSTER_NAME"))) {
            paramArrList.add("CLUSTER_NAME");
        }
        if (null == this.get((String)s_rspParams.get("CLUSTER_NODES"))) {
            paramArrList.add("NODELIST");
        }
        if (null == this.get((String)s_rspParams.get("ORACLE_HOME"))) {
            paramArrList.add("ORACLE_HOME");
        }
        if (null == this.get((String)s_rspParams.get("OSDBA_GROUP"))) {
            paramArrList.add("OSDBA_GROUP");
        }
        if (null == this.get((String)s_rspParams.get("OSASM_GROUP"))) {
            paramArrList.add("OSASM_GROUP");
        }
        if (null == this.get((String)s_rspParams.get("NETWORK_INTERFACE"))) {
            paramArrList.add("NETWORK_INTERFACE");
        }
        String storageOpt = this.get((String)s_rspParams.get("STORAGE_OPTION"));
        String clusterType = this.get((String)s_rspParams.get("CLUSTER_CONFIGURATION"));
        if (clusterType != null && !clusterType.equals(CLUSTER_TYPE_APPLICATION) && storageOpt != null && !storageOpt.equals(STORAGE_OPTION_ASMCLIENT)) {
            if (null == this.get((String)s_rspParams.get("SYS_ASM_PASS"))) {
                paramArrList.add("SYS_ASM_PASS");
            }
            if (null == this.get((String)s_rspParams.get("ASM_MONITOR_PASS"))) {
                paramArrList.add("ASM_MONITOR_PASS");
            }
        }
        if (null == this.get((String)s_rspParams.get("INVENTORY"))) {
            paramArrList.add("INVENTORY");
        }
        if (!paramArrList.isEmpty()) {
            String paramString = this.list2String(paramArrList, ",");
            this.Trace("Mandatory parameters not set :" + paramString);
            throw new GIResponseFileHandlerException(this.genTagExceptionMsg(PARAM_NOT_SET, new String[]{paramString}));
        }
    }

    @Override
    protected void fillDefaults() throws GIResponseFileHandlerException {
        this.isGeneratableResponseFile();
        String oracleHomeParentDir = new File(this.get((String)s_rspParams.get("ORACLE_HOME"))).getParent();
        String INVENTORY_DEFAULT = oracleHomeParentDir + FILE_SEPARATOR + INVENTORY_DIR;
        String ORACLE_BASE_DEFAULT = oracleHomeParentDir + FILE_SEPARATOR + BASE_DIR;
        HashMap defaultMap = new HashMap();
        defaultMap.put(s_rspParams.get("SCAN_PORT"), SCAN_PORT_DEFAULT);
        defaultMap.put(s_rspParams.get("ORACLE_BASE"), ORACLE_BASE_DEFAULT);
        defaultMap.put(s_rspParams.get("INVENTORY"), INVENTORY_DEFAULT);
        defaultMap.put(s_rspParams.get("CONFIG_GNS"), CONFIG_GNS_DEFAULT);
        defaultMap.put(s_rspParams.get("INSTALL_OPTION"), INSTALL_OPTION_DEFAULT);
        defaultMap.put(s_rspParams.get("STORAGE_OPTION"), STORAGE_OPTION_DEFAULT);
        defaultMap.put(s_rspParams.get("DISKGROUP"), DISKGROUP_DEFAULT);
        defaultMap.put(s_rspParams.get("ALLOCATION_UNIT"), ALLOCATION_UNIT_DEFAULT);
        defaultMap.put(s_rspParams.get("CLUSTER_CONFIGURATION"), CLUSTER_CONFIGURATION_DEFAULT);
        defaultMap.put(s_rspParams.get("IGNORE_DOWN_NODES"), IGNORE_DOWN_NODES_DEFAULT);
        Set defaultMapSet = defaultMap.keySet();
        for (String s : defaultMapSet) {
            int i;
            if (!this.isDefaultRequired(s)) continue;
            for (i = 0; i < this.m_rspFileAsList.size() && !((String)this.m_rspFileAsList.get(i)).startsWith(s); ++i) {
            }
            this.m_rspFileAsList.remove(i);
            this.m_rspFileAsList.add(i, "#RHP_DEFAULT");
            this.m_rspFileAsList.add(i + 1, s + "=" + (String)defaultMap.get(s));
        }
    }

    static {
        s_rspParams.put("CLUSTER_CONFIGURATION", "oracle.install.crs.config.ClusterConfiguration");
        s_rspParams.put("GNS_CLIENT_FILE_122", "oracle.install.crs.config.memberClusterManifestFile");
        s_rspParams.put("ASM_CLIENT_FILE_122", "oracle.install.crs.config.memberClusterManifestFile");
        s_rspParams.put("CLUSTER_MANIFEST_FILE", "oracle.install.crs.config.memberClusterManifestFile");
        s_rspParams.put("EXECUTE_ROOT_SCRIPT", "oracle.install.crs.rootconfig.executeRootScript");
        NODE_ROLE_DEFAULT = "HUB";
        CLUSTER_CONFIGURATION_DEFAULT = "STANDALONE";
    }
}

