/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.gridhome.giprov122;

import java.util.Arrays;
import oracle.cluster.gridhome.giprov.GIResponseFileHandler;
import oracle.cluster.gridhome.giprov.GIResponseFileHandlerException;

public class GIResponseFileHandler12102
extends GIResponseFileHandler {
    protected static final String[] INVALID_CLUSTER_TYPE = new String[]{"PrGo", "1653"};
    private static String NODE_ROLE_DEFAULT = "HUB";

    public GIResponseFileHandler12102(String responseFile, boolean isTemplateResponseFile) throws GIResponseFileHandlerException {
        super(responseFile, isTemplateResponseFile);
        this.validateClusterMode();
    }

    public GIResponseFileHandler12102(String responseFile, String tmpltResponseFile) throws GIResponseFileHandlerException {
        super(responseFile, tmpltResponseFile);
        this.validateClusterMode();
    }

    public String getClusterMode() {
        String clusterConfig = this.get((String)s_rspParams.get("CLUSTER_TYPE"));
        if (clusterConfig == null) {
            String flex = "FLEX";
            return flex;
        }
        return clusterConfig;
    }

    public void validateClusterMode() throws GIResponseFileHandlerException {
        String flex = "FLEX";
        String standard = "STANDARD";
        String clusterConfig = this.get((String)s_rspParams.get("CLUSTER_TYPE"));
        if (clusterConfig != null && !clusterConfig.equalsIgnoreCase(flex) && !clusterConfig.equalsIgnoreCase(standard)) {
            throw new GIResponseFileHandlerException(this.genTagExceptionMsg(INVALID_CLUSTER_TYPE, new String[]{clusterConfig}));
        }
    }

    @Override
    public void overrideNodeList(String nodeList) {
        if (null == nodeList) {
            return;
        }
        String[] nodes = nodeList.split(",");
        for (int iter = 0; iter < nodes.length; ++iter) {
            String[] nodeArr = nodes[iter].split(":");
            if (nodeArr.length == 3 || nodeArr.length != 2) continue;
            nodes[iter] = nodes[iter] + ":" + NODE_ROLE_DEFAULT;
        }
        this.overrideParams((String)s_rspParams.get("CLUSTER_NODES"), this.list2String(Arrays.asList(nodes), ","));
    }
}

