/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.gridhome.giprov;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class RHPHelper {
    public static final String LSEP = System.getProperty("line.separator");
    public static final String FSEP = System.getProperty("file.separator");
    public static final String DOT = "\\.";
    public static final String DELIM1 = ",";
    public static final String DELIM2 = ";";
    public static final String DELIM3 = "=###=";
    public static final String EQUALS = "=";
    public static final String CLOSE_PAREN = ")";
    public static final int GET_SERVICE_INFO_NUM_FIELDS = 4;
    public static final String HELPER_OUTPUT_TAG_START = "<HLP_OUT>";
    public static final String HELPER_OUTPUT_TAG_END = "</HLP_OUT>";
    public static final String HELPER_ERROR_TAG_START = "<HLP_EMSG>";
    public static final String HELPER_ERROR_TAG_END = "</HLP_EMSG>";
    public static final String HELPER_EXEC_ERROR_TAG_START = "<HLP_IEEMSG>";
    public static final String HELPER_EXEC_ERROR_TAG_END = "</HLP_IEEMSG>";
    public static final String HELPER_WARN_TAG_START = "<HLP_WMSG>";
    public static final String HELPER_WARN_TAG_END = "</HLP_WMSG>";
    public static final String HELPER_ERES_TAG_START = "<HLP_ERES>";
    public static final String HELPER_ERES_TAG_END = "</HLP_ERES>";
    public static final int HELPER_EXEC_PASS_VALUE = 0;
    public static final int HELPER_EXEC_ERROR_VALUE = 1;
    public static final int HELPER_EXEC_WARN_VALUE = 2;
    public static final String HELPER_VRES_TAG_START = "<HLP_VRES>";
    public static final String HELPER_VRES_TAG_END = "</HLP_VRES>";
    public static final int HELPER_VRES_SUCC_VALUE = 0;
    public static final int HELPER_VRES_WARN_VALUE = 1;
    public static final int HELPER_VRES_FAIL_VALUE = 2;
    public static final int HELPER_VRES_EXPN_VALUE = 3;
    public static final String CMD_GET_ORA_OWNER = "-getOracleUser";
    public static final String CMD_GET_INVENTORY = "-getInventory";
    public static final String CMD_GET_ORACLE_HOMES = "-getOracleHomes";
    public static final String CMD_COPY_DB_FILES = "-copydbs";
    public static final String CMD_TRANSFER = "-transfer";
    public static final String CMD_TRANSFERNOUSEREQ = "-transferNoUserEq";
    public static final String CMD_MERGE_LISTENERORA = "-mergeListenerOra";
    public static final String CMD_MERGE_TNSNAMES = "-mergeTNSNames";
    public static final String CMD_MERGE_SQLNETORA = "-mergeSqlNetOra";
    public static final String CMD_IS_SHARED_PATH = "isSharedPath";
    public static final String CMD_CHECK_ENOUGH_SPACE = "-checkEnoughSpace";
    public static final String CMD_VERIFY = "-verify";
    public static final String CMD_VERIFY_UPGRADE = "-verifyUpgrade";
    public static final String CMD_DISCOVER = "-discover";
    public static final String CMD_MOVEDB = "-moveDatabase";
    public static final String CMD_GET_DB_INFO = "-getDBInfo";
    public static final String CMD_GET_DB_TYPE = "-getDBType";
    public static final String CMD_IS_DB_RUNNING = "-isDBRunning";
    public static final String CMD_GET_DB_STOP_NODE = "-getDBStopNode";
    public static final String CMD_COPYDIR = "-copyDir";
    public static final String CMD_GET_CLUSTER_NAME = "-getClusterName";
    public static final String CMD_GET_CLUSTER_NODES = "-getClusterNodes";
    public static final String CMD_GET_CLUSTER_NODES_ROLES = "-getClusterNodesRoles";
    public static final String CMD_GET_HIST_CLUSTER_NODES = "-getHistoricalClusterNodes";
    public static final String CMD_STOP_CLUSTER = "-stopCluster";
    public static final String CMD_STOP_LISTENER = "-stopListener";
    public static final String CMD_GET_RUNNING_NODES = "-getRunningNodes";
    public static final String CMD_GET_SERVICE_INFO = "-getServiceInfo";
    public static final String CMD_GET_HUB_NODES = "-getHubNodes";
    public static final String CMD_GET_ADMIN_DBS = "-getAdminManagedDatabases";
    public static final String CMD_GET_RAC_DBS = "-getCardinalDatabases";
    public static final String CMD_RELOCATE_SVCS = "-relocateServices";
    public static final String CMD_RELOCATE_SVC = "-relocateService";
    public static final String CMD_UPDATE_ORATAB = "-updateOratab";
    public static final String CMD_CHECK_PATCHED_BUGS = "-checkPatchedBugs";
    public static final String CMD_START_DBS = "-startDatabases";
    public static final String CMD_STOP_DBS = "-stopDatabases";
    public static final String CMD_START_SERVICES = "-startServices";
    public static final String CMD_STOP_SERVICES = "-stopServices";
    public static final String OPTION_IGNOREWARN = "-ignorewarn";
    public static final String OPTION_FIXUP = "-fixup";
    public static final String OPTION_SETUPSSH = "-setupSSH";
    public static final String OPTION_ROOT = "-root";
    public static final String OPTION_NOT_SPECIFIED = "NOT_SPECIFIED";
    public static final String CVU_INSTALL_OPTION = "INSTALL_OPTION";
    public static final String CVU_INSTALL_OPT_UPGRADE = "UPGRADE";
    public static final String CVU_CRS_HOME_VAR = "CRS_HOME";
    public static final String CVU_RHP_MOUNT_VAR = "RHP_MOUNT";
    public static final String CVU_RHP_MOUNT_VALUE = "true";
    public static final String CVU_RAC_VERSION = "RAC_VERSION";
    public static final String CVU_CV_RAC_HOME = "CV_RAC_HOME";
    protected static final String METHOD_GET_ORA_OWNER = "getOracleHomeOwner";
    protected static final String METHOD_GET_INVENTORY = "getInventoryLoc";
    protected static final String METHOD_GET_ORACLE_HOMES = "getOracleHomes";
    protected static final String METHOD_COPY_DB_FILES = "copyDBFiles";
    protected static final String METHOD_TRANSFER = "transfer";
    protected static final String METHOD_TRANSFERNOUSEREQ = "transferNoUserEq";
    protected static final String METHOD_MERGE_LISTENERORA = "mergeListenerOra";
    protected static final String METHOD_MERGE_SQLNETORA = "mergeSqlNetOra";
    protected static final String METHOD_MERGE_TNSNAMES = "mergeTNSNames";
    protected static final String METHOD_VERIFY = "verify";
    protected static final String METHOD_VERIFY_UPGRADE = "verifyUpgrade";
    protected static final String METHOD_CHECK_ENOUGH_SPACE = "checkEnoughSpace";
    protected static final String METHOD_DISCOVER = "discover";
    protected static final String METHOD_MOVEDB = "moveDatabase";
    protected static final String METHOD_GET_DB_INFO = "getDBInfo";
    protected static final String METHOD_GET_DB_TYPE = "getDBType";
    protected static final String METHOD_IS_DB_RUNNING = "isDBRunning";
    protected static final String METHOD_GET_DB_STOP_NODE = "getDBStopNode";
    protected static final String METHOD_COPYDIR = "copyDir";
    protected static final String METHOD_GET_CLUSTER_NAME = "getClusterName";
    protected static final String METHOD_GET_CLUSTER_NODES = "getClusterNodes";
    protected static final String METHOD_GET_CLUSTER_NODES_ROLES = "getClusterNodesRoles";
    protected static final String METHOD_GET_HIST_CLUSTER_NODES = "getHistoricalClusterNodes";
    protected static final String METHOD_STOP_CLUSTER = "stopCluster";
    protected static final String METHOD_STOP_LISTENER = "stopListener";
    protected static final String METHOD_GET_RUNNING_NODES = "getRunningNodes";
    protected static final String METHOD_GET_SERVICE_INFO = "getServiceInfo";
    protected static final String METHOD_GET_HUB_NODES = "getHubNodes";
    protected static final String METHOD_GET_ADMIN_DBS = "getAdminManagedDBs";
    protected static final String METHOD_GET_RAC_DBS = "getCardinalDBs";
    protected static final String METHOD_RELOCATE_SVCS = "relocateServices";
    protected static final String METHOD_RELOCATE_SVC = "relocateService";
    protected static final String METHOD_UPDATE_ORATAB = "updateOratab";
    protected static final String METHOD_CHECK_PATCHED_BUGS = "checkPatchedBugs";
    protected static final String METHOD_START_DBS = "startDatabases";
    protected static final String METHOD_STOP_DBS = "stopDatabases";
    protected static final String METHOD_START_SERVICES = "startServices";
    protected static final String METHOD_STOP_SERVICES = "stopServices";
    protected static final String TNSNAMES_FILE = "tnsnames.ora";
    protected static final String TNSNAMES_FILE_DIR = File.separator + "network" + File.separator + "admin";
    protected static final String TNSNAMES_FILE_PATH = TNSNAMES_FILE_DIR + File.separator + "tnsnames.ora";
    protected static final String LISTENER_FILE = "listener.ora";
    protected static final String LISTENER_FILE_PATH = TNSNAMES_FILE_DIR + File.separator + "listener.ora";
    public static final String SQLNET_FILE = "sqlnet.ora";
    public static final String SQLNET_FILE_PATH = TNSNAMES_FILE_DIR + File.separator + "sqlnet.ora";
    protected static final String TMP_LOC = System.getProperty("java.io.tmpdir");
    protected static final String MV_DB_PROG_MSG_STOP_INST = "stopping instances of databases \"%s\" on node %s ...";
    protected static final String MV_DB_PROG_MSG_START_INST = "starting instances of databases \"%s\" on node %s ...";
    protected static final String MV_DB_PROG_MSG_STOP_DB = "stopping databases \"%s\" ...";
    protected static final String MV_DB_PROG_MSG_START_DB = "starting databases \"%s\" ...";
    private static String[] m_args;
    private static String TRACE_SRVMHELPER_FNAME;
    private static final String FILE_SEP;
    private ArrayList<CommandLineOption> m_cmdLineOptList = null;
    private Method m_outMethod = null;
    private boolean m_useTags = true;
    private static final String WALLET_LOCATION = "WALLET_LOCATION";
    private static final String DIRECTORY_KEYWORD = "DIRECTORY";
    private static final String METHOD_KEYWORD = "METHOD";
    private static final String FILE_KEYWORD = "FILE";
    private static final String FILE_NOT_FOUND = "PRCF-1003";

    public RHPHelper() {
        try {
            this.setupTracing();
            if (System.getSecurityManager() == null) {
                Class<?> nullSecurityManagerCls = Class.forName("oracle.ops.mgmt.security.NullSecurityManager");
                Class[] noParam = new Class[]{};
                Object noArg = null;
                Constructor<?> secManagerConst = nullSecurityManagerCls.getConstructor(new Class[0]);
                Object secManagerObject = secManagerConst.newInstance(new Object[0]);
                System.setSecurityManager((SecurityManager)secManagerObject);
                this.Trace("Security manager is set");
            }
        }
        catch (ClassNotFoundException e) {
            this.Trace("Security manager is not set :" + e.getMessage());
        }
        catch (NoSuchMethodException e) {
            this.Trace("Security manager is not set :" + e.getMessage());
        }
        catch (InstantiationException e) {
            this.Trace("Security manager is not set :" + e.getMessage());
        }
        catch (IllegalAccessException e) {
            this.Trace("Security manager is not set :" + e.getMessage());
        }
        catch (InvocationTargetException e) {
            this.Trace("Security manager is not set :" + e.getMessage());
        }
        this.m_cmdLineOptList = new ArrayList();
    }

    public int processCommandLine(String helperClassName, String methodName, String[] args) {
        try {
            this.Trace("Invoking method " + methodName);
            Class<?> helperClass = Class.forName(helperClassName);
            Class[] clsArr = new Class[]{args.getClass()};
            Method cmdMethod = helperClass.getMethod(methodName, clsArr);
            Object[] arglist = new Object[]{args};
            Integer retVal = (Integer)cmdMethod.invoke(helperClass.newInstance(), arglist);
            return retVal;
        }
        catch (NoSuchMethodException e) {
            this.Trace("NSME : " + e);
            this.displayExecutionError("RHPHELP_procCmdLine-01");
            return 1;
        }
        catch (InstantiationException e) {
            this.Trace("IE : " + e);
            this.displayExecutionError("RHPHELP_procCmdLine-02");
            return 1;
        }
        catch (ClassNotFoundException e) {
            this.Trace("CNFE : " + e);
            this.displayExecutionError("RHPHELP_procCmdLine-03");
            return 1;
        }
        catch (IllegalAccessException e) {
            this.Trace("IAE : " + e);
            this.displayExecutionError("RHPHELP_procCmdLine-04");
            return 1;
        }
        catch (InvocationTargetException e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            this.Trace("ITE : " + sw.toString());
            this.displayErrorResult("RHPHELP_procCmdLine-05", 3);
            return 1;
        }
    }

    public void addCommandLineOption(String key, int numberOfArgs, String methodName, String usageInfo) {
        CommandLineOption cmdOpt = new CommandLineOption(key, numberOfArgs, methodName, usageInfo);
        this.m_cmdLineOptList.add(cmdOpt);
    }

    private void displayUsage() {
        String usageString = "";
        for (CommandLineOption cmdOpt : this.m_cmdLineOptList) {
            String curOpt = cmdOpt.getKey();
            String usageInfo = cmdOpt.getUsageInfo();
            usageString = usageString + usageInfo + LSEP;
        }
        this.displayExecutionError(usageString);
    }

    private void displayUsage(String curOpt) {
        String usageInfo = null;
        for (CommandLineOption cmdOpt : this.m_cmdLineOptList) {
            if (!curOpt.equalsIgnoreCase(cmdOpt.getKey())) continue;
            usageInfo = cmdOpt.getUsageInfo();
            break;
        }
        if (usageInfo == null) {
            this.displayExecutionError("RHPHELP_displayUsage-01");
            return;
        }
        this.displayErrorResult(usageInfo);
    }

    public String parseArguments(String[] args) {
        boolean argsOK = false;
        boolean found = false;
        String methodName = null;
        int numberOfArgs = -1;
        String curOpt = null;
        this.Trace("number of args : " + args.length);
        this.Trace("args : " + Arrays.asList(args).toString());
        if (args.length < 1) {
            return null;
        }
        this.Trace("more than one arg found");
        for (CommandLineOption cmdOpt : this.m_cmdLineOptList) {
            curOpt = cmdOpt.getKey();
            this.Trace("cmdOpt.getKey(): " + cmdOpt.getKey());
            this.Trace("cmdOpt.getMethod(): " + cmdOpt.getMethodName());
            if (!curOpt.equalsIgnoreCase(args[0])) continue;
            found = true;
            methodName = cmdOpt.getMethodName();
            numberOfArgs = cmdOpt.getNumberOfArgs();
            String usageInfo = cmdOpt.getUsageInfo();
            break;
        }
        if (found) {
            if (numberOfArgs != 1 && args.length < numberOfArgs) {
                this.Trace("incorrect number of arguments for " + args[0]);
                return null;
            }
        } else {
            this.Trace("option not supported");
            return null;
        }
        return methodName;
    }

    public void setUseTags(boolean useTags) {
        this.m_useTags = useTags;
    }

    public void displaySuccessResult(List<String> rsltArr) {
        if (this.m_useTags) {
            System.out.println(HELPER_OUTPUT_TAG_START);
        }
        for (String rslt : rsltArr) {
            System.out.println(rslt);
        }
        if (this.m_useTags) {
            System.out.println(HELPER_OUTPUT_TAG_END);
        }
    }

    public void displaySuccessResult(String rslt) {
        if (this.m_useTags) {
            System.out.println(HELPER_OUTPUT_TAG_START);
        }
        System.out.println(rslt);
        if (this.m_useTags) {
            System.out.println(HELPER_OUTPUT_TAG_END);
        }
    }

    public void displaySuccessResult(List<String> rslt, int status) {
        this.displaySuccessResult(rslt);
        this.displayVRESStatus(status);
    }

    public void displaySuccessResult(String rslt, int status) {
        this.displaySuccessResult(rslt);
        this.displayVRESStatus(status);
    }

    public void displayWarningResult(String warning) {
        if (this.m_useTags) {
            System.out.println(HELPER_WARN_TAG_START);
        }
        System.out.println(warning);
        if (this.m_useTags) {
            System.out.println(HELPER_WARN_TAG_END);
        }
    }

    public void displayWarningResult(String warning, int status) {
        this.displayWarningResult(warning);
        this.displayVRESStatus(status);
    }

    public void displayErrorResult(String errMsg) {
        if (this.m_useTags) {
            System.out.println(HELPER_ERROR_TAG_START);
        }
        System.out.println(errMsg);
        if (this.m_useTags) {
            System.out.println(HELPER_ERROR_TAG_END);
        }
    }

    public void displayErrorResult(String errMsg, int status) {
        this.displayErrorResult(errMsg);
        this.displayVRESStatus(status);
    }

    public void displayVRESStatus(int status) {
        if (this.m_useTags) {
            System.out.println(HELPER_VRES_TAG_START + status + HELPER_VRES_TAG_END);
        }
    }

    public void displayExecutionError(String errMsg) {
        if (this.m_useTags) {
            System.out.println(HELPER_EXEC_ERROR_TAG_START);
        }
        System.out.println(errMsg);
        if (this.m_useTags) {
            System.out.println(HELPER_EXEC_ERROR_TAG_END);
            System.out.println("<HLP_ERES>1</HLP_ERES>");
        }
    }

    public void displayExecutionSuccess() {
        if (this.m_useTags) {
            System.out.println("<HLP_ERES>0</HLP_ERES>");
        }
    }

    public String genTaggedOutput(String output, String tagStart, String tagEnd) {
        return tagStart + output + tagEnd;
    }

    protected void Trace(String text) {
        try {
            if (null == this.m_outMethod) {
                Class<?> traceCls = Class.forName("oracle.ops.mgmt.trace.Trace");
                Class[] stringParam = new Class[]{String.class};
                this.m_outMethod = traceCls.getDeclaredMethod("out", stringParam);
            }
            Object[] stringArg = new Object[]{text};
            this.m_outMethod.invoke(null, stringArg);
        }
        catch (ClassNotFoundException e) {
            this.Trace("Ignoring ClassNotFoundException  : " + e);
        }
        catch (IllegalAccessException e) {
            this.Trace("Ignoring IllegalAccessException : " + e);
        }
        catch (IllegalArgumentException e) {
            this.Trace("Ignoring IllegalArgumentException : " + e);
        }
        catch (InvocationTargetException e) {
            this.Trace("Ignoring InvocationTargetException : " + e.getCause());
        }
        catch (NoSuchMethodException e) {
            this.Trace("Ignoring NoSuchMethodException : " + e);
        }
        catch (NullPointerException e) {
            this.Trace("Ignoring NullPointerException : " + e);
        }
        catch (ExceptionInInitializerError e) {
            this.Trace("Ignoring ExceptionInInitializerError : " + e);
        }
    }

    protected void setupTracing() {
        try {
            Class<?> traceCls = Class.forName("oracle.ops.mgmt.trace.Trace");
            String traceFileName = System.getProperty("srvm.rhphelper.tracefile");
            Method traceEnabledMethod = traceCls.getDeclaredMethod("traceEnabled", Boolean.TYPE);
            traceEnabledMethod.invoke(null, true);
            Method setTraceLevelMethod = traceCls.getDeclaredMethod("setTraceLevel", Integer.TYPE);
            setTraceLevelMethod.invoke(null, 2);
            Method configureMethod = traceCls.getDeclaredMethod("configure", Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, String.class, Boolean.TYPE);
            configureMethod.invoke(null, false, false, true, true, traceFileName, true);
        }
        catch (ClassNotFoundException e) {
            this.Trace("Ignoring ClassNotFoundException  : " + e);
        }
        catch (IllegalAccessException e) {
            this.Trace("Ignoring IllegalAccessException : " + e);
        }
        catch (IllegalArgumentException e) {
            this.Trace("Ignoring IllegalArgumentException : " + e);
        }
        catch (InvocationTargetException e) {
            this.Trace("Ignoring InvocationTargetException : " + e.getCause());
        }
        catch (NoSuchMethodException e) {
            this.Trace("Ignoring NoSuchMethodException : " + e);
        }
        catch (NullPointerException e) {
            this.Trace("Ignoring NullPointerException : " + e);
        }
        catch (ExceptionInInitializerError e) {
            this.Trace("Ignoring ExceptionInInitializerError : " + e);
        }
    }

    protected String arrToStr(String[] arr, String sep) {
        StringBuilder sb = new StringBuilder();
        if (arr != null) {
            for (String str : arr) {
                if (sb.length() == 0) {
                    sb.append(str);
                    continue;
                }
                sb.append(sep).append(str);
            }
        }
        return sb.toString();
    }

    protected String list2String(List<String> strList, String delim) {
        StringBuilder sb = new StringBuilder();
        for (String str : strList) {
            sb.append(str + delim);
        }
        String result = "";
        if (sb.length() > 0) {
            result = sb.toString().trim();
            return result.substring(0, result.length() - delim.length());
        }
        return result;
    }

    public int getInventoryLoc(String[] args) {
        File invFile;
        String parentDir;
        String inventoryLoc = "";
        try {
            Class<?> utilClass = Class.forName("oracle.ops.verification.framework.util.VerificationUtil");
            this.Trace("Got Util class");
            Method method = utilClass.getDeclaredMethod("getInventoryFileLocation", new Class[0]);
            this.Trace("Invoking getInventoryFileLocation method ...");
            inventoryLoc = (String)method.invoke(utilClass.newInstance(), new Object[0]);
        }
        catch (ClassNotFoundException e) {
            this.Trace("getInventoryLoc-ClassNotFoundException  : " + e);
            this.displayErrorResult("RHPHELP_getInventoryLoc-01", 2);
            return 1;
        }
        catch (InstantiationException e) {
            this.Trace("getInventoryLoc-InstantiationException : " + e);
            this.displayErrorResult("RHPHELP_getInventoryLoc-02", 2);
            return 1;
        }
        catch (IllegalAccessException e) {
            this.Trace("getInventoryLoc-IllegalAccessException : " + e);
            this.displayErrorResult("RHPHELP_getInventoryLoc-03", 2);
            return 1;
        }
        catch (IllegalArgumentException e) {
            this.Trace("getInventoryLoc-IllegalArgumentException : " + e);
            this.displayErrorResult("RHPHELP_getInventoryLoc-04", 2);
            return 1;
        }
        catch (InvocationTargetException e) {
            this.Trace("getInventoryLoc-InvocationTargetException : " + e.getCause());
            this.displayErrorResult(e.getCause().getMessage(), 3);
            return 1;
        }
        catch (NoSuchMethodException e) {
            this.Trace("getInventoryLoc-NoSuchMethodException : " + e);
            this.displayErrorResult("RHPHELP_getInventoryLoc-05", 2);
            return 1;
        }
        catch (NullPointerException e) {
            this.Trace("getInventoryLoc-NullPointerException : " + e);
            this.displayErrorResult("RHPHELP_getInventoryLoc-06", 2);
            return 1;
        }
        catch (ExceptionInInitializerError e) {
            this.Trace("getInventoryLoc-ExceptionInInitializerError : " + e);
            this.displayErrorResult("RHPHELP_getInventoryLoc-07", 2);
            return 1;
        }
        if (inventoryLoc.length() == 0) {
            this.Trace("getInventoryFileLocation method failed..");
            this.displayErrorResult("RHPHELP_getInventoryLoc-08", 2);
            return 1;
        }
        this.Trace("getInventoryFileLocation method returned :" + inventoryLoc);
        if (inventoryLoc != null && inventoryLoc.length() > 0 && (parentDir = (invFile = new File(inventoryLoc)).getParent()) != null) {
            invFile = new File(parentDir);
            inventoryLoc = invFile.getParent();
        }
        this.Trace("Returning :" + inventoryLoc);
        this.displaySuccessResult(inventoryLoc, 0);
        return 0;
    }

    public int getOracleHomeOwner(String[] args) {
        String oracleHome = args[1];
        this.Trace("Retrieving Oracle home owner for " + oracleHome);
        String owner = null;
        try {
            Class<?> utilClass = Class.forName("oracle.ops.mgmt.has.Util");
            this.Trace("Got Util class");
            Method method = utilClass.getDeclaredMethod("getOracleUser", String.class, String.class);
            this.Trace("Invoking getOracleUser method ...");
            owner = (String)method.invoke(utilClass.newInstance(), oracleHome, null);
        }
        catch (ClassNotFoundException e) {
            this.Trace("getOracleHomeOwner-ClassNotFoundException  : " + e);
            this.displayErrorResult("RHPHELP_getOraOwner-01", 2);
            return 1;
        }
        catch (InstantiationException e) {
            this.Trace("getOracleHomeOwner-InstantiationException : " + e);
            this.displayErrorResult("RHPHELP_getOraOwner-02", 2);
            return 1;
        }
        catch (IllegalAccessException e) {
            this.Trace("getOracleHomeOwner-IllegalAccessException : " + e);
            this.displayErrorResult("RHPHELP_getOraOwner-03", 2);
            return 1;
        }
        catch (IllegalArgumentException e) {
            this.Trace("getOracleHomeOwner-IllegalArgumentException : " + e);
            this.displayErrorResult("RHPHELP_getOraOwner-04", 2);
            return 1;
        }
        catch (InvocationTargetException e) {
            this.Trace("getOracleHomeOwner-InvocationTargetException : " + e.getCause());
            this.displayErrorResult(e.getCause().getMessage(), 3);
            return 1;
        }
        catch (NoSuchMethodException e) {
            this.Trace("getOracleHomeOwner-NoSuchMethodException : " + e);
            this.displayErrorResult("RHPHELP_getOraOwner-05", 2);
            return 1;
        }
        catch (NullPointerException e) {
            this.Trace("getOracleHomeOwner-NullPointerException : " + e);
            this.displayErrorResult("RHPHELP_getOraOwner-06", 2);
            return 1;
        }
        catch (ExceptionInInitializerError e) {
            this.Trace("getOracleHomeOwner-ExceptionInInitializerError : " + e);
            this.displayErrorResult("RHPHELP_getOraOwner-07", 2);
            return 1;
        }
        this.Trace("Executed getOracleUser method");
        this.displaySuccessResult(owner, 0);
        return 0;
    }

    public int transfer(String[] args) {
        Class<?> remFileOpExceptionCls = null;
        Method getErrorMessage = null;
        Method getErrorMessages = null;
        Method getException = null;
        String[] nodeNames = args[2].split(DELIM1);
        try {
            remFileOpExceptionCls = Class.forName("oracle.ops.mgmt.cluster.RemoteFileOperationException");
            getErrorMessage = remFileOpExceptionCls.getMethod("getErrorMessage", String.class);
            getErrorMessages = remFileOpExceptionCls.getMethod("getErrorMessages", String.class);
            getException = remFileOpExceptionCls.getMethod("getException", String.class);
            String oracleHomePath = args[1];
            String srcPath = args[3];
            String[] destPath = args[4].split(DELIM1);
            String excludeListFile = args.length > 5 ? args[5] : null;
            Class[] argTypeNone = new Class[]{};
            Object argumentNone = null;
            Class<?> clusterCmdClass = Class.forName("oracle.ops.mgmt.cluster.ClusterCmd");
            this.Trace("Got ClusterCmd class");
            Object clusterCmdObj = clusterCmdClass.newInstance();
            this.Trace("Created ClusterCmd object");
            Method transferDirStructureToNodes = clusterCmdClass.getDeclaredMethod("transferDirStructureToNodes", String.class, String[].class, String.class, String.class, String.class, String.class, String[].class);
            this.Trace("Invoking transferDirStructureToNodes method ...");
            transferDirStructureToNodes.invoke(clusterCmdObj, oracleHomePath, nodeNames, srcPath, null, excludeListFile, TMP_LOC, destPath);
        }
        catch (ClassNotFoundException e) {
            this.Trace("transfer-ClassNotFoundException  : " + e);
            this.displayErrorResult("RHPHELP_transfer-03", 2);
            return 1;
        }
        catch (InstantiationException e) {
            this.Trace("transfer-InstantiationException : " + e);
            this.displayErrorResult("RHPHELP_transfer-04", 2);
            return 1;
        }
        catch (IllegalAccessException e) {
            this.Trace("transfer-IllegalAccessException : " + e);
            this.displayErrorResult("RHPHELP_transfer-05", 2);
            return 1;
        }
        catch (IllegalArgumentException e) {
            this.Trace("transfer-IllegalArgumentException : " + e);
            this.displayErrorResult("RHPHELP_transfer-06", 2);
            return 1;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            this.Trace("transfer-InvocationTargetException : " + cause.getClass().getName() + " : " + cause);
            StringBuilder detailedError = new StringBuilder();
            if (cause.getClass().equals(remFileOpExceptionCls)) {
                for (String node : nodeNames) {
                    try {
                        this.Trace("failed node : " + node);
                        String errMsg = (String)getErrorMessage.invoke((Object)cause, node);
                        String[] errMsgs = (String[])getErrorMessages.invoke((Object)cause, node);
                        Exception exp = (Exception)getException.invoke((Object)cause, node);
                        if (errMsg != null) {
                            this.Trace("transferDirStructureToNodes failed with error message : " + errMsg);
                        } else if (errMsgs != null) {
                            errMsg = this.arrToStr(errMsgs, "\n");
                            this.Trace("transferDirStructureToNodes failed with error messages : " + errMsg);
                        } else if (exp != null) {
                            errMsg = exp.getMessage();
                            this.Trace("transferDirStructureToNodes failed with exception : " + exp.getMessage());
                        }
                        detailedError.append(errMsg + "\n");
                    }
                    catch (IllegalAccessException ie) {
                        this.Trace("ignoring exception : " + ie.getMessage());
                    }
                    catch (InvocationTargetException ie) {
                        this.Trace("ignoring exception : " + ie.getCause().getMessage());
                    }
                }
            }
            this.displayErrorResult(cause.getMessage() + "\n" + detailedError.toString(), 3);
            return 1;
        }
        catch (NoSuchMethodException e) {
            this.Trace("transfer-NoSuchMethodException : " + e);
            this.displayErrorResult("RHPHELP_transfer-07", 2);
            return 1;
        }
        catch (NullPointerException e) {
            this.Trace("transfer-NullPointerException : " + e);
            this.displayErrorResult("RHPHELP_transfer-08", 2);
            return 1;
        }
        catch (ExceptionInInitializerError e) {
            this.Trace("transfer-ExceptionInInitializerError : " + e);
            this.displayErrorResult("RHPHELP_transfer-09", 2);
            return 1;
        }
        this.Trace("Executed transfer command");
        return 0;
    }

    public int copyDBFiles(String[] args) {
        String srcHome = args[1];
        String dstHome = args[2];
        final String dbName = args.length > 3 ? args[3] : null;
        String srcDBsDir = srcHome + File.separator + "dbs" + File.separator;
        String dstDBsDir = dstHome + File.separator + "dbs" + File.separator;
        File includeFile = null;
        try {
            String localhost = InetAddress.getLocalHost().getCanonicalHostName();
            if (dbName != null) {
                this.Trace("Finding relevant files in " + srcDBsDir);
                File srcDir = new File(srcDBsDir);
                File[] dbFiles = srcDir.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.contains(dbName);
                    }
                });
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
                includeFile = new File("/tmp/include" + sdf.format(new Date()));
                PrintWriter writer = new PrintWriter(includeFile);
                for (File file : dbFiles) {
                    this.Trace("Found " + file.getName());
                    writer.println(file.getAbsolutePath());
                }
                writer.close();
                includeFile.deleteOnExit();
            }
            this.Trace("Copying files from " + srcDBsDir + " to " + dstDBsDir);
            Class<?> clusterCmdClass = Class.forName("oracle.ops.mgmt.cluster.ClusterCmd");
            this.Trace("Got ClusterCmd class");
            Object clusterCmdObj = clusterCmdClass.newInstance();
            this.Trace("Created ClusterCmd object");
            Method transferDirStructureToNodes = clusterCmdClass.getDeclaredMethod("transferDirStructureToNodes", String.class, String[].class, String.class, String.class, String.class, String.class, String[].class);
            this.Trace("Invoking transferDirStructureToNodes method ...");
            transferDirStructureToNodes.invoke(clusterCmdObj, srcHome, new String[]{localhost}, srcDBsDir, dbName != null ? includeFile.getAbsolutePath() : null, null, "/tmp", new String[]{dstDBsDir});
        }
        catch (UnknownHostException e) {
            this.Trace("copydbs-UnknownHostException  : " + e);
            this.displayErrorResult("RHPHELP_copyDBFiles-01", 2);
            return 1;
        }
        catch (FileNotFoundException e) {
            this.Trace("copydbs-FileNotFoundException  : " + e);
            this.displayErrorResult("RHPHELP_copyDBFiles-02", 2);
            return 1;
        }
        catch (ClassNotFoundException e) {
            this.Trace("copydbs-ClassNotFoundException  : " + e);
            this.displayErrorResult("RHPHELP_copyDBFiles-03", 2);
            return 1;
        }
        catch (InstantiationException e) {
            this.Trace("copydbs-InstantiationException : " + e);
            this.displayErrorResult("RHPHELP_copyDBFiles-04", 2);
            return 1;
        }
        catch (IllegalAccessException e) {
            this.Trace("copydbs-IllegalAccessException : " + e);
            this.displayErrorResult("RHPHELP_copyDBFiles-05", 2);
            return 1;
        }
        catch (IllegalArgumentException e) {
            this.Trace("copydbs-IllegalArgumentException : " + e);
            this.displayErrorResult("RHPHELP_copyDBFiles-06", 2);
            return 1;
        }
        catch (InvocationTargetException e) {
            this.Trace("copydbs-InvocationTargetException : " + e.getCause());
            this.displayErrorResult(e.getCause().getMessage(), 3);
            return 1;
        }
        catch (NoSuchMethodException e) {
            this.Trace("copydbs-NoSuchMethodException : " + e);
            this.displayErrorResult("RHPHELP_copyDBFiles-07", 2);
            return 1;
        }
        catch (NullPointerException e) {
            this.Trace("copydbs-NullPointerException : " + e);
            this.displayErrorResult("RHPHELP_copyDBFiles-08", 2);
            return 1;
        }
        catch (ExceptionInInitializerError e) {
            this.Trace("copydbs-ExceptionInInitializerError : " + e);
            this.displayErrorResult("RHPHELP_copyDBFiles-09", 2);
            return 1;
        }
        this.Trace("Executed copy command");
        return 0;
    }

    public int mergeListenerOra(String[] args) {
        String srcHome = args[1];
        String dstHome = args[2];
        this.Trace("Merging listener.ora files ...");
        String srcFile = srcHome + LISTENER_FILE_PATH;
        String tgtFile = dstHome + LISTENER_FILE_PATH;
        Class<?> invalidFileExceptionCls = null;
        try {
            invalidFileExceptionCls = Class.forName("oracle.cluster.nodeapps.InvalidFileException");
            Class<?> nodeAppsFac = Class.forName("oracle.cluster.nodeapps.NodeAppsFactory");
            Method getInstance = nodeAppsFac.getDeclaredMethod("getInstance", new Class[0]);
            Object naf = getInstance.invoke(null, new Object[0]);
            this.Trace("Created NodeAppsFactory object");
            Method mergeListenerOra = nodeAppsFac.getDeclaredMethod(METHOD_MERGE_LISTENERORA, String.class, String.class);
            mergeListenerOra.invoke(naf, srcFile, tgtFile);
        }
        catch (ClassNotFoundException e) {
            this.Trace("mergeLsnr12c-ClassNotFoundException  : " + e);
            this.displayErrorResult("RHPHELP_mergeLsnr12c-01", 2);
            return 1;
        }
        catch (IllegalAccessException e) {
            this.Trace("mergeLsnr12c-IllegalAccessException : " + e);
            this.displayErrorResult("RHPHELP_mergeLsnr12c-02", 2);
            return 1;
        }
        catch (IllegalArgumentException e) {
            this.Trace("mergeLsnr12c-IllegalArgumentException : " + e);
            this.displayErrorResult("RHPHELP_mergeLsnr12c-03", 2);
            return 1;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            this.Trace("mergeLsnr12c-InvocationTargetException : " + cause);
            if (!cause.getMessage().contains(FILE_NOT_FOUND)) {
                this.displayErrorResult(cause.getMessage(), 3);
                return 1;
            }
        }
        catch (NoSuchMethodException e) {
            this.Trace("mergeLsnr12c-NoSuchMethodException : " + e);
            this.displayErrorResult("RHPHELP_mergeLsnr12c-04", 2);
            return 1;
        }
        catch (NullPointerException e) {
            this.Trace("mergeLsnr12c-NullPointerException : " + e);
            this.displayErrorResult("RHPHELP_mergeLsnr12c-05", 2);
            return 1;
        }
        catch (ExceptionInInitializerError e) {
            this.Trace("mergeLsnr12c-ExceptionInInitializerError : " + e);
            this.displayErrorResult("RHPHELP_mergeLsnr12c-06", 2);
            return 1;
        }
        this.Trace("Completed merging lsnrs");
        return 0;
    }

    public int mergeSqlNetOra(String[] args) {
        String srcHome = args[1];
        String dstHome = args[2];
        this.Trace("Merging sqlnet.ora files ...");
        String srcFile = srcHome + SQLNET_FILE_PATH;
        String tgtFile = dstHome + SQLNET_FILE_PATH;
        Class<?> invalidFileExceptionCls = null;
        try {
            invalidFileExceptionCls = Class.forName("oracle.cluster.nodeapps.InvalidFileException");
            Class<?> nodeAppsFac = Class.forName("oracle.cluster.nodeapps.NodeAppsFactory");
            Method getInstance = nodeAppsFac.getDeclaredMethod("getInstance", new Class[0]);
            Object naf = getInstance.invoke(null, new Object[0]);
            this.Trace("Got NodeAppsFactory singleton object");
            Method mergeSqlNet = nodeAppsFac.getDeclaredMethod("mergeSqlNet", String.class, String.class, String.class, String.class);
            mergeSqlNet.invoke(naf, srcFile, tgtFile, srcHome, dstHome);
        }
        catch (ClassNotFoundException e) {
            this.Trace("mergeSqlNetOra12c-ClassNotFoundException  : " + e);
            this.displayErrorResult("RHPHELP_mergeSqlNetOra12c-01", 2);
            return 1;
        }
        catch (IllegalAccessException e) {
            this.Trace("mergeSqlNetOra12c-IllegalAccessException : " + e);
            this.displayErrorResult("RHPHELP_mergeSqlNetOra12c-02", 2);
            return 1;
        }
        catch (IllegalArgumentException e) {
            this.Trace("mergeSqlNetOra12c-IllegalArgumentException : " + e);
            this.displayErrorResult("RHPHELP_mergeSqlNetOra12c-03", 2);
            return 1;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            this.Trace("mergeSqlNetOra12c-InvocationTargetException : " + cause);
            if (!cause.getMessage().contains(FILE_NOT_FOUND)) {
                this.displayErrorResult(cause.getMessage(), 3);
                return 1;
            }
        }
        catch (NoSuchMethodException e) {
            this.Trace("mergeSqlNetOra12c-NoSuchMethodException : " + e);
            this.displayErrorResult("RHPHELP_mergeSqlNetOra12c-04", 2);
            return 1;
        }
        catch (NullPointerException e) {
            this.Trace("mergeSqlNetOra12c-NullPointerException : " + e);
            this.displayErrorResult("RHPHELP_mergeSqlNetOra12c-05", 2);
            return 1;
        }
        catch (ExceptionInInitializerError e) {
            this.Trace("mergeSqlNetOra12c-ExceptionInInitializerError : " + e);
            this.displayErrorResult("RHPHELP_mergeSqlNetOra12c-06", 2);
            return 1;
        }
        this.Trace("Completed merging sqlnet.ora files");
        return 0;
    }

    public int mergeTNSNames(String[] args) {
        String srcHome = args[1];
        String dstHome = args[2];
        this.Trace("Merging tnsnames.ora files ...");
        String srcFile = srcHome + TNSNAMES_FILE_PATH;
        String tgtFile = dstHome + TNSNAMES_FILE_PATH;
        Class<?> invalidFileExceptionCls = null;
        try {
            invalidFileExceptionCls = Class.forName("oracle.cluster.nodeapps.InvalidFileException");
            Class<?> nodeAppsFac = Class.forName("oracle.cluster.nodeapps.NodeAppsFactory");
            Method getInstance = nodeAppsFac.getDeclaredMethod("getInstance", new Class[0]);
            Object naf = getInstance.invoke(null, new Object[0]);
            this.Trace("Created NodeAppsFactory object");
            Method mergeTnsNames = nodeAppsFac.getDeclaredMethod("mergeTnsNames", String.class, String.class);
            mergeTnsNames.invoke(naf, srcFile, tgtFile);
        }
        catch (ClassNotFoundException e) {
            this.Trace("mergeTNS12c-ClassNotFoundException  : " + e);
            this.displayErrorResult("RHPHELP_mergeTNS12c-01", 2);
            return 1;
        }
        catch (IllegalAccessException e) {
            this.Trace("mergeTNS12c-IllegalAccessException : " + e);
            this.displayErrorResult("RHPHELP_mergeTNS12c-02", 2);
            return 1;
        }
        catch (IllegalArgumentException e) {
            this.Trace("mergeTNS12c-IllegalArgumentException : " + e);
            this.displayErrorResult("RHPHELP_mergeTNS12c-03", 2);
            return 1;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            this.Trace("mergeTNS12c-InvocationTargetException : " + cause);
            if (!cause.getMessage().contains(FILE_NOT_FOUND)) {
                this.displayErrorResult(cause.getMessage(), 3);
                return 1;
            }
        }
        catch (NoSuchMethodException e) {
            this.Trace("mergeTNS12c-NoSuchMethodException : " + e);
            this.displayErrorResult("RHPHELP_mergeTNS12c-04", 2);
            return 1;
        }
        catch (NullPointerException e) {
            this.Trace("mergeTNS12c-NullPointerException : " + e);
            this.displayErrorResult("RHPHELP_mergeTNS12c-05", 2);
            return 1;
        }
        catch (ExceptionInInitializerError e) {
            this.Trace("mergeTNS12c-ExceptionInInitializerError : " + e);
            this.displayErrorResult("RHPHELP_mergeTNS12c-06", 2);
            return 1;
        }
        this.Trace("Completed merging TNS names");
        return 0;
    }

    public int getHistoricalClusterNodes(String[] args) {
        this.Trace("Running getHistoricalClusterNodes ...");
        try {
            Class<?> clustInfoCls = Class.forName("oracle.cluster.deployment.ClusterwareInfo");
            Object cinfo = clustInfoCls.newInstance();
            this.Trace("Created ClusterwareInfo object");
            String crsHome = args[1];
            this.Trace("CRS home is " + crsHome);
            Method getHistoricalClusterNodes = clustInfoCls.getDeclaredMethod(METHOD_GET_HIST_CLUSTER_NODES, String.class);
            this.Trace("Got getHistoricalClusterNodes method");
            List nodeList = (List)getHistoricalClusterNodes.invoke(cinfo, crsHome);
            String nodeListStr = this.list2String(nodeList, DELIM1);
            this.Trace("Node list string is " + nodeListStr);
            this.displaySuccessResult(nodeListStr, 0);
        }
        catch (ClassNotFoundException e) {
            this.Trace("ClassNotFoundException : " + e);
            this.displayErrorResult("RHPHELP_getHistoricalClusterNodes-01", 2);
            return 1;
        }
        catch (NoSuchMethodException e) {
            this.Trace("NoSuchMethodException : " + e);
            this.displayErrorResult("RHPHELP_getHistoricalClusterNodes-02", 2);
            return 1;
        }
        catch (IllegalAccessException e) {
            this.Trace("IllegalAccessException : " + e);
            this.displayErrorResult("RHPHELP_getHistoricalClusterNodes-03", 2);
            return 1;
        }
        catch (InstantiationException e) {
            this.Trace("InstantiationException : " + e);
            this.displayErrorResult("RHPHELP_getHistoricalClusterNodes-04", 2);
            return 1;
        }
        catch (InvocationTargetException e) {
            this.Trace("InvocationTargetException : " + e.getCause());
            this.displayErrorResult(e.getCause().getMessage(), 3);
            return 1;
        }
        return 0;
    }

    public int stopCluster(String[] args) {
        String crsHome = args[1];
        this.Trace("Stopping CRS stack ...");
        String[] cmdArgs = new String[]{crsHome + "/bin/crsctl", "stop", "crs"};
        StringBuilder cmd = new StringBuilder();
        for (String arg : cmdArgs) {
            cmd.append(arg + " ");
        }
        this.Trace("Stopping CRS stack command: " + cmd);
        try {
            Class<?> runtimeExecCls = Class.forName("oracle.ops.mgmt.nativesystem.RuntimeExec");
            Object[] argRuntime = new Object[]{cmdArgs, null, null};
            Constructor<?> runtimeConst = runtimeExecCls.getConstructor(String[].class, String[].class, String[].class);
            Object runtime = runtimeConst.newInstance(argRuntime);
            Class[] argTypeNone = new Class[]{};
            Object[] argumentNone = null;
            this.Trace("Got the RuntimeExec object");
            Method runCommandMethod = runtimeExecCls.getDeclaredMethod("runCommand", argTypeNone);
            int retVal = (Integer)runCommandMethod.invoke(runtime, argumentNone);
            this.Trace("After invoking runCommand");
            Method getOutputMethod = runtimeExecCls.getDeclaredMethod("getOutput", argTypeNone);
            String[] cmdOutput = (String[])getOutputMethod.invoke(runtime, argumentNone);
            this.Trace("After invoking getOutput");
            Method getErrorMethod = runtimeExecCls.getDeclaredMethod("getError", argTypeNone);
            String[] cmdError = (String[])getErrorMethod.invoke(runtime, argumentNone);
            this.Trace("After invoking getError");
            Method getExitValueMethod = runtimeExecCls.getDeclaredMethod("getExitValue", argTypeNone);
            int exitVal = (Integer)getExitValueMethod.invoke(runtime, argumentNone);
            this.Trace("After invoking getExitValue");
            this.Trace("retval = " + retVal);
            this.Trace("exitval = " + exitVal);
            if (cmdError != null) {
                this.Trace("cmdError length = " + cmdError.length);
            }
            if (cmdError != null && cmdError.length != 0) {
                StringBuilder error = new StringBuilder();
                for (int i = 0; i < cmdError.length; ++i) {
                    error.append(cmdError[i] + LSEP);
                }
                String errorMsg = error.toString();
                this.Trace("crsctl stop crs command error:" + errorMsg);
                if (errorMsg.length() > 0) {
                    this.displayErrorResult(errorMsg, 3);
                    return 0;
                }
            }
            if (cmdOutput != null && cmdOutput.length > 0) {
                StringBuilder output = new StringBuilder();
                this.Trace("crsctl stop crs output:");
                for (int i = 0; i < cmdOutput.length; ++i) {
                    this.Trace(cmdOutput[i]);
                    output.append(cmdOutput[i] + LSEP);
                }
                String outputMsg = output.toString();
                if (outputMsg.length() > 0) {
                    if (exitVal == 0) {
                        this.displaySuccessResult(outputMsg, 0);
                        return 0;
                    }
                    this.displayErrorResult(outputMsg, 3);
                    return 0;
                }
            }
        }
        catch (ClassNotFoundException e) {
            this.Trace(e.getMessage());
            this.displayErrorResult("RHPHELP_stopCluster-01", 2);
            return 0;
        }
        catch (NoSuchMethodException e) {
            this.Trace(e.getMessage());
            this.displayErrorResult("RHPHELP_stopCluster-02", 2);
            return 0;
        }
        catch (IllegalAccessException e) {
            this.Trace(e.getMessage());
            this.displayErrorResult("RHPHELP_stopCluster-03", 2);
            return 0;
        }
        catch (InvocationTargetException e) {
            this.Trace(e.getCause().getMessage());
            this.displayErrorResult(e.getCause().getMessage(), 3);
            return 0;
        }
        catch (InstantiationException e) {
            this.Trace(e.getMessage());
            this.displayErrorResult("RHPHELP_stopCluster-04", 2);
            return 0;
        }
        this.Trace("Exit stop cluster method");
        return 0;
    }

    public int stopListener(String[] args) {
        String home = args[1];
        String[] nodes = args[2].split(DELIM1);
        this.Trace("Stopping listener ...");
        Class<?> notExistsExceptionCls = null;
        Class<?> alreadyStoppedExceptionCls = null;
        try {
            notExistsExceptionCls = Class.forName("oracle.cluster.util.NotExistsException");
            alreadyStoppedExceptionCls = Class.forName("oracle.cluster.util.AlreadyStoppedException");
            Class<?> nodeAppsFac = Class.forName("oracle.cluster.nodeapps.NodeAppsFactory");
            Method getInstance = nodeAppsFac.getDeclaredMethod("getInstance", new Class[0]);
            Object naf = getInstance.invoke(null, new Object[0]);
            this.Trace("Created NodeAppsFactory object");
            Method getListeners = nodeAppsFac.getDeclaredMethod("getListeners", new Class[0]);
            List lsnrs = (List)getListeners.invoke(naf, new Object[0]);
            List<Object> nodeList = this.getNodes(Arrays.asList(nodes));
            Class<?> listenerCls = Class.forName("oracle.cluster.nodeapps.Listener");
            Method getOracleHome = listenerCls.getDeclaredMethod("getOracleHome", new Class[0]);
            Method stop = listenerCls.getDeclaredMethod("stop", List.class, Boolean.TYPE);
            for (Object lsnr : lsnrs) {
                String lsnrHome = (String)getOracleHome.invoke(lsnr, new Object[0]);
                if (!home.equals(lsnrHome)) continue;
                this.Trace("Stopping listener running from " + home);
                stop.invoke(lsnr, nodeList, true);
            }
        }
        catch (ClassNotFoundException e) {
            this.Trace("stopLsnr112-ClassNotFoundException  : " + e);
            this.displayErrorResult("RHPHELP_stopLsnr112-01", 2);
            return 1;
        }
        catch (IllegalAccessException e) {
            this.Trace("stopLsnr112-IllegalAccessException : " + e);
            this.displayErrorResult("RHPHELP_stopLsnr112-02", 2);
            return 1;
        }
        catch (IllegalArgumentException e) {
            this.Trace("stopLsnr112-IllegalArgumentException : " + e);
            this.displayErrorResult("RHPHELP_stopLsnr112-03", 2);
            return 1;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            this.Trace("stopLsnr112-InvocationTargetException : " + cause);
            if (!cause.getClass().equals(notExistsExceptionCls) && !cause.getClass().equals(alreadyStoppedExceptionCls)) {
                this.displayErrorResult(cause.getMessage(), 3);
                return 1;
            }
        }
        catch (NoSuchMethodException e) {
            this.Trace("stopLsnr112-NoSuchMethodException : " + e);
            this.displayErrorResult("RHPHELP_stopLsnr112-04", 2);
            return 1;
        }
        catch (NullPointerException e) {
            this.Trace("stopLsnr112-NullPointerException : " + e);
            this.displayErrorResult("RHPHELP_stopLsnr112-05", 2);
            return 1;
        }
        catch (ExceptionInInitializerError e) {
            this.Trace("stopLsnr112-ExceptionInInitializerError : " + e);
            this.displayErrorResult("RHPHELP_stopLsnr112-06", 2);
            return 1;
        }
        this.Trace("stopped listener");
        return 0;
    }

    public int moveDatabase(String[] args) {
        block56: {
            try {
                ArrayList<Object> svcs2Start;
                String nodeName;
                block58: {
                    Throwable cause;
                    ArrayList<String> dbNamesList;
                    Class<?> alreadyRunningExceptionCls;
                    Method write;
                    Object plsnrClient;
                    block57: {
                        String[] dbNames = args[1].split(DELIM1);
                        String destHome = args[2];
                        boolean isModifyHome = !OPTION_NOT_SPECIFIED.equals(destHome);
                        String plsnrHostPort = args[3];
                        boolean isNonrolling = OPTION_NOT_SPECIFIED.equals(args[4]);
                        nodeName = null;
                        Object node = null;
                        if (!isNonrolling) {
                            nodeName = args[4];
                            node = this.getNodes(Arrays.asList(nodeName)).get(0);
                        }
                        String stopOption = OPTION_NOT_SPECIFIED.equals(args[5]) ? null : args[5];
                        Boolean isDisconnect = null;
                        Boolean isNoreplay = null;
                        if (args.length > 6 && !OPTION_NOT_SPECIFIED.equals(args[6])) {
                            isDisconnect = Boolean.valueOf(args[6]);
                        }
                        if (args.length > 7 && !OPTION_NOT_SPECIFIED.equals(args[7])) {
                            isNoreplay = Boolean.valueOf(args[7]);
                        }
                        Class<?> nodeCls = Class.forName("oracle.cluster.server.Node");
                        Class<?> versionCls = Class.forName("oracle.ops.mgmt.cluster.Version");
                        Class<?> databaseFac = Class.forName("oracle.cluster.database.DatabaseFactory");
                        Method getInstance = databaseFac.getDeclaredMethod("getInstance", new Class[0]);
                        Method getDatabase = databaseFac.getDeclaredMethod("getDatabase", String.class, versionCls);
                        Method getDatabaseVersion = databaseFac.getDeclaredMethod("getDatabaseVersion", String.class);
                        Class<?> databaseCls = Class.forName("oracle.cluster.database.Database");
                        Method setOracleHome = databaseCls.getDeclaredMethod("setOracleHome", String.class);
                        Method getOracleHome = databaseCls.getDeclaredMethod("getOracleHome", new Class[0]);
                        Method getSPFile = databaseCls.getDeclaredMethod("getSPFile", new Class[0]);
                        Method setSPFile = databaseCls.getDeclaredMethod("setSPFile", String.class);
                        Method databaseType = databaseCls.getDeclaredMethod("databaseType", new Class[0]);
                        Method getServices = databaseCls.getMethod("services", new Class[0]);
                        Method isRunning = databaseCls.getMethod("isRunning", new Class[0]);
                        Method isRunningOnNode = databaseCls.getMethod("isRunning", nodeCls);
                        Class<?> databaseTypeCls = Class.forName("oracle.cluster.database.DatabaseType");
                        Method getEnumMember = databaseTypeCls.getDeclaredMethod("getEnumMember", String.class);
                        Object df = getInstance.invoke(null, new Object[0]);
                        this.Trace("Created DatabaseFactory object");
                        Object dbVer = getDatabaseVersion.invoke(df, dbNames[0]);
                        this.Trace("databases are of version " + dbVer.toString());
                        Method getMajorVersion = versionCls.getDeclaredMethod("getMajorVersion", new Class[0]);
                        int majorVer = Integer.parseInt((String)getMajorVersion.invoke(dbVer, new Object[0]));
                        HashMap<String, Object> nonrollingDBs = new HashMap<String, Object>();
                        HashMap<String, Object> rollingDBs = new HashMap<String, Object>();
                        for (String dbName : dbNames) {
                            Boolean isOnline;
                            this.Trace(String.format("retrieving database %s ...", dbName));
                            Object db = getDatabase.invoke(df, dbName, dbVer);
                            this.Trace(String.format("retrieved database %s", dbName));
                            Object dbType = databaseType.invoke(db, new Object[0]);
                            boolean isHomeAlreadyModified = true;
                            if (isModifyHome) {
                                String currOH = (String)getOracleHome.invoke(db, new Object[0]);
                                this.Trace(String.format("current ORACLE_HOME of database %s : %s", dbName, currOH));
                                if (!destHome.equals(currOH)) {
                                    this.Trace(String.format("Modifying ORACLE_HOME attr of database %s ...", dbName));
                                    setOracleHome.invoke(db, destHome);
                                    isHomeAlreadyModified = false;
                                    this.Trace(String.format("Modified ORACLE_HOME attr of database %s", dbName));
                                    if (majorVer == 12 && getEnumMember.invoke(null, "SINGLE").equals(dbType)) {
                                        String currSPFile = null;
                                        try {
                                            currSPFile = (String)getSPFile.invoke(db, new Object[0]);
                                        }
                                        catch (InvocationTargetException spexp) {
                                            this.Trace(String.format("failed to get SPFILE of SIDB %s : %s", dbName, spexp.getCause()));
                                        }
                                        if (currSPFile != null) {
                                            this.Trace(String.format("SPFILE of SIDB %s is currently %s ...", dbName, currSPFile));
                                            if (currSPFile.endsWith("dbs" + File.separator + "spfile" + dbName + ".ora")) {
                                                String spFile = destHome + File.separator + "dbs" + File.separator + "spfile" + dbName + ".ora";
                                                this.Trace(String.format("Modifying SPFILE attr of SIDB %s to %s ...", dbName, spFile));
                                                setSPFile.invoke(db, spFile);
                                                this.Trace(String.format("Modified SPFILE attr of SIDB %s", dbName));
                                            }
                                        }
                                    }
                                }
                            }
                            if (!(isOnline = (Boolean)isRunning.invoke(db, new Object[0])).booleanValue()) {
                                this.Trace(String.format("Database %s is offline and will be started in non-rolling fashion", dbName));
                                nonrollingDBs.put(dbName, db);
                                continue;
                            }
                            if (isHomeAlreadyModified && !this.hasInstancesRunningFromOldHome(dbName)) {
                                this.Trace(String.format("database %s does not have instances running from old home", dbName));
                                continue;
                            }
                            if (!isNonrolling && !(isOnline = (Boolean)isRunningOnNode.invoke(db, node)).booleanValue()) {
                                this.Trace(String.format("Database %s is not running on node %s", dbName, nodeName));
                                continue;
                            }
                            boolean isRAC = getEnumMember.invoke(null, "RAC").equals(dbType);
                            if (isRAC && !isNonrolling) {
                                this.Trace(String.format("Database %s will be restarted on node %s", dbName, args[4]));
                                rollingDBs.put(dbName, db);
                                continue;
                            }
                            this.Trace(String.format("Database %s will be restarted in a non-rolling fashion", dbName));
                            nonrollingDBs.put(dbName, db);
                        }
                        plsnrClient = null;
                        write = null;
                        if (majorVer == 12 && !OPTION_NOT_SPECIFIED.equals(plsnrHostPort)) {
                            Class<?> progressListenerCls = Class.forName("oracle.cluster.common.ProgressListener");
                            write = progressListenerCls.getDeclaredMethod("write", String.class, Boolean.TYPE);
                            this.Trace("creating instance of ProgressListener to be used as a client ...");
                            String[] plsnrDetails = plsnrHostPort.split(":");
                            String plsnrHost = plsnrDetails[0];
                            int plsnrPort = Integer.parseInt(plsnrDetails[1]);
                            Class<?> commonFactoryCls = Class.forName("oracle.cluster.common.CommonFactory");
                            getInstance = commonFactoryCls.getDeclaredMethod("getInstance", new Class[0]);
                            Object cf = getInstance.invoke(null, new Object[0]);
                            this.Trace("Created CommonFactory object");
                            Method getProgressListenerClient = commonFactoryCls.getDeclaredMethod("getProgressListenerClient", String.class, Integer.TYPE);
                            plsnrClient = getProgressListenerClient.invoke(cf, plsnrHost, plsnrPort);
                            this.Trace("Created ProgressListener client object");
                        }
                        Class<?> alreadyStoppedExceptionCls = Class.forName("oracle.cluster.util.AlreadyStoppedException");
                        alreadyRunningExceptionCls = Class.forName("oracle.cluster.util.AlreadyRunningException");
                        if (!nonrollingDBs.isEmpty()) {
                            block55: {
                                Object cause2;
                                block54: {
                                    dbNamesList = new ArrayList<String>(nonrollingDBs.keySet());
                                    ArrayList dbs = new ArrayList(nonrollingDBs.values());
                                    this.Trace(String.format("restarting dbs %s in a non-rolling fashion ...", ((Object)dbNamesList).toString()));
                                    if (plsnrClient != null) {
                                        write.invoke(plsnrClient, String.format(MV_DB_PROG_MSG_STOP_DB, this.list2String(dbNamesList, DELIM1)), true);
                                    }
                                    if (isDisconnect != null) {
                                        this.Trace("stopping services using a filter ...");
                                        try {
                                            this.stopServices(dbNamesList, isDisconnect, majorVer < 12 ? null : isNoreplay, null);
                                            this.Trace("stopped services using a filter");
                                        }
                                        catch (InvocationTargetException ite) {
                                            this.Trace("ignoring 'stop service' failure : " + ite.getCause());
                                        }
                                    }
                                    try {
                                        this.Trace("stopping databases using a filter ...");
                                        this.stopDatabases(dbNamesList, stopOption, null);
                                        this.Trace("stopped databases using a filter");
                                    }
                                    catch (InvocationTargetException ite) {
                                        cause2 = ite.getCause();
                                        this.Trace("non-rolling 'stop database' failed with : " + ((Throwable)cause2).getMessage());
                                        if (cause2.getClass().equals(alreadyStoppedExceptionCls)) break block54;
                                        this.displayErrorResult(((Throwable)cause2).getMessage(), 3);
                                        return 1;
                                    }
                                }
                                if (plsnrClient != null) {
                                    write.invoke(plsnrClient, String.format(MV_DB_PROG_MSG_START_DB, this.list2String(dbNamesList, DELIM1)), true);
                                }
                                try {
                                    this.Trace("starting databases using a filter ...");
                                    this.startDatabases(dbNamesList, null);
                                    this.Trace("started databases using a filter");
                                }
                                catch (InvocationTargetException ite) {
                                    cause2 = ite.getCause();
                                    this.Trace("non-rolling 'start database' failed with : " + ((Throwable)cause2).getMessage());
                                    if (cause2.getClass().equals(alreadyRunningExceptionCls) || ((Throwable)cause2).getMessage().contains("CRS-5702")) break block55;
                                    this.displayErrorResult(((Throwable)cause2).getMessage(), 3);
                                    return 1;
                                }
                            }
                            try {
                                this.Trace(String.format("starting services using a filter ...", new Object[0]));
                                this.startServices(dbNamesList);
                                this.Trace(String.format("started services using a filter", new Object[0]));
                            }
                            catch (InvocationTargetException ite) {
                                this.Trace("ignoring 'start service' failure : " + ite.getCause().getMessage());
                            }
                        }
                        if (rollingDBs.isEmpty()) break block56;
                        dbNamesList = new ArrayList(rollingDBs.keySet());
                        ArrayList dbs = new ArrayList(rollingDBs.values());
                        this.Trace(String.format("restarting dbs %s on node %s ...", ((Object)dbNamesList).toString(), nodeName));
                        ArrayList svcs = new ArrayList();
                        for (Object db : dbs) {
                            this.Trace("retrieving services ...");
                            svcs.addAll((List)getServices.invoke(db, new Object[0]));
                            this.Trace("retrieved services ...");
                        }
                        if (plsnrClient != null) {
                            write.invoke(plsnrClient, String.format(MV_DB_PROG_MSG_STOP_INST, this.list2String(dbNamesList, DELIM1), nodeName), true);
                        }
                        this.Trace(String.format("relocating services from node %s ...", nodeName));
                        Class<?> relocateOptCls = Class.forName("oracle.cluster.database.ServiceArgs$RelocateOption");
                        getEnumMember = relocateOptCls.getDeclaredMethod("getEnumMember", String.class);
                        Object relocateOptsArr = Array.newInstance(relocateOptCls, 0);
                        if (isDisconnect != null && isDisconnect.booleanValue()) {
                            relocateOptsArr = Array.newInstance(relocateOptCls, 1);
                            Array.set(relocateOptsArr, 0, getEnumMember.invoke(null, "disconnect"));
                        }
                        Class<?> cardinalSvcCls = Class.forName("oracle.cluster.database.CardinalService");
                        Method isEnabled = cardinalSvcCls.getMethod("isEnabled", new Class[0]);
                        Method getName = cardinalSvcCls.getMethod("getName", new Class[0]);
                        Method relocate = cardinalSvcCls.getDeclaredMethod("relocate", nodeCls, nodeCls, relocateOptsArr.getClass());
                        svcs2Start = new ArrayList<Object>();
                        for (Object svc : svcs) {
                            String svcName = (String)getName.invoke(svc, new Object[0]);
                            this.Trace(String.format("checking if service %s is globally disabled ...", svcName));
                            Boolean isDisabled = (Boolean)isEnabled.invoke(svc, new Object[0]) == false;
                            if (isDisabled.booleanValue()) {
                                this.Trace(String.format("service %s is globally disabled", svcName));
                                continue;
                            }
                            this.Trace(String.format("retrieving info about service %s ...", svcName));
                            List<List<String>> info = this.getServiceInfo(svc);
                            this.Trace(String.format("retrieved info about service %s", svcName));
                            List<String> allNodes = info.get(0);
                            List<String> onlineNodes = info.get(1);
                            List<String> disabledNodes = info.get(2);
                            if (!onlineNodes.contains(nodeName)) {
                                this.Trace(String.format("service %s is not running on node %s", svcName, nodeName));
                                continue;
                            }
                            this.Trace(String.format("service %s is running on node %s", svcName, nodeName));
                            ArrayList<String> potentialTgts = new ArrayList<String>(allNodes);
                            potentialTgts.remove(nodeName);
                            potentialTgts.removeAll(onlineNodes);
                            potentialTgts.removeAll(disabledNodes);
                            if (potentialTgts.isEmpty()) {
                                this.Trace(String.format("service %s cannot be relocated and will be stopped", svcName));
                                svcs2Start.add(svc);
                                continue;
                            }
                            String tgt = (String)potentialTgts.get(0);
                            this.Trace(String.format("relocating service %s to node %s ...", svcName, tgt));
                            Object tgtNode = this.getNodes(Arrays.asList(tgt)).get(0);
                            relocate.invoke(svc, node, tgtNode, relocateOptsArr);
                            this.Trace(String.format("relocated service %s to node %s", svcName, tgt));
                        }
                        this.Trace(String.format("stopping services on node %s using a filter ...", nodeName));
                        try {
                            this.stopServices(dbNamesList, isDisconnect, majorVer < 12 ? null : isNoreplay, nodeName);
                            this.Trace(String.format("stopped services on node %s using a filter", nodeName));
                        }
                        catch (InvocationTargetException ite) {
                            this.Trace("ignoring 'stop service' failure : " + ite.getCause().getMessage());
                        }
                        try {
                            this.Trace(String.format("stopping databases on node %s using a filter ...", nodeName));
                            this.stopDatabases(dbNamesList, stopOption, nodeName);
                            this.Trace(String.format("stopped databases on node %s using a filter", nodeName));
                        }
                        catch (InvocationTargetException ite) {
                            cause = ite.getCause();
                            this.Trace(String.format("'stop databases' on node %s failed with : %s", nodeName, cause.getMessage()));
                            if (cause.getClass().equals(alreadyStoppedExceptionCls)) break block57;
                            this.displayErrorResult(cause.getMessage(), 3);
                            return 1;
                        }
                    }
                    if (plsnrClient != null) {
                        write.invoke(plsnrClient, String.format(MV_DB_PROG_MSG_START_INST, this.list2String(dbNamesList, DELIM1), nodeName), true);
                    }
                    try {
                        this.Trace(String.format("starting databases on node %s using a filter ...", nodeName));
                        this.startDatabases(dbNamesList, nodeName);
                        this.Trace(String.format("started databases on node %s using a filter", nodeName));
                    }
                    catch (InvocationTargetException ite) {
                        cause = ite.getCause();
                        this.Trace(String.format("'start databases' on node %s failed with : %s", nodeName, cause.getMessage()));
                        if (cause.getClass().equals(alreadyRunningExceptionCls) || cause.getMessage().contains("CRS-5702")) break block58;
                        this.displayErrorResult(cause.getMessage(), 3);
                        return 1;
                    }
                }
                try {
                    if (!svcs2Start.isEmpty()) {
                        this.Trace(String.format("starting services on node %s using a filter ...", nodeName));
                        this.startServices(svcs2Start, nodeName);
                        this.Trace(String.format("started services on node %s using a filter", nodeName));
                    }
                }
                catch (InvocationTargetException ite) {
                    this.Trace("ignoring 'start service' failure : " + ite.getCause().getMessage());
                }
            }
            catch (ClassNotFoundException e) {
                this.Trace("moveDB-ClassNotFoundException  : " + e);
                this.displayErrorResult("RHPHELP_moveDB-01", 2);
                return 1;
            }
            catch (IllegalAccessException e) {
                this.Trace("moveDB-IllegalAccessException : " + e);
                this.displayErrorResult("RHPHELP_moveDB-02", 2);
                return 1;
            }
            catch (IllegalArgumentException e) {
                this.Trace("moveDB-IllegalArgumentException : " + e);
                this.displayErrorResult("RHPHELP_moveDB-03", 2);
                return 1;
            }
            catch (InvocationTargetException e) {
                this.Trace("moveDB-InvocationTargetException : " + e.getCause());
                this.displayErrorResult(e.getCause().getMessage(), 3);
                return 1;
            }
            catch (InstantiationException e) {
                this.Trace("moveDB-InstantiationException : " + e);
                this.displayErrorResult("RHPHELP_moveDB-04", 2);
                return 1;
            }
            catch (NoSuchMethodException e) {
                this.Trace("moveDB-NoSuchMethodException : " + e);
                this.displayErrorResult("RHPHELP_moveDB-05", 2);
                return 1;
            }
            catch (NullPointerException e) {
                this.Trace("moveDB-NullPointerException : " + e);
                this.displayErrorResult("RHPHELP_moveDB-06", 2);
                return 1;
            }
            catch (ExceptionInInitializerError e) {
                this.Trace("moveDB-ExceptionInInitializerError : " + e);
                this.displayErrorResult("RHPHELP_moveDB-07", 2);
                return 1;
            }
        }
        this.Trace("Completed move database");
        return 0;
    }

    protected boolean hasInstancesRunningFromOldHome(String db) throws InvocationTargetException {
        this.Trace(String.format("checking if database %s has instances running from old home ...", db));
        Map result = new HashMap();
        try {
            Class<?> filterCls = Class.forName("oracle.cluster.impl.crs.Filter");
            Class<?> comparatorCls = Class.forName("oracle.cluster.impl.crs.Filter$Comparator");
            Object EQ = Enum.valueOf(comparatorCls, "EQ");
            Object CONTAINS = Enum.valueOf(comparatorCls, "CONTAINS");
            Class<?> operatorCls = Class.forName("oracle.cluster.impl.crs.Filter$Operator");
            Object AND = Enum.valueOf(operatorCls, "AND");
            Object OR = Enum.valueOf(operatorCls, "OR");
            Class<?> filterFactoryCls = Class.forName("oracle.cluster.impl.crs.FilterFactoryImpl");
            Method getSimpleFilter = filterFactoryCls.getDeclaredMethod("getSimpleFilter", comparatorCls, String.class, String.class);
            Method getExpressionFilter = filterFactoryCls.getDeclaredMethod("getExpressionFilter", operatorCls, filterCls, filterCls);
            Class<?> crsEntityTypeCls = Class.forName("oracle.cluster.impl.crs.CRSEntity$Type");
            Object RES_INSTANCE = Enum.valueOf(crsEntityTypeCls, "ResourceInstance");
            Class<?> crsFactoryCls = Class.forName("oracle.cluster.impl.crs.CRSFactoryImpl");
            Method getInstance = crsFactoryCls.getDeclaredMethod("getInstance", new Class[0]);
            Method searchEntities = crsFactoryCls.getDeclaredMethod("searchEntities", crsEntityTypeCls, Boolean.TYPE, filterCls, String[].class);
            Object cf = getInstance.invoke(null, new Object[0]);
            this.Trace("Created CRSFactory object");
            Object typeFilter = getSimpleFilter.invoke(null, EQ, "TYPE", "ora.database.type");
            this.Trace(String.format("created type filter : %s", typeFilter.toString()));
            Object nameFilter = getSimpleFilter.invoke(null, EQ, "NAME", "ora." + db.toLowerCase() + ".db");
            this.Trace(String.format("created name filter : %s", nameFilter.toString()));
            Object onlineFilter = getSimpleFilter.invoke(null, EQ, "STATE", "ONLINE");
            Object interFilter = getSimpleFilter.invoke(null, EQ, "STATE", "INTERMEDIATE");
            Object stateFilter = getExpressionFilter.invoke(null, OR, onlineFilter, interFilter);
            this.Trace(String.format("created state filter : %s", stateFilter.toString()));
            Object oldHomeFilter = getSimpleFilter.invoke(null, CONTAINS, "STATE_DETAILS", "Running from Old Oracle Home");
            this.Trace(String.format("created old home filter : %s", oldHomeFilter.toString()));
            Object filter = getExpressionFilter.invoke(null, AND, typeFilter, nameFilter);
            filter = getExpressionFilter.invoke(null, AND, filter, stateFilter);
            filter = getExpressionFilter.invoke(null, AND, filter, oldHomeFilter);
            this.Trace(String.format("created filter : %s", filter.toString()));
            String[] attrs = new String[]{"LAST_SERVER"};
            result = (Map)searchEntities.invoke(cf, RES_INSTANCE, false, filter, attrs);
            this.Trace(String.format("instances running from old Oracle home are : %s", result.toString()));
        }
        catch (ClassNotFoundException e) {
            this.Trace(String.format("CNFE while checking if %s has instances running from old home : %s", db, e.getMessage()));
        }
        catch (IllegalAccessException e) {
            this.Trace(String.format("IAE while checking if %s has instances running from old home : %s", db, e.getMessage()));
        }
        catch (IllegalArgumentException e) {
            this.Trace(String.format("IAE2 while checking if %s has instances running from old home : %s", db, e.getMessage()));
        }
        catch (InvocationTargetException e) {
            this.Trace(String.format("ITE while checking if %s has instances running from old home : %s", db, e.getCause().getMessage()));
            throw e;
        }
        catch (NoSuchMethodException e) {
            this.Trace(String.format("NSME while checking if %s has instances running from old home : %s", db, e.getMessage()));
        }
        catch (NullPointerException e) {
            this.Trace(String.format("NPE while checking if %s has instances running from old home : %s", db, e.getMessage()));
        }
        return !result.isEmpty();
    }

    protected void CVUTaskCheck(Object verTask, List<String> resultList) throws NoSuchMethodException, IllegalAccessException, ClassNotFoundException {
        Object failedNodesString = null;
        Object successNodesString = null;
        Class[] argTypeNone = new Class[]{};
        Object[] argumentNone = null;
        try {
            Method verifyMethod;
            Class<?> verificationTaskCls = Class.forName("oracle.cluster.verification.VerificationTask");
            Class<?> verificationResultSetCls = Class.forName("oracle.cluster.verification.VerificationResultSet");
            Class<?> verificationResultCls = Class.forName("oracle.cluster.verification.VerificationResult");
            Class<?> verificationErrorCls = Class.forName("oracle.cluster.verification.VerificationError");
            Method getElementNameMethod = verificationTaskCls.getDeclaredMethod("getElementName", argTypeNone);
            Method getDescriptionMethod = verificationTaskCls.getDeclaredMethod("getDescription", argTypeNone);
            String taskName = (String)getElementNameMethod.invoke(verTask, argumentNone);
            String taskDescr = (String)getDescriptionMethod.invoke(verTask, argumentNone);
            this.Trace("CVU task name is " + taskName);
            this.Trace("CVU task description is " + taskDescr);
            Object set = null;
            Method hasSubtaskMethod = verificationTaskCls.getDeclaredMethod("hasSubtasks", argTypeNone);
            Boolean subTasks = (Boolean)hasSubtaskMethod.invoke(verTask, argumentNone);
            if (!subTasks.booleanValue() && (set = (verifyMethod = verificationTaskCls.getDeclaredMethod(METHOD_VERIFY, argTypeNone)).invoke(verTask, argumentNone)) != null) {
                String errorMessage = this.getErrorMessage(set);
                this.Trace("Got The error set :" + errorMessage);
                if (errorMessage.length() > 0) {
                    resultList.add(errorMessage);
                }
            }
        }
        catch (InvocationTargetException ioe) {
            this.Trace("InvocationTargetException :" + ioe.getCause().getMessage());
        }
    }

    protected String getErrorMessage(Object resultSet) throws NoSuchMethodException, IllegalAccessException, ClassNotFoundException, InvocationTargetException {
        String errMsg = "";
        if (null == resultSet) {
            return errMsg;
        }
        Class<?> verificationResultSetCls = Class.forName("oracle.cluster.verification.VerificationResultSet");
        Class<?> verificationResultCls = Class.forName("oracle.cluster.verification.VerificationResult");
        Class<?> verificationErrorCls = Class.forName("oracle.cluster.verification.VerificationError");
        Class[] argTypeNone = new Class[]{};
        Object[] argumentNone = null;
        Method getOverallStatusMethod = verificationResultSetCls.getDeclaredMethod("getOverallStatus", argTypeNone);
        this.Trace("Retrieved the method getOverallStatus");
        Enum status = (Enum)getOverallStatusMethod.invoke(resultSet, argumentNone);
        this.Trace("Enum status is " + status.toString());
        Class<?> overStatusCls = Class.forName("oracle.cluster.verification.OverallStatus");
        this.Trace("Extracting the values");
        Object successful = Enum.valueOf(overStatusCls, "SUCCESSFUL");
        this.Trace("Enum successful is " + ((Enum)successful).toString());
        Method failedNodesMethod = verificationResultSetCls.getDeclaredMethod("getFailedNodes", argTypeNone);
        this.Trace("Retrieved the method getFailedNodes");
        List failedNodes = (List)failedNodesMethod.invoke(resultSet, argumentNone);
        this.Trace("Retrieved the list of failed nodes");
        if (successful != status) {
            Method getErrorsMethod = verificationResultSetCls.getDeclaredMethod("getErrors", argTypeNone);
            this.Trace("Retrieved the method getErrors");
            List errors = (List)getErrorsMethod.invoke(resultSet, argumentNone);
            this.Trace("Retrieved the list of errors");
            for (Object vfe : errors) {
                Method getErrorMessageMethod = verificationErrorCls.getDeclaredMethod("getErrorMessage", argTypeNone);
                this.Trace("Retrieved the method getErrorMessage");
                String errorMessage = (String)getErrorMessageMethod.invoke(vfe, argumentNone);
                this.Trace("Retrieved the error message " + errorMessage);
                errMsg = errMsg + LSEP + errorMessage;
            }
            if (failedNodes != null && failedNodes.size() > 0) {
                for (String nodeName : failedNodes) {
                    try {
                        Class[] argTypeString = new Class[]{String.class};
                        Object[] argumentString = new Object[]{nodeName};
                        Method getNodesResultMethod = verificationResultSetCls.getDeclaredMethod("getNodeResult", argTypeString);
                        Object vr = getNodesResultMethod.invoke(resultSet, argumentString);
                        this.Trace("Extracted some nodes as failed nodes result");
                        getErrorsMethod = verificationResultCls.getDeclaredMethod("getErrors", argTypeNone);
                        List vErrList = (List)getErrorsMethod.invoke(vr, argumentNone);
                        this.Trace("Extracted some Error messages for node:" + nodeName);
                        for (Object verErr : vErrList) {
                            this.Trace("Extract error messages from the Error List");
                            Method getErrorMessageMethod = verificationErrorCls.getDeclaredMethod("getErrorMessage", argTypeNone);
                            String errormessage = (String)getErrorMessageMethod.invoke(verErr, argumentNone);
                            this.Trace("Got The error message:" + errormessage);
                            errMsg = errMsg + LSEP + errormessage;
                        }
                    }
                    catch (InvocationTargetException ioe) {
                        this.Trace("InvocationTargetException :" + ioe.getCause().getMessage());
                        errMsg = errMsg + LSEP + ioe.getCause().getMessage();
                    }
                }
            }
        }
        return errMsg;
    }

    public int getDBInfo(String[] args) {
        try {
            this.Trace("Start of getDBInfo method");
            Class[] argTypeNone = new Class[]{};
            Object[] argumentNone = null;
            Class<?> dbFactCls = Class.forName("oracle.cluster.database.DatabaseFactory");
            this.Trace("Got dbFactCls");
            Method getInstanceMethod = dbFactCls.getDeclaredMethod("getInstance", argTypeNone);
            this.Trace("Got getInstanceMethod");
            Object dbFact = getInstanceMethod.invoke(null, new Object[0]);
            this.Trace("Created dbFact");
            Method dbInfoMethod = dbFactCls.getDeclaredMethod("getDatabaseInfos", argTypeNone);
            this.Trace("Got dbInfoMethod..");
            Map dbInfos = (Map)dbInfoMethod.invoke(dbFact, argumentNone);
            this.Trace("Got dbInfos");
            ArrayList<String> result = new ArrayList<String>();
            ArrayList keys = new ArrayList(dbInfos.keySet());
            for (String key : keys) {
                String resultStr = key + ": " + dbInfos.get(key);
                result.add(resultStr);
                this.Trace(resultStr);
            }
            this.displaySuccessResult(result, 0);
            this.Trace("End of getDBInfo");
            return 0;
        }
        catch (ClassNotFoundException e) {
            this.Trace("ClassNotFoundException : " + e);
            this.displayErrorResult("RHPHELP_getDBInfo-01", 2);
            return 1;
        }
        catch (NoSuchMethodException e) {
            this.Trace("NoSuchMethodException : " + e);
            this.displayErrorResult("RHPHELP_getDBInfo-02", 2);
            return 1;
        }
        catch (IllegalAccessException e) {
            this.Trace("IllegalAccessException : " + e);
            this.displayErrorResult("RHPHELP_getDBInfo-03", 2);
            return 1;
        }
        catch (InvocationTargetException e) {
            this.Trace("InvocationTargetException : " + e.getCause());
            this.displayErrorResult(e.getCause().getMessage(), 3);
            return 1;
        }
    }

    public int getDBType(String[] args) {
        try {
            this.Trace("Start of getDBType method");
            String dbName = args[1];
            Class[] argTypeNone = new Class[]{};
            Object[] argumentNone = null;
            Class<?> dbFactCls = Class.forName("oracle.cluster.database.DatabaseFactory");
            this.Trace("Got dbFactCls");
            Method getInstanceMethod = dbFactCls.getDeclaredMethod("getInstance", argTypeNone);
            this.Trace("Got getInstanceMethod");
            Object dbFact = getInstanceMethod.invoke(null, new Object[0]);
            this.Trace("Created dbFact");
            Class[] argTypes = new Class[]{String.class};
            Object[] argumentList = new Object[]{dbName};
            Method dbMethod = dbFactCls.getDeclaredMethod("getDatabase", argTypes);
            this.Trace("Got dbMethod");
            Object db = dbMethod.invoke(dbFact, argumentList);
            Class<?> dbCls = Class.forName("oracle.cluster.database.Database");
            this.Trace("Got dbCls");
            Method dbTypeMethod = dbCls.getDeclaredMethod("databaseType", argTypeNone);
            this.Trace("Got dbTypeMethod");
            Object dbType = dbTypeMethod.invoke(db, argumentNone);
            Class<?> dbTypeCls = Class.forName("oracle.cluster.database.DatabaseType");
            this.Trace("Got dbTypeCls");
            Method dbTypeToStringMethod = dbTypeCls.getDeclaredMethod("toString", argTypeNone);
            this.Trace("Got dbTypeToStringMethod");
            String dbTypeStr = (String)dbTypeToStringMethod.invoke(dbType, argumentNone);
            this.Trace("dbTypeStr: " + dbTypeStr);
            this.displaySuccessResult(dbTypeStr, 0);
            this.Trace("End of getDBType method");
            return 0;
        }
        catch (ClassNotFoundException e) {
            this.Trace("ClassNotFoundException : " + e);
            this.displayErrorResult("RHPHELP_getDBType-01", 2);
            return 1;
        }
        catch (NoSuchMethodException e) {
            this.Trace("NoSuchMethodException : " + e);
            this.displayErrorResult("RHPHELP_getDBType-02", 2);
            return 1;
        }
        catch (IllegalAccessException e) {
            this.Trace("IllegalAccessException : " + e);
            this.displayErrorResult("RHPHELP_getDBType-03", 2);
            return 1;
        }
        catch (InvocationTargetException e) {
            this.Trace("InvocationTargetException : " + e.getCause());
            this.displayErrorResult(e.getCause().getMessage(), 3);
            return 1;
        }
    }

    public int isDBRunning(String[] args) {
        try {
            this.Trace("Start of isDBRunning method");
            String dbName = args[1];
            Class[] argTypeNone = new Class[]{};
            Object[] argumentNone = null;
            Class<?> dbFactCls = Class.forName("oracle.cluster.database.DatabaseFactory");
            this.Trace("Got dbFactCls");
            Method getInstanceMethod = dbFactCls.getDeclaredMethod("getInstance", argTypeNone);
            this.Trace("Got getInstanceMethod");
            Object dbFact = getInstanceMethod.invoke(null, new Object[0]);
            this.Trace("Created dbFact");
            Class[] argTypes = new Class[]{String.class};
            Object[] argumentList = new Object[]{dbName};
            Method dbMethod = dbFactCls.getDeclaredMethod("getDatabase", argTypes);
            this.Trace("Got dbMethod");
            Object db = dbMethod.invoke(dbFact, argumentList);
            Class<?> dbCls = Class.forName("oracle.cluster.impl.common.SoftwareModuleImpl");
            this.Trace("Got dbCls");
            Method dbIsRunningMethod = dbCls.getDeclaredMethod("isRunning", argTypeNone);
            this.Trace("Got dbIsRunningMethod");
            Boolean dbInstancesStat = (Boolean)dbIsRunningMethod.invoke(db, argumentNone);
            if (dbInstancesStat.booleanValue()) {
                this.displaySuccessResult("TRUE", 0);
            } else {
                this.displaySuccessResult("FALSE", 0);
            }
            this.Trace("End of isDBRunning method");
            return 0;
        }
        catch (ClassNotFoundException e) {
            this.Trace("ClassNotFoundException : " + e);
            this.displayErrorResult("RHPHELP_isDBRun-01", 2);
            return 1;
        }
        catch (NoSuchMethodException e) {
            this.Trace("NoSuchMethodException : " + e);
            this.displayErrorResult("RHPHELP_isDBRun-02", 2);
            return 1;
        }
        catch (IllegalAccessException e) {
            this.Trace("IllegalAccessException : " + e);
            this.displayErrorResult("RHPHELP_isDBRun-03", 2);
            return 1;
        }
        catch (InvocationTargetException e) {
            this.Trace("InvocationTargetException : " + e.getCause());
            this.displayErrorResult(e.getCause().getMessage(), 3);
            return 1;
        }
    }

    public int getDBStopNode(String[] args) {
        try {
            String dbName = args[1];
            Class[] argTypeNone = new Class[]{};
            Object[] argumentNone = null;
            Class<?> dbFactCls = Class.forName("oracle.cluster.database.DatabaseFactory");
            this.Trace("Got dbFactCls");
            Method getInstanceMethod = dbFactCls.getDeclaredMethod("getInstance", argTypeNone);
            this.Trace("Got getInstanceMethod");
            Object dbFact = getInstanceMethod.invoke(null, new Object[0]);
            this.Trace("Created dbFact");
            Class[] argTypes = new Class[]{String.class};
            Object[] argumentList = new Object[]{dbName};
            Method dbMethod = dbFactCls.getDeclaredMethod("getDatabase", argTypes);
            this.Trace("Got dbMethod");
            Object db = dbMethod.invoke(dbFact, argumentList);
            this.Trace("Got db");
            Class<?> dbCls = Class.forName("oracle.cluster.database.Database");
            this.Trace("Got dbCls");
            Method dbInstancesMethod = dbCls.getDeclaredMethod("instances", argTypeNone);
            this.Trace("Got dbInstancesMethod");
            List dbInstancesList = (List)dbInstancesMethod.invoke(db, argumentNone);
            String nodeName = null;
            if (dbInstancesList.size() > 0) {
                Class<?> dbInstanceCls = Class.forName("oracle.cluster.database.Instance");
                this.Trace("Got dbInstanceCls");
                Object dbInstancesListStart = dbInstancesList.get(0);
                Method nodeMethod = dbInstanceCls.getDeclaredMethod("node", argTypeNone);
                this.Trace("Got nodeMethod");
                Object dbRunningNode = nodeMethod.invoke(dbInstancesListStart, argumentNone);
                this.Trace("Got dbRunningNode");
                Class<?> nodeCls = Class.forName("oracle.cluster.server.Node");
                this.Trace("Got nodeCls..");
                Method nodeGetNameMethod = nodeCls.getDeclaredMethod("getName", argTypeNone);
                this.Trace("Got nodeGetNameMethod..");
                nodeName = (String)nodeGetNameMethod.invoke(dbRunningNode, argumentNone);
                this.Trace("Got nodeName");
                this.displaySuccessResult(nodeName, 0);
            } else {
                this.displaySuccessResult("NULL", 0);
            }
            this.Trace("End of getDBStopNode method");
            return 0;
        }
        catch (ClassNotFoundException e) {
            this.Trace("ClassNotFoundException : " + e);
            this.displayErrorResult("RHPHELP_getStopNode-01", 2);
            return 1;
        }
        catch (NoSuchMethodException e) {
            this.Trace("NoSuchMethodException : " + e);
            this.displayErrorResult("RHPHELP_getStopNode-02", 2);
            return 1;
        }
        catch (IllegalAccessException e) {
            this.Trace("IllegalAccessException : " + e);
            this.displayErrorResult("RHPHELP_getStopNode-03", 2);
            return 1;
        }
        catch (InvocationTargetException e) {
            this.Trace("InvocationTargetException : " + e.getCause());
            this.displayErrorResult(e.getCause().getMessage(), 3);
            return 1;
        }
    }

    public int copyDir(String[] args) {
        try {
            String crsHome = args[1];
            String sourceDir = args[2];
            String excludeListFile = args[3];
            String[] nodeList = args[4].split(DELIM1);
            Class[] argTypeNone = new Class[]{};
            Object[] argumentNone = null;
            Class<?> racTransCls = Class.forName("oracle.cluster.deployment.ractrans.RACTransfer");
            this.Trace("Got racTransCls..");
            Constructor<?> racTransConst = racTransCls.getConstructor(argTypeNone);
            Object racTransObj = racTransConst.newInstance(argumentNone);
            this.Trace("Created racTrans object");
            Class[] argTypes = new Class[]{String.class, String[].class, String.class, String.class, String.class};
            Object[] argumentList = new Object[]{crsHome, nodeList, sourceDir, excludeListFile.equals(OPTION_NOT_SPECIFIED) ? null : excludeListFile, "/tmp"};
            Method transferMethod = racTransCls.getDeclaredMethod("transferDirToNodes", argTypes);
            this.Trace("Got transferMethod..");
            Object transferObj = transferMethod.invoke(racTransObj, argumentList);
            this.Trace("End of copyDir method");
            return 0;
        }
        catch (ClassNotFoundException e) {
            this.Trace("ClassNotFoundException : " + e);
            this.displayErrorResult("RHPHELP_copyDir-01", 2);
            return 1;
        }
        catch (NoSuchMethodException e) {
            this.Trace("NoSuchMethodException : " + e);
            this.displayErrorResult("RHPHELP_copyDir-02", 2);
            return 1;
        }
        catch (IllegalAccessException e) {
            this.Trace("IllegalAccessException : " + e);
            this.displayErrorResult("RHPHELP_copyDir-03", 2);
            return 1;
        }
        catch (InstantiationException e) {
            this.Trace("InstantiationException : " + e);
            this.displayErrorResult("RHPHELP_copyDir-04", 2);
            return 1;
        }
        catch (InvocationTargetException e) {
            this.Trace("InvocationTargetException : " + e.getCause());
            this.displayErrorResult(e.getCause().getMessage(), 3);
            return 1;
        }
    }

    public int getClusterName(String[] args) {
        this.Trace("Running getClusterName ...");
        try {
            Class<?> clustInfoCls = Class.forName("oracle.cluster.deployment.ClusterwareInfo");
            Object cinfo = clustInfoCls.newInstance();
            this.Trace("Created ClusterwareInfo object");
            Class<?> versionCls = Class.forName("oracle.ops.mgmt.cluster.Version");
            Object verObject = versionCls.newInstance();
            this.Trace("Created Version object");
            Method getCrsHome = clustInfoCls.getDeclaredMethod("getCRSHome", versionCls);
            this.Trace("Got getCRSHome method");
            String crsHome = (String)getCrsHome.invoke(cinfo, verObject);
            this.Trace("CRS Home obtained is " + crsHome);
            Method getClusterName = clustInfoCls.getDeclaredMethod(METHOD_GET_CLUSTER_NAME, String.class);
            this.Trace("Got getClusterName method");
            String clusterName = (String)getClusterName.invoke(cinfo, crsHome);
            this.Trace("Cluster name is " + clusterName);
            this.displaySuccessResult(clusterName, 0);
        }
        catch (ClassNotFoundException e) {
            this.Trace("ClassNotFoundException : " + e);
            this.displayErrorResult("RHPHELP_getClusterName-01", 2);
            return 1;
        }
        catch (NoSuchMethodException e) {
            this.Trace("NoSuchMethodException : " + e);
            this.displayErrorResult("RHPHELP_getClusterName-02", 2);
            return 1;
        }
        catch (IllegalAccessException e) {
            this.Trace("IllegalAccessException : " + e);
            this.displayErrorResult("RHPHELP_getClusterName-03", 2);
            return 1;
        }
        catch (InstantiationException e) {
            this.Trace("InstantiationException : " + e);
            this.displayErrorResult("RHPHELP_getClusterName-04", 2);
            return 1;
        }
        catch (InvocationTargetException e) {
            this.Trace("InvocationTargetException : " + e.getCause());
            this.displayErrorResult(e.getCause().getMessage(), 3);
            return 1;
        }
        return 0;
    }

    public int getClusterNodes(String[] args) {
        this.Trace("Running getClusterNodes ...");
        try {
            Class<?> clustInfoCls = Class.forName("oracle.cluster.deployment.ClusterwareInfo");
            Object cinfo = clustInfoCls.newInstance();
            this.Trace("Created ClusterwareInfo object");
            Class<?> versionCls = Class.forName("oracle.ops.mgmt.cluster.Version");
            Object verObject = versionCls.newInstance();
            this.Trace("Created Version object");
            Method getCrsHome = clustInfoCls.getDeclaredMethod("getCRSHome", versionCls);
            this.Trace("Got getCRSHome method");
            String crsHome = (String)getCrsHome.invoke(cinfo, verObject);
            this.Trace("CRS home is " + crsHome);
            Class<?> cluUtilCls = Class.forName("oracle.ops.mgmt.has.ClusterUtil");
            Method getNodeNames = cluUtilCls.getDeclaredMethod("getNodeNames", new Class[0]);
            this.Trace("Got getNodeNames method");
            Object cluUtil = cluUtilCls.getConstructor(new Class[0]).newInstance(new Object[0]);
            String nodes = this.arrToStr((String[])getNodeNames.invoke(cluUtil, new Object[0]), DELIM1);
            this.Trace("Nodes: " + nodes);
            this.displaySuccessResult(nodes, 0);
        }
        catch (ClassNotFoundException e) {
            this.Trace("ClassNotFoundException : " + e);
            this.displayErrorResult("RHPHELP_getClusterNodes-01", 2);
            return 1;
        }
        catch (NoSuchMethodException e) {
            this.Trace("NoSuchMethodException : " + e);
            this.displayErrorResult("RHPHELP_getClusterNodes-02", 2);
            return 1;
        }
        catch (IllegalAccessException e) {
            this.Trace("IllegalAccessException : " + e);
            this.displayErrorResult("RHPHELP_getClusterNodes-03", 2);
            return 1;
        }
        catch (InstantiationException e) {
            this.Trace("InstantiationException : " + e);
            this.displayErrorResult("RHPHELP_getClusterNodes-04", 2);
            return 1;
        }
        catch (InvocationTargetException e) {
            this.Trace("InvocationTargetException : " + e.getCause());
            this.displayErrorResult(e.getCause().getMessage(), 3);
            return 1;
        }
        return 0;
    }

    public int getClusterNodesRoles(String[] args) {
        this.Trace("Running getClusterNodesRoles ...");
        try {
            Class<?> clustInfoCls = Class.forName("oracle.cluster.deployment.ClusterwareInfo");
            Object cinfo = clustInfoCls.newInstance();
            this.Trace("Created ClusterwareInfo object");
            String crsHome = args[1];
            this.Trace("CRS home is " + crsHome);
            Method getClusterNodeActiveRoles = clustInfoCls.getDeclaredMethod("getClusterNodeActiveRoles", String.class);
            this.Trace("Got getClusterNodeActiveNodeRoles method");
            Map nodeMap = (Map)getClusterNodeActiveRoles.invoke(cinfo, crsHome);
            StringBuffer sb = new StringBuffer();
            Class[] argTypeNone = new Class[]{};
            Object[] argumentNone = null;
            Class<?> nodeRoleCls = Class.forName("oracle.cluster.common.NodeRole");
            Method getRoleStrMethod = nodeRoleCls.getDeclaredMethod("getRoleStr", argTypeNone);
            for (Map.Entry nodeRoleMap : nodeMap.entrySet()) {
                sb.append((String)nodeRoleMap.getKey());
                sb.append(":");
                Object nodeRole = nodeRoleMap.getValue();
                String roleStr = (String)getRoleStrMethod.invoke(nodeRole, argumentNone);
                sb.append(roleStr);
                sb.append(DELIM1);
            }
            sb.deleteCharAt(sb.length() - 1);
            String nodeListStr = sb.toString();
            this.Trace("Node list string is " + nodeListStr);
            this.displaySuccessResult(nodeListStr, 0);
        }
        catch (ClassNotFoundException e) {
            this.Trace("ClassNotFoundException : " + e);
            this.displayErrorResult("RHPHELP_getClusterNodes-01", 2);
            return 1;
        }
        catch (NoSuchMethodException e) {
            this.Trace("NoSuchMethodException : " + e);
            this.displayErrorResult("RHPHELP_getClusterNodes-02", 2);
            return 1;
        }
        catch (IllegalAccessException e) {
            this.Trace("IllegalAccessException : " + e);
            this.displayErrorResult("RHPHELP_getClusterNodes-03", 2);
            return 1;
        }
        catch (InstantiationException e) {
            this.Trace("InstantiationException : " + e);
            this.displayErrorResult("RHPHELP_getClusterNodes-04", 2);
            return 1;
        }
        catch (InvocationTargetException e) {
            this.Trace("InvocationTargetException : " + e.getCause());
            this.displayErrorResult(e.getCause().getMessage(), 3);
            return 1;
        }
        return 0;
    }

    public int getRunningNodes(String[] args) {
        try {
            String oraHome = args[1];
            this.Trace("Start of getRunningNodes method");
            Class<?> dbFactCls = Class.forName("oracle.cluster.database.DatabaseFactory");
            this.Trace("Got dbFactCls");
            Method getInstanceMethod = dbFactCls.getDeclaredMethod("getInstance", new Class[0]);
            this.Trace("Got getInstanceMethod");
            Object dbFact = getInstanceMethod.invoke(null, new Object[0]);
            this.Trace("Created dbFact");
            Method dbInfoMethod = dbFactCls.getDeclaredMethod("getDatabaseInfos", new Class[0]);
            this.Trace("Got dbInfoMethod..");
            Map dbInfos = (Map)dbInfoMethod.invoke(dbFact, new Object[0]);
            this.Trace("Got dbInfos");
            ArrayList<Object> dbs = new ArrayList<Object>();
            Class<?> versionCls = Class.forName("oracle.ops.mgmt.cluster.Version");
            Method getDatabaseMethod = dbFactCls.getDeclaredMethod("getDatabase", String.class, versionCls);
            this.Trace("Got getDatabaseMethod..");
            for (String db : dbInfos.keySet()) {
                LinkedList details = (LinkedList)dbInfos.get(db);
                String dbHome = (String)details.getFirst();
                Object dbVer = details.getLast();
                if (!dbHome.equals(oraHome)) continue;
                dbs.add(getDatabaseMethod.invoke(dbFact, db, dbVer));
            }
            Class<?> dbCls = Class.forName("oracle.cluster.database.Database");
            Method crsResourceMethod = dbCls.getDeclaredMethod("crsResource", new Class[0]);
            Method getUserAssignedNameMethod = dbCls.getMethod("getUserAssignedName", new Class[0]);
            Class<?> crsResourceCls = Class.forName("oracle.cluster.crs.CRSResource");
            Method fetchRunningNodesMethod = crsResourceCls.getDeclaredMethod("fetchRunningNodes", new Class[0]);
            Class<?> nodeCls = Class.forName("oracle.cluster.server.Node");
            Method getNameMethod = nodeCls.getDeclaredMethod("getName", new Class[0]);
            ArrayList<String> result = new ArrayList<String>();
            for (Object e : dbs) {
                String dbName = (String)getUserAssignedNameMethod.invoke(e, new Object[0]);
                Object crsRes = crsResourceMethod.invoke(e, new Object[0]);
                List nodes = (List)fetchRunningNodesMethod.invoke(crsRes, new Object[0]);
                if (nodes == null || nodes.isEmpty()) continue;
                StringBuilder sb = new StringBuilder(dbName + ":");
                for (Object node : nodes) {
                    sb.append(getNameMethod.invoke(node, new Object[0]) + DELIM1);
                }
                String resultStr = sb.substring(0, sb.length() - 1);
                this.Trace(resultStr);
                result.add(resultStr);
            }
            this.displaySuccessResult(result, 0);
            this.Trace("End of getRunningNodes");
            return 0;
        }
        catch (ClassNotFoundException e) {
            this.Trace("ClassNotFoundException : " + e);
            this.displayErrorResult("RHPHELP_getRunningNodes-01", 2);
            return 1;
        }
        catch (NoSuchMethodException e) {
            this.Trace("NoSuchMethodException : " + e);
            this.displayErrorResult("RHPHELP_getRunningNodes-02", 2);
            return 1;
        }
        catch (IllegalAccessException e) {
            this.Trace("IllegalAccessException : " + e);
            this.displayErrorResult("RHPHELP_getRunningNodes-03", 2);
            return 1;
        }
        catch (InvocationTargetException e) {
            this.Trace("InvocationTargetException : " + e.getCause());
            this.displayErrorResult(e.getCause().getMessage(), 3);
            return 1;
        }
    }

    public int isSharedPath(String[] args) {
        try {
            this.Trace("Starting isSharedPath ...");
            Boolean isShared = new Boolean(false);
            String nodes = null;
            String[] nodeList = null;
            String dirPath = null;
            if (!args[1].equals("null") && !args[1].equals(OPTION_NOT_SPECIFIED)) {
                nodes = args[1];
                this.Trace("Node list is " + nodes);
            }
            if (args[2].equals("null") || args[2].equals(OPTION_NOT_SPECIFIED)) {
                this.displayErrorResult("RHPHELP_isSharedPath-01", 2);
                return 1;
            }
            dirPath = args[2];
            this.Trace("Dir path is " + dirPath);
            Class<?> clusterClass = Class.forName("oracle.ops.mgmt.cluster.Cluster");
            this.Trace("Got Cluster class");
            if (nodes == null) {
                this.Trace("Retrieving cluster nodes ...");
                Method getNodes = clusterClass.getDeclaredMethod("getNodes", new Class[0]);
                nodeList = (String[])getNodes.invoke(null, new Object[0]);
            } else {
                nodeList = nodes.split(DELIM1);
            }
            if (nodeList.length == 0) {
                this.displayErrorResult("RHPHELP_isSharedPath-02", 2);
                return 1;
            }
            if (nodeList.length > 1) {
                this.Trace("Retrieving cluster nodes ...");
                Method isSharedPath = clusterClass.getDeclaredMethod(CMD_IS_SHARED_PATH, String.class, String[].class);
                isShared = (Boolean)isSharedPath.invoke(null, dirPath, nodeList);
            }
            this.displaySuccessResult(isShared.toString(), 0);
            return 0;
        }
        catch (ClassNotFoundException e) {
            this.Trace("ClassNotFoundException : " + e);
            this.displayErrorResult("RHPHELP_isSharedPath-03", 2);
            return 1;
        }
        catch (NoSuchMethodException e) {
            this.Trace("NoSuchMethodException : " + e);
            this.displayErrorResult("RHPHELP_isSharedPath-04", 2);
            return 1;
        }
        catch (IllegalAccessException e) {
            this.Trace("IllegalAccessException : " + e);
            this.displayErrorResult("RHPHELP_isSharedPath-05", 2);
            return 1;
        }
        catch (InvocationTargetException e) {
            this.Trace("InvocationTargetException : " + e.getCause());
            this.displayErrorResult(e.getCause().getMessage(), 3);
            return 1;
        }
    }

    protected String[] getNodeListArr(List<String> nodeList) {
        String[] nodeListArr = new String[nodeList.size()];
        int index = 0;
        for (String node : nodeList) {
            this.Trace("Node is " + node);
            String[] nodeNameArr = node.split(DOT);
            nodeListArr[index++] = nodeNameArr[0].toLowerCase();
        }
        return nodeListArr;
    }

    public int getHubNodes(String[] args) {
        this.Trace("Running getHubNodes ...");
        try {
            Class<?> clusterUtilCls = Class.forName("oracle.ops.mgmt.has.ClusterUtil");
            Object util = clusterUtilCls.newInstance();
            this.Trace("Created ClusterUtil object");
            Method getHUBNodes = clusterUtilCls.getMethod("getHUBNodes", new Class[0]);
            this.Trace("Got getHUBNodes method");
            String[] nodes = (String[])getHUBNodes.invoke(util, new Object[0]);
            String nodeListStr = this.list2String(Arrays.asList(nodes), DELIM1);
            this.Trace("Node list string is " + nodeListStr);
            this.displaySuccessResult(nodeListStr, 0);
        }
        catch (ClassNotFoundException e) {
            this.Trace("ClassNotFoundException : " + e);
            this.displayErrorResult("RHPHELP_getHUBNodes-01", 2);
            return 1;
        }
        catch (NoSuchMethodException e) {
            this.Trace("NoSuchMethodException : " + e);
            this.displayErrorResult("RHPHELP_getHUBNodes-02", 2);
            return 1;
        }
        catch (IllegalAccessException e) {
            this.Trace("IllegalAccessException : " + e);
            this.displayErrorResult("RHPHELP_getHUBNodes-03", 2);
            return 1;
        }
        catch (InstantiationException e) {
            this.Trace("InstantiationException : " + e);
            this.displayErrorResult("RHPHELP_getHUBNodes-04", 2);
            return 1;
        }
        catch (InvocationTargetException e) {
            this.Trace("InvocationTargetException : " + e.getCause());
            this.displayErrorResult(e.getCause().getMessage(), 3);
            return 1;
        }
        return 0;
    }

    public int getAdminManagedDBs(String[] args) {
        this.Trace("Running getAdminManagedDBs ...");
        try {
            List<String> dbNames = new ArrayList<String>();
            if (args.length > 1) {
                dbNames = Arrays.asList(args[1].split(DELIM1));
            }
            List<Object> dbs = this.getDatabases(dbNames);
            Class<?> dbCls = Class.forName("oracle.cluster.database.Database");
            Method getUserAssgnName = dbCls.getMethod("getUserAssignedName", new Class[0]);
            StringBuilder result = new StringBuilder();
            for (Object db : dbs) {
                if (!this.isAdminManaged(db)) continue;
                result.append((String)getUserAssgnName.invoke(db, new Object[0]));
                result.append(DELIM1);
            }
            String print = "";
            if (result.length() > 0) {
                print = result.substring(0, result.length() - 1);
            }
            this.displaySuccessResult(print, 0);
        }
        catch (InvocationTargetException e) {
            this.Trace("InvocationTargetException : " + e.getCause());
            this.displayErrorResult(e.getCause().getMessage(), 3);
            return 1;
        }
        catch (ClassNotFoundException e) {
            this.Trace("ClassNotFoundException : " + e);
        }
        catch (NoSuchMethodException e) {
            this.Trace("NoSuchMethodException : " + e);
        }
        catch (IllegalAccessException e) {
            this.Trace("IllegalAccessException : " + e);
        }
        catch (IllegalArgumentException e) {
            this.Trace("IllegalArgumentException : " + e);
        }
        return 0;
    }

    protected boolean isAdminManaged(Object db) throws InvocationTargetException {
        Boolean isAdminManaged = new Boolean(false);
        try {
            Class<?> dbCls = Class.forName("oracle.cluster.database.Database");
            Method serverGroupsMethod = dbCls.getMethod("serverGroups", new Class[0]);
            List sgList = (List)serverGroupsMethod.invoke(db, new Object[0]);
            this.Trace("retrieved list of server groups");
            isAdminManaged = new Boolean(false);
            if (sgList.size() == 1) {
                Object sg = sgList.get(0);
                Class<?> srvGrpCls = Class.forName("oracle.cluster.server.ServerGroup");
                Method isSrvPool = srvGrpCls.getMethod("isServerPool", new Class[0]);
                isAdminManaged = (Boolean)isSrvPool.invoke(sg, new Object[0]) == false;
            }
        }
        catch (ClassNotFoundException e) {
            this.Trace("ClassNotFoundException : " + e);
        }
        catch (NoSuchMethodException e) {
            this.Trace("NoSuchMethodException : " + e);
        }
        catch (IllegalAccessException e) {
            this.Trace("IllegalAccessException : " + e);
        }
        catch (IllegalArgumentException e) {
            this.Trace("IllegalArgumentException : " + e);
        }
        return isAdminManaged;
    }

    public int getCardinalDBs(String[] args) {
        this.Trace("Running getCardinalDBs ...");
        try {
            List<String> dbNames = new ArrayList<String>();
            if (args.length > 1) {
                dbNames = Arrays.asList(args[1].split(DELIM1));
            }
            List<Object> dbs = this.getDatabases(dbNames);
            Class<?> dbCls = Class.forName("oracle.cluster.database.Database");
            Method getUserAssgnName = dbCls.getMethod("getUserAssignedName", new Class[0]);
            StringBuilder result = new StringBuilder();
            for (Object db : dbs) {
                if (!this.isCardinalDatabase(db)) continue;
                result.append((String)getUserAssgnName.invoke(db, new Object[0]));
                result.append(DELIM1);
            }
            String print = "";
            if (result.length() > 0) {
                print = result.substring(0, result.length() - 1);
            }
            this.displaySuccessResult(print, 0);
        }
        catch (InvocationTargetException e) {
            this.Trace("InvocationTargetException : " + e.getCause());
            this.displayErrorResult(e.getCause().getMessage(), 3);
            return 1;
        }
        catch (ClassNotFoundException e) {
            this.Trace("ClassNotFoundException : " + e);
        }
        catch (NoSuchMethodException e) {
            this.Trace("NoSuchMethodException : " + e);
        }
        catch (IllegalAccessException e) {
            this.Trace("IllegalAccessException : " + e);
        }
        catch (IllegalArgumentException e) {
            this.Trace("IllegalArgumentException : " + e);
        }
        return 0;
    }

    protected boolean isCardinalDatabase(Object db) throws InvocationTargetException {
        boolean isCardinal = false;
        try {
            Class<?> dbCls = Class.forName("oracle.cluster.database.Database");
            Method databaseType = dbCls.getDeclaredMethod("databaseType", new Class[0]);
            Object dbType = databaseType.invoke(db, new Object[0]);
            Class<?> databaseTypeCls = Class.forName("oracle.cluster.database.DatabaseType");
            Method getEnumMember = databaseTypeCls.getDeclaredMethod("getEnumMember", String.class);
            isCardinal = !getEnumMember.invoke(null, "SINGLE").equals(dbType);
        }
        catch (ClassNotFoundException e) {
            this.Trace("ClassNotFoundException : " + e);
        }
        catch (NoSuchMethodException e) {
            this.Trace("NoSuchMethodException : " + e);
        }
        catch (IllegalAccessException e) {
            this.Trace("IllegalAccessException : " + e);
        }
        catch (IllegalArgumentException e) {
            this.Trace("IllegalArgumentException : " + e);
        }
        return isCardinal;
    }

    public int relocateService(String[] args) {
        this.Trace("running relocateService ...");
        try {
            String dbName = args[1];
            String svcName = args[2];
            String srcNodeName = args[3];
            String dstNodeName = args[4];
            Object db = this.getDatabases(Arrays.asList(dbName)).get(0);
            if (!this.isCardinalDatabase(db)) {
                this.Trace("specified database is not RAC or RAC One");
                this.displayErrorResult("RHPHELP_relocateSvc-0", 2);
                return 1;
            }
            List<Object> nodes = this.getNodes(Arrays.asList(srcNodeName, dstNodeName));
            Object srcNode = nodes.get(0);
            Object dstNode = nodes.get(1);
            Class<?> cardinalDBCls = Class.forName("oracle.cluster.database.CardinalDatabase");
            Method services = cardinalDBCls.getMethod("services", new Class[0]);
            Class<?> cardinalSvcCls = Class.forName("oracle.cluster.database.CardinalService");
            Method getName = cardinalSvcCls.getMethod("getName", new Class[0]);
            Object svc = null;
            List svcs = (List)services.invoke(db, new Object[0]);
            for (Object iter : svcs) {
                String resName = (String)getName.invoke(iter, new Object[0]);
                if (!svcName.equals(this.processServiceResName(resName).get(1))) continue;
                svc = iter;
                break;
            }
            if (svc == null) {
                this.Trace("could not retrieve service object");
                this.displayErrorResult("RHPHELP_relocateSvc-1", 2);
                return 1;
            }
            Class<?> nodeCls = Class.forName("oracle.cluster.server.Node");
            Class<?> relocateOptCls = Class.forName("oracle.cluster.database.ServiceArgs$RelocateOption");
            Object relocateOptsArr = Array.newInstance(relocateOptCls, 0);
            Method relocate = cardinalSvcCls.getDeclaredMethod("relocate", nodeCls, nodeCls, relocateOptsArr.getClass());
            relocate.invoke(svc, srcNode, dstNode, relocateOptsArr);
            return 0;
        }
        catch (InvocationTargetException e) {
            this.Trace("InvocationTargetException : " + e.getCause());
            this.displayErrorResult(e.getCause().getMessage(), 3);
            return 1;
        }
        catch (ClassNotFoundException e) {
            this.Trace("ClassNotFoundException : " + e);
            this.displayErrorResult("RHPHELP_relocateSvc-2", 2);
            return 1;
        }
        catch (NoSuchMethodException e) {
            this.Trace("NoSuchMethodException : " + e);
            this.displayErrorResult("RHPHELP_relocateSvc-3", 2);
            return 1;
        }
        catch (IllegalAccessException e) {
            this.Trace("IllegalAccessException : " + e);
            this.displayErrorResult("RHPHELP_relocateSvc-4", 2);
            return 1;
        }
        catch (IllegalArgumentException e) {
            this.Trace("IllegalArgumentException : " + e);
            this.displayErrorResult("RHPHELP_relocateSvc-5", 2);
            return 1;
        }
    }

    public int relocateServices(String[] args) {
        ArrayList<String> dbNames = new ArrayList<String>(Arrays.asList(args[1].split(DELIM1)));
        String node = args[2];
        Boolean isDisconnect = OPTION_NOT_SPECIFIED.equals(args[3]) ? null : Boolean.valueOf(args[3]);
        Boolean isNoreplay = OPTION_NOT_SPECIFIED.equals(args[4]) ? null : Boolean.valueOf(args[4]);
        try {
            Map<String, String> relocatedSvcs = this.relocateServices(dbNames, isDisconnect, isNoreplay, node);
            StringBuilder result = new StringBuilder();
            for (String key : relocatedSvcs.keySet()) {
                result.append(key + ":" + relocatedSvcs.get(key));
                result.append(DELIM1);
            }
            String print = "";
            if (result.length() > 0) {
                print = result.substring(0, result.length() - 1);
            }
            this.displaySuccessResult(print, 0);
            return 0;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            this.Trace("relocateServices-InvocationTargetException : " + cause.getMessage());
            this.displayErrorResult(cause.getMessage(), 3);
            return 1;
        }
        catch (InstantiationException e) {
            this.Trace("relocateServices-InstantiationException : " + e.getMessage());
            this.displayErrorResult("RHPHELP_relocateServices-01", 2);
            return 1;
        }
    }

    protected Map<String, String> relocateServices(List<String> dbNames, Boolean isDisconnect, Boolean isNoreplay, String nodeName) throws InstantiationException, InvocationTargetException {
        HashMap<String, String> relocatedSvcs = new HashMap<String, String>();
        try {
            Class<?> versionCls = Class.forName("oracle.ops.mgmt.cluster.Version");
            Class<?> nodeCls = Class.forName("oracle.cluster.server.Node");
            Class<?> databaseFac = Class.forName("oracle.cluster.database.DatabaseFactory");
            Method getInstance = databaseFac.getDeclaredMethod("getInstance", new Class[0]);
            Method getDatabase = databaseFac.getDeclaredMethod("getDatabase", String.class, versionCls);
            Method getDatabaseVersion = databaseFac.getDeclaredMethod("getDatabaseVersion", String.class);
            Class<?> databaseCls = Class.forName("oracle.cluster.database.Database");
            Method databaseType = databaseCls.getDeclaredMethod("databaseType", new Class[0]);
            Method getServices = databaseCls.getMethod("services", new Class[0]);
            Class<?> databaseTypeCls = Class.forName("oracle.cluster.database.DatabaseType");
            Method getDBTypeEnumMember = databaseTypeCls.getDeclaredMethod("getEnumMember", String.class);
            Class<?> relocateOptCls = Class.forName("oracle.cluster.database.ServiceArgs$RelocateOption");
            Method getRelocateOptEnumMember = relocateOptCls.getDeclaredMethod("getEnumMember", String.class);
            Object srcNode = this.getNodes(Arrays.asList(nodeName)).get(0);
            Object df = getInstance.invoke(null, new Object[0]);
            this.Trace("Created DatabaseFactory object");
            for (String dbName : dbNames) {
                this.Trace(String.format("retrieving database %s ...", dbName));
                Object dbVer = getDatabaseVersion.invoke(df, dbName);
                this.Trace(String.format("version of database %s : %s", dbName, dbVer.toString()));
                Method getMajorVersion = versionCls.getDeclaredMethod("getMajorVersion", new Class[0]);
                int majorVer = Integer.parseInt((String)getMajorVersion.invoke(dbVer, new Object[0]));
                Object db = getDatabase.invoke(df, dbName, dbVer);
                this.Trace(String.format("retrieved database %s", dbName));
                Object dbType = databaseType.invoke(db, new Object[0]);
                boolean isRAC = getDBTypeEnumMember.invoke(null, "RAC").equals(dbType);
                ArrayList svcs = new ArrayList();
                this.Trace("retrieving services ...");
                svcs.addAll((List)getServices.invoke(db, new Object[0]));
                this.Trace("retrieved services ...");
                Object relocateOptsArr = Array.newInstance(relocateOptCls, 0);
                if (isDisconnect != null && isDisconnect.booleanValue()) {
                    relocateOptsArr = Array.newInstance(relocateOptCls, 1);
                    Array.set(relocateOptsArr, 0, getRelocateOptEnumMember.invoke(null, "disconnect"));
                }
                Class<?> cardinalSvcCls = Class.forName("oracle.cluster.database.CardinalService");
                Method isEnabled = cardinalSvcCls.getMethod("isEnabled", new Class[0]);
                Method getName = cardinalSvcCls.getMethod("getName", new Class[0]);
                Method relocate = cardinalSvcCls.getDeclaredMethod("relocate", nodeCls, nodeCls, relocateOptsArr.getClass());
                for (Object svc : svcs) {
                    String svcName = (String)getName.invoke(svc, new Object[0]);
                    this.Trace(String.format("checking if service %s is globally disabled ...", svcName));
                    Boolean isDisabled = (Boolean)isEnabled.invoke(svc, new Object[0]) == false;
                    if (isDisabled.booleanValue()) {
                        this.Trace(String.format("service %s is globally disabled", svcName));
                        continue;
                    }
                    this.Trace(String.format("retrieving info about service %s ...", svcName));
                    List<List<String>> info = this.getServiceInfo(svc);
                    this.Trace(String.format("retrieved info about service %s", svcName));
                    List<String> allNodes = info.get(0);
                    List<String> onlineNodes = info.get(1);
                    List<String> disabledNodes = info.get(2);
                    if (!onlineNodes.contains(nodeName)) {
                        this.Trace(String.format("service %s is not running on node %s", svcName, nodeName));
                        continue;
                    }
                    this.Trace(String.format("service %s is running on node %s", svcName, nodeName));
                    if (isRAC) {
                        this.Trace(String.format("checking if service %s can be relocated from node %s ...", svcName, nodeName));
                        ArrayList<String> potentialTgts = new ArrayList<String>(allNodes);
                        potentialTgts.remove(nodeName);
                        potentialTgts.removeAll(onlineNodes);
                        potentialTgts.removeAll(disabledNodes);
                        if (potentialTgts.isEmpty()) {
                            this.Trace(String.format("service %s cannot be relocated", svcName));
                            continue;
                        }
                        String tgt = (String)potentialTgts.get(0);
                        this.Trace(String.format("relocating service %s to node %s ...", svcName, tgt));
                        Object tgtNode = this.getNodes(Arrays.asList(tgt)).get(0);
                        try {
                            relocate.invoke(svc, srcNode, tgtNode, relocateOptsArr);
                            this.Trace(String.format("relocated service %s to node %s", svcName, tgt));
                            relocatedSvcs.put(svcName, tgt);
                        }
                        catch (InvocationTargetException ite) {
                            Throwable cause = ite.getCause();
                            this.Trace(String.format("failed to relocate service %s to node %s due to : %s", svcName, tgt, cause.getMessage()));
                        }
                        continue;
                    }
                    this.Trace(String.format("service %s cannot be relocated", svcName));
                }
            }
        }
        catch (ClassNotFoundException e) {
            this.Trace("relocateServices-ClassNotFoundException  : " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            this.Trace("relocateServices-IllegalArgumentException : " + e.getMessage());
        }
        catch (NullPointerException e) {
            this.Trace("relocateServices-NullPointerException : " + e.getMessage());
        }
        catch (ExceptionInInitializerError e) {
            this.Trace("relocateServices-ExceptionInInitializerError : " + e.getMessage());
        }
        catch (NoSuchMethodException e) {
            this.Trace("relocateServices-NoSuchMethodException : " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            this.Trace("relocateServices-IllegalAccessException : " + e.getMessage());
        }
        this.Trace(String.format("services that were relocated from the specified node : %s", ((Object)relocatedSvcs).toString()));
        return relocatedSvcs;
    }

    protected void stopServices(Object db, Boolean isDisconnect, Boolean isNoreplay) throws InstantiationException, InvocationTargetException {
        try {
            Class<?> databaseCls = Class.forName("oracle.cluster.database.Database");
            Method getVersion = databaseCls.getMethod("version", new Class[0]);
            Object dbVer = getVersion.invoke(db, new Object[0]);
            Class<?> versionCls = Class.forName("oracle.ops.mgmt.cluster.Version");
            Method getMajorVersion = versionCls.getDeclaredMethod("getMajorVersion", new Class[0]);
            int majorVer = Integer.parseInt((String)getMajorVersion.invoke(dbVer, new Object[0]));
            Method services = databaseCls.getMethod("services", new Class[0]);
            List svcs = (List)services.invoke(db, new Object[0]);
            if (majorVer >= 12) {
                this.Trace("stopping services of a 12.1 database ...");
                Class<?> serviceArgsCls = Class.forName("oracle.cluster.database.ServiceArgs");
                Object serviceArgsObj = serviceArgsCls.newInstance();
                this.Trace("Created ServiceArgs object");
                if (isDisconnect != null) {
                    Method setDisconnectOpt = serviceArgsCls.getDeclaredMethod("setDisconnectOpt", Boolean.TYPE);
                    setDisconnectOpt.invoke(serviceArgsObj, (boolean)isDisconnect);
                    this.Trace("Set disconnect option");
                }
                if (isNoreplay != null) {
                    Method setNoreplay = serviceArgsCls.getDeclaredMethod("setNoreplay", Boolean.TYPE);
                    setNoreplay.invoke(serviceArgsObj, (boolean)isNoreplay);
                    this.Trace("Set noreplay option");
                }
                Method setGlobal = serviceArgsCls.getDeclaredMethod("setGlobal", Boolean.TYPE);
                setGlobal.invoke(serviceArgsObj, true);
                this.Trace("Set global option");
                Method stopServices = databaseCls.getDeclaredMethod(METHOD_STOP_SERVICES, List.class, serviceArgsCls);
                stopServices.invoke(db, svcs, serviceArgsObj);
                this.Trace("stopped services");
            } else {
                this.Trace("stopping services of an 11.2 database ...");
                Class<?> svcCls = Class.forName("oracle.cluster.database.Service");
                Method getSvcName = svcCls.getMethod("getName", new Class[0]);
                Class<?> stopOptionCls = Class.forName("oracle.cluster.database.StopOptions");
                Object stopOptsArr = Array.newInstance(stopOptionCls, 0);
                Method stop = svcCls.getMethod("stop", stopOptsArr.getClass(), Boolean.TYPE);
                for (Object svc : svcs) {
                    String resName = (String)getSvcName.invoke(svc, new Object[0]);
                    this.Trace("stopping service " + resName);
                    stop.invoke(svc, stopOptsArr, isDisconnect != null && isDisconnect != false);
                }
            }
        }
        catch (ClassNotFoundException e) {
            this.Trace("ClassNotFoundException : " + e);
        }
        catch (NoSuchMethodException e) {
            this.Trace("NoSuchMethodException : " + e);
        }
        catch (IllegalAccessException e) {
            this.Trace("IllegalAccessException : " + e);
        }
        catch (IllegalArgumentException e) {
            this.Trace("IllegalArgumentException : " + e);
        }
    }

    protected void stopServices(List<String> dbs, Boolean isDisconnect, Boolean isNoreplay, String node) throws InstantiationException, InvocationTargetException {
        try {
            Class<?> filterCls = Class.forName("oracle.cluster.impl.crs.Filter");
            Class<?> comparatorCls = Class.forName("oracle.cluster.impl.crs.Filter$Comparator");
            Object EQ = Enum.valueOf(comparatorCls, "EQ");
            Object STARTS_WITH = Enum.valueOf(comparatorCls, "STARTS_WITH");
            Class<?> operatorCls = Class.forName("oracle.cluster.impl.crs.Filter$Operator");
            Object AND = Enum.valueOf(operatorCls, "AND");
            Object OR = Enum.valueOf(operatorCls, "OR");
            Class<?> filterFactoryCls = Class.forName("oracle.cluster.impl.crs.FilterFactoryImpl");
            Method getSimpleFilter = filterFactoryCls.getDeclaredMethod("getSimpleFilter", comparatorCls, String.class, String.class);
            Method getExpressionFilter = filterFactoryCls.getDeclaredMethod("getExpressionFilter", operatorCls, filterCls, filterCls);
            Class<?> resAttrCls = Class.forName("oracle.cluster.impl.crs.ResourceAttribute");
            Object resAttrArr = Array.newInstance(resAttrCls, 1);
            Class<?> crsFactoryCls = Class.forName("oracle.cluster.impl.crs.CRSFactoryImpl");
            Method getInstance = crsFactoryCls.getDeclaredMethod("getInstance", new Class[0]);
            Method create = crsFactoryCls.getDeclaredMethod("create", String.class, String.class);
            Method stopResources = crsFactoryCls.getDeclaredMethod("stopResources", filterCls, Boolean.TYPE, Boolean.TYPE, resAttrArr.getClass());
            Object cf = getInstance.invoke(null, new Object[0]);
            this.Trace("Created CRSFactory object");
            resAttrArr = null;
            if (isDisconnect != null) {
                resAttrArr = Array.newInstance(resAttrCls, 1);
                if (isNoreplay != null) {
                    resAttrArr = Array.newInstance(resAttrCls, 2);
                    Array.set(resAttrArr, 1, create.invoke(cf, "SESSION_NOREPLAY", isNoreplay.toString()));
                    this.Trace("Set noreplay option");
                }
                Array.set(resAttrArr, 0, create.invoke(cf, "USR_ORA_DISCONNECT", isDisconnect.toString()));
                this.Trace("Set disconnect option");
            }
            Object typeFilter = getSimpleFilter.invoke(null, EQ, "TYPE", "ora.service.type");
            this.Trace(String.format("created type filter : %s", typeFilter.toString()));
            Object nameFilter = null;
            for (String db : dbs) {
                Object dbFilter = getSimpleFilter.invoke(null, STARTS_WITH, "NAME", "ora." + db.toLowerCase() + ".");
                this.Trace(String.format("created filter : %s", dbFilter.toString()));
                nameFilter = nameFilter == null ? dbFilter : getExpressionFilter.invoke(null, OR, nameFilter, dbFilter);
            }
            this.Trace(String.format("created name filter : %s", nameFilter.toString()));
            Object onlineFilter = getSimpleFilter.invoke(null, EQ, "STATE", "ONLINE");
            Object interFilter = getSimpleFilter.invoke(null, EQ, "STATE", "INTERMEDIATE");
            Object stateFilter = getExpressionFilter.invoke(null, OR, onlineFilter, interFilter);
            this.Trace(String.format("created state filter : %s", stateFilter.toString()));
            Object stopFilter = getExpressionFilter.invoke(null, AND, typeFilter, nameFilter);
            stopFilter = getExpressionFilter.invoke(null, AND, stopFilter, stateFilter);
            if (node != null) {
                Object nodeFilter = getSimpleFilter.invoke(null, EQ, "LAST_SERVER", node);
                this.Trace(String.format("created node filter : %s", nodeFilter.toString()));
                stopFilter = getExpressionFilter.invoke(null, AND, stopFilter, nodeFilter);
            }
            this.Trace(String.format("created stop filter : %s", stopFilter.toString()));
            stopResources.invoke(cf, stopFilter, true, false, resAttrArr);
        }
        catch (ClassNotFoundException e) {
            this.Trace("ClassNotFoundException : " + e.getMessage());
        }
        catch (NoSuchMethodException e) {
            this.Trace("NoSuchMethodException : " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            this.Trace("IllegalAccessException : " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            this.Trace("IllegalArgumentException : " + e.getMessage());
        }
    }

    public int stopServices(String[] args) {
        ArrayList<String> dbNames = new ArrayList<String>(Arrays.asList(args[1].split(DELIM1)));
        String node = OPTION_NOT_SPECIFIED.equals(args[2]) ? null : args[2];
        Boolean isDisconnect = OPTION_NOT_SPECIFIED.equals(args[3]) ? null : Boolean.valueOf(args[3]);
        Class<?> alreadyStoppedExceptionCls = null;
        try {
            alreadyStoppedExceptionCls = Class.forName("oracle.cluster.util.AlreadyStoppedException");
            this.Trace("Stopping services ...");
            this.stopServices(dbNames, isDisconnect, null, node);
        }
        catch (ClassNotFoundException e) {
            this.Trace("stopServices-ClassNotFoundException  : " + e.getMessage());
            this.displayErrorResult("RHPHELP_stopServices-01", 2);
            return 1;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            this.Trace("stopServices-InvocationTargetException : " + cause.getMessage());
            if (!cause.getClass().equals(alreadyStoppedExceptionCls)) {
                this.displayErrorResult(cause.getMessage(), 3);
                return 1;
            }
        }
        catch (InstantiationException e) {
            this.Trace("stopServices-InstantiationException : " + e.getMessage());
            this.displayErrorResult("RHPHELP_stopServices-03", 2);
            return 1;
        }
        this.Trace("stopped services");
        return 0;
    }

    public int startServices(String[] args) {
        ArrayList<String> resNames = new ArrayList<String>(Arrays.asList(args[1].split(DELIM1)));
        String node = OPTION_NOT_SPECIFIED.equals(args[2]) ? null : args[2];
        Class<?> alreadyRunningExceptionCls = null;
        try {
            Class<?> databaseFac = Class.forName("oracle.cluster.database.DatabaseFactory");
            Method getInstance = databaseFac.getDeclaredMethod("getInstance", new Class[0]);
            Method getService = databaseFac.getDeclaredMethod("getService", String.class, String.class);
            alreadyRunningExceptionCls = Class.forName("oracle.cluster.util.AlreadyRunningException");
            Object df = getInstance.invoke(null, new Object[0]);
            this.Trace("Created DatabaseFactory object");
            this.Trace("retrieving service objects ...");
            ArrayList<Object> services = new ArrayList<Object>();
            for (String resName : resNames) {
                this.Trace(String.format("retrieving service with resource name %s ...", resName));
                String[] vals = resName.split(DOT);
                this.Trace(String.format("db name : %s and service name : %s ...", vals[1], vals[2]));
                services.add(getService.invoke(df, vals[1], vals[2]));
            }
            this.Trace("Starting services ...");
            this.startServices(services, node);
        }
        catch (ClassNotFoundException e) {
            this.Trace("startServices-ClassNotFoundException  : " + e.getMessage());
            this.displayErrorResult("RHPHELP_startServices-01", 2);
            return 1;
        }
        catch (IllegalArgumentException e) {
            this.Trace("startServices-IllegalArgumentException : " + e.getMessage());
            this.displayErrorResult("RHPHELP_startServices-02", 2);
            return 1;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            this.Trace("startServices-InvocationTargetException : " + cause.getMessage());
            if (!cause.getClass().equals(alreadyRunningExceptionCls) && !cause.getMessage().contains("CRS-5702")) {
                this.displayErrorResult(cause.getMessage(), 3);
                return 1;
            }
        }
        catch (InstantiationException e) {
            this.Trace("startServices-InstantiationException : " + e.getMessage());
            this.displayErrorResult("RHPHELP_startServices-03", 2);
            return 1;
        }
        catch (NullPointerException e) {
            this.Trace("startServices-NullPointerException : " + e.getMessage());
            this.displayErrorResult("RHPHELP_startServices-04", 2);
            return 1;
        }
        catch (ExceptionInInitializerError e) {
            this.Trace("startServices-ExceptionInInitializerError : " + e.getMessage());
            this.displayErrorResult("RHPHELP_startServices-05", 2);
            return 1;
        }
        catch (NoSuchMethodException e) {
            this.Trace("startServices-NoSuchMethodException : " + e.getMessage());
            this.displayErrorResult("RHPHELP_startServices-05", 2);
            return 1;
        }
        catch (IllegalAccessException e) {
            this.Trace("startServices-IllegalAccessException : " + e.getMessage());
            this.displayErrorResult("RHPHELP_startServices-06", 2);
            return 1;
        }
        this.Trace("started services");
        return 0;
    }

    protected void startServices(List<Object> svcs, String node) throws InstantiationException, InvocationTargetException {
        try {
            Class<?> filterCls = Class.forName("oracle.cluster.impl.crs.Filter");
            Class<?> comparatorCls = Class.forName("oracle.cluster.impl.crs.Filter$Comparator");
            Object EQ = Enum.valueOf(comparatorCls, "EQ");
            Class<?> operatorCls = Class.forName("oracle.cluster.impl.crs.Filter$Operator");
            Object AND = Enum.valueOf(operatorCls, "AND");
            Object OR = Enum.valueOf(operatorCls, "OR");
            Class<?> filterFactoryCls = Class.forName("oracle.cluster.impl.crs.FilterFactoryImpl");
            Method getSimpleFilter = filterFactoryCls.getDeclaredMethod("getSimpleFilter", comparatorCls, String.class, String.class);
            Method getExpressionFilter = filterFactoryCls.getDeclaredMethod("getExpressionFilter", operatorCls, filterCls, filterCls);
            Class<?> resAttrCls = Class.forName("oracle.cluster.impl.crs.ResourceAttribute");
            Object resAttrArr = Array.newInstance(resAttrCls, 1);
            Class<?> crsFactoryCls = Class.forName("oracle.cluster.impl.crs.CRSFactoryImpl");
            Method getInstance = crsFactoryCls.getDeclaredMethod("getInstance", new Class[0]);
            Method startResources = crsFactoryCls.getDeclaredMethod("startResources", filterCls, Boolean.TYPE, String.class, resAttrArr.getClass());
            Class<?> serviceCls = Class.forName("oracle.cluster.database.Service");
            Method getName = serviceCls.getMethod("getName", new Class[0]);
            Object cf = getInstance.invoke(null, new Object[0]);
            this.Trace("Created CRSFactory object");
            Object typeFilter = getSimpleFilter.invoke(null, EQ, "TYPE", "ora.service.type");
            this.Trace(String.format("created type filter : %s", typeFilter.toString()));
            Object nameFilter = null;
            for (Object svc : svcs) {
                String svcName = (String)getName.invoke(svc, new Object[0]);
                this.Trace(String.format("service res name : %s", svcName));
                Object svcFilter = getSimpleFilter.invoke(null, EQ, "NAME", svcName);
                this.Trace(String.format("created filter : %s", svcFilter.toString()));
                nameFilter = nameFilter == null ? svcFilter : getExpressionFilter.invoke(null, OR, nameFilter, svcFilter);
            }
            this.Trace(String.format("created name filter : %s", nameFilter.toString()));
            Object stateFilter = getSimpleFilter.invoke(null, EQ, "STATE", "OFFLINE");
            this.Trace(String.format("created state filter : %s", stateFilter.toString()));
            Object startFilter = getExpressionFilter.invoke(null, AND, typeFilter, nameFilter);
            startFilter = getExpressionFilter.invoke(null, AND, startFilter, stateFilter);
            this.Trace(String.format("created start filter : %s", startFilter.toString()));
            startResources.invoke(cf, startFilter, false, node, null);
        }
        catch (ClassNotFoundException e) {
            this.Trace("ClassNotFoundException : " + e.getMessage());
        }
        catch (NoSuchMethodException e) {
            this.Trace("NoSuchMethodException : " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            this.Trace("IllegalAccessException : " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            this.Trace("IllegalArgumentException : " + e.getMessage());
        }
    }

    protected void startServices(List<String> dbs) throws InstantiationException, InvocationTargetException {
        try {
            Class<?> filterCls = Class.forName("oracle.cluster.impl.crs.Filter");
            Class<?> comparatorCls = Class.forName("oracle.cluster.impl.crs.Filter$Comparator");
            Object EQ = Enum.valueOf(comparatorCls, "EQ");
            Object STARTS_WITH = Enum.valueOf(comparatorCls, "STARTS_WITH");
            Class<?> operatorCls = Class.forName("oracle.cluster.impl.crs.Filter$Operator");
            Object AND = Enum.valueOf(operatorCls, "AND");
            Object OR = Enum.valueOf(operatorCls, "OR");
            Class<?> filterFactoryCls = Class.forName("oracle.cluster.impl.crs.FilterFactoryImpl");
            Method getSimpleFilter = filterFactoryCls.getDeclaredMethod("getSimpleFilter", comparatorCls, String.class, String.class);
            Method getExpressionFilter = filterFactoryCls.getDeclaredMethod("getExpressionFilter", operatorCls, filterCls, filterCls);
            Class<?> resAttrCls = Class.forName("oracle.cluster.impl.crs.ResourceAttribute");
            Object resAttrArr = Array.newInstance(resAttrCls, 1);
            Class<?> crsFactoryCls = Class.forName("oracle.cluster.impl.crs.CRSFactoryImpl");
            Method getInstance = crsFactoryCls.getDeclaredMethod("getInstance", new Class[0]);
            Method startResources = crsFactoryCls.getDeclaredMethod("startResources", filterCls, Boolean.TYPE, String.class, resAttrArr.getClass());
            Object cf = getInstance.invoke(null, new Object[0]);
            this.Trace("Created CRSFactory object");
            Object typeFilter = getSimpleFilter.invoke(null, EQ, "TYPE", "ora.service.type");
            this.Trace(String.format("created type filter : %s", typeFilter.toString()));
            Object nameFilter = null;
            for (String db : dbs) {
                Object svcFilter = getSimpleFilter.invoke(null, STARTS_WITH, "NAME", "ora." + db.toLowerCase() + ".");
                this.Trace(String.format("created filter : %s", svcFilter.toString()));
                nameFilter = nameFilter == null ? svcFilter : getExpressionFilter.invoke(null, OR, nameFilter, svcFilter);
            }
            this.Trace(String.format("created name filter : %s", nameFilter.toString()));
            Object stateFilter = getSimpleFilter.invoke(null, EQ, "STATE", "OFFLINE");
            this.Trace(String.format("created state filter : %s", stateFilter.toString()));
            Object startFilter = getExpressionFilter.invoke(null, AND, typeFilter, nameFilter);
            startFilter = getExpressionFilter.invoke(null, AND, startFilter, stateFilter);
            this.Trace(String.format("created start filter : %s", startFilter.toString()));
            startResources.invoke(cf, startFilter, false, null, null);
        }
        catch (ClassNotFoundException e) {
            this.Trace("ClassNotFoundException : " + e.getMessage());
        }
        catch (NoSuchMethodException e) {
            this.Trace("NoSuchMethodException : " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            this.Trace("IllegalAccessException : " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            this.Trace("IllegalArgumentException : " + e.getMessage());
        }
    }

    protected void stopServices(Object db, Boolean isDisconnect, Boolean isNoreplay, Object node) throws InstantiationException, InvocationTargetException {
        try {
            if (!this.isCardinalDatabase(db)) {
                this.Trace("specified database is not RAC or RAC One");
                throw new InvocationTargetException(new Exception("RHPHELP_stopSvcs2-1"));
            }
            Class<?> nodeCls = Class.forName("oracle.cluster.server.Node");
            Method nodeGetNameMethod = nodeCls.getDeclaredMethod("getName", new Class[0]);
            String nodeName = (String)nodeGetNameMethod.invoke(node, new Object[0]);
            this.Trace("stopping services on node " + nodeName);
            ArrayList<Object> nodeList = new ArrayList<Object>(Arrays.asList(node));
            Class<?> cardinalDBCls = Class.forName("oracle.cluster.database.CardinalDatabase");
            Method getVersion = cardinalDBCls.getMethod("version", new Class[0]);
            Object dbVer = getVersion.invoke(db, new Object[0]);
            Class<?> versionCls = Class.forName("oracle.ops.mgmt.cluster.Version");
            Method getMajorVersion = versionCls.getDeclaredMethod("getMajorVersion", new Class[0]);
            int majorVer = Integer.parseInt((String)getMajorVersion.invoke(dbVer, new Object[0]));
            Method services = cardinalDBCls.getMethod("services", new Class[0]);
            List svcs = (List)services.invoke(db, new Object[0]);
            if (majorVer >= 12) {
                this.Trace("stopping services of a 12.1 database ...");
                Class<?> serviceArgsCls = Class.forName("oracle.cluster.database.ServiceArgs");
                Object serviceArgsObj = serviceArgsCls.newInstance();
                this.Trace("Created ServiceArgs object");
                if (isDisconnect != null) {
                    Method setDisconnectOpt = serviceArgsCls.getDeclaredMethod("setDisconnectOpt", Boolean.TYPE);
                    setDisconnectOpt.invoke(serviceArgsObj, (boolean)isDisconnect);
                    this.Trace("Set disconnect option");
                }
                if (isNoreplay != null) {
                    Method setNoreplay = serviceArgsCls.getDeclaredMethod("setNoreplay", Boolean.TYPE);
                    setNoreplay.invoke(serviceArgsObj, (boolean)isNoreplay);
                    this.Trace("Set noreplay option");
                }
                Method setGlobal = serviceArgsCls.getDeclaredMethod("setGlobal", Boolean.TYPE);
                setGlobal.invoke(serviceArgsObj, true);
                this.Trace("Set global option");
                Method stopServices = cardinalDBCls.getMethod(METHOD_STOP_SERVICES, List.class, String.class, serviceArgsCls);
                stopServices.invoke(db, svcs, nodeName, serviceArgsObj);
                this.Trace("stopped services");
            } else {
                this.Trace("stopping services of an 11.2 database ...");
                Class<?> stopOptionCls = Class.forName("oracle.cluster.database.StopOptions");
                Object stopOptsArr = Array.newInstance(stopOptionCls, 0);
                Class<?> cardinalSvcCls = Class.forName("oracle.cluster.database.CardinalService");
                Method getSvcName = cardinalSvcCls.getMethod("getName", new Class[0]);
                Method stop = cardinalSvcCls.getMethod("stop", Boolean.TYPE, List.class);
                for (Object svc : svcs) {
                    List<List<String>> info = this.getServiceInfo(svc);
                    List<String> onlineNodes = info.get(1);
                    if (!onlineNodes.contains(nodeName)) continue;
                    String resName = (String)getSvcName.invoke(svc, new Object[0]);
                    this.Trace("stopping service " + resName);
                    stop.invoke(svc, isDisconnect != null && isDisconnect != false, nodeList);
                }
            }
        }
        catch (ClassNotFoundException e) {
            this.Trace("ClassNotFoundException : " + e);
        }
        catch (NoSuchMethodException e) {
            this.Trace("NoSuchMethodException : " + e);
        }
        catch (IllegalAccessException e) {
            this.Trace("IllegalAccessException : " + e);
        }
        catch (IllegalArgumentException e) {
            this.Trace("IllegalArgumentException : " + e);
        }
    }

    public int stopDatabases(String[] args) {
        ArrayList<String> dbs = new ArrayList<String>(Arrays.asList(args[1].split(DELIM1)));
        String node = OPTION_NOT_SPECIFIED.equals(args[2]) ? null : args[2];
        String stopOption = OPTION_NOT_SPECIFIED.equals(args[3]) ? null : args[3];
        this.Trace("Stopping databases ...");
        Class<?> alreadyStoppedExceptionCls = null;
        try {
            alreadyStoppedExceptionCls = Class.forName("oracle.cluster.util.AlreadyStoppedException");
            this.stopDatabases(dbs, stopOption, node);
        }
        catch (ClassNotFoundException e) {
            this.Trace("stopDBs-ClassNotFoundException  : " + e.getMessage());
            this.displayErrorResult("RHPHELP_stopDBs-01", 2);
            return 1;
        }
        catch (IllegalArgumentException e) {
            this.Trace("stopDBs-IllegalArgumentException : " + e.getMessage());
            this.displayErrorResult("RHPHELP_stopDBs-02", 2);
            return 1;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            this.Trace("stopDBs-InvocationTargetException : " + cause);
            if (!cause.getClass().equals(alreadyStoppedExceptionCls)) {
                this.displayErrorResult(cause.getMessage(), 3);
                return 1;
            }
        }
        catch (NullPointerException e) {
            this.Trace("stopDBs-NullPointerException : " + e.getMessage());
            this.displayErrorResult("RHPHELP_stopDBs-03", 2);
            return 1;
        }
        catch (ExceptionInInitializerError e) {
            this.Trace("stopDBs-ExceptionInInitializerError : " + e.getMessage());
            this.displayErrorResult("RHPHELP_stopDBs-04", 2);
            return 1;
        }
        catch (InstantiationException e) {
            this.Trace("stopDBs-InstantiationException : " + e.getMessage());
            this.displayErrorResult("RHPHELP_stopDBs-05", 2);
            return 1;
        }
        this.Trace("stopped databases");
        return 0;
    }

    protected void stopDatabases(List<String> dbs, String stopOption, String node) throws InstantiationException, InvocationTargetException {
        this.stopOrStartDatabases(dbs, node, true, stopOption);
    }

    protected void startDatabases(List<String> dbs, String node) throws InstantiationException, InvocationTargetException {
        this.stopOrStartDatabases(dbs, node, false, null);
    }

    private void stopOrStartDatabases(List<String> dbs, String node, boolean isStop, String stopOption) throws InstantiationException, InvocationTargetException {
        try {
            Class<?> filterCls = Class.forName("oracle.cluster.impl.crs.Filter");
            Class<?> comparatorCls = Class.forName("oracle.cluster.impl.crs.Filter$Comparator");
            Object EQ = Enum.valueOf(comparatorCls, "EQ");
            Object STARTS_WITH = Enum.valueOf(comparatorCls, "STARTS_WITH");
            Class<?> operatorCls = Class.forName("oracle.cluster.impl.crs.Filter$Operator");
            Object AND = Enum.valueOf(operatorCls, "AND");
            Object OR = Enum.valueOf(operatorCls, "OR");
            Class<?> filterFactoryCls = Class.forName("oracle.cluster.impl.crs.FilterFactoryImpl");
            Method getSimpleFilter = filterFactoryCls.getDeclaredMethod("getSimpleFilter", comparatorCls, String.class, String.class);
            Method getExpressionFilter = filterFactoryCls.getDeclaredMethod("getExpressionFilter", operatorCls, filterCls, filterCls);
            Class<?> resAttrCls = Class.forName("oracle.cluster.impl.crs.ResourceAttribute");
            Object resAttrArr = Array.newInstance(resAttrCls, 1);
            Class<?> crsFactoryCls = Class.forName("oracle.cluster.impl.crs.CRSFactoryImpl");
            Method getInstance = crsFactoryCls.getDeclaredMethod("getInstance", new Class[0]);
            Method create = crsFactoryCls.getDeclaredMethod("create", String.class, String.class);
            Method stopResources = crsFactoryCls.getDeclaredMethod("stopResources", filterCls, Boolean.TYPE, Boolean.TYPE, resAttrArr.getClass());
            Method startResources = crsFactoryCls.getDeclaredMethod("startResources", filterCls, Boolean.TYPE, String.class, resAttrArr.getClass());
            Object cf = getInstance.invoke(null, new Object[0]);
            this.Trace("Created CRSFactory object");
            resAttrArr = null;
            if (isStop && stopOption != null) {
                resAttrArr = Array.newInstance(resAttrCls, 1);
                Array.set(resAttrArr, 0, create.invoke(cf, "USR_ORA_STOP_MODE", stopOption));
            }
            Object typeFilter = getSimpleFilter.invoke(null, EQ, "TYPE", "ora.database.type");
            this.Trace(String.format("created type filter : %s", typeFilter.toString()));
            Object nameFilter = null;
            for (String db : dbs) {
                Object dbFilter = getSimpleFilter.invoke(null, EQ, "NAME", "ora." + db.toLowerCase() + ".db");
                this.Trace(String.format("created filter : %s", dbFilter.toString()));
                nameFilter = nameFilter == null ? dbFilter : getExpressionFilter.invoke(null, OR, nameFilter, dbFilter);
            }
            this.Trace(String.format("created name filter : %s", nameFilter.toString()));
            Object stateFilter = null;
            if (isStop) {
                Object onlineFilter = getSimpleFilter.invoke(null, EQ, "STATE", "ONLINE");
                Object interFilter = getSimpleFilter.invoke(null, EQ, "STATE", "INTERMEDIATE");
                stateFilter = getExpressionFilter.invoke(null, OR, onlineFilter, interFilter);
            } else {
                stateFilter = getSimpleFilter.invoke(null, EQ, "STATE", "OFFLINE");
            }
            this.Trace(String.format("created state filter : %s", stateFilter.toString()));
            Object filter = getExpressionFilter.invoke(null, AND, typeFilter, nameFilter);
            filter = getExpressionFilter.invoke(null, AND, filter, stateFilter);
            if (isStop && node != null) {
                Object nodeFilter = getSimpleFilter.invoke(null, EQ, "LAST_SERVER", node);
                this.Trace(String.format("created node filter : %s", nodeFilter.toString()));
                filter = getExpressionFilter.invoke(null, AND, filter, nodeFilter);
            }
            if (isStop) {
                this.Trace(String.format("stopping databases using filter : %s", filter.toString()));
                stopResources.invoke(cf, filter, true, false, resAttrArr);
            } else {
                this.Trace(String.format("starting databases using filter : %s", filter.toString()));
                startResources.invoke(cf, filter, false, node, resAttrArr);
            }
        }
        catch (ClassNotFoundException e) {
            this.Trace("ClassNotFoundException : " + e.getMessage());
        }
        catch (NoSuchMethodException e) {
            this.Trace("NoSuchMethodException : " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            this.Trace("IllegalAccessException : " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            this.Trace("IllegalArgumentException : " + e.getMessage());
        }
    }

    public int startDatabases(String[] args) {
        ArrayList<String> dbs = new ArrayList<String>(Arrays.asList(args[1].split(DELIM1)));
        String node = OPTION_NOT_SPECIFIED.equals(args[2]) ? null : args[2];
        this.Trace("Starting databases ...");
        Class<?> alreadyRunningExceptionCls = null;
        try {
            alreadyRunningExceptionCls = Class.forName("oracle.cluster.util.AlreadyRunningException");
            this.startDatabases(dbs, node);
        }
        catch (ClassNotFoundException e) {
            this.Trace("startDBs-ClassNotFoundException  : " + e.getMessage());
            this.displayErrorResult("RHPHELP_startDBs-01", 2);
            return 1;
        }
        catch (IllegalArgumentException e) {
            this.Trace("startDBs-IllegalArgumentException : " + e.getMessage());
            this.displayErrorResult("RHPHELP_startDBs-02", 2);
            return 1;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            this.Trace("startDBs-InvocationTargetException : " + cause.getMessage());
            if (!cause.getClass().equals(alreadyRunningExceptionCls) && !cause.getMessage().contains("CRS-5702")) {
                this.displayErrorResult(cause.getMessage(), 3);
                return 1;
            }
        }
        catch (InstantiationException e) {
            this.Trace("startDBs-InstantiationException : " + e.getMessage());
            this.displayErrorResult("RHPHELP_startDBs-03", 2);
            return 1;
        }
        catch (NullPointerException e) {
            this.Trace("startDBs-NullPointerException : " + e.getMessage());
            this.displayErrorResult("RHPHELP_startDBs-04", 2);
            return 1;
        }
        catch (ExceptionInInitializerError e) {
            this.Trace("startDBs-ExceptionInInitializerError : " + e.getMessage());
            this.displayErrorResult("RHPHELP_startDBs-05", 2);
            return 1;
        }
        this.Trace("started databases");
        return 0;
    }

    public int getServiceInfo(String[] args) {
        this.Trace("Running getServiceInfo ...");
        try {
            List<String> dbNames = new ArrayList<String>();
            if (args.length > 1) {
                dbNames = Arrays.asList(args[1].split(DELIM1));
            }
            Map<String, List<List<String>>> svcInfo = this.getServiceInfo(dbNames);
            StringBuilder result = new StringBuilder();
            for (String svc : svcInfo.keySet()) {
                result.append(svc);
                result.append(DELIM2);
                List<List<String>> val = svcInfo.get(svc);
                result.append(this.list2String(val.get(0), DELIM1));
                result.append(DELIM2);
                result.append(this.list2String(val.get(1), DELIM1));
                result.append(DELIM2);
                result.append(this.list2String(val.get(2), DELIM1));
                result.append(DELIM3);
            }
            this.Trace("result is " + result.toString());
            String print = "";
            if (result.length() > 0) {
                print = result.substring(0, result.length() - DELIM3.length());
            }
            this.displaySuccessResult(print, 0);
            return 0;
        }
        catch (InvocationTargetException e) {
            this.Trace("InvocationTargetException : " + e.getCause());
            this.displayErrorResult(e.getCause().getMessage(), 3);
            return 1;
        }
    }

    protected Map<String, List<List<String>>> getServiceInfo(List<String> dbNames) throws InvocationTargetException {
        this.Trace("retrieving service info ...");
        HashMap<String, List<List<String>>> retVal = new HashMap<String, List<List<String>>>();
        try {
            List<Object> dbs = this.getDatabases(dbNames);
            Class<?> dbCls = Class.forName("oracle.cluster.database.Database");
            Method services = dbCls.getDeclaredMethod("services", new Class[0]);
            Class<?> svcCls = Class.forName("oracle.cluster.database.Service");
            Method getSvcName = svcCls.getMethod("getName", new Class[0]);
            for (Object db : dbs) {
                List svcs = (List)services.invoke(db, new Object[0]);
                if (svcs.isEmpty()) continue;
                for (Object svc : svcs) {
                    List<List<String>> val = this.getServiceInfo(svc);
                    String resName = (String)getSvcName.invoke(svc, new Object[0]);
                    retVal.put(resName, val);
                }
            }
            this.Trace("retrieved service info");
        }
        catch (ClassNotFoundException e) {
            this.Trace("ClassNotFoundException : " + e);
        }
        catch (NoSuchMethodException e) {
            this.Trace("NoSuchMethodException : " + e);
        }
        catch (IllegalAccessException e) {
            this.Trace("IllegalAccessException : " + e);
        }
        catch (IllegalArgumentException e) {
            this.Trace("IllegalArgumentException : " + e);
        }
        return retVal;
    }

    protected List<List<String>> getServiceInfo(Object svc) throws InvocationTargetException {
        this.Trace("retrieving service info ...");
        ArrayList<List<String>> val = new ArrayList<List<String>>();
        try {
            Class<?> svcCls = Class.forName("oracle.cluster.impl.database.ServiceImpl");
            Method getSvcName = svcCls.getMethod("getName", new Class[0]);
            Method getServerGroup = svcCls.getMethod("serverGroup", new Class[0]);
            Method crsResource = svcCls.getMethod("crsResource", new Class[0]);
            Class<?> crsResCls = Class.forName("oracle.cluster.crs.CRSResource");
            Method fetchRunningNodes = crsResCls.getMethod("fetchRunningNodes", new Class[0]);
            Method fetchDisabledNodes = crsResCls.getMethod("fetchDisabledNodes", new Class[0]);
            Class<?> srvGrpCls = Class.forName("oracle.cluster.server.ServerGroup");
            Method servers = srvGrpCls.getMethod("servers", new Class[0]);
            Class<?> serverCls = Class.forName("oracle.cluster.server.Server");
            Method getServerName = serverCls.getMethod("getName", new Class[0]);
            Class<?> nodeCls = Class.forName("oracle.cluster.server.Node");
            Method getNodeName = nodeCls.getMethod("getName", new Class[0]);
            String resName = (String)getSvcName.invoke(svc, new Object[0]);
            this.Trace("processing service " + resName);
            Object srvGrp = getServerGroup.invoke(svc, new Object[0]);
            ArrayList<Object> allNodes = new ArrayList<Object>();
            for (Object server : (List)servers.invoke(srvGrp, new Object[0])) {
                String srvName = (String)getServerName.invoke(server, new Object[0]);
                this.Trace("service " + resName + "'s server pool contains " + (String)srvName);
                allNodes.add(srvName);
            }
            Object crsRes = crsResource.invoke(svc, new Object[0]);
            ArrayList<String> onlineNodes = new ArrayList<String>();
            for (Object node : (List)fetchRunningNodes.invoke(crsRes, new Object[0])) {
                String nodeName = (String)getNodeName.invoke(node, new Object[0]);
                this.Trace("service " + resName + " is running on " + nodeName);
                onlineNodes.add(nodeName);
            }
            ArrayList<String> disabledNodes = new ArrayList<String>();
            for (Object node : (List)fetchDisabledNodes.invoke(crsRes, new Object[0])) {
                String nodeName = (String)getNodeName.invoke(node, new Object[0]);
                this.Trace("service " + resName + " is disabled on " + nodeName);
                disabledNodes.add(nodeName);
            }
            val.add(allNodes);
            val.add(onlineNodes);
            val.add(disabledNodes);
        }
        catch (ClassNotFoundException e) {
            this.Trace("ClassNotFoundException : " + e);
        }
        catch (NoSuchMethodException e) {
            this.Trace("NoSuchMethodException : " + e);
        }
        catch (IllegalAccessException e) {
            this.Trace("IllegalAccessException : " + e);
        }
        catch (IllegalArgumentException e) {
            this.Trace("IllegalArgumentException : " + e);
        }
        return val;
    }

    protected List<Object> getDatabases(List<String> dbNames) throws InvocationTargetException {
        ArrayList<Object> dbs = new ArrayList<Object>();
        try {
            Class<?> databaseFac = Class.forName("oracle.cluster.database.DatabaseFactory");
            Method getInstance = databaseFac.getDeclaredMethod("getInstance", new Class[0]);
            Object df = getInstance.invoke(null, new Object[0]);
            this.Trace("Created DatabaseFactory object");
            if (dbNames == null || dbNames.isEmpty()) {
                this.Trace("retrieving names of all configured databases ...");
                Method getDatabaseInfos = databaseFac.getDeclaredMethod("getDatabaseInfos", new Class[0]);
                Map dbInfos = (Map)getDatabaseInfos.invoke(df, new Object[0]);
                dbNames = new ArrayList(dbInfos.keySet());
                this.Trace("retrieved names of all configured databases");
            }
            Method getDatabaseVersion = databaseFac.getDeclaredMethod("getDatabaseVersion", String.class);
            Class<?> versionCls = Class.forName("oracle.ops.mgmt.cluster.Version");
            Method getDatabase = databaseFac.getDeclaredMethod("getDatabase", String.class, versionCls);
            for (String dbName : dbNames) {
                this.Trace("retrieving database " + dbName);
                Object dbVer = getDatabaseVersion.invoke(df, dbName);
                this.Trace("database is of version " + dbVer.toString());
                Object db = getDatabase.invoke(df, dbName, dbVer);
                this.Trace("retrieved database " + dbName);
                dbs.add(db);
            }
        }
        catch (ClassNotFoundException e) {
            this.Trace("ClassNotFoundException : " + e);
        }
        catch (NoSuchMethodException e) {
            this.Trace("NoSuchMethodException : " + e);
        }
        catch (IllegalAccessException e) {
            this.Trace("IllegalAccessException : " + e);
        }
        catch (IllegalArgumentException e) {
            this.Trace("IllegalArgumentException : " + e);
        }
        return dbs;
    }

    protected List<Object> getNodes(List<String> nodes) throws InvocationTargetException {
        ArrayList<Object> retval = new ArrayList<Object>();
        try {
            Class<?> serverFac = Class.forName("oracle.cluster.server.ServerFactory");
            Method getInstance = serverFac.getDeclaredMethod("getInstance", new Class[0]);
            Object sf = getInstance.invoke(null, new Object[0]);
            this.Trace("Created ServerFactory object");
            Method getNode = serverFac.getDeclaredMethod("getNode", String.class);
            for (String node : nodes) {
                retval.add(getNode.invoke(sf, node));
            }
        }
        catch (ClassNotFoundException e) {
            this.Trace("ClassNotFoundException : " + e);
        }
        catch (NoSuchMethodException e) {
            this.Trace("NoSuchMethodException : " + e);
        }
        catch (IllegalAccessException e) {
            this.Trace("IllegalAccessException : " + e);
        }
        catch (IllegalArgumentException e) {
            this.Trace("IllegalArgumentException : " + e);
        }
        return retval;
    }

    protected List<String> processServiceResName(String resName) {
        ArrayList<String> retVal = new ArrayList<String>();
        String dup = new String(resName);
        dup = dup.replaceFirst("^ora\\.", "");
        dup = dup.substring(0, dup.lastIndexOf(46));
        String dbName = dup.substring(0, dup.indexOf(46));
        String svcName = dup.substring(dup.indexOf(46) + 1);
        retVal.add(dbName);
        retVal.add(svcName);
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateOratab(String[] args) {
        String sid = args[1];
        String home = args[2];
        home = home.endsWith(File.separator) ? home.substring(0, home.length() - 1) : home;
        String oratabPath = "/etc/oratab";
        this.Trace("updating /etc/oratab for sid " + sid + " to use home " + home);
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader bufferedReader = null;
        try {
            this.Trace("reading /etc/oratab file ...");
            FileReader fileReader = new FileReader(oratabPath);
            bufferedReader = new BufferedReader(fileReader);
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                lines.add(line);
            }
            this.Trace("contents of /etc/oratab file : " + ((Object)lines).toString());
            if (lines.isEmpty()) {
                this.Trace("nothing to modify");
                int n = 0;
                return n;
            }
        }
        catch (FileNotFoundException e) {
            this.Trace("/etc/oratab file doesn't exist : " + e.getMessage());
            this.displayErrorResult(e.getMessage(), 2);
            int line = 1;
            return line;
        }
        catch (IOException e) {
            this.Trace("failed to read /etc/oratab file : " + e.getMessage());
            this.displayErrorResult(e.getMessage(), 2);
            int line = 1;
            return line;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException ioe) {
                    this.Trace("failed to close BufferedReader for /etc/oratab : " + ioe.getMessage());
                    this.displayErrorResult(ioe.getMessage(), 2);
                    return 1;
                }
            }
        }
        ArrayList<String> newContents = new ArrayList<String>();
        try {
            String localHost = InetAddress.getLocalHost().getHostName().split(DOT)[0];
            String backupFile = home + "/srvm/admin/oratab.bak." + localHost;
            this.Trace("Copying /etc/oratab to " + backupFile);
            Class<?> clusterCmdClass = Class.forName("oracle.ops.mgmt.cluster.ClusterCmd");
            this.Trace("Got ClusterCmd class");
            Object clusterCmdObj = clusterCmdClass.newInstance();
            this.Trace("Created ClusterCmd object");
            Method copyFileBetweenNodes = clusterCmdClass.getMethod("copyFileBetweenNodes", String.class, String.class, String.class, String.class);
            this.Trace("Invoking copyFileBetweenNodes method ...");
            copyFileBetweenNodes.invoke(clusterCmdObj, "localnode", oratabPath, "localnode", backupFile);
            this.Trace("Copied /etc/oratab to " + backupFile);
            lines.remove(0);
            lines.add(0, "#Backup file is  " + backupFile + " line added by RHP");
            for (String line : lines) {
                if (line.startsWith(sid + ":")) {
                    this.Trace("changing line : " + line);
                    String[] vals = line.split(":");
                    line = vals[0] + ":" + home + ":" + vals[2];
                }
                newContents.add(line);
            }
        }
        catch (UnknownHostException e) {
            this.Trace("failed to get local host name : " + e.getMessage());
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        catch (InstantiationException e) {
            this.Trace("failed to instantiate ClusterCmd object : " + e);
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        catch (InvocationTargetException e) {
            this.Trace("copyFileBetweenNodes failed with exception : " + e.getCause());
            this.displayErrorResult(e.getCause().getMessage(), 3);
            return 1;
        }
        catch (ClassNotFoundException e) {
            this.Trace("failed to find oracle.ops.mgmt.cluster.ClusterCmd : " + e);
        }
        catch (NoSuchMethodException e) {
            this.Trace("failed to get method copyFileBetweenNodes : " + e);
        }
        catch (IllegalAccessException e) {
            this.Trace("failed to invoke method copyFileBetweenNodes : " + e);
        }
        catch (IllegalArgumentException e) {
            this.Trace("method copyFileBetweenNodes got illegal arguments : " + e);
        }
        this.Trace("contents of /etc/oratab will be changed to : " + ((Object)newContents).toString());
        BufferedWriter bufferedWriter = null;
        try {
            this.Trace("writing to /etc/oratab file ...");
            FileWriter fileWriter = new FileWriter(oratabPath, false);
            bufferedWriter = new BufferedWriter(fileWriter);
            for (String line : newContents) {
                bufferedWriter.write(line);
                bufferedWriter.newLine();
            }
            this.Trace("completed writing to /etc/oratab file");
        }
        catch (IOException e) {
            this.Trace("failed to write to /etc/oratab file : " + e.getMessage());
            this.displayErrorResult(e.getMessage(), 2);
            int n = 1;
            return n;
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException ioe) {
                    this.Trace("failed to close BufferedWriter for /etc/oratab : " + ioe.getMessage());
                    this.displayErrorResult(ioe.getMessage(), 2);
                    return 1;
                }
            }
        }
        return 0;
    }

    public int getOracleHomes(String[] args) {
        try {
            String compName = "deinstall";
            Class<?> inventorySessionClass = Class.forName("oracle.sysman.oii.oiic.OiicStandardInventorySession");
            Class<?> versionCls = Class.forName("oracle.ops.mgmt.cluster.Version");
            Object verObject = versionCls.newInstance();
            this.Trace("Created Version object");
            String versionStr = verObject.toString();
            this.Trace("Version is " + versionStr);
            Constructor<?> inventorySessionConst = inventorySessionClass.getConstructor(String.class, String.class);
            this.Trace("Got the construtor method");
            Object inventorySessionOb = inventorySessionConst.newInstance(compName, versionStr);
            this.Trace("Got the constructor object");
            Class<?> instAreaControlClass = Class.forName("oracle.sysman.oii.oiii.OiiiInstallAreaControl");
            Integer accessLevelRead = (Integer)instAreaControlClass.getDeclaredField("ACCESSLEVEL_READ_LOCKLESS").get(null);
            Method initSessionMethod = inventorySessionClass.getDeclaredMethod("initSession", Integer.TYPE);
            initSessionMethod.invoke(inventorySessionOb, (int)accessLevelRead);
            this.Trace("Got till inventorySeesion Object");
            Class[] argTypeNone = new Class[]{};
            Object[] argumentNone = null;
            Method installAreaControlMethod = inventorySessionClass.getDeclaredMethod("getInstallAreaControl", argTypeNone);
            Object instAreaControlOb = installAreaControlMethod.invoke(inventorySessionOb, argumentNone);
            this.Trace("Got till install Area control Object");
            Method getInventoryMethod = instAreaControlClass.getDeclaredMethod("getInstallInventory", argTypeNone);
            this.Trace("Got till get Inventory method");
            Object inventoryOb = getInventoryMethod.invoke(instAreaControlOb, argumentNone);
            this.Trace("Got the inventory");
            Class<?> inventoryClass = Class.forName("oracle.sysman.oii.oiii.OiiiInstallInventory");
            Class<?> oiHomeInfoClass = Class.forName("oracle.sysman.oii.oiii.OiiiOracleHomeInfo");
            Method getHomeMethod = inventoryClass.getDeclaredMethod("getHomes", argTypeNone);
            Method getLocationMethod = oiHomeInfoClass.getDeclaredMethod("getLocation", argTypeNone);
            Vector oracleHomes = (Vector)getHomeMethod.invoke(inventoryOb, argumentNone);
            this.Trace("Got the oracleHomes");
            String oracleHomeStr = "";
            if (null != oracleHomes) {
                StringBuffer retStringBuf = new StringBuffer();
                for (int j = 0; j < oracleHomes.size(); ++j) {
                    Object oiHomeInfo = oracleHomes.elementAt(j);
                    String homeLoc = (String)getLocationMethod.invoke(oiHomeInfo, argumentNone);
                    this.Trace("OracleHome is " + homeLoc);
                    retStringBuf.append(homeLoc + DELIM1);
                }
                if (retStringBuf.length() > 0) {
                    oracleHomeStr = retStringBuf.substring(0, retStringBuf.length() - 1);
                }
            }
            this.displaySuccessResult(oracleHomeStr, 0);
        }
        catch (ClassNotFoundException e) {
            this.Trace("ClassNotFoundException : " + e);
            this.displayErrorResult("RHPHELP_getOracleHomes-01", 2);
            return 1;
        }
        catch (NoSuchMethodException e) {
            this.Trace("NoSuchMethodException : " + e);
            this.displayErrorResult("RHPHELP_getOracleHomes-02", 2);
            return 1;
        }
        catch (NoSuchFieldException e) {
            this.Trace("NoSuchMethodException : " + e);
            this.displayErrorResult("RHPHELP_getOracleHomes-02", 2);
            return 1;
        }
        catch (IllegalAccessException e) {
            this.Trace("IllegalAccessException : " + e);
            this.displayErrorResult("RHPHELP_getOracleHomes-03", 2);
            return 1;
        }
        catch (InstantiationException e) {
            this.Trace("InstantiationException : " + e);
            this.displayErrorResult("RHPHELP_getOracleHomes-04", 2);
            return 1;
        }
        catch (InvocationTargetException e) {
            this.Trace("InvocationTargetException : " + e.getCause());
            this.displayErrorResult(e.getCause().getMessage(), 3);
            return 1;
        }
        return 0;
    }

    public int checkEnoughSpace(String[] args) {
        this.Trace("Framework home is " + args[1]);
        this.Trace("Nodes are " + args[2]);
        this.Trace("Path is" + args[3]);
        this.Trace("Size is " + args[4]);
        String frameworkHome = args[1];
        String[] nodeList = args[2].split(DELIM1);
        String[] nodeListArr = this.getNodeListArr(Arrays.asList(nodeList));
        String path = args[3];
        Long size = Long.parseLong(args[4]);
        try {
            Class<?> clusterVerificationCls = Class.forName("oracle.cluster.verification.ClusterVerification");
            this.Trace("Check if at least " + args[4] + " GB space is available for " + path);
            Class<?> pathTypeCls = Class.forName("oracle.cluster.verification.ClusterVerification$PathType");
            Object pathType = Enum.valueOf(pathTypeCls, "FRAMEWORK_HOME");
            Class<?> storageTypeCls = Class.forName("oracle.cluster.verification.StorageUnit");
            Object GBYTE = Enum.valueOf(storageTypeCls, "GBYTE");
            this.Trace("Verification task: Got the enum types");
            Class[] argTypes = new Class[]{String.class, pathTypeCls};
            Method method = clusterVerificationCls.getDeclaredMethod("getInstance", argTypes);
            Object cvu = method.invoke(null, frameworkHome, pathType);
            argTypes = new Class[]{String[].class, String.class, Long.TYPE, storageTypeCls};
            Object[] argumentList = new Object[]{nodeListArr, path, size, GBYTE};
            Method checkMethod = clusterVerificationCls.getDeclaredMethod("checkSpaceAvailability", argTypes);
            this.Trace("Got the method checkSpaceAvailability");
            Object resultSet = checkMethod.invoke(cvu, argumentList);
            this.Trace("Executed the method");
            String errMsg = this.getErrorMessage(resultSet);
            if (errMsg.length() > 0) {
                this.Trace("Error Message is " + errMsg);
                this.displayErrorResult(errMsg, 3);
            }
            this.Trace("Checked the results for error messages. No error found.");
            return 0;
        }
        catch (NoSuchMethodException e) {
            this.Trace("Got Exception while checkSpaceAvailability :" + e.getMessage());
            this.displayErrorResult(e.getMessage(), 3);
            return 0;
        }
        catch (ClassNotFoundException e) {
            this.Trace("Got Exception while checkSpaceAvailability :" + e.getMessage());
            this.displayErrorResult(e.getMessage(), 3);
            return 0;
        }
        catch (IllegalAccessException e) {
            this.Trace("Got Exception while checkSpaceAvailability :" + e.getMessage());
            this.displayErrorResult(e.getMessage(), 3);
            return 0;
        }
        catch (InvocationTargetException e) {
            this.Trace("Got Exception while checkSpaceAvailability :" + e.getMessage());
            this.displayErrorResult(e.getMessage(), 3);
            return 0;
        }
        catch (Throwable e) {
            this.Trace(e.getMessage());
            this.displayErrorResult(e.getMessage(), 3);
            return 0;
        }
    }

    protected int mergeSqlNetOraPre122(String[] args) {
        this.Trace("Merging sqlnet.ora files ...");
        String srcHome = args[1];
        String dstHome = args[2];
        String srcFile = srcHome + SQLNET_FILE_PATH;
        String tgtFile = dstHome + SQLNET_FILE_PATH;
        try {
            File f = new File(srcFile);
            if (!f.exists()) {
                this.Trace("Nothing to be done");
                return 0;
            }
            Class<?> configClass = Class.forName("oracle.net.config.Config");
            Class<?> profileClass = Class.forName("oracle.net.config.Profile");
            Class<?> nlParserClass = Class.forName("oracle.net.nl.NLParamParser");
            Class<?> nnlWrapClass = Class.forName("oracle.net.ldap.NNFLWrapper");
            Class<?> nvPairClass = Class.forName("oracle.net.nl.NVPair");
            Class<?> utilClass = Class.forName("oracle.ops.mgmt.has.Util");
            Class<?> cluCmdClass = Class.forName("oracle.ops.mgmt.cluster.ClusterCmd");
            this.Trace("Creating Config objects ...");
            int authMethod = (Integer)nnlWrapClass.getDeclaredField("NNFL_AUTH_NONE").get(null);
            Constructor<?> configConstr = configClass.getDeclaredConstructor(String.class, Integer.TYPE, String[].class);
            Object srcConfig = configConstr.newInstance(srcFile, authMethod, null);
            Object tgtConfig = configConstr.newInstance(tgtFile, authMethod, null);
            int profType = (Integer)configClass.getDeclaredField("PROFILE").get(null);
            Method setFileName = configClass.getDeclaredMethod("setFilename", Integer.TYPE, String.class);
            setFileName.invoke(srcConfig, profType, srcFile);
            setFileName.invoke(tgtConfig, profType, tgtFile);
            Constructor<?> profConstr = profileClass.getDeclaredConstructor(configClass);
            Object srcServ = profConstr.newInstance(srcConfig);
            Object tgtServ = profConstr.newInstance(tgtConfig);
            this.Trace("Creating NLParamParser objects ...");
            Method getNlpa = configClass.getDeclaredMethod("getNlpa", Integer.TYPE);
            Object srcNlpa = getNlpa.invoke(srcConfig, profType);
            Object tgtNlpa = getNlpa.invoke(tgtConfig, profType);
            File tgtFObj = new File(tgtFile);
            Method getParameter = profileClass.getSuperclass().getDeclaredMethod("getParameter", String.class);
            String wallParam = (String)getParameter.invoke(srcServ, WALLET_LOCATION);
            Method saveNLParams = nlParserClass.getDeclaredMethod("saveNLParams", String.class);
            if (wallParam == null) {
                if (!tgtFObj.exists()) {
                    this.Trace("Target file does not exist, copying source file...");
                    tgtFObj.createNewFile();
                    saveNLParams.invoke(srcNlpa, tgtFile);
                }
            } else {
                if (!tgtFObj.exists()) {
                    tgtConfig = configConstr.newInstance(srcFile, authMethod, null);
                    setFileName.invoke(tgtConfig, profType, srcFile);
                    tgtNlpa = getNlpa.invoke(tgtConfig, profType);
                    Method removeNLPListElement = nlParserClass.getDeclaredMethod("removeNLPListElement", String.class);
                    removeNLPListElement.invoke(tgtNlpa, WALLET_LOCATION);
                }
                if ((wallParam = (String)getParameter.invoke(tgtServ, WALLET_LOCATION)) == null) {
                    Method getNLPListElement = nlParserClass.getDeclaredMethod("getNLPListElement", String.class);
                    Object nvp = getNLPListElement.invoke(srcNlpa, WALLET_LOCATION);
                    Method getListElement = nvPairClass.getDeclaredMethod("getListElement", Integer.TYPE);
                    Method nvpToString = nvPairClass.getDeclaredMethod("toString", new Class[0]);
                    Method setAtom = nvPairClass.getDeclaredMethod("setAtom", String.class);
                    Method addNLPListElement = nlParserClass.getDeclaredMethod("addNLPListElement", String.class);
                    Object nvpFirst = getListElement.invoke(nvp, 0);
                    String val = (String)nvpToString.invoke(nvpFirst, new Object[0]);
                    String valU = val.toUpperCase();
                    int dirIx = valU.indexOf(DIRECTORY_KEYWORD);
                    int mIx = valU.indexOf(METHOD_KEYWORD);
                    int fIx = valU.indexOf(FILE_KEYWORD);
                    if (mIx != -1 && fIx != -1 && fIx < dirIx) {
                        int bracIx = val.indexOf(CLOSE_PAREN, dirIx);
                        int eqIx = val.indexOf(EQUALS, dirIx);
                        if (bracIx != -1 && eqIx != -1) {
                            String wallPath = val.substring(eqIx + 1, bracIx);
                            this.Trace("Wallet path is: " + wallPath);
                            File ohomeF = new File(srcHome);
                            File wallF = new File(wallPath);
                            String ohomeStr = ohomeF.getCanonicalPath();
                            String wallStr = wallF.getCanonicalPath();
                            if (wallStr.startsWith(ohomeStr)) {
                                this.Trace("Wallet belongs to oracle home: " + srcHome);
                                Constructor<?> utilConst = utilClass.getConstructor(new Class[0]);
                                Constructor<?> cluCmdConst = cluCmdClass.getConstructor(new Class[0]);
                                Object util = utilConst.newInstance(new Object[0]);
                                Object cCmd = cluCmdConst.newInstance(new Object[0]);
                                Method getLocalHostName = utilClass.getDeclaredMethod("getLocalHostName", new Class[0]);
                                Method getCRSHome = utilClass.getDeclaredMethod("getCRSHome", new Class[0]);
                                String localHost = (String)getLocalHostName.invoke(util, new Object[0]);
                                String crsHome = (String)getCRSHome.invoke(util, new Object[0]);
                                File destF = new File(dstHome);
                                String destStr = destF.getCanonicalPath();
                                String relPathStr = wallStr.substring(ohomeStr.length());
                                String tgtPathStr = destStr + relPathStr;
                                String tmpDir = System.getProperty("java.io.tmpdir");
                                this.Trace("About to call transfer API with args: ohome: " + crsHome + ",host: " + localHost + ",srcPath: " + wallStr + ",tgtPath: " + tgtPathStr + ",tmpDir: " + tmpDir);
                                Method transferDirStructureToNodes = cluCmdClass.getDeclaredMethod("transferDirStructureToNodes", String.class, String[].class, String.class, String.class, String.class, String.class, String[].class);
                                transferDirStructureToNodes.invoke(cCmd, crsHome, new String[]{localHost}, wallStr, null, null, tmpDir, new String[]{tgtPathStr});
                                String newWalStr = val.substring(0, eqIx + 1) + tgtPathStr + val.substring(bracIx);
                                this.Trace("Transfer done, updating WALLET_LOCATION parameter with: " + newWalStr);
                                setAtom.invoke(nvp, newWalStr);
                                String nvpStr = (String)nvpToString.invoke(nvp, new Object[0]);
                                addNLPListElement.invoke(tgtNlpa, nvpStr);
                                saveNLParams.invoke(tgtNlpa, tgtFile);
                            } else {
                                this.Trace("Wallet directory [" + wallStr + "] does not belong to oracle home [" + ohomeStr + "]");
                                if (!tgtFObj.exists()) {
                                    saveNLParams.invoke(srcNlpa, tgtFile);
                                } else {
                                    setAtom.invoke(nvp, wallPath);
                                    String nvpStr = (String)nvpToString.invoke(nvp, new Object[0]);
                                    addNLPListElement.invoke(tgtNlpa, nvpStr);
                                    saveNLParams.invoke(tgtNlpa, tgtFile);
                                }
                            }
                        }
                    }
                }
            }
            this.Trace("sqlnet.ora merge complete.");
            return 0;
        }
        catch (ClassNotFoundException e) {
            this.Trace("Pre122mergeSqlNet-ClassNotFoundException  : " + e);
            this.displayErrorResult("RHPHELP_Pre122_mergeSQL-01", 2);
            return 1;
        }
        catch (InstantiationException e) {
            this.Trace("Pre122mergeSqlNet-InstantiationException  : " + e);
            this.displayErrorResult("RHPHELP_Pre122_mergeSQL-02", 2);
            return 1;
        }
        catch (IllegalAccessException e) {
            this.Trace("Pre122mergeSqlNet-IllegalAccessException  : " + e);
            this.displayErrorResult("RHPHELP_Pre122_mergeSQL-03", 2);
            return 1;
        }
        catch (IllegalArgumentException e) {
            this.Trace("Pre122mergeSqlNet-IllegalArgumentException  : " + e);
            this.displayErrorResult("RHPHELP_Pre122_mergeSQL-04", 2);
            return 1;
        }
        catch (InvocationTargetException e) {
            this.Trace("Pre122mergeSqlNet-InvocationTargetException  : " + e.getCause());
            this.displayErrorResult(e.getCause().getMessage(), 3);
            return 1;
        }
        catch (IOException e) {
            this.Trace("Pre122mergeSqlNet-IOException  : " + e);
            this.displayErrorResult("RHPHELP_Pre122_mergeSQL-05", 2);
            return 1;
        }
        catch (NoSuchMethodException e) {
            this.Trace("Pre122mergeSqlNet-NoSuchMethodException  : " + e);
            this.displayErrorResult("RHPHELP_Pre122_mergeSQL-06", 2);
            return 1;
        }
        catch (NoSuchFieldException e) {
            this.Trace("Pre122mergeSqlNet-NoSuchFieldException  : " + e);
            this.displayErrorResult("RHPHELP_Pre122_mergeSQL-07", 2);
            return 1;
        }
        catch (NullPointerException e) {
            this.Trace("Pre122mergeSqlNet-NullPointerException  : " + e);
            this.displayErrorResult("RHPHELP_Pre122_mergeSQL-08", 2);
            return 1;
        }
        catch (ExceptionInInitializerError e) {
            this.Trace("Pre122mergeSqlNet-ExceptionInInitializerError  : " + e);
            this.displayErrorResult("RHPHELP_Pre122_mergeSQL-09", 2);
            return 1;
        }
    }

    static {
        TRACE_SRVMHELPER_FNAME = "rhphelper.log";
        FILE_SEP = System.getProperty("file.separator");
    }

    class CommandLineOption {
        String m_key;
        String m_usageInfo;
        String m_methodName;
        int m_numberOfArgs;

        public CommandLineOption(String key, int numberOfArgs, String methodName, String usageInfo) {
            this.m_key = key;
            this.m_numberOfArgs = numberOfArgs;
            this.m_methodName = methodName;
            this.m_usageInfo = usageInfo;
        }

        public String getKey() {
            return this.m_key;
        }

        public String getUsageInfo() {
            return this.m_usageInfo;
        }

        public int getNumberOfArgs() {
            return this.m_numberOfArgs;
        }

        public String getMethodName() {
            return this.m_methodName;
        }
    }
}

