/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.gridhome.giprov;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import oracle.cluster.gridhome.giprov.GIResponseFileHandlerException;

public class GIResponseFileHandler {
    protected static final String LSEP = System.getProperty("line.separator");
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    protected static final String HASH = "#";
    protected static final String EQUAL = "=";
    protected static final String COMMA = ",";
    protected static final String COLON = ":";
    protected static final String DOT = "\\.";
    protected static final String UNDERSCORE = "_";
    protected static final String ASTERISK = "*";
    protected static final String[] RESPONSEFILE_NOT_EXISTS = new String[]{"PrGo", "1379"};
    protected static final String[] RESPONSEFILE_NOT_VALID = new String[]{"PrGo", "1380"};
    protected static final String[] PARAM_NOT_SET = new String[]{"PrGo", "1381"};
    protected static final String[] INVALID_RSP_FILE_PARAM = new String[]{"PrGo", "1382"};
    protected static final String[] RESPONSEFILE_GEN_PATH_NOT_SUPPLIED = new String[]{"PrGo", "1383"};
    protected static final String[] RSPFILE_MODIFIED_RERUN = new String[]{"PrGo", "1341"};
    protected static final String[] RSPFILE_RERUN_NOT_EQUAL = new String[]{"PrGo", "1676"};
    protected static final String[] INVALID_NULL_PARAM = new String[]{"PrGo", "1384"};
    protected static String SCAN_PORT_DEFAULT = "1521";
    protected static String STORAGE_OPTION_DEFAULT = "FLEX_ASM_STORAGE";
    protected static String STORAGE_OPTION_ASMCLIENT = "CLIENT_ASM_STORAGE";
    protected static String CLUSTER_TYPE_DEFAULT = "FLEX";
    protected static String CLUSTER_TYPE_APPLICATION = "APPLICATION";
    protected static String CONFIG_GNS_DEFAULT = "false";
    protected static String DISKGROUP_DEFAULT = "DATA";
    protected static String ALLOCATION_UNIT_DEFAULT = "1";
    protected static String INSTALL_OPTION_DEFAULT = "CRS_CONFIG";
    protected static String MANAGEMENT_OPTION_DEFAULT = "NONE";
    protected static String IGNORE_DOWN_NODES_DEFAULT = "false";
    protected static String IPMI_DEFAULT = "false";
    protected static String BASE_DIR = "gibase";
    protected static String INVENTORY_DIR = "oraInventory";
    protected static String MEMBERCLUSTER_MANIFEST_FILE = "oracle.install.crs.config.memberClusterManifestFile";
    protected static boolean m_manifestFileFromCLI = false;
    protected String m_responseFile = null;
    protected ArrayList<String> m_rspFileAsList = null;
    private Method m_outMethod = null;
    private static final String RHP_DISCOVERED = "RHP_DISCOVERED. Uncomment to use";
    private static final String RHP_MANDATORY_PARAM = "RHP_MANDATORY_PARAM";
    private static final String RHP_OVERRIDE = "RHP_OVERRIDE";
    protected static final String RHP_DEFAULT = "RHP_DEFAULT";
    private static final String RHP_INTERFACES_DISCOVERED = "RHP_INTERFACES_DISCOVERED";
    protected static ArrayList<String> s_pathParamsList;
    protected static HashMap<String, String> s_rspParams;

    public GIResponseFileHandler(String responseFile, String templateResponseFile) throws GIResponseFileHandlerException {
        this.Trace("Processing the input responseFile" + responseFile);
        this.assertFile(responseFile);
        this.m_responseFile = responseFile;
        this.initTemplateResponseFile(templateResponseFile);
        this.readFileAsList(responseFile);
    }

    public GIResponseFileHandler(String responseFile, boolean isTemplateResponseFile) throws GIResponseFileHandlerException {
        this.Trace("Processing the input responseFile" + responseFile);
        this.assertFile(responseFile);
        this.initTemplateResponseFile(responseFile);
        if (!isTemplateResponseFile) {
            this.m_responseFile = responseFile;
        }
    }

    public String getClusterNodesStr() {
        String nodeString = "";
        nodeString = this.get(s_rspParams.get("CLUSTER_NODES"));
        return nodeString;
    }

    public List<String> getNodeList() {
        String nodeString = this.get(s_rspParams.get("CLUSTER_NODES"));
        if (null == nodeString) {
            return null;
        }
        String[] nodes = nodeString.split(COMMA);
        ArrayList<String> nodeList = new ArrayList<String>();
        for (String node : nodes) {
            String[] nodeArr = node.split(COLON);
            nodeList.add(nodeArr[0]);
        }
        return nodeList;
    }

    public String getNodeListString() {
        List<String> nodes = this.getNodeList();
        return this.list2String(nodes, COMMA);
    }

    public HashMap<String, String> getClusterNodeRoles() {
        String nodeString = this.get(s_rspParams.get("CLUSTER_NODES"));
        if (null == nodeString) {
            return null;
        }
        String[] nodes = nodeString.split(COMMA);
        HashMap<String, String> nodeRoleMap = new HashMap<String, String>(nodes.length);
        for (String node : nodes) {
            String[] nodeArr = node.split(COLON);
            if (nodeArr.length <= 2) continue;
            nodeRoleMap.put(nodeArr[0], nodeArr[2]);
        }
        return nodeRoleMap;
    }

    public String getHostVips() {
        String nodeString = this.get(s_rspParams.get("CLUSTER_NODES"));
        if (null == nodeString) {
            return null;
        }
        String[] nodes = nodeString.split(COMMA);
        ArrayList<String> vipList = new ArrayList<String>();
        for (String node : nodes) {
            String[] nodeArr = node.split(COLON);
            if (nodeArr.length <= 1) continue;
            vipList.add(nodeArr[1]);
        }
        return this.list2String(vipList, COMMA);
    }

    public String getClient() {
        return this.get(s_rspParams.get("CLUSTER_NAME"));
    }

    public String getOracleHome() {
        return this.get(s_rspParams.get("ORACLE_HOME"));
    }

    public String getOracleBase() {
        return this.get(s_rspParams.get("ORACLE_BASE"));
    }

    public String getInventoryLoc() {
        return this.get(s_rspParams.get("INVENTORY"));
    }

    public String getASMpasswd() {
        return this.get(s_rspParams.get("SYS_ASM_PASS"));
    }

    public String getASMMonitorpasswd() {
        return this.get(s_rspParams.get("ASM_MONITOR_PASS"));
    }

    public String getVotingLocations() {
        return this.get(s_rspParams.get("VOTE_DISKS"));
    }

    public String getOCRLocations() {
        return this.get(s_rspParams.get("OCR_LOCS"));
    }

    public String getASMDiscoveryString() {
        return this.get(s_rspParams.get("DISK_DISCOVERY"));
    }

    public String getDisks() {
        return this.get(s_rspParams.get("DISKS"));
    }

    public String getDiskGroup() {
        return this.get(s_rspParams.get("DISKGROUP"));
    }

    public String getIPMI() {
        return this.get(s_rspParams.get("IPMI"));
    }

    public String getDBAGroup() {
        return this.get(s_rspParams.get("OSDBA_GROUP"));
    }

    public String getASMGroup() {
        return this.get(s_rspParams.get("OSASM_GROUP"));
    }

    public String getOPERGroup() {
        return this.get(s_rspParams.get("OSOPER_GROUP"));
    }

    public String getInstallOption() {
        return this.get(s_rspParams.get("INSTALL_OPTION"));
    }

    public String getConfigGNS() {
        return this.get(s_rspParams.get("CONFIG_GNS"));
    }

    public String getUseSharedGNS() {
        String value = this.getCreateGNS();
        if (value != null && value.equals("USE_SHARED_GNS")) {
            return String.valueOf(true);
        }
        return String.valueOf(false);
    }

    public String getCreateGNS() {
        return this.get(s_rspParams.get("CREATE_GNS"));
    }

    public String getSCANName() {
        return this.get(s_rspParams.get("SCAN_NAME"));
    }

    public String getAutoConfigureClusterNodeVIP() {
        return this.get(s_rspParams.get("AUTO_CONFIGURE_CLUSTER_NODE_VIP"));
    }

    public String getGNSVIP() {
        return this.get(s_rspParams.get("GNS_VIP"));
    }

    public String getGNSSubdomain() {
        return this.get(s_rspParams.get("GNS_SUBDOMAIN"));
    }

    public String getASMStorageOption() {
        return this.get(s_rspParams.get("STORAGE_OPTION"));
    }

    public String getInterConnectList() {
        String[] incArr;
        String inc = this.get(s_rspParams.get("NETWORK_INTERFACE"));
        if (null == inc) {
            return inc;
        }
        StringBuilder resString = new StringBuilder();
        boolean isMoreThanOne = false;
        for (String inf : incArr = inc.split(COMMA)) {
            String[] infArray;
            if (isMoreThanOne) {
                resString.append(COMMA);
            }
            if ((infArray = inf.split(COLON)).length != 3) continue;
            resString.append("\"" + infArray[0] + "\"");
            resString.append(COLON);
            resString.append(infArray[1]);
            resString.append(COLON);
            if (infArray[2].equals("1")) {
                resString.append("PUB");
            } else if (infArray[2].equals("2")) {
                resString.append("PVT");
            } else if (infArray[2].equals("4")) {
                resString.append("ASM");
            } else if (infArray[2].equals("5")) {
                resString.append("ASM-PRIV");
            }
            isMoreThanOne = true;
        }
        return resString.toString();
    }

    private void readFileAsList(String rspFile) throws GIResponseFileHandlerException {
        String line = null;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(rspFile));
            while ((line = reader.readLine()) != null) {
                int index;
                String[] res;
                if (line.trim().startsWith(HASH) || line.trim().length() == 0 || (res = line.split(EQUAL)).length <= 1) continue;
                for (index = 0; index < this.m_rspFileAsList.size() && !this.m_rspFileAsList.get(index).startsWith(res[0].trim() + EQUAL); ++index) {
                }
                if (index != this.m_rspFileAsList.size()) {
                    this.m_rspFileAsList.add(index + 1, res[0].trim() + EQUAL + res[1].trim());
                    this.m_rspFileAsList.remove(index);
                    continue;
                }
                this.Trace("Invalid entry in the response file :" + line);
                throw new GIResponseFileHandlerException(this.genTagExceptionMsg(INVALID_RSP_FILE_PARAM, new String[]{line}));
            }
        }
        catch (IOException ioe) {
            this.Trace("IOException encountered: " + ioe.getMessage());
            throw new GIResponseFileHandlerException(ioe);
        }
        finally {
            try {
                if (null != reader) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public String generateResponseFile() throws GIResponseFileHandlerException {
        return this.generateResponseFile(null, true);
    }

    public String generateResponseFile(String target) throws GIResponseFileHandlerException {
        return this.generateResponseFile(target, true);
    }

    public String generateResponseFile(String targetResponseFile, boolean fillDefaults) throws GIResponseFileHandlerException {
        if (fillDefaults) {
            this.fillDefaults();
        }
        String genRspFile = null;
        if (null == targetResponseFile) {
            if (null == this.m_responseFile) {
                this.Trace("Response file generate path not supplied");
                throw new GIResponseFileHandlerException(this.genTagExceptionMsg(RESPONSEFILE_GEN_PATH_NOT_SUPPLIED));
            }
            String rspFile = new File(this.m_responseFile).getName();
            String[] fileNameSplit = rspFile.split(DOT);
            String rspDir = new File(this.m_responseFile).getParent();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            genRspFile = rspDir + FILE_SEPARATOR + fileNameSplit[0] + UNDERSCORE + sdf.format(new Date()) + ".rsp";
        } else {
            genRspFile = targetResponseFile;
        }
        String rspFileAsString = "";
        for (String s : this.m_rspFileAsList) {
            rspFileAsString = rspFileAsString + s + LSEP;
        }
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(genRspFile));
            writer.write(rspFileAsString);
            writer.flush();
        }
        catch (IOException ioe) {
            this.Trace("IOException encountered: " + ioe.getMessage());
            throw new GIResponseFileHandlerException(ioe);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
        return genRspFile;
    }

    public void overrideScan(String scanName) {
        if (null == scanName) {
            return;
        }
        this.overrideParams(s_rspParams.get("SCAN_NAME"), scanName);
    }

    public void overrideCreateGNS(boolean value) {
        if (value) {
            this.overrideParams(s_rspParams.get("CREATE_GNS"), "CREATE_NEW_GNS");
        } else {
            this.overrideParams(s_rspParams.get("CREATE_GNS"), "USE_SHARED_GNS");
        }
    }

    public void overrideClient(String client) {
        if (null == client) {
            return;
        }
        this.overrideParams(s_rspParams.get("CLUSTER_NAME"), client);
    }

    public void overrideNodeList(String nodeList) {
        if (null == nodeList) {
            return;
        }
        this.overrideParams(s_rspParams.get("CLUSTER_NODES"), nodeList);
    }

    public void overrideOracleHome(String oracleHome) {
        if (null == oracleHome) {
            return;
        }
        this.overrideParams(s_rspParams.get("ORACLE_HOME"), oracleHome);
    }

    public void overrideASMClientData(String asmClientData) {
        if (null == asmClientData) {
            return;
        }
        this.overrideParams(s_rspParams.get("STORAGE_OPTION"), "CLIENT_ASM_STORAGE");
        this.overrideParams(s_rspParams.get("ASM_CLIENT_FILE"), asmClientData);
    }

    public void overrideGNSClientData(String gnsClientData) {
        if (null == gnsClientData) {
            return;
        }
        this.overrideParams(s_rspParams.get("CONFIG_GNS"), "true");
        this.overrideParams(s_rspParams.get("CREATE_GNS"), "USE_SHARED_GNS");
        this.overrideParams(s_rspParams.get("GNS_CLIENT_FILE"), gnsClientData);
    }

    public void overrideOracleBase(String oracleBase) {
        if (null == oracleBase) {
            return;
        }
        this.overrideParams(s_rspParams.get("ORACLE_BASE"), oracleBase);
    }

    public void overrideOSDbaGroup(String osdbaGrp) {
        if (null == osdbaGrp) {
            return;
        }
        this.overrideParams(s_rspParams.get("OSDBA_GROUP"), osdbaGrp);
    }

    public void overrideOSOperGroup(String osoperGrp) {
        if (null == osoperGrp) {
            return;
        }
        this.overrideParams(s_rspParams.get("OSOPER_GROUP"), osoperGrp);
    }

    public void overrideOSAsmGroup(String osasmGrp) {
        if (null == osasmGrp) {
            return;
        }
        this.overrideParams(s_rspParams.get("OSASM_GROUP"), osasmGrp);
    }

    public void overrideInstallOption(String installOpt) {
        if (null == installOpt) {
            return;
        }
        this.overrideParams(s_rspParams.get("INSTALL_OPTION"), installOpt);
    }

    public void overrideIgnoreDownNodes(String igDown) {
        if (null == igDown) {
            return;
        }
        this.overrideParams(s_rspParams.get("IGNORE_DOWN_NODES"), igDown);
    }

    public void addDiscoveredDisks(String disks) {
        if (null == disks) {
            return;
        }
        this.addDiscoveredParams(s_rspParams.get("DISKS"), disks);
    }

    public void addDiscoveredVoteDisksOCR(String sharedPath) {
        if (null == sharedPath) {
            return;
        }
        this.addDiscoveredParams(s_rspParams.get("VOTE_DISKS"), sharedPath);
        this.addDiscoveredParams(s_rspParams.get("OCR_LOCS"), sharedPath);
    }

    public void addDiscoveredDiskDiscoveryString(String diskDiscoveryString) {
        if (null == diskDiscoveryString) {
            return;
        }
        this.addDiscoveredParams(s_rspParams.get("DISK_DISCOVERY"), diskDiscoveryString + File.separator + ASTERISK);
    }

    public void addDiscoveredGroupDBA(String group) {
        if (null == group) {
            return;
        }
        this.addDiscoveredParams(s_rspParams.get("OSDBA_GROUP"), group);
    }

    public void addDiscoveredGroupASM(String group) {
        if (null == group) {
            return;
        }
        this.addDiscoveredParams(s_rspParams.get("OSASM_GROUP"), group);
    }

    public void addDiscoveredGroupOPER(String group) {
        if (null == group) {
            return;
        }
        this.addDiscoveredParams(s_rspParams.get("OSOPER_GROUP"), group);
    }

    public void addDiscoveredInterfaces(String interfaceString) {
        if (null == interfaceString) {
            return;
        }
        this.addDiscoveredParams(s_rspParams.get("NETWORK_INTERFACE"), interfaceString);
    }

    public void addDiscoveredInterfacesList(List<String> interfaceStringList) {
        int i;
        if (null == interfaceStringList) {
            return;
        }
        for (i = 0; i < this.m_rspFileAsList.size() && !this.m_rspFileAsList.get(i).startsWith(s_rspParams.get("NETWORK_INTERFACE")); ++i) {
        }
        int n = ++i;
        ++i;
        this.m_rspFileAsList.add(n, "#RHP_INTERFACES_DISCOVERED");
        for (String infStr : interfaceStringList) {
            this.m_rspFileAsList.add(i++, HASH + infStr);
        }
    }

    protected void overrideParams(String paramName, String value) {
        int i;
        if (null == value) {
            return;
        }
        for (i = 0; i < this.m_rspFileAsList.size() && !this.m_rspFileAsList.get(i).startsWith(paramName + EQUAL); ++i) {
        }
        if (i == this.m_rspFileAsList.size()) {
            this.m_rspFileAsList.add(paramName + EQUAL + value);
            return;
        }
        String[] paramArr = this.m_rspFileAsList.get(i).split(EQUAL);
        if (paramArr.length > 1 && paramArr[1].equalsIgnoreCase(value)) {
            return;
        }
        this.m_rspFileAsList.add(i + 1, HASH + this.m_rspFileAsList.get(i));
        this.m_rspFileAsList.add(i + 2, "#RHP_OVERRIDE");
        this.m_rspFileAsList.add(i + 3, paramName + EQUAL + value);
        this.m_rspFileAsList.remove(i);
    }

    protected void addDiscoveredParams(String paramName, String value) {
        int i;
        if (null == value) {
            return;
        }
        for (String s : this.m_rspFileAsList) {
            String[] valArray;
            String[] sArr;
            if (!s.replaceAll("\\s+", "").startsWith(HASH + paramName + EQUAL) && !s.startsWith(paramName + EQUAL) || (sArr = s.split(EQUAL)).length <= 1) continue;
            for (String existingValue : valArray = sArr[1].split(COMMA)) {
                if (!existingValue.equalsIgnoreCase(value)) continue;
                this.Trace("discovered value is :" + value + " existing value is :" + existingValue);
                return;
            }
        }
        for (i = 0; i < this.m_rspFileAsList.size() && !this.m_rspFileAsList.get(i).startsWith(paramName + EQUAL); ++i) {
        }
        this.m_rspFileAsList.add(i + 1, "#RHP_DISCOVERED. Uncomment to use");
        this.m_rspFileAsList.add(i + 2, HASH + paramName + EQUAL + value);
    }

    public void addMandatoryTag() {
        ArrayList<String> mandParams = new ArrayList<String>();
        mandParams.add(s_rspParams.get("CLUSTER_TYPE"));
        mandParams.add(s_rspParams.get("CLUSTER_NAME"));
        mandParams.add(s_rspParams.get("SYS_ASM_PASS"));
        mandParams.add(s_rspParams.get("ASM_MONITOR_PASS"));
        mandParams.add(s_rspParams.get("INSTALL_OPTION"));
        mandParams.add(s_rspParams.get("INVENTORY"));
        mandParams.add(s_rspParams.get("CLUSTER_NODES"));
        mandParams.add(s_rspParams.get("NETWORK_INTERFACE"));
        mandParams.add(s_rspParams.get("SCAN_NAME"));
        mandParams.add(s_rspParams.get("OSASM_GROUP"));
        mandParams.add(s_rspParams.get("OSDBA_GROUP"));
        mandParams.add(s_rspParams.get("ORACLE_HOME"));
        mandParams.add(s_rspParams.get("ORACLE_BASE"));
        for (String params : mandParams) {
            int i;
            for (i = 0; i < this.m_rspFileAsList.size() && !this.m_rspFileAsList.get(i).startsWith(params + EQUAL); ++i) {
            }
            if (i <= 0) continue;
            this.m_rspFileAsList.add(i, "#RHP_MANDATORY_PARAM");
        }
    }

    public void isValidResponseFile() throws GIResponseFileHandlerException {
        ArrayList<String> paramArrList = new ArrayList<String>();
        if (null == this.get(s_rspParams.get("CLUSTER_NAME"))) {
            paramArrList.add("CLUSTER_NAME");
        }
        if (null == this.get(s_rspParams.get("CLUSTER_NODES"))) {
            paramArrList.add("NODELIST");
        }
        if (null == this.get(s_rspParams.get("ORACLE_HOME"))) {
            paramArrList.add("ORACLE_HOME");
        }
        if (null == this.get(s_rspParams.get("OSDBA_GROUP"))) {
            paramArrList.add("OSDBA_GROUP");
        }
        if (null == this.get(s_rspParams.get("OSASM_GROUP"))) {
            paramArrList.add("OSASM_GROUP");
        }
        if (null == this.get(s_rspParams.get("NETWORK_INTERFACE"))) {
            paramArrList.add("NETWORK_INTERFACE");
        }
        String storageOpt = this.get(s_rspParams.get("STORAGE_OPTION"));
        String clusterType = this.get(s_rspParams.get("CLUSTER_TYPE"));
        if (clusterType != null && !clusterType.equals(CLUSTER_TYPE_APPLICATION) && storageOpt != null && !storageOpt.equals(STORAGE_OPTION_ASMCLIENT)) {
            if (null == this.get(s_rspParams.get("SYS_ASM_PASS"))) {
                paramArrList.add("SYS_ASM_PASS");
            }
            if (null == this.get(s_rspParams.get("ASM_MONITOR_PASS"))) {
                paramArrList.add("ASM_MONITOR_PASS");
            }
        }
        if (null == this.get(s_rspParams.get("INVENTORY"))) {
            paramArrList.add("INVENTORY");
        }
        if (!paramArrList.isEmpty()) {
            String paramString = this.list2String(paramArrList, COMMA);
            this.Trace("Mandatory parameters not set :" + paramString);
            throw new GIResponseFileHandlerException(this.genTagExceptionMsg(PARAM_NOT_SET, new String[]{paramString}));
        }
    }

    public void isGeneratableResponseFile() throws GIResponseFileHandlerException {
        ArrayList<String> paramArrList = new ArrayList<String>();
        if (null == this.get(s_rspParams.get("CLUSTER_NAME"))) {
            paramArrList.add("CLUSTER_NAME");
        }
        if (null == this.get(s_rspParams.get("CLUSTER_NODES"))) {
            paramArrList.add("NODELIST");
        }
        if (null == this.get(s_rspParams.get("ORACLE_HOME"))) {
            paramArrList.add("ORACLE_HOME");
        }
        if (!paramArrList.isEmpty()) {
            String paramString = this.list2String(paramArrList, COMMA);
            this.Trace("Mandatory parameters not set :" + paramString);
            throw new GIResponseFileHandlerException(this.genTagExceptionMsg(PARAM_NOT_SET, new String[]{paramString}));
        }
    }

    protected void fillDefaults() throws GIResponseFileHandlerException {
        this.isGeneratableResponseFile();
        String oracleHomeParentDir = new File(this.get(s_rspParams.get("ORACLE_HOME"))).getParent();
        String INVENTORY_DEFAULT = oracleHomeParentDir + FILE_SEPARATOR + INVENTORY_DIR;
        String ORACLE_BASE_DEFAULT = oracleHomeParentDir + FILE_SEPARATOR + BASE_DIR;
        HashMap<String, String> defaultMap = new HashMap<String, String>();
        defaultMap.put(s_rspParams.get("SCAN_PORT"), SCAN_PORT_DEFAULT);
        defaultMap.put(s_rspParams.get("ORACLE_BASE"), ORACLE_BASE_DEFAULT);
        defaultMap.put(s_rspParams.get("INVENTORY"), INVENTORY_DEFAULT);
        defaultMap.put(s_rspParams.get("CONFIG_GNS"), CONFIG_GNS_DEFAULT);
        defaultMap.put(s_rspParams.get("INSTALL_OPTION"), INSTALL_OPTION_DEFAULT);
        defaultMap.put(s_rspParams.get("STORAGE_OPTION"), STORAGE_OPTION_DEFAULT);
        defaultMap.put(s_rspParams.get("DISKGROUP"), DISKGROUP_DEFAULT);
        defaultMap.put(s_rspParams.get("ALLOCATION_UNIT"), ALLOCATION_UNIT_DEFAULT);
        defaultMap.put(s_rspParams.get("CLUSTER_TYPE"), CLUSTER_TYPE_DEFAULT);
        defaultMap.put(s_rspParams.get("IGNORE_DOWN_NODES"), IGNORE_DOWN_NODES_DEFAULT);
        Set defaultMapSet = defaultMap.keySet();
        for (String s : defaultMapSet) {
            int i;
            if (!this.isDefaultRequired(s)) continue;
            for (i = 0; i < this.m_rspFileAsList.size() && !this.m_rspFileAsList.get(i).startsWith(s); ++i) {
            }
            this.m_rspFileAsList.remove(i);
            this.m_rspFileAsList.add(i, "#RHP_DEFAULT");
            this.m_rspFileAsList.add(i + 1, s + EQUAL + (String)defaultMap.get(s));
        }
    }

    protected boolean isDefaultRequired(String str) {
        for (String s : this.m_rspFileAsList) {
            if (!s.startsWith(str)) continue;
            String[] strArr = s.split(EQUAL);
            return strArr.length <= 1;
        }
        return false;
    }

    private void assertFile(String fileName) throws GIResponseFileHandlerException {
        if (null == fileName || fileName.trim().length() == 0) {
            this.Trace("Invalid null parameter filename :" + fileName);
            throw new GIResponseFileHandlerException(this.genTagExceptionMsg(INVALID_NULL_PARAM));
        }
        File validateFile = new File(fileName);
        if (!validateFile.exists()) {
            this.Trace("Response file : " + fileName + " does not exist");
            throw new GIResponseFileHandlerException(this.genTagExceptionMsg(RESPONSEFILE_NOT_EXISTS, new String[]{fileName}));
        }
        if (validateFile.isDirectory()) {
            this.Trace("Response file : " + fileName + " is a directory");
            throw new GIResponseFileHandlerException(this.genTagExceptionMsg(RESPONSEFILE_NOT_VALID, new String[]{fileName}));
        }
    }

    private void initTemplateResponseFile(String templateResponseFile) throws GIResponseFileHandlerException {
        this.m_rspFileAsList = new ArrayList();
        String line = null;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(templateResponseFile));
            while ((line = reader.readLine()) != null) {
                this.m_rspFileAsList.add(line.trim());
            }
        }
        catch (IOException ioe) {
            this.Trace("IOException encountered: " + ioe.getMessage());
            throw new GIResponseFileHandlerException(ioe);
        }
        finally {
            try {
                if (null != reader) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void isModifiedResponseFile(String responseFile, String filePath) throws GIResponseFileHandlerException {
        String line = null;
        BufferedReader reader = null;
        this.Trace("Filling the defaults in the modified responsefile");
        this.fillDefaults();
        try {
            reader = new BufferedReader(new FileReader(filePath + File.separator + responseFile));
            while ((line = reader.readLine()) != null) {
                String[] res;
                if (line.trim().startsWith(HASH) || line.trim().length() == 0 || (res = line.split(EQUAL)).length <= 1) continue;
                String param = res[0].trim();
                String valueAtRerun = this.get(param);
                String valueAtFirst = res[1].trim();
                if (s_pathParamsList.contains(param)) {
                    this.Trace("File param encountered :" + param);
                    if (param.equalsIgnoreCase(MEMBERCLUSTER_MANIFEST_FILE) && !m_manifestFileFromCLI) {
                        this.Trace("No need to validate");
                        continue;
                    }
                    File f1 = new File(valueAtFirst);
                    String localPath = filePath + File.separator + f1.getName();
                    if (this.isFileEquals(localPath, valueAtRerun)) continue;
                    this.Trace("localPath " + localPath + " and  valueAtRerun " + valueAtRerun + "are not equal");
                    throw new GIResponseFileHandlerException(this.genTagExceptionMsg(RSPFILE_RERUN_NOT_EQUAL, new String[]{valueAtRerun, param}));
                }
                if (valueAtFirst.equals(valueAtRerun)) continue;
                this.Trace("valueAtFirst " + valueAtFirst + " and  valueAtRerun " + valueAtRerun + "are not equal");
                throw new GIResponseFileHandlerException(this.genTagExceptionMsg(RSPFILE_MODIFIED_RERUN, new String[]{param, valueAtRerun, valueAtFirst}));
            }
        }
        catch (IOException ioe) {
            this.Trace("IOException encountered: " + ioe.getMessage());
            throw new GIResponseFileHandlerException(ioe);
        }
        finally {
            try {
                if (null != reader) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private boolean isFileEquals(String fileAtFirst, String fileAtRerun) throws GIResponseFileHandlerException {
        this.Trace("fileAtFirst :" + fileAtFirst);
        this.Trace("fileAtRerun :" + fileAtRerun);
        try {
            Scanner scFirst = new Scanner(new FileReader(fileAtFirst));
            Scanner scRerun = new Scanner(new FileReader(fileAtRerun));
            while (scFirst.hasNext() && scRerun.hasNext()) {
                String strRerun;
                String strFirst = scFirst.next();
                if (strFirst.equals(strRerun = scRerun.next())) continue;
                this.Trace("Line mismatch. Expected :" + strFirst);
                this.Trace("Line mismatch. Found :" + strRerun);
                return false;
            }
            if (scFirst.hasNext()) {
                this.Trace("Missing Line " + scFirst.next());
                return false;
            }
            if (scRerun.hasNext()) {
                this.Trace("New Line found " + scRerun.next());
                return false;
            }
            scFirst.close();
            scRerun.close();
        }
        catch (IOException e) {
            this.Trace(e.getClass().getSimpleName() + " : " + e.getMessage());
            throw new GIResponseFileHandlerException(e);
        }
        return true;
    }

    public String genTagExceptionMsg(String[] message) {
        return this.genTagExceptionMsg(message, null);
    }

    public String genTagExceptionMsg(String[] message, String[] args) {
        StringBuilder resString = new StringBuilder();
        resString.append("<FACILITY>" + message[0] + "</FACILITY>");
        resString.append("<KEY>" + message[1] + "</KEY>");
        resString.append("<PRINTKEY>true</PRINTKEY>");
        if (null != args && 0 != args.length) {
            for (String arg : args) {
                resString.append("<ARG>" + arg + "</ARG>");
            }
        }
        return resString.toString();
    }

    protected String list2String(List<String> strList, String delim) {
        StringBuilder sb = new StringBuilder();
        boolean isMoreThanOne = false;
        for (String str : strList) {
            if (isMoreThanOne) {
                sb.append(delim + str);
                continue;
            }
            sb.append(str);
            isMoreThanOne = true;
        }
        return sb.toString();
    }

    protected void Trace(String text) {
        try {
            if (null == this.m_outMethod) {
                Class<?> traceCls = Class.forName("oracle.ops.mgmt.trace.Trace");
                Class[] stringParam = new Class[]{String.class};
                this.m_outMethod = traceCls.getDeclaredMethod("out", stringParam);
            }
            Object[] stringArg = new Object[]{text};
            this.m_outMethod.invoke(null, stringArg);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected String get(String param) {
        for (String strParams : this.m_rspFileAsList) {
            if (strParams.startsWith(HASH) || !strParams.startsWith(param + EQUAL)) continue;
            String[] strArray = strParams.split(EQUAL);
            if (strArray.length <= 1) break;
            return strArray[1];
        }
        return null;
    }

    static {
        s_rspParams = new HashMap();
        s_rspParams.put("INVENTORY", "INVENTORY_LOCATION");
        s_rspParams.put("INSTALL_OPTION", "oracle.install.option");
        s_rspParams.put("ORACLE_BASE", "ORACLE_BASE");
        s_rspParams.put("ORACLE_HOME", "ORACLE_HOME");
        s_rspParams.put("OSDBA_GROUP", "oracle.install.asm.OSDBA");
        s_rspParams.put("OSOPER_GROUP", "oracle.install.asm.OSOPER");
        s_rspParams.put("OSASM_GROUP", "oracle.install.asm.OSASM");
        s_rspParams.put("SCAN_NAME", "oracle.install.crs.config.gpnp.scanName");
        s_rspParams.put("SCAN_PORT", "oracle.install.crs.config.gpnp.scanPort");
        s_rspParams.put("CLUSTER_TYPE", "oracle.install.crs.config.ClusterType");
        s_rspParams.put("CLUSTER_NAME", "oracle.install.crs.config.clusterName");
        s_rspParams.put("CONFIG_GNS", "oracle.install.crs.config.gpnp.configureGNS");
        s_rspParams.put("AUTO_CONFIG_VIP", "oracle.install.crs.config.autoConfigureClusterNodeVIP");
        s_rspParams.put("CREATE_GNS", "oracle.install.crs.config.gpnp.gnsOption");
        s_rspParams.put("GNS_CLIENT_FILE", "oracle.install.crs.config.gpnp.gnsClientDataFile");
        s_rspParams.put("GNS_SUBDOMAIN", "oracle.install.crs.config.gpnp.gnsSubDomain");
        s_rspParams.put("GNS_VIP", "oracle.install.crs.config.gpnp.gnsVIPAddress");
        s_rspParams.put("CLUSTER_NODES", "oracle.install.crs.config.clusterNodes");
        s_rspParams.put("NETWORK_INTERFACE", "oracle.install.crs.config.networkInterfaceList");
        s_rspParams.put("STORAGE_OPTION", "oracle.install.crs.config.storageOption");
        s_rspParams.put("VOTE_DISKS", "oracle.install.crs.config.sharedFileSystemStorage.votingDiskLocations");
        s_rspParams.put("VOTE_DISK_REDUNDANCY", "oracle.install.crs.config.sharedFileSystemStorage.votingDiskRedundancy");
        s_rspParams.put("OCR_LOCS", "oracle.install.crs.config.sharedFileSystemStorage.ocrLocations");
        s_rspParams.put("OCR_REDUNDANCY", "oracle.install.crs.config.sharedFileSystemStorage.ocrRedundancy");
        s_rspParams.put("SYS_ASM_PASS", "oracle.install.asm.SYSASMPassword");
        s_rspParams.put("DISKGROUP", "oracle.install.asm.diskGroup.name");
        s_rspParams.put("ASM_REDUNDANCY", "oracle.install.asm.diskGroup.redundancy");
        s_rspParams.put("ALLOCATION_UNIT", "oracle.install.asm.diskGroup.AUSize");
        s_rspParams.put("DISKS", "oracle.install.asm.diskGroup.disks");
        s_rspParams.put("DISK_DISCOVERY", "oracle.install.asm.diskGroup.diskDiscoveryString");
        s_rspParams.put("ASM_MONITOR_PASS", "oracle.install.asm.monitorPassword");
        s_rspParams.put("ASM_CLIENT_FILE", "oracle.install.asm.ClientDataFile");
        s_rspParams.put("IGNORE_DOWN_NODES", "oracle.install.crs.config.ignoreDownNodes");
        s_pathParamsList = new ArrayList();
        s_pathParamsList.add("oracle.install.asm.ClientDataFile");
        s_pathParamsList.add("oracle.install.crs.config.gpnp.gnsClientDataFile");
        s_pathParamsList.add(MEMBERCLUSTER_MANIFEST_FILE);
    }
}

