/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.share.nls;

import java.util.Locale;
import oracle.bali.share.collection.OptimisticHashMap;
import oracle.bali.share.nls.AvailableLocaleMapper;
import oracle.bali.share.util.ClassLoaderUtils;

public class BundleAvailableLocaleMapper
extends AvailableLocaleMapper {
    private static final Object _NOT_FOUND = new Object();
    private String _bundleName;
    private OptimisticHashMap _supportedMap = new OptimisticHashMap(13);

    public BundleAvailableLocaleMapper(String string) {
        this(string, null);
    }

    public BundleAvailableLocaleMapper(String string, Locale locale) {
        super(locale);
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this._bundleName = string;
    }

    protected boolean isSupportedLocale(Locale locale) {
        Object object = this._supportedMap.get(locale);
        if (object == null) {
            try {
                ClassLoaderUtils.loadClass(this._bundleName + '_' + locale);
                object = locale;
            }
            catch (ClassNotFoundException classNotFoundException) {
                object = _NOT_FOUND;
            }
            this._supportedMap.put(locale, object);
        }
        return object != _NOT_FOUND;
    }
}

