/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.share.nls;

import java.util.Locale;
import oracle.bali.share.collection.OptimisticHashMap;
import oracle.bali.share.nls.LocaleMapper;

abstract class AvailableLocaleMapper
extends LocaleMapper {
    private Locale _defaultLocale;
    private OptimisticHashMap _localeMap = new OptimisticHashMap(13);

    public AvailableLocaleMapper(Locale locale) {
        if (locale == null) {
            locale = Locale.US;
        }
        this._defaultLocale = locale;
    }

    public Locale mapLocale(Locale locale) {
        if (locale == null) {
            return this._defaultLocale;
        }
        Locale locale2 = (Locale)this._localeMap.get(locale);
        if (locale2 == null) {
            locale2 = locale;
            if (!this.isSupportedLocale(locale2)) {
                String string = locale2.getVariant();
                String string2 = locale2.getLanguage();
                boolean bl = false;
                if (string.length() != 0) {
                    locale2 = new Locale(string2, locale2.getCountry());
                    bl = this.isSupportedLocale(locale2);
                }
                if (!bl && !this.isSupportedLocale(locale2 = new Locale(string2, ""))) {
                    locale2 = this._defaultLocale;
                }
            }
            this._localeMap.put(locale, locale2);
        }
        return locale2;
    }

    protected abstract boolean isSupportedLocale(Locale var1);
}

