/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.share.collection;

import java.util.Enumeration;
import java.util.Vector;
import oracle.bali.share.sort.Comparator;
import oracle.bali.share.sort.Sort;

public class Range
implements Cloneable {
    private int _upperLimit;
    private int _lowerLimit;
    private static RangeComparator _rangeComparator;

    public Range(int n, int n2) {
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        this._lowerLimit = n;
        this._upperLimit = n2;
    }

    public Object clone() throws CloneNotSupportedException {
        return new Range(this.getLowerLimit(), this.getUpperLimit());
    }

    public int getLowerLimit() {
        return this._lowerLimit;
    }

    public int getUpperLimit() {
        return this._upperLimit;
    }

    public boolean inRange(int n) {
        return n >= this._lowerLimit && n <= this._upperLimit;
    }

    public String toString() {
        return "[" + this._lowerLimit + "," + this._upperLimit + "]";
    }

    public static Range[] addRanges(Range[] rangeArray, Range[] rangeArray2) {
        int n;
        int n2 = rangeArray == null ? 0 : rangeArray.length;
        int n3 = n = rangeArray2 == null ? 0 : rangeArray2.length;
        if (n2 == 0 && n == 0) {
            return null;
        }
        if (n == 0) {
            Range[] rangeArray3 = new Range[n2];
            System.arraycopy(rangeArray, 0, rangeArray3, 0, n2);
            return rangeArray3;
        }
        if (n2 == 0) {
            Range[] rangeArray4 = new Range[n];
            System.arraycopy(rangeArray2, 0, rangeArray4, 0, n);
            return rangeArray4;
        }
        Object[] objectArray = new Range[n2 + n];
        System.arraycopy(rangeArray, 0, objectArray, 0, n2);
        System.arraycopy(rangeArray2, 0, objectArray, n2, n);
        int n4 = objectArray.length;
        Sort.qSort(objectArray, n4, Range._getRangeComparator());
        int n5 = -1;
        int n6 = -1;
        Vector<Range> vector = new Vector<Range>();
        for (int i = 0; i < n4; ++i) {
            int n7 = ((Range)objectArray[i]).getLowerLimit();
            int n8 = ((Range)objectArray[i]).getUpperLimit();
            if (n5 == -1 && n6 == -1) {
                n5 = n7;
                n6 = n8;
                continue;
            }
            if (n6 >= n7 - 1 && n6 < n8) {
                n6 = n8;
                continue;
            }
            vector.addElement(new Range(n5, n6));
            n5 = n7;
            n6 = n8;
        }
        if (n5 != -1 && n6 != -1) {
            vector.addElement(new Range(n5, n6));
        }
        objectArray = new Range[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static Range[] subtractRanges(Range[] rangeArray, Range[] rangeArray2) {
        Object[] objectArray;
        int n;
        int n2 = rangeArray == null ? 0 : rangeArray.length;
        int n3 = n = rangeArray2 == null ? 0 : rangeArray2.length;
        if (n2 == 0 && n == 0) {
            return null;
        }
        if (n2 == 0) {
            return null;
        }
        if (n == 0) {
            Range[] rangeArray3 = new Range[n2];
            System.arraycopy(rangeArray, 0, rangeArray3, 0, n2);
            return rangeArray3;
        }
        Vector<Range> vector = new Vector<Range>();
        for (int i = 0; i < n2; ++i) {
            vector.addElement(rangeArray[i]);
        }
        for (int i = 0; i < rangeArray2.length; ++i) {
            objectArray = rangeArray2[i];
            Vector<Range> vector2 = new Vector<Range>();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Range range = (Range)enumeration.nextElement();
                int n4 = objectArray.getLowerLimit();
                int n5 = objectArray.getUpperLimit();
                int n6 = range.getLowerLimit();
                int n7 = range.getUpperLimit();
                if (n4 <= n6 && n5 >= n7) continue;
                if (n5 < n6 || n4 > n7) {
                    vector2.addElement(range);
                    continue;
                }
                if (n4 > n6 && n5 < n7) {
                    vector2.addElement(Range._newRange(n6, n4 - 1));
                    vector2.addElement(Range._newRange(n5 + 1, n7));
                    continue;
                }
                if (n4 > n6 && n5 >= n7) {
                    vector2.addElement(Range._newRange(n6, n4 - 1));
                    continue;
                }
                if (n4 > n6 || n5 >= n7) continue;
                vector2.addElement(Range._newRange(n5 + 1, n7));
            }
            vector = vector2;
        }
        objectArray = new Range[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static boolean rangesContain(Range[] rangeArray, int n) {
        if (rangeArray == null) {
            return false;
        }
        for (int i = 0; i < rangeArray.length; ++i) {
            if (!rangeArray[i].inRange(n)) continue;
            return true;
        }
        return false;
    }

    public static boolean rangesContain(Range[] rangeArray, Range[] rangeArray2) {
        if (rangeArray2 == null || rangeArray2.length == 0) {
            return true;
        }
        if (rangeArray == null || rangeArray.length == 0) {
            return false;
        }
        Range[] rangeArray3 = Range.subtractRanges(rangeArray2, rangeArray);
        return rangeArray3 == null || rangeArray3.length == 0;
    }

    private static Range _newRange(int n, int n2) {
        if (n <= n2) {
            return new Range(n, n2);
        }
        return new Range(n2, n);
    }

    private static Comparator _getRangeComparator() {
        if (_rangeComparator == null) {
            _rangeComparator = new RangeComparator();
        }
        return _rangeComparator;
    }

    private static class RangeComparator
    implements Comparator {
        private RangeComparator() {
        }

        public int compare(Object object, Object object2) {
            Range range = (Range)object;
            Range range2 = (Range)object2;
            if (range.getLowerLimit() < range2.getLowerLimit()) {
                return -1;
            }
            if (range.getLowerLimit() > range2.getLowerLimit()) {
                return 1;
            }
            return 0;
        }
    }
}

