/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.helper.helper10205;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import oracle.jdbc.driver.OracleConnection;
import oracle.ops.mgmt.asm.ASM;
import oracle.ops.mgmt.asm.ASMConfigurationException;
import oracle.ops.mgmt.asm.ASMInstance;
import oracle.ops.mgmt.asm.ASMInstanceException;
import oracle.ops.mgmt.asm.ASMInstanceNotExistException;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.database.ConfigurationException;
import oracle.ops.mgmt.database.Instance;
import oracle.ops.mgmt.database.ListenerException;
import oracle.ops.mgmt.database.ParallelServer;
import oracle.ops.mgmt.database.ParallelServerConfig;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nodeapps.Listener;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.nodeapps.config.NodeApps;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.helper.helper10205.CVUHelper;

public class CVUHelper10205
extends CVUHelper {
    public CVUHelper10205() {
        this.addCommandLineOption("-getCRSUser", 1, "getCRSUser", "gets the clusterware home user name");
        this.addCommandLineOption("-checkASMRunning", 2, "checkASMRunning", "check if ASM is running on nodes");
        this.addCommandLineOption("-getASMhome", 2, "getASMhome", "gets the ASM home on the given node");
        this.addCommandLineOption("-getASMsid", 2, "getASMsid", "gets the ASM sid on the given node");
        this.addCommandLineOption("-checkDefaultListener", 2, "checkDefaultListener", "checks if default listener for the node is running");
        this.addCommandLineOption("-getDbNodes", 2, "getDbNodes", "Gets list of cluster nodes for a specified database");
        this.addCommandLineOption("-getDatabaseInfos", 1, "getDatabaseInfos", "Gets database unique names, oracle homes, and versions of all configured databases  on the cluster");
        this.addCommandLineOption("-runASMQuery", 4, "runASMQuery", "Runs the specified SQL query and return the output");
        this.addCommandLineOption("-getASMConnectionInfo", 3, "getASMConnectionInfo", "Gets ASM connection information");
    }

    public int checkASMRunning(String[] args) {
        String[] nodeArray = args[1].split(",");
        boolean failNodes = false;
        boolean succNodes = false;
        MessageBundle msgBndl = MessageBundle.getMessageBundle((String)"Prko");
        for (int j = 0; j < nodeArray.length; ++j) {
            String[] insts;
            String node = nodeArray[j];
            try {
                insts = ASM.getInstances((String)node, (Version)new Version());
            }
            catch (ASMConfigurationException e) {
                this.displayErrorResult(e.getMessage(), 2);
                return 0;
            }
            String oh = null;
            ASMInstance asmInst = null;
            if (insts == null || insts.length == 0) {
                failNodes = true;
                this.displayWarningResult("<ASM_FAIL_NODE>" + node + "</ASM_FAIL_NODE>");
                continue;
            }
            for (int i = 0; i < insts.length; ++i) {
                try {
                    oh = ASM.getOracleHome((String)insts[i], (String)node, (Version)new Version());
                    asmInst = new ASMInstance(insts[i], node, oh, new Version());
                    if (!asmInst.isEnabled()) {
                        failNodes = true;
                        this.displayWarningResult("<ASM_FAIL_NODE>" + node + "</ASM_FAIL_NODE>");
                        continue;
                    }
                    if (asmInst.isRunning()) {
                        succNodes = true;
                        this.displaySuccessResult("<ASM_SUCC_NODE>" + node + "</ASM_SUCC_NODE>");
                        continue;
                    }
                    failNodes = true;
                    this.displayWarningResult("<ASM_FAIL_NODE>" + node + "</ASM_FAIL_NODE>");
                    continue;
                }
                catch (ASMInstanceException e) {
                    failNodes = true;
                    this.displayWarningResult("<ASM_FAIL_NODE>" + node + "</ASM_FAIL_NODE>");
                    continue;
                }
                catch (ASMConfigurationException e) {
                    failNodes = true;
                    this.displayWarningResult("<ASM_FAIL_NODE>" + node + "</ASM_FAIL_NODE>");
                }
            }
        }
        if (succNodes) {
            if (failNodes) {
                this.displayVRESStatus(1);
                return 0;
            }
            this.displayVRESStatus(0);
            return 0;
        }
        this.displayVRESStatus(2);
        return 0;
    }

    public int getASMhome(String[] args) {
        String asmHome = null;
        String node = args[1];
        try {
            String[] insts = ASM.getInstances((String)node, (Version)new Version());
            if (insts == null || insts.length == 0) {
                Trace.out((String)"Couldn't get the ASM instances configured for the given node");
                this.displayErrorResult("No configured ASM instance is found", 2);
                return 0;
            }
            asmHome = ASM.getOracleHome((String)insts[0], (String)node, (Version)new Version());
            this.displaySuccessResult(asmHome, 0);
            return 0;
        }
        catch (ASMConfigurationException e) {
            Trace.out((String)("Couldn't get ASM home. " + e.getMessage()));
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
        catch (ASMInstanceNotExistException e) {
            Trace.out((String)("Couldn't get ASM home. " + e.getMessage()));
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
    }

    public int getASMsid(String[] args) {
        Object asmHome = null;
        String node = args[1];
        try {
            String[] insts = ASM.getInstances((String)node, (Version)new Version());
            if (insts == null || insts.length == 0) {
                Trace.out((String)"Couldn't get the ASM instances configured for the given node");
                this.displayErrorResult("No configured ASM instance is found", 2);
                return 0;
            }
            this.displaySuccessResult(insts[0], 0);
            return 0;
        }
        catch (ASMConfigurationException e) {
            Trace.out((String)("Couldn't get ASM home. " + e.getMessage()));
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
    }

    public int getDbNodes(String[] args) {
        String dbUniqueName = args[1];
        Vector<String> dbNodes = new Vector<String>();
        try {
            Trace.out((String)"Trying to get node list from configuration.");
            ParallelServer ops = Cluster.getParallelServer((String)dbUniqueName);
            ParallelServerConfig opsConfig = ops.getConfiguration();
            Vector instances = opsConfig.getInstances();
            if (instances.size() > 0) {
                Iterator iter = instances.iterator();
                while (iter.hasNext()) {
                    Instance inst = (Instance)iter.next();
                    dbNodes.add(inst.getNode());
                }
                this.displaySuccessResult(CVUHelper10205.strVect2List(dbNodes), 0);
                return 0;
            }
            Trace.out((String)"Could not find any node for the specified database name ");
            this.displayErrorResult("Could not find any node for the specified database name", 2);
            return 0;
        }
        catch (ConfigurationException ex) {
            Trace.out((String)("Exception from database configuration: " + ex.getMessage()));
            this.displayErrorResult(ex.getMessage(), 2);
            return 0;
        }
    }

    public int getDatabaseInfos(String[] args) {
        Trace.out((String)"Method Entry");
        StringBuffer dbInfosSB = new StringBuffer("");
        try {
            String[] dbNames = Cluster.listParallelServers();
            for (int i = 0; i < dbNames.length; ++i) {
                ParallelServer ops = Cluster.getParallelServer((String)dbNames[i]);
                ParallelServerConfig opsConfig = ops.getConfiguration();
                dbInfosSB.append(dbNames[i] + "|" + opsConfig.getOracleHome() + VerificationConstants.LSEP);
            }
            this.displaySuccessResult(dbInfosSB.toString(), 0);
            return 0;
        }
        catch (ConfigurationException ex) {
            Trace.out((String)("Exception from database configuration: " + ex.getMessage()));
            this.displayErrorResult(ex.getMessage(), 2);
            return 0;
        }
    }

    public int checkDefaultListener(String[] args) {
        String node = args[1];
        try {
            Listener listnr = null;
            listnr = new Listener(node);
            if (listnr.exists() && listnr.isRunning()) {
                Trace.out((String)("Default listener " + listnr.getResourceName() + " was found configured and running on local node"));
                this.displaySuccessResult(node, 0);
                return 0;
            }
            NodeApps nodeApps = new NodeApps(node, new Version());
            String resourceRunningNode = nodeApps.nodeRunning(listnr.getResourceName());
            if (resourceRunningNode != null) {
                Trace.out((String)("Default listener " + listnr.getResourceName() + " was found configured but running on node " + resourceRunningNode));
                this.displaySuccessResult(resourceRunningNode, 0);
                return 0;
            }
            Trace.out((String)("Default listener " + listnr.getResourceName() + " was not found configured"));
            this.displayErrorResult("Default listener " + listnr.getResourceName() + " was not found configured", 2);
            return 0;
        }
        catch (ListenerException le) {
            Trace.out((String)("Caught ListenerException : " + le.getMessage()));
            this.displayErrorResult(le.getMessage(), 2);
            return 0;
        }
        catch (NodeException ne) {
            Trace.out((String)("Caught NodeException : " + ne.getMessage()));
            this.displayErrorResult(ne.getMessage(), 2);
            return 0;
        }
    }

    public int getCRSUser(String[] args) {
        String crsHome = System.getProperty("GI_HOME");
        try {
            Util hasUtil = new Util();
            this.displaySuccessResult(hasUtil.getOracleUser(crsHome, null), 0);
            return 0;
        }
        catch (UtilException e) {
            Trace.out((String)"Couldn't get oracle user");
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
    }

    public int processCommandLine(String methodName, String[] args) {
        String className = "oracle.ops.verification.helper.helper10205.CVUHelper10205";
        try {
            Class<?> helperClass = Class.forName(className);
            Class[] clsArr = new Class[]{args.getClass()};
            Method cmdMethod = helperClass.getMethod(methodName, clsArr);
            Object[] arglist = new Object[]{args};
            Integer retVal = (Integer)cmdMethod.invoke(helperClass.newInstance(), arglist);
            return retVal;
        }
        catch (NoSuchMethodException e) {
            this.displayExecutionError("Method " + methodName + " not found: " + e.getMessage());
            return 2;
        }
        catch (InstantiationException e) {
            this.displayExecutionError("error while instantiating method " + methodName + ": " + e.getMessage());
            return 2;
        }
        catch (ClassNotFoundException e) {
            this.displayExecutionError("Class " + className + " not found: " + e.getMessage());
            return 2;
        }
        catch (IllegalAccessException e) {
            this.displayExecutionError("Illegal Access while running method " + methodName + ": " + e.getMessage());
            return 2;
        }
        catch (InvocationTargetException e) {
            this.displayExecutionError("error while invoking method " + methodName + ": " + e.getMessage());
            return 2;
        }
    }

    public static String strVect2List(Vector v) {
        String delim = ",";
        StringBuffer strBuf = new StringBuffer("");
        if (v != null) {
            boolean first = true;
            for (int i = 0; i < v.size(); ++i) {
                if (first) {
                    first = false;
                } else {
                    strBuf.append(delim);
                }
                strBuf.append(v.get(i));
            }
        }
        return strBuf.toString();
    }

    public int runASMQuery(String[] args) {
        int status = 0;
        String sqlQuery = args[1];
        String node = args[2];
        String role = args[3];
        OracleConnection asmConnection = this.getASMConnection(node, role);
        if (asmConnection != null) {
            try {
                int i;
                Trace.out((String)"Connection to Local ASM instance successful");
                Statement stmt = asmConnection.createStatement();
                Trace.out((String)("Executing the query " + sqlQuery));
                ResultSet queryResult = stmt.executeQuery(sqlQuery);
                ResultSetMetaData rsmd = queryResult.getMetaData();
                int colCount = rsmd.getColumnCount();
                String colNames = "";
                String colLabels = "";
                Trace.out((String)("Number of columns: " + colCount));
                String resultString = "<COLUMN_COUNT>" + colCount + "</COLUMN_COUNT>";
                for (i = 1; i <= colCount; ++i) {
                    colNames = colNames + rsmd.getColumnName(i) + "|";
                    colLabels = colLabels + rsmd.getColumnLabel(i) + "|";
                }
                resultString = resultString + "<COLUMN_NAME>" + colNames.substring(0, colNames.length() - 1) + "</COLUMN_NAME>" + "<COLUMN_LABEL>" + colLabels.substring(0, colLabels.length() - 1) + "</COLUMN_LABEL>";
                while (queryResult.next()) {
                    resultString = resultString + "<ROW_DATA>";
                    for (i = 1; i <= colCount; ++i) {
                        resultString = resultString + queryResult.getObject(i) + "|";
                    }
                    resultString = resultString.substring(0, resultString.length() - 1);
                    resultString = resultString + "</ROW_DATA>";
                }
                Trace.out((String)resultString);
                queryResult.close();
                stmt.close();
                asmConnection.close();
                this.displaySuccessResult(resultString);
            }
            catch (SQLException sqlex) {
                Trace.out((String)("SQLException occured while executing query " + sqlQuery));
                Trace.out((String)sqlex.getMessage());
                this.displayErrorResult(sqlex.getMessage(), 2);
                return 0;
            }
        } else {
            return 0;
        }
        return status;
    }

    private OracleConnection getASMConnection(String node, String role) {
        String connString = this.getASMConnectString(node);
        if (connString == null) {
            return null;
        }
        String jdbcURL = "jdbc:oracle:oci:@" + connString;
        try {
            Class.forName("oracle.jdbc.driver.OracleDriver");
        }
        catch (ClassNotFoundException cnfe) {
            Trace.out((String)("Exception while loading OracleDriver " + cnfe.getMessage()));
            String errMsg = "<FACILITY>PRVG</FACILITY><ID>12943</ID><ARGS>" + node + "</ARGS>";
            this.displayErrorResult(errMsg, 2);
            return null;
        }
        try {
            Properties conProperties = new Properties();
            conProperties.put("user", "");
            conProperties.put("password", "");
            conProperties.put("internal_logon", role);
            Trace.out((String)("Trying to establish connection using thin jdbc url '" + jdbcURL + "'"));
            return (OracleConnection)DriverManager.getConnection(jdbcURL, conProperties);
        }
        catch (SQLException sqlex) {
            Trace.out((String)sqlex.getMessage());
            String errMsg = "<FACILITY>PRVG</FACILITY><ID>12945</ID><ARGS>" + connString + "</ARGS>";
            errMsg = errMsg + "<AMSG>" + sqlex.getMessage() + "</AMSG>";
            this.displayErrorResult(errMsg, 2);
            return null;
        }
    }

    private String getASMConnectString(String node) {
        String asmSid = null;
        String asmHome = null;
        try {
            String[] insts = ASM.getInstances((String)node, (Version)new Version());
            if (insts == null || insts.length == 0) {
                Trace.out((String)"Couldn't get the ASM instances configured for the given node");
                String errMsg = "<FACILITY>PRVG</FACILITY><ID>12942</ID><ARGS>" + node + "</ARGS>";
                this.displayErrorResult(errMsg, 2);
                return null;
            }
            asmSid = insts[0];
            asmHome = ASM.getOracleHome((String)insts[0], (String)node, (Version)new Version());
            Trace.out((String)("ASM instance " + asmSid + " ASM/ORACLE Home " + asmHome + " found"));
        }
        catch (ASMConfigurationException asmce) {
            Trace.out((String)("Couldn't get ASM Sid. " + asmce.getMessage()));
            this.displayErrorResult(asmce.getMessage(), 2);
            return null;
        }
        catch (ASMInstanceNotExistException asmne) {
            Trace.out((String)("Couldn't get ASM/ORACLE home. " + asmne.getMessage()));
            this.displayErrorResult(asmne.getMessage(), 2);
            return null;
        }
        String enableSetuser = "(ENABLE=SETUSER)";
        String security = "(SECURITY=(AUTHENTICATION_SERVICES=NTS))";
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        if (!nativeSystem.isUnixSystem()) {
            enableSetuser = "";
        } else {
            security = "";
        }
        String oracleBinary = nativeSystem.getExeName(asmHome + VerificationConstants.FSEP + "bin" + VerificationConstants.FSEP + "oracle");
        MessageFormat msFm = new MessageFormat("(DESCRIPTION={0}(ADDRESS_LIST=(ADDRESS=(PROTOCOL=beq)(PROGRAM={1})(ARGV0=oracle{2})(ENVS=''ORACLE_HOME={3},ORACLE_SID={2}'')(ARGS=''(DESCRIPTION=(LOCAL=YES)(ADDRESS=(PROTOCOL=beq)))'')){4}))");
        String connString = msFm.format(new String[]{security, oracleBinary, asmSid, asmHome, enableSetuser});
        return connString;
    }

    public int getASMConnectionInfo(String[] args) {
        int status = 0;
        String node = args[2];
        String connString = this.getASMConnectString(node);
        if (connString == null) {
            return 0;
        }
        this.displaySuccessResult("<CONN_STRING>" + connString + "</CONN_STRING>");
        return status;
    }

    public static void main(String[] args) {
        int retVal = 2;
        CVUHelper10205.setupTracing();
        Trace.out((String)"CVUHelper10205 main");
        CVUHelper10205 cvuHelper = new CVUHelper10205();
        String methodName = cvuHelper.parseArguments(args);
        if (methodName != null) {
            retVal = cvuHelper.processCommandLine(methodName, args);
            if (retVal != 2) {
                cvuHelper.displayExecutionSuccess();
            } else {
                cvuHelper.displayExecutionError("exception returned by method : " + args[0]);
            }
        }
        Trace.out((String)"==== cvuhelper exiting normally.");
        System.exit(retVal);
    }
}

