set trimspool on
set echo      on
set pagesize  999
set linesize  132

drop materialized view sales_prod;

create materialized view sales_prod
       build immediate
       enable query rewrite
as
SELECT s.prod_id
,      t.fiscal_month_number 
,      sum(s.amount_sold) AS sum_amount
FROM   sales s, times t
WHERE  s.time_id = t.time_id
AND    t.fiscal_year = 2000
GROUP  BY s.prod_id, t.fiscal_month_number;

execute dbms_stats.gather_table_stats('SH','SALES_PROD');
execute dbms_stats.gather_table_stats('SH','SALES');
execute dbms_stats.gather_table_stats('SH','TIMES');