rem
rem Header: procedures.sql 16-May-03
rem
rem Copyright (c) 2001 Oracle Corporation.  All rights reserved.
rem
rem Owner  : 
rem
rem NAME
rem   procedures.sql - script for function creation which will be used in search
rem
rem DESCRIPTON
rem   
rem
rem MODIFIED   (MM/DD/YY)


set define off;


CREATE OR REPLACE FUNCTION GET_TEXT_AROUND_KEYWORD (
  index_name     IN VARCHAR2,
  textkey        IN VARCHAR2,
  text_query     IN VARCHAR2
)

RETURN VARCHAR2
IS

  buf     CLOB;                  -- CLOB Locator  
  offset  NUMBER;               -- Offset  
  amt     NUMBER := 150; -- Number of chars read from CLOB
  prefix  NUMBER := 30;         -- Number of chars before the keyword
  result  VARCHAR2(800);         -- Storage for result

  -- starttag should be unique in the whole text because
  -- starttag will be used for the key to search the keyword. 
  starttag VARCHAR2(50) := '<b name=9itext><font color="RED">';
  endtag VARCHAR2(50)   := '</font></b>';

BEGIN

  -- Run MARKUP procedure in-memory version to get CLOB result
  -- The in-memory version of MARKUP is new feature from 9i.

  -- buf is NULL when passed-in, so ctx-doc.markup will allocate 
  -- a temporary CLOB for us and place the results there.
  
  -- Note 1 :  plaintext = FALSE means returning clob with
  -- HTML style. Document styles such as font setting defined 
  -- in MS Word doc will be converted to HTML automatically.   

  -- Note 2 : MARKUP automatically escape HTML special 
  -- characters so we don't have to care about.

  CTX_DOC.MARKUP (
         index_name => index_name ,
         textkey    => textkey,
         text_query => text_query,
         plaintext  => TRUE,
         restab     => buf,
         tagset     => 'HTML_DEFAULT',
         starttag   => starttag,
         endtag     => endtag 
  );
  -- Get the offset to the first occurrence of the given keyword
  offset := DBMS_LOB.INSTR(buf, starttag, 1, 1);

  -- Read number of characters (not bytes) defined in [amt] 
  -- from the CLOB around the first occurrence of the given keyword.
  -- If there are more than [prefix] characters before the keyword,
  -- we will start to read [prefix] characters before the keyword.
  -- Otherwise, we will start to read from the top of the CLOB.
  if offset > prefix THEN 
    offset := offset - prefix;
  ELSE
    offset := 1;
  END IF;

  -- If keyword not found ... it happens very rare.
  -- You can remove this IF clause and call DBMS_LOB.READ
  -- directly for improving performance.
  IF offset = 0 THEN
    result := 'No summary available';
  ELSE 
    DBMS_LOB.READ(buf, amt, offset , result); 
  END IF;

  -- Free the CLOB 
  DBMS_LOB.FREETEMPORARY(buf);

  result := result || '</font></b>';

  -- Return result string
  RETURN result;

END;
/

show errors;

-- End of the script
