rem
rem Header: po_main.sql 12-Apr-01
rem
rem Copyright (c) 2001 Oracle Corporation.  All rights reserved.
rem
rem Owner  : 
rem
rem NAME
rem   po_main.sql - Main script for PO schema
rem
rem DESCRIPTON
rem   
rem
rem MODIFIED   (MM/DD/YY)


SET VERIFY OFF

spool po_main.log

ALTER SESSION SET NLS_LANGUAGE=American;

PROMPT 
PROMPT specify password for PO as parameter 1:
define pass     = &1
PROMPT 
PROMPT specify default tablespeace for PO as parameter 2:
define tbs      = &2
PROMPT 
PROMPT specify temporary tablespace for PO as parameter 3:
define ttbs     = &3
PROMPT
PROMPT specify password for SYS as parameter 4:
define pass_sys = &4
PROMPT
PROMPT specify tnsnames entry as parameter 5 (i.e. orcl.world):
define tns   = &5
PROMPT


REM =======================================================
REM cleanup section
REM =======================================================

DROP USER po CASCADE;

REM =======================================================
REM create user
REM three separate commands, so the create user command 
REM will succeed regardless of the existence of the 
REM DEMO and TEMP tablespaces 
REM =======================================================

CREATE USER po IDENTIFIED BY &pass;

ALTER USER po DEFAULT TABLESPACE &tbs
              QUOTA UNLIMITED ON &tbs;

ALTER USER po TEMPORARY TABLESPACE &ttbs;

GRANT create session
     , create table
     , create procedure 
     , create sequence
     , create trigger
     , create view
     , create synonym
     , alter session
     , ctxapp
TO po;


REM =======================================================
REM grants from sys schema
REM =======================================================

CONNECT sys/&pass_sys@&tns AS SYSDBA;
GRANT execute ON sys.dbms_stats TO po;

REM =======================================================
REM create po schema objects
REM =======================================================

CONNECT po/&pass@&tns
@@po_cre       -- create tables, sequences and constraints
@@ traintable      -- creates the tables and lexer for classification search
host sqlldr po/&pass@&tns control='po_p_lob.ctl'
@@ create_lexer   -- create Lexer
@@ file_datastore  -- create file datastore table
@@ procedures      -- create the function for multilingual search

spool off
