rem
rem Header: file_datastore.sql 16-May-03
rem
rem Copyright (c) 2001 Oracle Corporation.  All rights reserved.
rem
rem Owner  : 
rem
rem NAME
rem   file_datastore.sql -  script which will create file data store
rem
rem DESCRIPTON
rem   
rem
rem MODIFIED   (MM/DD/YY)


SET VERIFY OFF

REM spool file_datastore.log

REM ==========================================
REM  Drop existing tables and indexes
REM ==========================================

drop index FILEDOC_IDX;
drop table FILEDOC;

REM ==========================================
REM Drop existing preferences
REM ==========================================

exec ctx_ddl.drop_preference('MY_FILE_DATASTORE');


REM ==========================================
REM Create document data table
REM ==========================================


CREATE TABLE FILEDOC (
  ID        NUMBER        PRIMARY KEY,
  LANG      VARCHAR2(3),
  URL       VARCHAR2(200),
  ENCODING  VARCHAR2(20),
  FORMAT    VARCHAR2(10)  
);

REM ==========================================
REM Set FILE_DATASTORE datastore type
REM ==========================================


exec ctx_ddl.create_preference('MY_FILE_DATASTORE','FILE_DATASTORE');

REM ========================================
REM Change the directory to reflect your downloaded directory
REM ========================================

exec ctx_ddl.set_attribute('MY_FILE_DATASTORE','PATH','d:\OBE');

REM ==========================================
REM  Insert demo data into document data table
REM The 'lang' column should have one of the lexer identifiers set above.
REM The 'url' column should have the url of the target file.
REM The 'encoding' column should have one of the database character sets
REM to tell 9iText which encoding is used for the document.
REM This is needed only for plain-text files.
REM The 'bort' should have either TEXT or BINARY.  
REM ==========================================

insert into FILEDOC values (
  1,
  'eng', 
  'en.doc', 
  'US7ASCII', 
  'BINARY');
  
insert into FILEDOC values (
  2,
  'eng', 
  'en2.doc', 
  'US7ASCII',
  'BINARY');

insert into FILEDOC values (
  3,
  'jpn', 
  'ja.doc', 
  'JA16SJIS', 
  'BINARY');
  
insert into FILEDOC values (
  4,
  'jpn', 
  'ja2.doc', 
  'JA16SJIS', 
  'BINARY');
  
insert into FILEDOC values (
  5,
  'chn', 
  'zht.doc', 
  'ZHT16BIG5', 
  'BINARY');

insert into FILEDOC values (
  6,
  'chn', 
  'zht2.doc', 
  'ZHT16BIG5', 
  'BINARY');

insert into FILEDOC values (
  7,
  'kor', 
  'kr.doc', 
  'KO16KSC5601',
  'BINARY');

insert into FILEDOC values (
  8,
  'kor', 
  'kr2.doc', 
  'KO16KSC5601', 
  'BINARY');
 


REM ==========================================
REM Create Index on document data table
REM ==========================================

create index FILEDOC_IDX on FILEDOC(URL) 
  indextype is ctxsys.context
  parameters (
    'lexer            GLOBAL_LEXER 
     language column  LANG 
     datastore        MY_FILE_DATASTORE 
     filter           MY_FILTER
     charset column   ENCODING
     format column    FORMAT');

commit;

REM ==========================================
REM End of the script
REM ==========================================

