package oracle.i18n.demo.obe.gdkshop;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class AuthFilter implements Filter
{
  private FilterConfig m_fc;

  /**
   * Initializes to keep the filter config object.
   *
   * @param fc <code>FilterConfig</code> object
   *
   * @throws ServletException if something wrong.
   *
   * @exclude
   */
  public void init(FilterConfig fc) throws ServletException
  {
    m_fc = fc;
  }

  /**
   * Cleans up the object
   *
   * @exclude
   */
  public void destroy()
  {
  }

  /**
   * Executes the filter operation.
   *
   * @param request the servlet request object
   * @param response the servlet response object
   * @param chain a filter chain object
   *
   * @throws RuntimeException if <code>IOException</code> or
   *         <code>ServletException</code> occurs
   */
  public void doFilter(ServletRequest request, ServletResponse response,
    FilterChain chain
  )
  {
    try
    {
      HttpServletRequest req = (HttpServletRequest)request;
      ShopAction.init(req); // init JDBC connection
      String command = ShopAction.getCommand(req);
      if (req.getServletPath().endsWith("index.jsp"))
      {
        // reset the user id (demo)
        ((HttpServletRequest) request).getSession().removeAttribute("userid");  
      }
      else
      {
        String userid = request.getParameter("userid");
        if (userid != null)
        {
          // do authentication ... 
          ((HttpServletRequest) request).getSession().setAttribute("userid",
              userid
          );
        }
      }
      chain.doFilter(request, response);
    }
    catch (Exception e)
    {
      throw new RuntimeException(e.getMessage());
    }
  }

  /**
   * Registers the filter config object
   *
   * @param fc <code>FilterConfig</code> object
   *
   * @exclude
   */
  public void setFilterConfig(final FilterConfig fc)
  {
    m_fc = fc;
  }

  /**
   * Returns the filter config object
   *
   * @return fc <code>FilterConfig</code> object
   *
   * @exclude
   */
  public FilterConfig getFilterConfig()
  {
    return m_fc;
  }
}
