WITH v1 AS
(SELECT time_id
   FROM times
   WHERE times.time_id BETWEEN
      TO_DATE('01/04/01', 'DD/MM/YY')
      AND TO_DATE('07/04/01', 'DD/MM/YY'))
SELECT product, time_id, quant quantity,
  LAST_VALUE(quant IGNORE NULLS)
  OVER (PARTITION BY product ORDER BY time_id)
   repeated_quantity
FROM
  (SELECT product, v1.time_id, quant
   FROM inventory PARTITION BY (product)
     RIGHT OUTER JOIN v1
     ON (v1.time_id = inventory.time_id))
ORDER BY 1, 2;
