col sales_prior_period  heading  'sales_prior|_period'
col variance_prior_period  heading  'variance|_prior|_period'
col sales_same_period_prior_year  -
    heading 'sales_same|_period_prior|_year'
col variance_same_period_p_year -
    heading 'variance|_same_period|_prior_year'
col ht format a12
col prod format a5

SELECT
  substr(prod,1,4) prod, substr(Hierarchical_Time,1,12) ht, 
  sales,
  sales_prior_period,
  sales - sales_prior_period variance_prior_period,
  sales_same_period_prior_year,
  sales - sales_same_period_prior_year variance_same_period_p_year
  FROM
  (SELECT cat, subcat, prod, gid_p, gid_t, Hierarchical_Time,
  yr, qtr, mon, day, sales,
  LAG(sales, 1) OVER (PARTITION BY gid_p, cat, subcat, prod,
  gid_t ORDER BY yr, qtr, mon, day) 
  sales_prior_period,
  LAG(sales, 1) OVER (PARTITION BY gid_p, cat, subcat, prod,
  gid_t, qtr_num, mon_num, day_num ORDER BY yr)
  sales_same_period_prior_year
  FROM
  ( SELECT c.gid, c.cat, c.subcat, c.prod, c.gid_p, 
  t.gid_t, t.yr, t.qtr, t.qtr_num, t.mon, t.mon_num,
  t.day, t.day_num, t.Hierarchical_Time, NVL(s_sold,0) sales
  FROM cube_prod_time c 
  PARTITION BY (gid_p, cat, subcat, prod)
  RIGHT OUTER JOIN edge_time t
  ON ( c.gid_t = t.gid_t AND c.Hierarchical_Time = t.Hierarchical_Time)          
  ) dense_cube_prod_time 
  ) 
  WHERE prod IN (139) AND gid_p=0 AND -- 1 product and product level data
  ( (mon IN ('2001-08' ) AND gid_t IN (0, 1) ) OR -- day and month data          
  ( qtr IN ('2001-03' ) AND gid_t IN (3) ) ) -- quarter level data 
  ORDER BY day;
