CREATE OR REPLACE VIEW edge_time
AS
SELECT
  (CASE
   WHEN ((GROUPING(calendar_year)=0 )
     AND (GROUPING(calendar_quarter_desc)=1 ))
   THEN (TO_CHAR(calendar_year) || '_0')
   WHEN ((GROUPING(calendar_quarter_desc)=0 )
     AND (GROUPING(calendar_month_desc)=1 ))
   THEN (TO_CHAR(calendar_quarter_desc) || '_1')
   WHEN ((GROUPING(calendar_month_desc)=0 )
     AND (GROUPING(time_id)=1 ))
   THEN (TO_CHAR(calendar_month_desc) || '_2')
   ELSE (TO_CHAR(time_id) || '_3') END) Hierarchical_Time,
   calendar_year yr,
   calendar_quarter_number qtr_num,
   calendar_quarter_desc qtr,
   calendar_month_number mon_num,
   calendar_month_desc mon,
   time_id - TRUNC(time_id, 'YEAR') + 1 day_num,
   time_id day,
   GROUPING_ID(calendar_year, calendar_quarter_desc,
     calendar_month_desc, time_id) gid_t
FROM TIMES
GROUP BY ROLLUP
(calendar_year,
(calendar_quarter_desc, calendar_quarter_number),
(calendar_month_desc, calendar_month_number), time_id);
