CREATE OR REPLACE VIEW cube_prod_time
AS
SELECT
  (CASE
   WHEN ((GROUPING(calendar_year)=0 )
     AND (GROUPING(calendar_quarter_desc)=1 ))
   THEN (TO_CHAR(calendar_year) || '_0')
   WHEN ((GROUPING(calendar_quarter_desc)=0 )
     AND (GROUPING(calendar_month_desc)=1 ))
   THEN (TO_CHAR(calendar_quarter_desc) || '_1')
   WHEN ((GROUPING(calendar_month_desc)=0 )
     AND (GROUPING(t.time_id)=1 ))
   THEN (TO_CHAR(calendar_month_desc) || '_2')
   ELSE (TO_CHAR(t.time_id) || '_3') END) Hierarchical_Time,
  calendar_year year,
  calendar_quarter_desc quarter,
  calendar_month_desc month,
  t.time_id day,
  prod_category cat,
  prod_subcategory subcat,
  p.prod_id prod,
  GROUPING_ID(prod_category, prod_subcategory, p.prod_id,
    calendar_year, calendar_quarter_desc, calendar_month_desc,t.time_id) gid,
  GROUPING_ID(prod_category, prod_subcategory, p.prod_id)  gid_p, 
  GROUPING_ID(calendar_year, calendar_quarter_desc,
    calendar_month_desc, t.time_id) gid_t,
  SUM(amount_sold) s_sold,
  COUNT(amount_sold) c_sold,
  COUNT(*) cnt
FROM SALES s, TIMES t, PRODUCTS p
WHERE s.time_id = t.time_id AND
  p.prod_name IN ('Bounce', 'Y Box')   AND
  s.prod_id = p.prod_id
GROUP BY 
  ROLLUP(calendar_year, calendar_quarter_desc, calendar_month_desc, t.time_id),
  ROLLUP(prod_category, prod_subcategory, p.prod_id);
