-- To find all the customers within 100 miles of warehouse_id = 3 
-- and return the distance in miles, and order the results by distance 

select /*+ordered*/ 
       c.customer_id,
       c.cust_address.state_province state,
       sdo_geom.sdo_distance (c.cust_geo_location, 
                              w.wh_geo_location, 
                              .005, 'unit=MILE') distance_in_miles  
from warehouses w, 
     customers c
where w.warehouse_id = 3
and sdo_within_distance (c.cust_geo_location,
                         w.wh_geo_location,
                         'distance = 100 unit=MILE') = 'TRUE'
order by distance_in_miles;


