REM Finds all the customers within 100 miles of warehouse_id=3

REM
REM CUSTOMERS and WAREHOUSES
REM


set lines 132
set pages 1000


-- To find all the customers within 100 miles of warehouse_id = 3

select /*+ordered*/ 
       c.customer_id,
       c.cust_address.state_province state
from warehouses w, 
       customers c
where w.warehouse_id = 3
and sdo_within_distance (c.cust_geo_location,
                         w.wh_geo_location,
                         'distance = 100 unit=MILE') = 'TRUE';