/*
 * Copyright (c) 2016, Oracle and/or its affiliates.  All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and
 * the Universal Permissive License (UPL).  See the LICENSE file in the root
 * directory for license terms.  You may choose either license, or both.
 */

package com.oracle.iot.sample.quickstart;

public class TokenAndActivation {
    public static void main(String[] args) {
        if (args[0].equalsIgnoreCase("token")) {
            if (args[1].equalsIgnoreCase("activationToken"))
                ClientAssertionHelper.clientAssertionForActivation(args[2], args[3], args[4]);
            else if (args[1].equalsIgnoreCase("messageToken"))
                ClientAssertionHelper.clientAssertionForMessaging(args[2], args[3], args[4]);
        }
        else if (args[0].equalsIgnoreCase("activation")) {
            DirectActivation directActivation = new DirectActivation(args[1], args[2], args[3], "private_key.der", "public_key.der");
            directActivation.printDirectActivationPayload();
        }
        else {
            System.out.println("Please Enter either activation or token as first parameter.");
        }
    }
}