/*
 * Copyright (c) 2016, Oracle and/or its affiliates. All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and the
 * Universal Permissive License (UPL). See the LICENSE file in the root
 * directory for license terms. You may choose either license, or both.
 */

package com.oracle.iot.sample.daf.type.temperature;

import oracle.iot.device.DeviceModel;
import oracle.iot.device.attribute.DeviceAttribute;
import oracle.iot.module.IoTExport;
import oracle.iot.device.attribute.ReadOnlyDeviceAttribute;
import oracle.iot.messaging.IoTResource;

import java.util.Date;

/**
 * A temperature sensor is a device that measures temperature using a variety of different principles.
 */
@IoTExport
@DeviceModel(name = "urn:com:oracle:iot:device:temperature_sensor")
public interface TemperatureSensor {
    @IoTResource
    DeviceAttribute<Integer> maxThresholdProperty();

    @IoTResource
    ReadOnlyDeviceAttribute<Float> maxTempProperty();

    @IoTResource
    DeviceAttribute<Integer> minThresholdProperty();

    @IoTResource
    ReadOnlyDeviceAttribute<Float> minTempProperty();

    @IoTResource
    void power(Boolean isOn);

    @IoTResource
    void reset();

    @IoTResource
    ReadOnlyDeviceAttribute<Date> startTimeProperty();

    @IoTResource
    ReadOnlyDeviceAttribute<Float> tempProperty();

    @IoTResource
    ReadOnlyDeviceAttribute<String> unitProperty();
}
