/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and the
 * Universal Permissive License (UPL). See the LICENSE file in the root
 * directory for license terms. You may choose either license, or both.
 */

package com.oracle.iot.sample.daf.type.motionactivatedcamera;

import oracle.iot.endpoint.Endpoint;
import oracle.iot.module.IoTExport;

/**
 * {@code Camera} device represented as a {@code DeviceEndpoint}.
 * <p>
 * Concrete implementation is responsible for sending
 * {@link MotionActivatedCameraEvent CameraDataEvents}.
 *
 * @see MotionActivatedCamera
 * @see oracle.iot.endpoint.Endpoint
 */
@IoTExport
public interface MotionActivatedCameraEndpoint extends MotionActivatedCamera, Endpoint {
}
