/*
 * Copyright (c) 2016, Oracle and/or its affiliates. All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and the
 * Universal Permissive License (UPL).  See the LICENSE file in the root
 * directory for license terms.  You may choose either license, or both.
 */

package com.oracle.iot.sample.helloworldadapter;

import oracle.iot.device.DeviceModel;
import oracle.iot.module.IoTExport;
import oracle.iot.device.attribute.ReadOnlyDeviceAttribute;
import oracle.iot.messaging.IoTResource;

/**
 *
 */
@IoTExport
@DeviceModel(name = "urn:com:oracle:iot:device:hello_world")
public interface HelloWorld {
    @IoTResource
    ReadOnlyDeviceAttribute<String> messageProperty();
}
