/*
 * Copyright (c) 2015, 2016, Oracle and/or its affiliates. All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and the
 * Universal Permissive License (UPL). See the LICENSE file in the root
 * directory for license terms. You may choose either license, or both.
 */

package com.oracle.iot.sample.service.contract;

import oracle.iot.app.AbstractApplication;
import oracle.iot.app.IoTDeviceApplication;
import oracle.iot.inject.Contract;

@Contract
public interface SampleContract {

    /**
      * Only method offered by the service.
      * Prints out a message indicating which service version
      * is used, and whether the application using the service
      * is starting or finishing.
      *
      * @param start {@code true} if application is starting,
      * {@code false} otherwise
      */
    public void serviceMethod(boolean start);

}
