/*
 * Copyright (c) 2014, 2016, Oracle and/or its affiliates. All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and the
 * Universal Permissive License (UPL). See the LICENSE file in the root
 * directory for license terms. You may choose either license, or both.
 */
package com.oracle.iot.sample.daf.type.thermometer;

import oracle.iot.device.Device;
import oracle.iot.device.DeviceModel;
import oracle.iot.module.IoTExport;
import oracle.iot.device.attribute.ReadOnlyDeviceAttribute;
import oracle.iot.messaging.IoTResource;

/**
 * A thermometer is a device that measures temperature using a variety of different principles.
 */
@IoTExport
@DeviceModel(name = "urn:com:oracle:iot:device:thermometer")
public interface Thermometer extends Device {

    /**
     * Temperature measured by this {@code Thermometer}. It is expressed in degrees Celsius (C).
     * @return the property describing the temperature
     */
    @IoTResource
    ReadOnlyDeviceAttribute<Float> temperatureProperty();

    Float getTemperature();

}
