/*
 * Copyright (c) 2014, 2016, Oracle and/or its affiliates. All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and the
 * Universal Permissive License (UPL). See the LICENSE file in the root
 * directory for license terms. You may choose either license, or both.
 */
package com.oracle.iot.sample.daf.type.heartratemonitor;

import oracle.iot.device.DeviceEndpoint;
import oracle.iot.module.IoTExport;

/**
 * {@code HeartRateMonitor} represented as a {@code DeviceEndpoint}.
 * <p>
 * Concrete implementation is responsible for sending
 * {@link HeartRateMonitorEvent HeartRateMonitorEvents}.
 *
 * @see HeartRateMonitor
 * @see oracle.iot.device.DeviceEndpoint
 */
@IoTExport
public interface HeartRateMonitorEndpoint extends HeartRateMonitor, DeviceEndpoint {
}
