/*
 * Copyright (c) 2014, 2016, Oracle and/or its affiliates. All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and the
 * Universal Permissive License (UPL). See the LICENSE file in the root
 * directory for license terms. You may choose either license, or both.
 */
package com.oracle.iot.sample.daf.type.bodyweightscale;

import oracle.iot.device.Device;
import oracle.iot.device.DeviceModel;
import oracle.iot.module.IoTExport;
import oracle.iot.device.attribute.ReadOnlyDeviceAttribute;
import oracle.iot.messaging.IoTResource;

/**
 * Device used for measuring body weight.
 */
@IoTExport
@DeviceModel(name = "urn:com:oracle:iot:device:body_weight_scale")
public interface BodyWeightScale extends Device {

    /**
     * Measured weight of the person in kilograms (kg).
     * @return the property describing the body weight
     */
    @IoTResource
    ReadOnlyDeviceAttribute<Float> bodyWeightProperty();

    Float getBodyWeight();


}
