/*
 * Copyright (c) 2014, 2016, Oracle and/or its affiliates. All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and the
 * Universal Permissive License (UPL). See the LICENSE file in the root
 * directory for license terms. You may choose either license, or both.
 */
package com.oracle.iot.sample.daf.type.bloodpressuremonitor;

import oracle.iot.device.DeviceEndpoint;
import oracle.iot.module.IoTExport;


/**
 * {@code BloodPressureMonitor} represented as a {@code DeviceEndpoint}.
 * <p>
 * Concrete implementation is responsible for sending
 * {@link BloodPressureMonitorEvent BloodPressureMonitorEvents}.
 *
 * @see BloodPressureMonitor
 * @see oracle.iot.device.DeviceEndpoint
 */
@IoTExport
public interface BloodPressureMonitorEndpoint extends BloodPressureMonitor, DeviceEndpoint {
}
