/*
 * Copyright (c) 2014, 2016, Oracle and/or its affiliates. All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and the
 * Universal Permissive License (UPL). See the LICENSE file in the root
 * directory for license terms. You may choose either license, or both.
 */

package com.oracle.iot.sample.adapter.bluetoothle;


import jdk.bluetooth.RemoteDevice;
import oracle.iot.device.AbstractDeviceEndpoint;
import oracle.iot.device.DeviceEndpoint;
import oracle.iot.device.Metadata;

import java.util.logging.Logger;

/**
 * Baseclass for bluetooth LE capable endpoint implementations
 */
public abstract class BluetoothLEEndpoint extends AbstractDeviceEndpoint {

    /**
     * Set device and register for alert change notifications from proximity device
     *
     * @param device the remote proximity profile device
     */
    abstract public void connect(RemoteDevice device);

    /**
     * Initializes  metadata associated with this endpoint.
     *
     * @param hardwareId a globally unique hardware ID.  For example, a Bluetooth address.
     * @param metadata   the IoT framework metadata associated with this device
     * @param address    the bluetooth address for the associated connected device
     * @param logger     the logger to use for this device
     */
    abstract public void init(String hardwareId, Metadata metadata, String address, Logger logger);

    /**
     * Disconnect the proximity listener from the remote device
     */
    abstract public void disconnect();
}
