/*
 * Copyright (c) 2014, 2016, Oracle and/or its affiliates. All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and the
 * Universal Permissive License (UPL). See the LICENSE file in the root
 * directory for license terms. You may choose either license, or both.
 */

package com.oracle.iot.sample.daf.adapter.temperature;

import oracle.iot.concurrent.ObservableFuture;
import oracle.iot.device.AbstractDeviceAdapter;
import oracle.iot.device.IoTDeviceAdapter;
import oracle.iot.device.Metadata;

import javax.inject.Inject;
import java.util.logging.Level;
import java.util.logging.Logger;


/**
 * Example of a device adapter implementation for handling temperature sensor device model endpoints
 */
@IoTDeviceAdapter
public class TemperatureSensorDeviceAdapter extends AbstractDeviceAdapter {
    @Inject
    public TemperatureSensorDeviceAdapter(Logger logger) {
        logger.log(Level.INFO, "Created new temperature sensor device adapter.");
    }

    /**
     * Starts the device adapter.
     */
    @Override
    protected void start() throws Exception {

        new Thread(() -> {
            synchronized(this) {
                try {
                    this.wait(5000);
                } catch(Exception e){};
            }

            for(int i = 0; i < 2; i++) {
                String address = "TemperatureSensor:" + getEndpointContext().getEndpointId() + "_"+ i;

                Metadata metadata = Metadata.builder().
                        protocol("device-model-sample").
                        protocolDeviceId(address).
                        manufacturer("Manu:" + address).
                        deviceClass("TemperatureSensorDevice").
                        serialNumber("Serial:" + address).
                        build();

                ObservableFuture<TemperatureSensorEndpointImpl> future = registerDevice(
                        "Manu:" + address + "Serial:" + address,
                        metadata, TemperatureSensorEndpointImpl.class,
                        (device) -> device.init());

                // Listen for the new device representation being ready
                future.addListener((observable) -> {
                    try {
                        TemperatureSensorEndpointImpl device = future.get();

                        getEndpointContext().getLogger().log(Level.FINE,
                                "Temperature sensor registered: " + device.getId());
                    } catch (final Exception e) {
                        e.printStackTrace();
                    }
                });
            }
        }).start();
    }

    /**
     * Stops the device adapter.
     */
    @Override
    protected void stop() throws Exception {
        super.stop();
    }
}
