/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and the
 * Universal Permissive License (UPL). See the LICENSE file in the root
 * directory for license terms. You may choose either license, or both.
 */

package com.oracle.iot.sample.daf.app.motionactivatedcamera;

import oracle.iot.beans.InvalidationListener;
import oracle.iot.beans.Observable;
import oracle.iot.concurrent.ObservableFuture;
import oracle.iot.storage.StorageObject;
import oracle.iot.storage.StorageSyncStatus;

import java.util.concurrent.ExecutionException;


/**
 * InvalidationListener for media downloads.
 */
class DownloadInvalidationListener implements InvalidationListener {
    @Override
    public void invalidated(Observable observable) {
        System.out.println("Completed downloading media.");

        // Prints the information on the media downloaded.
        if (observable instanceof ObservableFuture) {
            ObservableFuture<StorageSyncStatus> observableFuture = (ObservableFuture) observable;

            try {
                StorageSyncStatus storageSyncStatus = observableFuture.get();
                StorageSyncStatus.State state = storageSyncStatus.getState();
                System.out.println("\nState: " + state);

                System.out.println("\n# bytes transferred = " +
                    storageSyncStatus.getBytesTransferred());

                if (state == StorageSyncStatus.State.FAILED) {
                    System.err.println("\nFailure reason: " + storageSyncStatus.getFailureCause());
                } else {
                    StorageObject storageObject = storageSyncStatus.getStorageObject();

                    if (storageObject != null) {
                        System.out.println("\nName: " + storageObject.getName());
                        System.out.println("\nDate: " + storageObject.getDate());
                        System.out.println("\nURI: " + storageObject.getURI());
                        System.out.println("\nLength: " + storageObject.getLength());
                        System.out.println("\nType: " + storageObject.getType());
                        System.out.println("\nEncoding: " + storageObject.getEncoding());
                    }
                }
            } catch (ExecutionException | InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}
