/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and the
 * Universal Permissive License (UPL). See the LICENSE file in the root
 * directory for license terms. You may choose either license, or both.
 */

package com.oracle.iot.sample.daf.type.motionactivatedcamera;

import oracle.iot.device.DeviceModel;
import oracle.iot.device.attribute.ReadOnlyDeviceAttribute;
import oracle.iot.messaging.IoTResource;
import oracle.iot.module.IoTExport;

import java.util.Date;

/**
 * A motion activated camera is a device which captures images, both static and motion, when
 * invoked and when it detects motion.
 */
@IoTExport
@DeviceModel(name = "urn:com:oracle:iot:device:motion_activated_camera")
public interface MotionActivatedCamera {
    // Attribute names.
    public static final String IMAGE_ATTRIBUTE = "image";
    public static final String IMAGE_TIME_ATTRIBUTE = "imageTime";

    // Media extensions.
    public static final String IMAGE_EXT = ".jpg";
    public static final String VIDEO_EXT = ".mp4";

    @IoTResource
    ReadOnlyDeviceAttribute<String> imageProperty();

    @IoTResource
    ReadOnlyDeviceAttribute<Date> imageTimeProperty();

    @IoTResource
    void record(int numSecondsToRecord);
}
