/*
 * Copyright (c) 2016, Oracle and/or its affiliates. All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and the
 * Universal Permissive License (UPL). See the LICENSE file in the root
 * directory for license terms. You may choose either license, or both.
 */

package com.oracle.iot.sample.daf.type.humidity;

import oracle.iot.endpoint.Endpoint;
import oracle.iot.module.IoTExport;

/**
 * A {@code HumiditySensor} device represented as a {@code Endpoint}.
 * <p>
 * A concrete implementation responsible for sending these two types of events:
 * {@link HumiditySensorTooHumidEvent HumidityEvents}.
 * {@link HumiditySensorEvent HumidityEvents}.
 *
 * @see HumiditySensor
 * @see oracle.iot.endpoint.Endpoint
 */
@IoTExport
public interface HumiditySensorEndpoint extends HumiditySensor, Endpoint {
}
