/*
 * Copyright (c) 2016, Oracle and/or its affiliates. All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and the
 * Universal Permissive License (UPL). See the LICENSE file in the root
 * directory for license terms. You may choose either license, or both.
 */

package com.oracle.iot.sample.daf.type.humidity;

import oracle.iot.device.DeviceModel;
import oracle.iot.device.attribute.DeviceAttribute;
import oracle.iot.module.IoTExport;
import oracle.iot.device.attribute.ReadOnlyDeviceAttribute;
import oracle.iot.messaging.IoTResource;

/**
 * A humidity sensor is a device that measures the humidity.
 */
@IoTExport
@DeviceModel(name = "urn:com:oracle:iot:device:humidity_sensor")
public interface HumiditySensor {
    /**
     * Humidity measured by this {@code HumiditySensor}. It is expressed as a percentage.
     *
     * @return the property describing the humidity value.
     */
    @IoTResource
    ReadOnlyDeviceAttribute<Integer> humidityProperty();

    /**
     * The maximum humidity allowed.
     *
     * @return the property describing the maximum threshold value.
     */
    @IoTResource
    DeviceAttribute<Integer> maxThresholdProperty();
}
