/*
 * Copyright (c) 2015, 2016, Oracle and/or its affiliates. All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and the
 * Universal Permissive License (UPL). See the LICENSE file in the root
 * directory for license terms. You may choose either license, or both.
 */

package com.oracle.iot.sample.service.consumer;

import oracle.iot.app.AbstractApplication;
import oracle.iot.app.IoTDeviceApplication;
import com.oracle.iot.sample.service.contract.SampleContract;
import javax.inject.Inject;

@IoTDeviceApplication
public class SampleConsumer extends AbstractApplication {

    /**
      * The service to be used.
      */
    private SampleContract mySampleContract;

    @Inject
    public SampleConsumer(SampleContract sc) {
        this.mySampleContract = sc;
    }

    @Override
    protected void start() {
        // initialization code
        // call serviceMethod indicating that this is done during initialization
        mySampleContract.serviceMethod(true);
    }

    @Override
    protected void stop() {
        super.stop();
        // release resources etc.
        // call serviceMethod indicating that this is don during application stop
        mySampleContract.serviceMethod(false);
    }

}

